/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.xml.bind.JAXBException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.editor.GuardedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.rest.client.OAuthHelper;
import org.netbeans.modules.websvc.rest.client.Security;
import org.netbeans.modules.websvc.rest.client.SecurityParams;
import org.netbeans.modules.websvc.rest.client.Wadl2JavaHelper;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.model.api.RestMethodDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.SubResourceLocator;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.jaxb.Authenticator;
import org.netbeans.modules.websvc.saas.model.jaxb.Params;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;
import org.netbeans.modules.websvc.saas.model.jaxb.ServletDescriptor;
import org.netbeans.modules.websvc.saas.model.jaxb.Sign;
import org.netbeans.modules.websvc.saas.model.jaxb.TemplateType;
import org.netbeans.modules.websvc.saas.model.jaxb.UseTemplates;
import org.netbeans.modules.websvc.saas.model.oauth.Metadata;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClientJavaSourceHelper {
    public static void generateJerseyClient(Node resourceNode, FileObject targetFo, String className) {
        ClientJavaSourceHelper.generateJerseyClient(resourceNode, targetFo, className, new Security(false, Security.Authentication.NONE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void generateJerseyClient(Node resourceNode, FileObject targetFo, String className, Security security) {
        block20: {
            ProgressHandle handle = null;
            try {
                RestSupport restSupport;
                Library lib;
                handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ClientJavaSourceHelper.class, (String)"MSG_creatingRESTClient"));
                handle.start();
                ClassPath cp = ClassPath.getClassPath((FileObject)targetFo, (String)"classpath/compile");
                ArrayList<Library> restLibs = new ArrayList<Library>();
                if ((cp == null || cp.findResource("javax/ws/rs/WebApplicationException.class") == null) && (lib = LibraryManager.getDefault().getLibrary("restapi")) != null) {
                    restLibs.add(lib);
                }
                if ((cp == null || cp.findResource("com/sun/jersey/api/client/WebResource.class") == null || Security.Authentication.OAUTH == security.getAuthentication() && cp.findResource("com/sun/jersey/oauth/client/OAuthClientFilter.class") == null) && (lib = LibraryManager.getDefault().getLibrary("restlib")) != null) {
                    restLibs.add(lib);
                }
                if (restLibs.size() > 0) {
                    try {
                        ProjectClassPathModifier.addLibraries((Library[])restLibs.toArray(new Library[restLibs.size()]), (FileObject)targetFo, (String)"classpath/compile");
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot add Jersey libraries", ex);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ClientJavaSourceHelper.class, (String)"MSG_CannotAddJerseyLib"), 2));
                        handle.finish();
                        return;
                    }
                    catch (UnsupportedOperationException ex) {
                        Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Project doesn't support classpath modification", ex);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ClientJavaSourceHelper.class, (String)"MSG_CannotModifyClasspath"), 2));
                        handle.finish();
                        return;
                    }
                }
                String targetProjectType = null;
                Project project = FileOwnerQuery.getOwner((FileObject)targetFo);
                targetProjectType = project != null ? Wadl2JavaHelper.getProjectType(project) : "desktop";
                security.setProjectType(targetProjectType);
                RestServiceDescription restServiceDesc = (RestServiceDescription)resourceNode.getLookup().lookup(RestServiceDescription.class);
                if (restServiceDesc != null) {
                    String uriTemplate = restServiceDesc.getUriTemplate();
                    if (uriTemplate != null) {
                        String baseURL;
                        PathFormat pf = null;
                        if (uriTemplate.length() == 0) {
                            ResourcePath rootResourcePath = ClientJavaSourceHelper.getResourcePath(resourceNode, restServiceDesc.getClassName(), "");
                            uriTemplate = rootResourcePath.getPath();
                            pf = rootResourcePath.getPathFormat();
                        } else {
                            pf = ClientJavaSourceHelper.getPathFormat(uriTemplate);
                        }
                        Project prj = (Project)resourceNode.getLookup().lookup(Project.class);
                        String string = baseURL = prj == null ? "" : ClientJavaSourceHelper.getBaseURL(prj);
                        if (baseURL.endsWith("/")) {
                            baseURL = baseURL.substring(0, baseURL.length() - 1);
                        }
                        ClientJavaSourceHelper.addJerseyClient(JavaSource.forFileObject((FileObject)targetFo), className, baseURL, restServiceDesc, null, pf, security);
                    }
                    break block20;
                }
                WadlSaasResource saasResource = (WadlSaasResource)resourceNode.getLookup().lookup(WadlSaasResource.class);
                if (saasResource == null) break block20;
                ClientJavaSourceHelper.addSecurityMetadata(security, saasResource);
                if ("web".equals(security.getProjectType()) && (Security.Authentication.SESSION_KEY == security.getAuthentication() || Security.Authentication.OAUTH == security.getAuthentication()) && (restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class)) != null && restSupport instanceof WebRestSupport) {
                    security.setDeploymentDescriptor(((WebRestSupport)restSupport).getDeploymentDescriptor());
                }
                String baseUrl = saasResource.getSaas().getBaseURL();
                ResourcePath resourcePath = ClientJavaSourceHelper.getResourcePath(saasResource);
                PathFormat pf = resourcePath.getPathFormat();
                ClientJavaSourceHelper.addJerseyClient(JavaSource.forFileObject((FileObject)targetFo), className, baseUrl, null, saasResource, pf, security);
                try {
                    Wadl2JavaHelper.generateJaxb(targetFo, saasResource.getSaas());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                if (!(!"nb-module".equals(targetProjectType) || Security.Authentication.OAUTH != security.getAuthentication() && Security.Authentication.SESSION_KEY != security.getAuthentication() || cp != null && cp.findResource("org/openide/DialogDisplayer.class.class") != null && cp.findResource("org/openide/util/NbPreferences.class.class") != null && cp.findResource("org/openide/awt/HtmlBrowser.class") != null)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ClientJavaSourceHelper.class, (String)"MSG_MissingOpenideModules"), 2));
                }
                break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                handle.finish();
            }
        }
    }

    private static void addJerseyClient(final JavaSource source, final String className, final String resourceUri, final RestServiceDescription restServiceDesc, final WadlSaasResource saasResource, final PathFormat pf, final Security security) {
        try {
            AbstractTask<WorkingCopy> task = new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy copy) throws IOException {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    ClassTree tree = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                    ClassTree modifiedTree = null;
                    modifiedTree = className == null ? ClientJavaSourceHelper.modifyJerseyClientClass(copy, tree, resourceUri, restServiceDesc, saasResource, pf, security) : ClientJavaSourceHelper.addJerseyClientClass(copy, tree, className, resourceUri, restServiceDesc, saasResource, pf, security);
                    copy.rewrite((Tree)tree, (Tree)modifiedTree);
                }
            };
            ModificationResult result = source.runModificationTask((Task)task);
            if (SourceUtils.isScanInProgress()) {
                source.runWhenScanFinished((Task)new Task<CompilationController>((Task)task){
                    final /* synthetic */ Task val$task;
                    {
                        this.val$task = task;
                    }

                    public void run(CompilationController controller) throws Exception {
                        source.runModificationTask(this.val$task).commit();
                    }
                }, true);
            } else {
                result.commit();
            }
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof GuardedException) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ClientJavaSourceHelper.class, (String)"ERR_CannotApplyGuarded"), 0));
                Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.FINE, null, ex);
            }
            Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    private static ClassTree modifyJerseyClientClass(WorkingCopy copy, ClassTree classTree, String resourceURI, RestServiceDescription restServiceDesc, WadlSaasResource saasResource, PathFormat pf, Security security) {
        return ClientJavaSourceHelper.generateClassArtifacts(copy, classTree, resourceURI, restServiceDesc, saasResource, pf, security, null);
    }

    private static ClassTree addJerseyClientClass(WorkingCopy copy, ClassTree classTree, String className, String resourceURI, RestServiceDescription restServiceDesc, WadlSaasResource saasResource, PathFormat pf, Security security) {
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree modifs = maker.Modifiers(Collections.singleton(Modifier.STATIC));
        ClassTree innerClass = maker.Class(modifs, (CharSequence)className, Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList());
        ClassTree modifiedInnerClass = ClientJavaSourceHelper.generateClassArtifacts(copy, innerClass, resourceURI, restServiceDesc, saasResource, pf, security, classTree.getSimpleName().toString());
        return maker.addClassMember(classTree, (Tree)modifiedInnerClass);
    }

    private static ClassTree generateClassArtifacts(WorkingCopy copy, ClassTree classTree, String resourceURI, RestServiceDescription restServiceDesc, WadlSaasResource saasResource, PathFormat pf, Security security, String outerClassName) {
        String className;
        String packageName;
        FileObject ddFo;
        MethodTree methodTree;
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree fieldModif = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        ExpressionTree typeTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.WebResource");
        VariableTree fieldTree = maker.Variable(fieldModif, (CharSequence)"webResource", (Tree)typeTree, null);
        ClassTree modifiedClass = maker.addClassMember(classTree, (Tree)fieldTree);
        fieldModif = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
        typeTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.Client");
        fieldTree = maker.Variable(fieldModif, (CharSequence)"client", (Tree)typeTree, null);
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)fieldTree);
        HashSet<Modifier> modifiersSet = new HashSet<Modifier>();
        modifiersSet.add(Modifier.PRIVATE);
        modifiersSet.add(Modifier.STATIC);
        modifiersSet.add(Modifier.FINAL);
        fieldModif = maker.Modifiers(modifiersSet);
        typeTree = maker.Identifier((CharSequence)"String");
        String baseUri = resourceURI;
        if (security.isSSL() && resourceURI.startsWith("http:")) {
            baseUri = "https:" + resourceURI.substring(5);
        }
        fieldTree = maker.Variable(fieldModif, (CharSequence)"BASE_URI", (Tree)typeTree, (ExpressionTree)maker.Literal((Object)baseUri));
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)fieldTree);
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        TypeElement clientEl = copy.getElements().getTypeElement("com.sun.jersey.api.client.Client");
        boolean isSubresource = pf.getArguments().length > 0;
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        if (isSubresource) {
            for (String arg : pf.getArguments()) {
                IdentifierTree argTypeTree = maker.Identifier((CharSequence)"String");
                ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
                VariableTree argFieldTree = maker.Variable(fieldModifier, (CharSequence)arg, (Tree)argTypeTree, null);
                paramList.add(argFieldTree);
            }
        }
        String resURI = null;
        String subresourceExpr = "";
        if (isSubresource) {
            subresourceExpr = "    String resourcePath = " + ClientJavaSourceHelper.getPathExpression(pf) + ";";
            resURI = "resourcePath";
        } else {
            resURI = ClientJavaSourceHelper.getPathExpression(pf);
        }
        String SSLExpr = security.isSSL() ? "// SSL configuration\nconfig.getProperties().put(com.sun.jersey.client.urlconnection.HTTPSProperties.PROPERTY_HTTPS_PROPERTIES,                            new com.sun.jersey.client.urlconnection.HTTPSProperties(getHostnameVerifier(), getSSLContext()));" : "";
        String body = "{   com.sun.jersey.api.client.config.ClientConfig config = new com.sun.jersey.api.client.config.DefaultClientConfig();" + SSLExpr + "   client = " + (clientEl == null ? "com.sun.jersey.api.client." : "") + "Client.create(config);" + subresourceExpr + ("\"\"".equals(resURI) ? "   webResource = client.resource(BASE_URI);" : "   webResource = client.resource(BASE_URI).path(" + resURI + ");") + "}";
        MethodTree constructorTree = maker.Constructor(methodModifier, Collections.emptyList(), paramList, Collections.emptyList(), body);
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)constructorTree);
        if (isSubresource) {
            body = "{   String resourcePath = " + ClientJavaSourceHelper.getPathExpression(pf) + ";" + "   webResource = client.resource(BASE_URI).path(resourcePath);" + "}";
            methodTree = maker.Method(methodModifier, (CharSequence)"setResourcePath", (Tree)JavaSourceHelper.createTypeTree(copy, "void"), Collections.emptyList(), paramList, Collections.emptyList(), body, null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
        }
        if (restServiceDesc != null) {
            List annotatedMethods = restServiceDesc.getMethods();
            for (RestMethodDescription methodDesc : annotatedMethods) {
                if (!(methodDesc instanceof HttpMethod)) continue;
                List<MethodTree> httpMethods = ClientJavaSourceHelper.createHttpMethods(copy, (HttpMethod)methodDesc);
                for (MethodTree httpMethod : httpMethods) {
                    modifiedClass = maker.addClassMember(modifiedClass, (Tree)httpMethod);
                }
            }
        } else if (saasResource != null) {
            modifiedClass = Wadl2JavaHelper.addHttpMethods(copy, modifiedClass, saasResource, security);
        }
        methodTree = maker.Method(methodModifier, (CharSequence)"close", (Tree)JavaSourceHelper.createTypeTree(copy, "void"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{   client.destroy();}", null);
        modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
        if (Security.Authentication.BASIC == security.getAuthentication()) {
            ArrayList<VariableTree> authParams = new ArrayList<VariableTree>();
            IdentifierTree argTypeTree = maker.Identifier((CharSequence)"String");
            ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
            VariableTree argFieldTree = maker.Variable(fieldModifier, (CharSequence)"username", (Tree)argTypeTree, null);
            authParams.add(argFieldTree);
            argFieldTree = maker.Variable(fieldModifier, (CharSequence)"password", (Tree)argTypeTree, null);
            authParams.add(argFieldTree);
            body = "{   client.addFilter(new com.sun.jersey.api.client.filter.HTTPBasicAuthFilter(username, password));}";
            methodTree = maker.Method(methodModifier, (CharSequence)"setUsernamePassword", (Tree)JavaSourceHelper.createTypeTree(copy, "void"), Collections.emptyList(), authParams, Collections.emptyList(), body, null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
        } else if (saasResource != null && Security.Authentication.SESSION_KEY == security.getAuthentication()) {
            final SecurityParams securityParams = security.getSecurityParams();
            if (securityParams != null) {
                modifiedClass = Wadl2JavaHelper.addSessionAuthMethods(copy, modifiedClass, securityParams);
                if ("web".equals(security.getProjectType())) {
                    ddFo = security.getDeploymentDescriptor();
                    if (ddFo != null) {
                        packageName = copy.getCompilationUnit().getPackageName().toString();
                        className = (outerClassName == null ? "" : outerClassName + "$") + classTree.getSimpleName().toString();
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ClientJavaSourceHelper.addWebXmlArtifacts(ddFo, securityParams, className, packageName);
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot add servlet/servlet mapping to web.xml", ex);
                                }
                            }
                        }, 1000);
                    }
                    modifiedClass = Wadl2JavaHelper.addSessionAuthServlets(copy, modifiedClass, securityParams, ddFo == null);
                }
            }
        } else if (saasResource != null) {
            try {
                Metadata oauthMetadata = saasResource.getSaas().getOauthMetadata();
                if (oauthMetadata != null) {
                    modifiedClass = OAuthHelper.addOAuthMethods(security.getProjectType(), copy, modifiedClass, oauthMetadata, classTree.getSimpleName().toString());
                    if ("web".equals(security.getProjectType())) {
                        ddFo = security.getDeploymentDescriptor();
                        if (ddFo != null) {
                            packageName = copy.getCompilationUnit().getPackageName().toString();
                            className = (outerClassName == null ? "" : outerClassName + "$") + classTree.getSimpleName().toString();
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        ClientJavaSourceHelper.addWebXmlOAuthArtifacts(ddFo, className, packageName);
                                    }
                                    catch (IOException ex) {
                                        Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot add servlet/servlet mapping to web.xml", ex);
                                    }
                                }
                            }, 1000);
                        }
                        modifiedClass = OAuthHelper.addOAuthServlets(copy, modifiedClass, oauthMetadata, classTree.getSimpleName().toString(), ddFo == null);
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot get metadata for oauth", ex);
            }
            catch (JAXBException ex) {
                Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Cannot get metadata for oauth", ex);
            }
        }
        if (security.isSSL()) {
            ModifiersTree privateModifier = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
            body = "{   return new HostnameVerifier() {       @Override       public boolean verify(String hostname, javax.net.ssl.SSLSession sslSession) {           return true;       }   }}";
            methodTree = maker.Method(privateModifier, (CharSequence)"getHostnameVerifier", (Tree)JavaSourceHelper.createTypeTree(copy, "javax.net.ssl.HostnameVerifier"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
            body = "{   javax.net.ssl.TrustManager x509 = new javax.net.ssl.X509TrustManager() {       @Override       public void checkClientTrusted(java.security.cert.X509Certificate[] arg0, String arg1) throws java.security.cert.CertificateException {           return;       }       @Override       public void checkServerTrusted(java.security.cert.X509Certificate[] arg0, String arg1) throws java.security.cert.CertificateException {           return;       }       @Override       public java.security.cert.X509Certificate[] getAcceptedIssuers() {           return null;       }   };   SSLContext ctx = null;   try {       ctx = SSLContext.getInstance(\"SSL\");       ctx.init(null, new javax.net.ssl.TrustManager[] {x509}, null);   } catch (java.security.GeneralSecurityException ex) {}   return ctx;}";
            methodTree = maker.Method(privateModifier, (CharSequence)"getSSLContext", (Tree)JavaSourceHelper.createTypeTree(copy, "javax.net.ssl.SSLContext"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
        }
        return modifiedClass;
    }

    private static List<MethodTree> createHttpMethods(WorkingCopy copy, HttpMethod httpMethod) {
        ArrayList<MethodTree> httpMethods = new ArrayList<MethodTree>();
        String method = httpMethod.getType();
        if ("GET".equals(method)) {
            boolean found = false;
            String produces = httpMethod.getProduceMime();
            if (produces.length() > 0) {
                boolean multipleMimeTypes = produces.contains(",");
                for (HttpMimeType mimeType : HttpMimeType.values()) {
                    if (!produces.contains(mimeType.getMimeType())) continue;
                    httpMethods.addAll(ClientJavaSourceHelper.createHttpGETMethod(copy, httpMethod, mimeType, multipleMimeTypes));
                    found = true;
                }
            }
            if (!found) {
                httpMethods.addAll(ClientJavaSourceHelper.createHttpGETMethod(copy, httpMethod, null, false));
            }
        } else if ("PUT".equals(method) || "POST".equals(method) || "DELETE".equals(method)) {
            boolean found = false;
            String consumes = httpMethod.getConsumeMime();
            if (consumes.length() > 0) {
                boolean multipleMimeTypes = consumes.contains(",");
                for (HttpMimeType mimeType : HttpMimeType.values()) {
                    if (!consumes.contains(mimeType.getMimeType())) continue;
                    httpMethods.add(ClientJavaSourceHelper.createHttpPOSTMethod(copy, httpMethod, mimeType, multipleMimeTypes));
                    found = true;
                }
            }
            if (!found) {
                httpMethods.add(ClientJavaSourceHelper.createHttpPOSTMethod(copy, httpMethod, null, false));
            }
        }
        return httpMethods;
    }

    private static Collection<MethodTree> createHttpGETMethod(WorkingCopy copy, HttpMethod httpMethod, HttpMimeType mimeType, boolean multipleMimeTypes) {
        ArrayList<MethodTree> result = new ArrayList<MethodTree>(2);
        String responseType = httpMethod.getReturnType();
        String path = httpMethod.getPath();
        String methodName = httpMethod.getName() + (multipleMimeTypes ? "_" + mimeType.name() : "");
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        VariableTree classParam = null;
        IdentifierTree responseTree = null;
        String bodyParam = "";
        List<Object> typeParams = null;
        if ("java.lang.String".equals(responseType)) {
            responseTree = maker.Identifier((CharSequence)"String");
            bodyParam = "String.class";
            typeParams = Collections.emptyList();
        } else {
            responseTree = maker.Identifier((CharSequence)"T");
            bodyParam = "responseType";
            classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
            typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
        }
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        if (classParam != null) {
            paramList.add(classParam);
        }
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.UniformInterfaceException");
        StringBuilder body = new StringBuilder("{ WebResource resource = webResource;");
        StringBuilder resourceBuilder = new StringBuilder();
        if (path.length() == 0) {
            if (mimeType != null) {
                resourceBuilder.append(".accept(");
                resourceBuilder.append(mimeType.getMediaType());
                resourceBuilder.append(')');
            }
            ClientJavaSourceHelper.buildQueryParams(body, httpMethod, paramList, maker);
        } else {
            PathFormat pf = ClientJavaSourceHelper.getPathFormat(path);
            for (String arg : pf.getArguments()) {
                IdentifierTree typeTree = maker.Identifier((CharSequence)"String");
                ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
                VariableTree fieldTree = maker.Variable(fieldModifier, (CharSequence)arg, (Tree)typeTree, null);
                paramList.add(fieldTree);
            }
            ClientJavaSourceHelper.buildQueryParams(body, httpMethod, paramList, maker);
            body.append("resource=resource.path(");
            body.append(ClientJavaSourceHelper.getPathExpression(pf));
            body.append(')');
            if (mimeType != null) {
                resourceBuilder.append(".accept(");
                resourceBuilder.append(mimeType.getMediaType());
                resourceBuilder.append(')');
            }
        }
        body.append("return resource");
        body.append((CharSequence)resourceBuilder);
        body.append(".get(");
        body.append(bodyParam);
        body.append(");");
        body.append('}');
        MethodTree method = maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, Collections.singletonList(throwsTree), body.toString(), null);
        result.add(method);
        return result;
    }

    private static void buildQueryParams(StringBuilder body, HttpMethod httpMethod, List<VariableTree> paramList, TreeMaker maker) {
        Map queryParams = httpMethod.getQueryParams();
        if (queryParams.size() == 0) {
            return;
        }
        for (Map.Entry entry : queryParams.entrySet()) {
            String paramName = (String)entry.getKey();
            if (paramName == null) continue;
            String clientParam = ClientJavaSourceHelper.getClientParamName(paramName, paramList);
            IdentifierTree typeTree = maker.Identifier((CharSequence)"String");
            ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
            VariableTree fieldTree = maker.Variable(fieldModifier, (CharSequence)clientParam, (Tree)typeTree, null);
            paramList.add(fieldTree);
            body.append("if (");
            body.append(clientParam);
            body.append("!=null){");
            body.append("resource = resource.queryParam(\"");
            body.append(paramName);
            body.append("\",");
            body.append(clientParam);
            body.append(");}");
        }
    }

    private static String getClientParamName(String paramName, List<VariableTree> paramList) {
        return ClientJavaSourceHelper.getClientParamName(paramName, paramList, 0);
    }

    private static String getClientParamName(String paramName, List<VariableTree> paramList, int index) {
        String result = paramName;
        if (index != 0) {
            result = paramName + index;
        }
        for (VariableTree var : paramList) {
            String name = var.getName().toString();
            if (!name.equals(result)) continue;
            return ClientJavaSourceHelper.getClientParamName(paramName, paramList, index + 1);
        }
        return result;
    }

    private static MethodTree createHttpPOSTMethod(WorkingCopy copy, HttpMethod httpMethod, HttpMimeType requestMimeType, boolean multipleMimeTypes) {
        String methodPrefix = httpMethod.getType().toLowerCase();
        String responseType = httpMethod.getReturnType();
        String path = httpMethod.getPath();
        String methodName = httpMethod.getName() + (multipleMimeTypes ? "_" + requestMimeType.name() : "");
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        VariableTree classParam = null;
        IdentifierTree responseTree = null;
        String bodyParam1 = "";
        String ret = "";
        List<Object> typeParams = Collections.emptyList();
        if ("javax.ws.rs.core.Response".equals(responseType)) {
            TypeElement clientResponseEl = copy.getElements().getTypeElement("com.sun.jersey.api.client.ClientResponse");
            ret = "return ";
            responseTree = clientResponseEl == null ? copy.getTreeMaker().Identifier((CharSequence)"com.sun.jersey.api.client.ClientResponse") : copy.getTreeMaker().QualIdent((Element)clientResponseEl);
            bodyParam1 = clientResponseEl == null ? "com.sun.jersey.api.client.ClientResponse.class" : "ClientResponse.class";
        } else if ("void".equals(responseType)) {
            responseTree = maker.Identifier((CharSequence)"void");
        } else if ("java.lang.String".equals(responseType)) {
            responseTree = maker.Identifier((CharSequence)"String");
            ret = "return ";
            bodyParam1 = "String.class";
        } else {
            responseTree = maker.Identifier((CharSequence)"T");
            ret = "return ";
            bodyParam1 = "responseType";
            classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
            typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
        }
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        if (classParam != null) {
            paramList.add(classParam);
        }
        String bodyParam2 = "";
        if (requestMimeType != null && requestMimeType != HttpMimeType.FORM) {
            VariableTree objectParam = maker.Variable(paramModifier, (CharSequence)"requestEntity", (Tree)maker.Identifier((CharSequence)"Object"), null);
            paramList.add(objectParam);
            bodyParam2 = (bodyParam1.length() > 0 ? ", " : "") + "requestEntity";
        }
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.UniformInterfaceException");
        if (path.length() == 0) {
            String body = "{" + (requestMimeType == null ? "   " + ret + "webResource." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");" : "   " + ret + "webResource.type(" + requestMimeType.getMediaType() + ")." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");") + "}";
            return maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, Collections.singletonList(throwsTree), body, null);
        }
        PathFormat pf = ClientJavaSourceHelper.getPathFormat(path);
        for (String arg : pf.getArguments()) {
            IdentifierTree typeTree = maker.Identifier((CharSequence)"String");
            ModifiersTree fieldModifier = maker.Modifiers(Collections.emptySet());
            VariableTree fieldTree = maker.Variable(fieldModifier, (CharSequence)arg, (Tree)typeTree, null);
            paramList.add(fieldTree);
        }
        String body = "{" + (requestMimeType == null ? "   " + ret + "webResource.path(" + ClientJavaSourceHelper.getPathExpression(pf) + ")." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");" : "   " + ret + "webResource.path(" + ClientJavaSourceHelper.getPathExpression(pf) + ").type(" + requestMimeType.getMediaType() + ")." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");") + "}";
        return maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, Collections.singletonList(throwsTree), body, null);
    }

    private static String getPathExpression(PathFormat pf) {
        String[] arguments = pf.getArguments();
        if (arguments.length == 0) {
            return "\"" + pf.getPattern() + "\"";
        }
        return "java.text.MessageFormat.format(\"" + pf.getPattern() + "\", new Object[] {" + ClientJavaSourceHelper.getArgumentList(arguments) + "})";
    }

    private static String getArgumentList(String[] arguments) {
        if (arguments.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arguments[0]);
        for (int i = 1; i < arguments.length; ++i) {
            buf.append("," + arguments[i]);
        }
        return buf.toString();
    }

    private static PathFormat getPathFormat(String path) {
        String p = ClientJavaSourceHelper.normalizePath(path);
        PathFormat pathFormat = new PathFormat();
        StringBuffer buf = new StringBuffer();
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < p.length(); ++i) {
            char ch = p.charAt(i);
            if (ch == '{') {
                int j;
                for (j = i + 1; j < p.length() && p.charAt(j) != '}'; ++j) {
                }
                String arg = p.substring(i + 1, j);
                int index = arg.indexOf(58);
                if (index > -1) {
                    arg = arg.substring(0, index);
                }
                buf.append("{" + arguments.size() + "}");
                arguments.add(arg);
                i = j;
                continue;
            }
            buf.append(ch);
        }
        pathFormat.setPattern(buf.toString().trim());
        pathFormat.setArguments(arguments.toArray(new String[arguments.size()]));
        return pathFormat;
    }

    private static ResourcePath getResourcePath(WadlSaasResource saasResource) {
        String path = ClientJavaSourceHelper.normalizePath(saasResource.getResource().getPath());
        for (WadlSaasResource parent = saasResource.getParent(); parent != null; parent = parent.getParent()) {
            String pathToken = ClientJavaSourceHelper.normalizePath(parent.getResource().getPath());
            if (pathToken.length() <= 0) continue;
            path = pathToken + "/" + path;
        }
        return new ResourcePath(ClientJavaSourceHelper.getPathFormat(path), path);
    }

    private static String normalizePath(String path) {
        String s = path;
        while (s.startsWith("/")) {
            s = s.substring(1);
        }
        while (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static ResourcePath getResourcePath(Node resourceNode, String resourceClass, String uriTemplate) {
        String resourceUri = ClientJavaSourceHelper.normalizePath(uriTemplate);
        Node projectNode = resourceNode.getParentNode();
        if (projectNode != null) {
            for (Node sibling : projectNode.getChildren().getNodes()) {
                RestServiceDescription desc;
                if (resourceNode == sibling || (desc = (RestServiceDescription)sibling.getLookup().lookup(RestServiceDescription.class)) == null) continue;
                for (RestMethodDescription m : desc.getMethods()) {
                    SubResourceLocator resourceLocator;
                    if (!(m instanceof SubResourceLocator) || !resourceClass.equals((resourceLocator = (SubResourceLocator)m).getReturnType())) continue;
                    String resourceLocatorUri = ClientJavaSourceHelper.normalizePath(resourceLocator.getUriTemplate());
                    String parentResourceUri = desc.getUriTemplate();
                    if (parentResourceUri.length() > 0) {
                        String subresourceUri = null;
                        subresourceUri = resourceLocatorUri.length() > 0 ? (resourceUri.length() > 0 ? resourceLocatorUri + "/" + resourceUri : resourceLocatorUri) : resourceUri;
                        PathFormat pf = ClientJavaSourceHelper.getPathFormat(ClientJavaSourceHelper.normalizePath(parentResourceUri) + "/" + subresourceUri);
                        return new ResourcePath(pf, parentResourceUri);
                    }
                    return ClientJavaSourceHelper.getResourcePath(sibling, desc.getClassName(), resourceLocatorUri + "/" + uriTemplate);
                }
            }
        }
        return new ResourcePath(ClientJavaSourceHelper.getPathFormat(uriTemplate), uriTemplate);
    }

    public static String getBaseURL(Project project) {
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String serverInstanceID = provider.getServerInstanceID();
        if (serverInstanceID == null) {
            Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Can not detect target J2EE server");
            return "";
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(serverInstanceID);
        String portNumber = "8080";
        String hostName = "localhost";
        try {
            ServerInstance.Descriptor instanceDescriptor = serverInstance.getDescriptor();
            if (instanceDescriptor != null) {
                int port = instanceDescriptor.getHttpPort();
                portNumber = port == 0 ? "8080" : String.valueOf(port);
                String hstName = instanceDescriptor.getHostname();
                if (hstName != null) {
                    hostName = hstName;
                }
            }
        }
        catch (InstanceRemovedException ex) {
            Logger.getLogger(ClientJavaSourceHelper.class.getName()).log(Level.INFO, "Removed ServerInstance", ex);
        }
        String contextRoot = null;
        J2eeModule.Type moduleType = provider.getJ2eeModule().getType();
        if (J2eeModule.Type.WAR.equals(moduleType)) {
            J2eeModuleProvider.ConfigSupport configSupport = provider.getConfigSupport();
            try {
                contextRoot = configSupport.getWebContextRoot();
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
            if (contextRoot != null && contextRoot.startsWith("/")) {
                contextRoot = contextRoot.substring(1);
            }
        }
        String applicationPath = "webresources";
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            try {
                applicationPath = restSupport.getApplicationPath();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return "http://" + hostName + ":" + portNumber + "/" + (contextRoot != null && !contextRoot.equals("") ? contextRoot : "") + "/" + applicationPath;
    }

    private static void addSecurityMetadata(Security security, WadlSaasResource saasResource) {
        SaasMetadata.Authentication auth;
        SaasMetadata saasMetadata = saasResource.getSaas().getSaasMetadata();
        if (saasMetadata != null && (auth = saasMetadata.getAuthentication()) != null && auth.getSessionKey().size() > 0) {
            SecurityParams securityParams = new SecurityParams();
            SaasMetadata.Authentication.SessionKey sessionKey = (SaasMetadata.Authentication.SessionKey)auth.getSessionKey().get(0);
            if (sessionKey != null) {
                UseTemplates useTemplates;
                Authenticator authenticator;
                Params secParams;
                securityParams.setSignature(sessionKey.getSigId());
                Sign sign = sessionKey.getSign();
                if (sign != null && (secParams = sign.getParams()) != null) {
                    ArrayList<String> params = new ArrayList<String>();
                    for (Params.Param secParam : secParams.getParam()) {
                        params.add(secParam.getName());
                    }
                    securityParams.setParams(params);
                }
                if ((authenticator = sessionKey.getAuthenticator()) != null && (useTemplates = authenticator.getUseTemplates()) != null) {
                    TemplateType tt;
                    if ("nb-module".equals(security.getProjectType())) {
                        tt = useTemplates.getNbModule();
                        if (tt != null) {
                            securityParams.setFieldDescriptors(tt.getFieldDescriptor());
                            securityParams.setMethodDescriptors(tt.getMethodDescriptor());
                            securityParams.setServletDescriptors(tt.getServletDescriptor());
                        }
                    } else if ("web".equals(security.getProjectType())) {
                        tt = useTemplates.getWeb();
                        if (tt != null) {
                            securityParams.setFieldDescriptors(tt.getFieldDescriptor());
                            securityParams.setMethodDescriptors(tt.getMethodDescriptor());
                            securityParams.setServletDescriptors(tt.getServletDescriptor());
                        }
                    } else {
                        tt = useTemplates.getDesktop();
                        if (tt != null) {
                            securityParams.setFieldDescriptors(tt.getFieldDescriptor());
                            securityParams.setMethodDescriptors(tt.getMethodDescriptor());
                            securityParams.setServletDescriptors(tt.getServletDescriptor());
                        }
                    }
                }
            }
            security.setSecurityParams(securityParams);
        }
    }

    private static void addWebXmlArtifacts(FileObject ddFo, SecurityParams securityParams, String parentClassName, String packageName) throws IOException {
        WebApp webApp = DDProvider.getDefault().getDDRoot(ddFo);
        if (webApp != null) {
            for (ServletDescriptor servletDesc : securityParams.getServletDescriptors()) {
                String servletName = parentClassName + "$" + servletDesc.getClassName();
                String className = packageName + "." + servletName;
                String urlPattern = servletDesc.getServletMapping();
                try {
                    Servlet servlet = (Servlet)webApp.createBean("Servlet");
                    servlet.setServletName(servletName);
                    servlet.setServletClass(className);
                    ServletMapping servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                    servletMapping.setServletName(servletName);
                    if (servletMapping instanceof ServletMapping25) {
                        ((ServletMapping25)servletMapping).addUrlPattern(urlPattern);
                    } else {
                        servletMapping.setUrlPattern(urlPattern);
                    }
                    webApp.addServlet(servlet);
                    webApp.addServletMapping(servletMapping);
                }
                catch (ClassNotFoundException ex) {}
            }
            webApp.write(ddFo);
        }
    }

    private static void addWebXmlOAuthArtifacts(FileObject ddFo, String parentClassName, String packageName) throws IOException {
        String[] servletNames = new String[]{"OAuthLoginServlet", "OAuthCallbackServlet"};
        String[] urlPatterns = new String[]{"/OAuthLogin", "/OAuthCallback"};
        WebApp webApp = DDProvider.getDefault().getDDRoot(ddFo);
        if (webApp != null) {
            for (int i = 0; i < servletNames.length; ++i) {
                String servletName = parentClassName + "$" + servletNames[i];
                String className = packageName + "." + servletName;
                try {
                    Servlet servlet = (Servlet)webApp.createBean("Servlet");
                    servlet.setServletName(servletName);
                    servlet.setServletClass(className);
                    ServletMapping servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                    servletMapping.setServletName(servletName);
                    if (servletMapping instanceof ServletMapping25) {
                        ((ServletMapping25)servletMapping).addUrlPattern(urlPatterns[i]);
                    } else {
                        servletMapping.setUrlPattern(urlPatterns[i]);
                    }
                    webApp.addServlet(servlet);
                    webApp.addServletMapping(servletMapping);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
            }
            webApp.write(ddFo);
        }
    }

    static enum HttpMimeType {
        XML("application/xml", "javax.ws.rs.core.MediaType.APPLICATION_XML"),
        JSON("application/json", "javax.ws.rs.core.MediaType.APPLICATION_JSON"),
        TEXT("text/plain", "javax.ws.rs.core.MediaType.TEXT_PLAIN"),
        HTML("text/html", "javax.ws.rs.core.MediaType.TEXT_HTML"),
        TEXT_XML("text/xml", "javax.ws.rs.core.MediaType.TEXT_XML"),
        FORM("application/x-www-form-urlencoded", "javax.ws.rs.core.MediaType.APPLICATION_FORM_URLENCODED");

        private String mimeType;
        private String mediaType;

        private HttpMimeType(String mimeType, String mediaType) {
            this.mimeType = mimeType;
            this.mediaType = mediaType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getMediaType() {
            return this.mediaType;
        }
    }

    static class ResourcePath {
        private PathFormat pathFormat;
        private String path;

        public ResourcePath() {
        }

        public ResourcePath(PathFormat pathFormat, String path) {
            this.pathFormat = pathFormat;
            this.path = path;
        }

        public PathFormat getPathFormat() {
            return this.pathFormat;
        }

        public void setPathFormat(PathFormat pathFormat) {
            this.pathFormat = pathFormat;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    static class PathFormat {
        private static final String ARG = "arg";
        private String pattern;
        private String[] arguments;
        private Set<String> javaIds = new HashSet<String>();

        PathFormat() {
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public void setArguments(String[] arguments) {
            this.arguments = new String[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                this.arguments[i] = this.getJavaIdentifier(arguments[i]);
            }
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        private String getJavaIdentifier(String arg) {
            if (arg.length() == 0) {
                return this.getUniqueArgument(ARG);
            }
            char first = arg.charAt(0);
            if (Character.isJavaIdentifierStart(first)) {
                int index = -1;
                for (int i = 1; i < arg.length(); ++i) {
                    if (Character.isJavaIdentifierPart(arg.charAt(i))) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    return this.getUniqueArgument(arg);
                }
                String start = arg.substring(0, index);
                String end = "";
                if (index < arg.length() - 1) {
                    end = arg.substring(index + 1);
                }
                if (end.length() > 0) {
                    end = Character.toUpperCase(end.charAt(0)) + end.substring(1);
                }
                return this.getUniqueArgument(start + end);
            }
            return this.getJavaIdentifier(arg.substring(1));
        }

        private String getUniqueArgument(String base) {
            String result = base;
            int count = 1;
            while (this.javaIds.contains(result)) {
                result = base + count;
                ++count;
            }
            this.javaIds.add(result);
            return result;
        }
    }
}

