/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RestUtils {
    public static void upgrade(Project project) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            restSupport.upgrade();
        }
    }

    public static void ensureRestDevelopmentReady(Project project) throws IOException {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            restSupport.ensureRestDevelopmentReady();
        }
    }

    public static RestSupport getRestSupport(Project project) {
        return (RestSupport)project.getLookup().lookup(RestSupport.class);
    }

    public static RestServicesModel getRestServicesMetadataModel(Project project) {
        RestSupport support = RestUtils.getRestSupport(project);
        if (support != null) {
            return support.getRestServicesModel();
        }
        return null;
    }

    public static void disableRestServicesChangeListner(Project project) {
        RestServicesModel wsModel = RestUtils.getRestServicesMetadataModel(project);
        if (wsModel == null) {
            return;
        }
        wsModel.disablePropertyChangeListener();
    }

    public static void enableRestServicesChangeListner(Project project) {
        RestServicesModel wsModel = RestUtils.getRestServicesMetadataModel(project);
        if (wsModel == null) {
            return;
        }
        wsModel.enablePropertyChangeListener();
    }

    public static boolean hasJTASupport(Project project) {
        RestSupport support = RestUtils.getRestSupport(project);
        if (support != null) {
            return support.hasJTASupport();
        }
        return false;
    }

    public static boolean hasSpringSupport(Project project) {
        RestSupport support = RestUtils.getRestSupport(project);
        if (support != null) {
            return support.hasSpringSupport();
        }
        return false;
    }

    public static boolean isServerTomcat(Project project) {
        RestSupport support = RestUtils.getRestSupport(project);
        if (support != null) {
            return support.isServerTomcat();
        }
        return false;
    }

    public static boolean isServerGFV3(Project project) {
        RestSupport support = RestUtils.getRestSupport(project);
        if (support != null) {
            return support.isServerGFV3();
        }
        return false;
    }

    public static boolean isServerGFV2(Project project) {
        RestSupport support = RestUtils.getRestSupport(project);
        if (support != null) {
            return support.isServerGFV2();
        }
        return false;
    }

    public static Datasource getDatasource(Project project, String jndiName) {
        RestSupport support = RestUtils.getRestSupport(project);
        if (support != null) {
            return support.getDatasource(jndiName);
        }
        return null;
    }

    public static String getAttributeValue(Node n, String nodePath, String attrName) throws XPathExpressionException {
        String attrValue = null;
        int i = 0;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr3 = xpath.compile(nodePath + "/@" + attrName);
        Object result3 = expr3.evaluate(n, XPathConstants.NODESET);
        NodeList nodes3 = (NodeList)result3;
        if (i < nodes3.getLength()) {
            attrValue = nodes3.item(i).getNodeValue();
        }
        return attrValue;
    }

    public static NodeList getNodeList(Node n, String nodePath) throws XPathExpressionException {
        Object attrValue = null;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr3 = xpath.compile(nodePath);
        Object result3 = expr3.evaluate(n, XPathConstants.NODESET);
        NodeList nodes3 = (NodeList)result3;
        return nodes3;
    }

    public static FileObject findWadlFile(Project p) {
        FileObject pf = p.getProjectDirectory();
        FileObject f = pf.getFileObject("/build/web/WEB-INF/classes/com/sun/ws/rest/wadl/resource/application.wadl");
        return f;
    }

    public static DataObject createDataObjectFromTemplate(String template, FileObject targetFolder, String targetName, Map<String, String> parameters) throws IOException {
        assert (template != null);
        assert (targetFolder != null);
        assert (targetName != null && targetName.trim().length() > 0);
        FileObject templateFO = FileUtil.getConfigFile((String)template);
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
        if (parameters == null) {
            return templateDO.createFromTemplate(dataFolder, targetName);
        }
        return templateDO.createFromTemplate(dataFolder, targetName, parameters);
    }

    public static DataObject createDataObjectFromTemplate(String template, FileObject targetFolder, String targetName) throws IOException {
        return RestUtils.createDataObjectFromTemplate(template, targetFolder, targetName, null);
    }

    public static String findStubNameFromClass(String className) {
        String name = className;
        int index = name.lastIndexOf("Resource");
        if (index != -1) {
            name = name.substring(0, index);
        } else {
            index = name.lastIndexOf("Converter");
            if (index != -1) {
                name = name.substring(0, index);
            }
        }
        return name;
    }

    public static String findUri(JavaSource rSrc) {
        String path = null;
        List<? extends AnnotationMirror> annotations = JavaSourceHelper.getClassAnnotations(rSrc);
        for (AnnotationMirror annotationMirror : annotations) {
            String cAnonType = annotationMirror.getAnnotationType().toString();
            if (!"javax.ws.rs.Path".equals(cAnonType)) continue;
            path = RestUtils.getValueFromAnnotation(annotationMirror);
        }
        return path;
    }

    public static boolean isStaticResource(JavaSource src) {
        List<? extends AnnotationMirror> annotations = JavaSourceHelper.getClassAnnotations(src);
        if (annotations != null && annotations.size() > 0) {
            for (AnnotationMirror annotationMirror : annotations) {
                String classAnonType = annotationMirror.getAnnotationType().toString();
                if (!"javax.ws.rs.Path".equals(classAnonType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isConverter(JavaSource src) {
        List<? extends AnnotationMirror> annotations = JavaSourceHelper.getClassAnnotations(src);
        if (annotations != null && annotations.size() > 0) {
            for (AnnotationMirror annotationMirror : annotations) {
                String classAnonType = annotationMirror.getAnnotationType().toString();
                if (!"javax.xml.bind.annotation.XmlRootElement".equals(classAnonType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDynamicResource(JavaSource src) {
        List<MethodTree> trees = JavaSourceHelper.getAllMethods(src);
        for (MethodTree tree : trees) {
            List<? extends AnnotationTree> mAnons = tree.getModifiers().getAnnotations();
            if (mAnons == null || mAnons.size() <= 0) continue;
            for (AnnotationTree annotationTree : mAnons) {
                String mAnonType = annotationTree.getAnnotationType().toString();
                if ("Path".equals(mAnonType) || "javax.ws.rs.Path".equals(mAnonType)) {
                    return true;
                }
                if (!"GET".equals(mAnonType) && !"javax.ws.rs.GET".equals(mAnonType)) continue;
                return true;
            }
        }
        return false;
    }

    public static String findElementName(MethodTree tree) {
        String eName = "";
        List<? extends AnnotationTree> mAnons = tree.getModifiers().getAnnotations();
        if (mAnons != null && mAnons.size() > 0) {
            for (AnnotationTree annotationTree : mAnons) {
                eName = annotationTree.toString();
                if (eName.indexOf("\"") != -1) {
                    eName = RestUtils.getValueFromAnnotation(annotationTree);
                    continue;
                }
                eName = RestUtils.getNameFromMethod(tree);
            }
        }
        return eName.substring(0, 1).toLowerCase() + eName.substring(1);
    }

    public static MethodTree findGetAsXmlMethod(JavaSource rSrc) {
        MethodTree method = null;
        List<MethodTree> rTrees = JavaSourceHelper.getAllMethods(rSrc);
        for (MethodTree tree : rTrees) {
            boolean isHttpGetMethod = false;
            boolean isXmlMime = false;
            List<? extends AnnotationTree> mAnons = tree.getModifiers().getAnnotations();
            if (mAnons == null || mAnons.size() <= 0) continue;
            for (AnnotationTree annotationTree : mAnons) {
                List<String> mimes;
                String mAnonType = annotationTree.getAnnotationType().toString();
                if ("GET".equals(mAnonType) || "javax.ws.rs.GET".equals(mAnonType)) {
                    isHttpGetMethod = true;
                    continue;
                }
                if (!"Produces".equals(mAnonType) && !"javax.ws.rs.Produces".equals(mAnonType) || !(mimes = RestUtils.getMimeAnnotationValue(annotationTree)).contains(Constants.MimeType.JSON.value()) && !mimes.contains(Constants.MimeType.XML.value())) continue;
                isXmlMime = true;
            }
            if (!isHttpGetMethod || !isXmlMime) continue;
            method = tree;
            break;
        }
        return method;
    }

    public static String getNameFromMethod(MethodTree tree) {
        String attrName = tree.getName().toString();
        attrName = attrName.substring(attrName.indexOf("get") + 3);
        attrName = attrName.substring(0, 1).toLowerCase() + attrName.substring(1);
        return attrName;
    }

    public static String getValueFromAnnotation(AnnotationMirror annotation) {
        return RestUtils.getValueFromAnnotation(annotation.getElementValues().values().toString());
    }

    public static String getValueFromAnnotation(AnnotationTree mAnon) {
        return RestUtils.getValueFromAnnotation(mAnon.toString());
    }

    public static String getValueFromAnnotation(ExpressionTree eAnon) {
        return RestUtils.getValueFromAnnotation(eAnon.toString());
    }

    public static String getValueFromAnnotation(String value) {
        if (value.indexOf("\"") != -1) {
            value = value.substring(value.indexOf("\"") + 1, value.lastIndexOf("\""));
        }
        return value;
    }

    public static List<String> getMimeAnnotationValue(AnnotationTree ant) {
        List<? extends ExpressionTree> ets = ant.getArguments();
        if (ets.size() > 0) {
            String value = RestUtils.getValueFromAnnotation(ets.get(0));
            value = value.replace("\"", "");
            return Arrays.asList(value.split(","));
        }
        return Collections.emptyList();
    }

    public static String escapeJSReserved(String key) {
        if (key.equals("delete")) {
            return key + "_";
        }
        return key;
    }

    public static J2eeModule getJ2eeModule(Project prj) {
        J2eeModuleProvider provider = (J2eeModuleProvider)prj.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null) {
            return provider.getJ2eeModule();
        }
        return null;
    }

    public static boolean isAnnotationConfigAvailable(Project project) throws IOException {
        ClassPath cp;
        SourceGroup[] sourceGroups;
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null && restSupport.hasSpringSupport()) {
            return false;
        }
        return RestUtils.isJavaEE6(project) && (sourceGroups = SourceGroupSupport.getJavaSourceGroups(project)).length > 0 && (cp = ClassPath.getClassPath((FileObject)sourceGroups[0].getRootFolder(), (String)"classpath/compile")) != null && cp.findResource("javax/ws/rs/ApplicationPath.class") != null && cp.findResource("javax/ws/rs/core/Application.class") != null;
    }

    public static boolean isJSR_311OnClasspath(Project project) throws IOException {
        return RestUtils.hasClass(project, "javax/ws/rs/Path.class");
    }

    public static boolean hasClass(Project project, String fqn) throws IOException {
        ClassPath cp;
        SourceGroup[] sourceGroups;
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        return wm != null && (sourceGroups = SourceGroupSupport.getJavaSourceGroups(project)).length > 0 && (cp = ClassPath.getClassPath((FileObject)sourceGroups[0].getRootFolder(), (String)"classpath/compile")) != null && cp.findResource(fqn) != null;
    }

    public static void createApplicationConfigClass(FileObject packageFolder, String name) throws IOException {
        FileObject appClass = GenerationUtils.createClass((FileObject)packageFolder, (String)name, null);
        JavaSource javaSource = JavaSource.forFileObject((FileObject)appClass);
        if (javaSource == null) {
            return;
        }
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                JavaSourceHelper.addClassAnnotation(workingCopy, new String[]{"javax.ws.rs.ApplicationPath"}, new String[]{"webresources"});
                ClassTree tree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                TreeMaker maker = workingCopy.getTreeMaker();
                ClassTree newTree = maker.setExtends(tree, maker.QualIdent("javax.ws.rs.core.Application"));
                workingCopy.rewrite((Tree)tree, (Tree)newTree);
            }
        }).commit();
    }

    public static boolean isJavaEE6(Project project) {
        Profile profile;
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        return webModule != null && (Profile.JAVA_EE_6_WEB == (profile = webModule.getJ2eeProfile()) || Profile.JAVA_EE_6_FULL == profile || Profile.JAVA_EE_7_WEB == profile || Profile.JAVA_EE_7_FULL == profile);
    }

    public static boolean hasProfile(Project project, Profile ... profiles) {
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null) {
            Profile projectProfile = webModule.getJ2eeProfile();
            for (Profile profile : profiles) {
                if (projectProfile != profile) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAopAlliance(Project project) {
        try {
            return RestUtils.hasClass(project, "org/aopalliance/aop/Advice.class");
        }
        catch (IOException e) {
            return false;
        }
    }
}

