/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf20;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.api.TagFeature;
import org.netbeans.modules.web.jsfapi.spi.TagFeatureProvider;

public class JsfTagFeatureProvider
implements TagFeatureProvider {
    private static final String JSTL_CORE = "http://java.sun.com/jsp/jstl/core";
    private static final String JSF_CORE = "http://java.sun.com/jsf/core";
    private static final String JSF_HTML = "http://java.sun.com/jsf/html";
    private static final String VAR = "var";
    private static final String VALUE = "value";

    public <T extends TagFeature> Collection<T> getFeatures(final Tag tag, Library library, Class<T> clazz) {
        IterableTag iterableTag;
        if (clazz.equals(TagFeature.IterableTagPattern.class) && (iterableTag = this.resolveIterableTag(library, tag)) != null) {
            return Collections.singleton(clazz.cast(new TagFeature.IterableTagPattern(){

                public Attribute getVariable() {
                    return tag.getAttribute(iterableTag.getVariableAtribute());
                }

                public Attribute getItems() {
                    return tag.getAttribute(iterableTag.getItemsAtribute());
                }
            }));
        }
        return Collections.emptyList();
    }

    private IterableTag resolveIterableTag(Library library, Tag tag) {
        for (IterableTag iterableTag : IterableTag.values()) {
            if (library.getNamespace() == null || iterableTag.getNamespace() == null || !library.getNamespace().equalsIgnoreCase(iterableTag.getNamespace())) continue;
            return iterableTag;
        }
        return null;
    }

    private static enum IterableTag {
        FOR_EACH("http://java.sun.com/jsp/jstl/core", "forEach", "items", "var"),
        SELECT_ITEMS("http://java.sun.com/jsf/core", "selectItems", "value", "var"),
        DATA_TABLE("http://java.sun.com/jsf/html", "dataTable", "value", "var");

        private final String namespace;
        private final String name;
        private final String itemsAtribute;
        private final String variableAtribute;

        private IterableTag(String namespace, String name, String itemsAtribute, String variableAtribute) {
            this.namespace = namespace;
            this.name = name;
            this.itemsAtribute = itemsAtribute;
            this.variableAtribute = variableAtribute;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getItemsAtribute() {
            return this.itemsAtribute;
        }

        public String getVariableAtribute() {
            return this.variableAtribute;
        }
    }
}

