/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.breadcrumbs.spi;

import java.awt.Image;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.modules.editor.breadcrumbs.HolderImpl;
import org.netbeans.modules.editor.breadcrumbs.SideBarFactoryImpl;
import org.netbeans.modules.editor.breadcrumbs.support.BreadCrumbsScheduler;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

public class BreadcrumbsController {
    public static final Class<? extends Scheduler> BREADCRUMBS_SCHEDULER = BreadCrumbsScheduler.class;
    public static final Image NO_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/editor/breadcrumbs/resources/no-icon.png");

    private BreadcrumbsController() {
    }

    public static void setBreadcrumbs(@NonNull Document doc, final @NonNull Node root, final @NonNull Node selected) {
        Parameters.notNull((CharSequence)"doc", (Object)doc);
        Parameters.notNull((CharSequence)"root", (Object)root);
        Parameters.notNull((CharSequence)"selected", (Object)selected);
        final ExplorerManager manager = HolderImpl.get(doc).getManager();
        Children.MUTEX.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                manager.setRootContext(root);
                manager.setExploredContext(selected);
                return null;
            }
        });
    }

    public static boolean areBreadCrumsEnabled(@NonNull Document doc) {
        return ((Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class)).getBoolean("enable.breadcrumbs", true);
    }

    public static void addBreadCrumbsEnabledListener(final @NonNull ChangeListener l) {
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        prefs.addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if (evt == null || "enable.breadcrumbs".equals(evt.getKey())) {
                    l.stateChanged(new ChangeEvent(evt));
                }
            }
        });
    }

    public static SideBarFactory createSideBarFactory() {
        return new SideBarFactoryImpl();
    }
}

