/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NameAndPackagePanel
extends JPanel {
    static final String IS_VALID = "NameAndPackagePanel.isValidData";
    private JLabel classNameLabel;
    private JTextField classNameTextField;
    private JLabel packageNameLabel;
    private JTextField packageNameTextField;

    public NameAndPackagePanel(String className, String packageName) {
        this.initComponents();
        this.classNameTextField.setText(className);
        this.packageNameTextField.setText(packageName);
    }

    public String getClassName() {
        return this.classNameTextField.getText();
    }

    public String getPackageName() {
        return this.packageNameTextField.getText();
    }

    public boolean isValidData() {
        return this.isValidTypeIdentifier(this.getClassName()) && this.isValidPackageName(this.getPackageName());
    }

    private boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidTypeIdentifier(String ident) {
        return ident != null && !"".equals(ident) && Utilities.isJavaIdentifier((String)ident);
    }

    private void initComponents() {
        this.classNameLabel = new JLabel();
        this.classNameTextField = new JTextField();
        this.packageNameLabel = new JLabel();
        this.packageNameTextField = new JTextField();
        this.classNameLabel.setLabelFor(this.classNameTextField);
        this.classNameLabel.setText(NbBundle.getMessage(NameAndPackagePanel.class, (String)"LBL_ClassName"));
        this.classNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NameAndPackagePanel.this.classNameTextFieldKeyTyped(evt);
            }
        });
        this.packageNameLabel.setLabelFor(this.packageNameTextField);
        this.packageNameLabel.setText(NbBundle.getMessage(NameAndPackagePanel.class, (String)"LBL_PackageName"));
        this.packageNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NameAndPackagePanel.this.packageNameTextFieldKeyTyped(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.packageNameLabel).addComponent(this.classNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classNameTextField).addComponent(this.packageNameTextField, -1, 272, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.classNameLabel).addComponent(this.classNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageNameLabel).addComponent(this.packageNameTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void classNameTextFieldKeyTyped(KeyEvent evt) {
        this.firePropertyChange(IS_VALID, null, null);
    }

    private void packageNameTextFieldKeyTyped(KeyEvent evt) {
        this.firePropertyChange(IS_VALID, null, null);
    }
}

