/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.suggestions.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;

public class InvertIf {
    public static ErrorDescription computeWarning(HintContext ctx) {
        TreePath cond = (TreePath)ctx.getVariables().get("$cond");
        long conditionEnd = ctx.getInfo().getTrees().getSourcePositions().getEndPosition(cond.getCompilationUnit(), cond.getParentPath().getLeaf());
        if ((long)ctx.getCaretLocation() > conditionEnd) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_InvertIf(), (Fix[])new Fix[]{new FixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix()});
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_InvertIf();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            IfTree toRewrite = (IfTree)ctx.getPath().getLeaf();
            ctx.getWorkingCopy().rewrite((Tree)toRewrite, (Tree)ctx.getWorkingCopy().getTreeMaker().If(toRewrite.getCondition(), toRewrite.getElseStatement(), toRewrite.getThenStatement()));
            this.negate(ctx.getWorkingCopy(), toRewrite.getCondition(), toRewrite);
        }

        private void negate(WorkingCopy copy, ExpressionTree original, Tree parent) {
            ExpressionTree newTree;
            TreeMaker make = copy.getTreeMaker();
            switch (original.getKind()) {
                case PARENTHESIZED: {
                    ExpressionTree expr = ((ParenthesizedTree)original).getExpression();
                    this.negate(copy, expr, original);
                    return;
                }
                case LOGICAL_COMPLEMENT: {
                    newTree = ((UnaryTree)original).getExpression();
                    while (newTree.getKind() == Tree.Kind.PARENTHESIZED && !JavaFixUtilities.requiresParenthesis((Tree)((ParenthesizedTree)newTree).getExpression(), (Tree)original, (Tree)parent)) {
                        newTree = ((ParenthesizedTree)newTree).getExpression();
                    }
                    break;
                }
                case NOT_EQUAL_TO: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.EQUAL_TO, false);
                    break;
                }
                case EQUAL_TO: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.NOT_EQUAL_TO, false);
                    break;
                }
                case BOOLEAN_LITERAL: {
                    newTree = make.Literal((Object)((Boolean)((LiteralTree)original).getValue() == false ? 1 : 0));
                    break;
                }
                case CONDITIONAL_AND: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.CONDITIONAL_OR, true);
                    break;
                }
                case CONDITIONAL_OR: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.CONDITIONAL_AND, true);
                    break;
                }
                case LESS_THAN: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.GREATER_THAN_EQUAL, false);
                    break;
                }
                case LESS_THAN_EQUAL: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.GREATER_THAN, false);
                    break;
                }
                case GREATER_THAN: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.LESS_THAN_EQUAL, false);
                    break;
                }
                case GREATER_THAN_EQUAL: {
                    newTree = this.negateBinaryOperator(copy, original, Tree.Kind.LESS_THAN, false);
                    break;
                }
                default: {
                    newTree = make.Unary(Tree.Kind.LOGICAL_COMPLEMENT, original);
                }
            }
            if (JavaFixUtilities.requiresParenthesis((Tree)newTree, (Tree)original, (Tree)parent)) {
                newTree = make.Parenthesized(newTree);
            }
            copy.rewrite((Tree)original, (Tree)newTree);
        }

        private ExpressionTree negateBinaryOperator(WorkingCopy copy, Tree original, Tree.Kind newKind, boolean negateOperands) {
            BinaryTree bt = (BinaryTree)original;
            if (negateOperands) {
                this.negate(copy, bt.getLeftOperand(), original);
                this.negate(copy, bt.getRightOperand(), original);
            }
            return copy.getTreeMaker().Binary(newKind, bt.getLeftOperand(), bt.getRightOperand());
        }
    }
}

