/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;

public class IteratorToFor {
    public static ErrorDescription whileIdiom(HintContext ctx) {
        if (IteratorToFor.uses(ctx, (Collection)ctx.getMultiVariables().get("$rest$"), (TreePath)ctx.getVariables().get("$it"))) {
            return null;
        }
        if (!IteratorToFor.iterable(ctx, (TreePath)ctx.getVariables().get("$coll"), (TreePath)ctx.getVariables().get("$type"))) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_IteratorToFor(), (Fix[])new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)Bundle.FIX_IteratorToFor(), (TreePath)ctx.getPath(), (String)"for ($type $elem : $coll) {$rest$;}")});
    }

    public static ErrorDescription forIdiom(HintContext ctx) {
        if (IteratorToFor.uses(ctx, (Collection)ctx.getMultiVariables().get("$rest$"), (TreePath)ctx.getVariables().get("$it"))) {
            return null;
        }
        if (!IteratorToFor.iterable(ctx, (TreePath)ctx.getVariables().get("$coll"), (TreePath)ctx.getVariables().get("$type"))) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_IteratorToFor(), (Fix[])new Fix[]{JavaFixUtilities.rewriteFix((HintContext)ctx, (String)Bundle.FIX_IteratorToFor(), (TreePath)ctx.getPath(), (String)"for ($type $elem : $coll) {$rest$;}")});
    }

    private static boolean uses(final HintContext ctx, Collection<? extends TreePath> statements, TreePath var) {
        final Element e = ctx.getInfo().getTrees().getElement(var);
        for (TreePath treePath : statements) {
            boolean occurs = Boolean.TRUE.equals(new TreePathScanner<Boolean, Void>(){

                @Override
                public Boolean scan(Tree tree, Void p) {
                    if (tree == null) {
                        return false;
                    }
                    TreePath currentPath = new TreePath(this.getCurrentPath(), tree);
                    Element currentElement = ctx.getInfo().getTrees().getElement(currentPath);
                    if (((Object)e).equals(currentElement)) {
                        return true;
                    }
                    return (Boolean)super.scan(tree, p);
                }

                @Override
                public Boolean reduce(Boolean r1, Boolean r2) {
                    if (r1 == null) {
                        return r2;
                    }
                    if (r2 == null) {
                        return r1;
                    }
                    return r1 != false || r2 != false;
                }
            }.scan(treePath, (Void)null));
            if (!occurs) continue;
            return true;
        }
        return false;
    }

    private static boolean iterable(HintContext ctx, TreePath collection, TreePath type) {
        TypeMirror collectionType = ctx.getInfo().getTrees().getTypeMirror(collection);
        TypeElement iterable = ctx.getInfo().getElements().getTypeElement("java.lang.Iterable");
        if (collectionType == null || iterable == null) {
            return false;
        }
        DeclaredType iterableType = ctx.getInfo().getTypes().getDeclaredType(iterable, ctx.getInfo().getTypes().getWildcardType(ctx.getInfo().getTrees().getTypeMirror(type), null));
        DeclaredType bogusIterableType = ctx.getInfo().getTypes().getDeclaredType(iterable, ctx.getInfo().getTypes().getNullType());
        return ctx.getInfo().getTypes().isAssignable(collectionType, iterableType) && !ctx.getInfo().getTypes().isAssignable(collectionType, bogusIterableType);
    }
}

