/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class ConvertToStringSwitch {
    static final boolean DEF_ALSO_EQ = true;
    static final String KEY_ALSO_EQ = "also-equals";
    private static final String[] INIT_PATTERNS = new String[]{"$c1.equals($c2)", "$c1.contentEquals($c2)"};
    private static final String[] INIT_PATTERNS_EQ = new String[]{"$c1 == $c2"};
    private static final String[] PATTERNS = new String[]{"$var.equals($constant)", "$constant.equals($var)", "$var.contentEquals($constant)", "$constant.contentEquals($var)"};
    private static final String[] PATTERNS_EQ = new String[]{"$var == $constant", "$constant == $var"};

    public static List<ErrorDescription> hint(HintContext ctx) {
        TreePath variable;
        TreePathHandle defaultStatement;
        ArrayList<CatchDescription<TreePathHandle>> literal2Statement;
        block17: {
            if (ctx.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.IF || ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_7) < 0) {
                return null;
            }
            TypeElement jlString = ctx.getInfo().getElements().getTypeElement("java.lang.String");
            if (jlString == null) {
                return null;
            }
            literal2Statement = new ArrayList<CatchDescription<TreePathHandle>>();
            defaultStatement = null;
            Iterable<? extends TreePath> conds = ConvertToStringSwitch.linearizeOrs((TreePath)ctx.getVariables().get("$cond"));
            Iterator<? extends TreePath> iter = conds.iterator();
            TreePath first = iter.next();
            variable = null;
            ArrayList<String> initPatterns = new ArrayList<String>(INIT_PATTERNS.length + INIT_PATTERNS_EQ.length);
            initPatterns.addAll(Arrays.asList(INIT_PATTERNS));
            if (ctx.getPreferences().getBoolean(KEY_ALSO_EQ, true)) {
                initPatterns.addAll(Arrays.asList(INIT_PATTERNS_EQ));
            }
            for (String initPattern : initPatterns) {
                if (!MatcherUtilities.matches((HintContext)ctx, (TreePath)first, (String)initPattern, (boolean)true)) continue;
                TreePath c1 = (TreePath)ctx.getVariables().get("$c1");
                TreePath c2 = (TreePath)ctx.getVariables().get("$c2");
                TreePath treePath = (TreePath)ctx.getVariables().get("$body");
                LinkedList<TreePathHandle> literals = new LinkedList<TreePathHandle>();
                if (Utilities.isConstantString(ctx.getInfo(), c1)) {
                    literals.add(TreePathHandle.create((TreePath)c1, (CompilationInfo)ctx.getInfo()));
                    variable = c2;
                } else if (Utilities.isConstantString(ctx.getInfo(), c2)) {
                    literals.add(TreePathHandle.create((TreePath)c2, (CompilationInfo)ctx.getInfo()));
                    variable = c1;
                } else {
                    return null;
                }
                TypeMirror varType = ctx.getInfo().getTrees().getTypeMirror(variable);
                if (!ctx.getInfo().getTypes().isSameType(varType, jlString.asType())) {
                    return null;
                }
                ctx.getVariables().put("$var", variable);
                while (iter.hasNext()) {
                    TreePath lt = ConvertToStringSwitch.isStringComparison(ctx, iter.next());
                    if (lt == null) {
                        return null;
                    }
                    literals.add(TreePathHandle.create((TreePath)lt, (CompilationInfo)ctx.getInfo()));
                }
                literal2Statement.add(new CatchDescription<TreePathHandle>(literals, TreePathHandle.create((TreePath)treePath, (CompilationInfo)ctx.getInfo())));
                break;
            }
            if (variable == null) {
                return null;
            }
            TreePath tp = (TreePath)ctx.getVariables().get("$else");
            while (tp.getLeaf().getKind() == Tree.Kind.IF) {
                IfTree it = (IfTree)tp.getLeaf();
                LinkedList<TreePathHandle> literals = new LinkedList<TreePathHandle>();
                for (TreePath treePath : ConvertToStringSwitch.linearizeOrs(new TreePath(tp, it.getCondition()))) {
                    TreePath lt = ConvertToStringSwitch.isStringComparison(ctx, treePath);
                    if (lt == null || !Utilities.isConstantString(ctx.getInfo(), lt)) {
                        return null;
                    }
                    literals.add(TreePathHandle.create((TreePath)lt, (CompilationInfo)ctx.getInfo()));
                }
                literal2Statement.add(new CatchDescription<TreePathHandle>(literals, TreePathHandle.create((TreePath)new TreePath(tp, it.getThenStatement()), (CompilationInfo)ctx.getInfo())));
                if (it.getElseStatement() != null) {
                    tp = new TreePath(tp, it.getElseStatement());
                    continue;
                }
                break block17;
            }
            defaultStatement = TreePathHandle.create((TreePath)tp, (CompilationInfo)ctx.getInfo());
        }
        if (literal2Statement.size() <= 1) {
            return null;
        }
        Fix convert = new ConvertToSwitch(ctx.getInfo(), ctx.getPath(), TreePathHandle.create(variable, (CompilationInfo)ctx.getInfo()), literal2Statement, defaultStatement).toEditorFix();
        ErrorDescription ed = ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)"Convert to switch", (Fix[])new Fix[]{convert});
        return Collections.singletonList(ed);
    }

    private static TreePath isStringComparison(HintContext ctx, TreePath tp) {
        Tree leaf = tp.getLeaf();
        while (leaf.getKind() == Tree.Kind.PARENTHESIZED) {
            tp = new TreePath(tp, ((ParenthesizedTree)leaf).getExpression());
            leaf = tp.getLeaf();
        }
        ArrayList<String> patterns = new ArrayList<String>(PATTERNS.length + PATTERNS_EQ.length);
        patterns.addAll(Arrays.asList(PATTERNS));
        if (ctx.getPreferences().getBoolean(KEY_ALSO_EQ, true)) {
            patterns.addAll(Arrays.asList(PATTERNS_EQ));
        }
        for (String patt : patterns) {
            ctx.getVariables().remove("$constant");
            if (!MatcherUtilities.matches((HintContext)ctx, (TreePath)tp, (String)patt, (boolean)true)) continue;
            return (TreePath)ctx.getVariables().get("$constant");
        }
        return null;
    }

    private static Iterable<? extends TreePath> linearizeOrs(TreePath cond) {
        LinkedList<TreePath> result = new LinkedList<TreePath>();
        while (cond.getLeaf().getKind() == Tree.Kind.CONDITIONAL_OR || cond.getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
            if (cond.getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
                cond = new TreePath(cond, ((ParenthesizedTree)cond.getLeaf()).getExpression());
                continue;
            }
            BinaryTree bt = (BinaryTree)cond.getLeaf();
            result.add(new TreePath(cond, bt.getRightOperand()));
            cond = new TreePath(cond, bt.getLeftOperand());
        }
        result.add(cond);
        Collections.reverse(result);
        return result;
    }

    private static final class CatchDescription<T> {
        @NullAllowed
        private final Iterable<TreePathHandle> literals;
        @NonNull
        private final T path;

        public CatchDescription(Iterable<TreePathHandle> literals, T path) {
            this.literals = literals;
            this.path = path;
        }
    }

    private static final class ConvertToSwitch
    extends JavaFix {
        private final TreePathHandle value;
        private final List<CatchDescription<TreePathHandle>> literal2Statement;
        private final TreePathHandle defaultStatement;
        private static final String DEFAULT_LABEL = "OUTER";

        public ConvertToSwitch(CompilationInfo info, TreePath create, TreePathHandle value, List<CatchDescription<TreePathHandle>> literal2Statement, TreePathHandle defaultStatement) {
            super(info, create);
            this.value = value;
            this.literal2Statement = literal2Statement;
            this.defaultStatement = defaultStatement;
        }

        public String getText() {
            return NbBundle.getMessage(ConvertToStringSwitch.class, (String)"FIX_ConvertToStringSwitch");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath it = ctx.getPath();
            TreeMaker make = copy.getTreeMaker();
            LinkedList<CaseTree> cases = new LinkedList<CaseTree>();
            ArrayList<CatchDescription<TreePath>> resolved = new ArrayList<CatchDescription<TreePath>>(this.literal2Statement.size() + 1);
            IdentityHashMap<TreePath, Set<Name>> catch2Declared = new IdentityHashMap<TreePath, Set<Name>>();
            IdentityHashMap<TreePath, Set<Name>> catch2Used = new IdentityHashMap<TreePath, Set<Name>>();
            IdentityHashMap<BreakTree, StatementTree> break2Target = new IdentityHashMap<BreakTree, StatementTree>();
            for (CatchDescription<TreePathHandle> catchDescription : this.literal2Statement) {
                TreePath s = ((TreePathHandle)((CatchDescription)catchDescription).path).resolve((CompilationInfo)copy);
                if (s == null) {
                    return;
                }
                resolved.add(new CatchDescription<TreePath>(((CatchDescription)catchDescription).literals, s));
                catch2Declared.put(s, this.declaredVariables(s));
                catch2Used.put(s, this.usedVariables((CompilationInfo)copy, s, break2Target));
            }
            if (this.defaultStatement != null) {
                TreePath s = this.defaultStatement.resolve((CompilationInfo)copy);
                if (s == null) {
                    return;
                }
                resolved.add(new CatchDescription<TreePath>(null, s));
                catch2Declared.put(s, this.declaredVariables(s));
                catch2Used.put(s, this.usedVariables((CompilationInfo)copy, s, break2Target));
            }
            for (CatchDescription<Object> catchDescription : resolved) {
                if (!this.addCase(copy, catchDescription, cases, catch2Declared, catch2Used)) continue;
                return;
            }
            TreePath value = this.value.resolve((CompilationInfo)copy);
            SwitchTree switchTree = make.Switch((ExpressionTree)value.getLeaf(), cases);
            Utilities.copyComments(copy, it.getLeaf(), switchTree, true);
            copy.rewrite(it.getLeaf(), (Tree)switchTree);
            TreePath topLevelMethod = it;
            while (topLevelMethod.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && topLevelMethod.getParentPath().getLeaf().getKind() != Tree.Kind.CLASS && topLevelMethod.getParentPath().getLeaf().getKind() != Tree.Kind.METHOD) {
                topLevelMethod = topLevelMethod.getParentPath();
            }
            final HashSet<String> seenLabels = new HashSet<String>();
            new TreeScanner<Void, Void>(){

                @Override
                public Void visitLabeledStatement(LabeledStatementTree node, Void p) {
                    seenLabels.add(node.getLabel().toString());
                    return (Void)super.visitLabeledStatement(node, p);
                }
            }.scan(topLevelMethod.getLeaf(), null);
            IdentityHashMap labels = new IdentityHashMap();
            for (Map.Entry e : break2Target.entrySet()) {
                String label = (String)labels.get(e.getValue());
                if (label == null) {
                    label = ConvertToSwitch.computeLabel(seenLabels);
                    labels.put(e.getValue(), label);
                    copy.rewrite((Tree)e.getValue(), (Tree)make.LabeledStatement((CharSequence)label, (StatementTree)e.getValue()));
                }
                copy.rewrite((Tree)e.getKey(), (Tree)make.Break((CharSequence)label));
            }
        }

        private static String computeLabel(Set<String> labels) {
            int index = 0;
            String append = "";
            while (labels.contains(DEFAULT_LABEL + append)) {
                append = "_" + ++index;
            }
            labels.add(DEFAULT_LABEL + append);
            return DEFAULT_LABEL + append;
        }

        private boolean addCase(WorkingCopy copy, CatchDescription<TreePath> desc, List<CaseTree> cases, Map<TreePath, Set<Name>> catch2Declared, Map<TreePath, Set<Name>> catch2Used) {
            TreeMaker make = copy.getTreeMaker();
            LinkedList statements = new LinkedList();
            Tree then = ((TreePath)((CatchDescription)desc).path).getLeaf();
            if (then.getKind() == Tree.Kind.BLOCK) {
                Set<Name> currentDeclared = catch2Declared.get(((CatchDescription)desc).path);
                boolean keepBlock = false;
                for (Map.Entry<TreePath, Set<Name>> e : catch2Declared.entrySet()) {
                    if (e.getKey() == ((CatchDescription)desc).path || Collections.disjoint(currentDeclared, (Collection)e.getValue())) continue;
                    keepBlock = true;
                    break;
                }
                if (!keepBlock) {
                    for (Map.Entry<TreePath, Set<Name>> e : catch2Used.entrySet()) {
                        if (e.getKey() == ((CatchDescription)desc).path || Collections.disjoint(currentDeclared, (Collection)e.getValue())) continue;
                        keepBlock = true;
                        break;
                    }
                }
                boolean exitsFromAllBranches = false;
                for (StatementTree statementTree : ((BlockTree)then).getStatements()) {
                    exitsFromAllBranches |= Utilities.exitsFromAllBranchers((CompilationInfo)copy, new TreePath((TreePath)((CatchDescription)desc).path, statementTree));
                }
                BlockTree block = (BlockTree)then;
                if (keepBlock) {
                    if (!exitsFromAllBranches) {
                        statements.add(make.addBlockStatement(block, (StatementTree)make.Break(null)));
                    } else {
                        statements.add(block);
                    }
                } else {
                    statements.addAll(block.getStatements());
                    if (!exitsFromAllBranches) {
                        statements.add(make.Break(null));
                    }
                }
            } else {
                statements.add((StatementTree)then);
                if (!Utilities.exitsFromAllBranchers((CompilationInfo)copy, (TreePath)((CatchDescription)desc).path)) {
                    statements.add(make.Break(null));
                }
            }
            if (((CatchDescription)desc).literals == null) {
                cases.add(make.Case(null, statements));
                return false;
            }
            Iterator it = ((CatchDescription)desc).literals.iterator();
            while (it.hasNext()) {
                TreePathHandle tph = (TreePathHandle)it.next();
                TreePath lit = tph.resolve((CompilationInfo)copy);
                if (lit == null) {
                    return true;
                }
                List body = it.hasNext() ? Collections.emptyList() : statements;
                cases.add(make.Case((ExpressionTree)lit.getLeaf(), body));
            }
            return false;
        }

        private Set<Name> declaredVariables(TreePath where) {
            HashSet<Name> result = new HashSet<Name>();
            List<Tree> statements = where.getLeaf().getKind() == Tree.Kind.BLOCK ? ((BlockTree)where.getLeaf()).getStatements() : Collections.singletonList(where.getLeaf());
            for (Tree t : statements) {
                if (t.getKind() != Tree.Kind.VARIABLE) continue;
                result.add(((VariableTree)t).getName());
            }
            return result;
        }

        private Set<Name> usedVariables(final CompilationInfo info, TreePath where, final Map<BreakTree, StatementTree> break2Target) {
            final HashSet<Name> result = new HashSet<Name>();
            final HashSet declared = new HashSet();
            final HashSet<Tree> above = new HashSet<Tree>();
            for (Tree t : where) {
                above.add(t);
            }
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    if (declared.contains(info.getTrees().getElement(this.getCurrentPath()))) {
                        return null;
                    }
                    result.add(node.getName());
                    return (Void)super.visitIdentifier(node, p);
                }

                @Override
                public Void visitVariable(VariableTree node, Void p) {
                    declared.add(info.getTrees().getElement(this.getCurrentPath()));
                    return (Void)super.visitVariable(node, p);
                }

                @Override
                public Void visitBreak(BreakTree node, Void p) {
                    StatementTree target;
                    if (node.getLabel() == null && above.contains(target = info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()))) {
                        break2Target.put(node, target);
                    }
                    return (Void)super.visitBreak(node, p);
                }
            }.scan(where, (Void)null);
            return result;
        }
    }
}

