/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.SelectionAwareJavaSourceTaskFactory;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.modules.java.hints.providers.spi.PositionRefresherHelper;
import org.netbeans.spi.editor.hints.Context;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;

public class PositionRefresherHelperImpl
extends PositionRefresherHelper<DocumentVersionImpl> {
    public PositionRefresherHelperImpl() {
        super(IntroduceHint.class.getName());
    }

    protected boolean isUpToDate(Context context, Document doc, DocumentVersionImpl oldVersion) {
        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
        if (file == null) {
            return false;
        }
        int[] selection = SelectionAwareJavaSourceTaskFactory.getLastSelection((FileObject)file);
        if (selection == null) {
            return false;
        }
        return oldVersion.introduceSelStart != (long)selection[0] || oldVersion.introduceSelEnd != (long)selection[1];
    }

    public List<ErrorDescription> getErrorDescriptionsAt(CompilationInfo info, Context context, Document doc) throws Exception {
        int[] selection = SelectionAwareJavaSourceTaskFactory.getLastSelection((FileObject)info.getFileObject());
        if (selection == null) {
            return Collections.emptyList();
        }
        return IntroduceHint.computeError(info, selection[0], selection[1], new EnumMap<IntroduceKind, Fix>(IntroduceKind.class), new EnumMap<IntroduceKind, String>(IntroduceKind.class), context.getCancel());
    }

    static void setVersion(Document doc, int selStart, int selEnd) {
        for (PositionRefresherHelper h : MimeLookup.getLookup((String)"text/x-java").lookupAll(PositionRefresherHelper.class)) {
            if (!(h instanceof PositionRefresherHelperImpl)) continue;
            ((PositionRefresherHelperImpl)h).setVersion(doc, new DocumentVersionImpl(doc, selStart, selEnd));
        }
    }

    static final class DocumentVersionImpl
    extends PositionRefresherHelper.DocumentVersion {
        private final long introduceSelStart;
        private final long introduceSelEnd;

        public DocumentVersionImpl(Document doc, long introduceSelStart, long introduceSelEnd) {
            super(doc);
            this.introduceSelStart = introduceSelStart;
            this.introduceSelEnd = introduceSelEnd;
        }
    }
}

