/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.ChangeMethodReturnType;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class MissingReturnStatement
implements ErrorRule<Void> {
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.err.missing.ret.stmt"));

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        TreePath tp;
        TreePath method = null;
        for (tp = compilationInfo.getTreeUtilities().pathFor(offset); tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()); tp = tp.getParentPath()) {
            if (tp.getLeaf().getKind() != Tree.Kind.METHOD) continue;
            method = tp;
            break;
        }
        if (method == null) {
            return null;
        }
        MethodTree mt = (MethodTree)tp.getLeaf();
        if (mt.getReturnType() == null) {
            return null;
        }
        ArrayList<Fix> result = new ArrayList<Fix>(2);
        result.add(new FixImpl(compilationInfo.getSnapshot().getSource(), TreePathHandle.create((TreePath)tp, (CompilationInfo)compilationInfo)));
        result.add(new ChangeMethodReturnType.FixImpl(compilationInfo, tp, TypeMirrorHandle.create((TypeMirror)compilationInfo.getTypes().getNoType(TypeKind.VOID)), "void").toEditorFix());
        return result;
    }

    public String getId() {
        return MissingReturnStatement.class.getCanonicalName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MissingReturnStatement.class, (String)"DN_MissingReturnStatement");
    }

    public void cancel() {
    }

    private static final class FixImpl
    implements Fix {
        private final Source source;
        private final TreePathHandle methodHandle;

        public FixImpl(Source source, TreePathHandle methodHandle) {
            this.source = source;
            this.methodHandle = methodHandle;
        }

        public String getText() {
            return NbBundle.getMessage(MissingReturnStatement.class, (String)"FIX_AddReturnStatement");
        }

        public ChangeInfo implement() throws Exception {
            ModificationResult mr = ModificationResult.runModificationTask(Collections.singleton(this.source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Element methodEl;
                    WorkingCopy wc = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath method = FixImpl.this.methodHandle.resolve((CompilationInfo)wc);
                    Element element = methodEl = method != null ? wc.getTrees().getElement(method) : null;
                    if (methodEl == null || methodEl.getKind() != ElementKind.METHOD) {
                        return;
                    }
                    assert (method.getLeaf().getKind() == Tree.Kind.METHOD);
                    BlockTree body = ((MethodTree)method.getLeaf()).getBody();
                    TypeMirror type = ((ExecutableElement)methodEl).getReturnType();
                    TypeKind kind = type.getKind();
                    Comparable<Boolean> value = kind.isPrimitive() ? (kind == TypeKind.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0)) : null;
                    TreeMaker make = wc.getTreeMaker();
                    LiteralTree nullValue = make.Literal((Object)value);
                    wc.tag((Tree)nullValue, (Object)"select");
                    wc.rewrite((Tree)body, (Tree)make.addBlockStatement(body, (StatementTree)make.Return((ExpressionTree)nullValue)));
                }
            });
            return Utilities.commitAndComputeChangeInfo(this.source.getFileObject(), mr);
        }
    }
}

