/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MakeVariableFinal
implements ErrorRule<Void> {
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.err.local.var.accessed.from.icls.needs.final"));

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        Tree leaf = treePath.getLeaf();
        if (leaf.getKind() == Tree.Kind.IDENTIFIER) {
            Element el = compilationInfo.getTrees().getElement(treePath);
            TreePath declaration = compilationInfo.getTrees().getPath(el);
            if (declaration != null) {
                return Collections.singletonList(new FixImpl(compilationInfo.getFileObject(), el.getSimpleName().toString(), TreePathHandle.create((TreePath)declaration, (CompilationInfo)compilationInfo)));
            }
        }
        return Collections.emptyList();
    }

    public void cancel() {
    }

    public String getId() {
        return MakeVariableFinal.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MakeVariableFinal.class, (String)"DN_MakeVariableFinal");
    }

    public String getDescription() {
        return NbBundle.getMessage(MakeVariableFinal.class, (String)"DESC_MakeVariableFinal");
    }

    private static final class FixImpl
    implements Fix {
        private String variableName;
        private TreePathHandle variable;
        private FileObject file;

        public FixImpl(FileObject file, String variableName, TreePathHandle variable) {
            this.file = file;
            this.variableName = variableName;
            this.variable = variable;
        }

        public String getText() {
            return NbBundle.getMessage(MakeVariableFinal.class, (String)"FIX_MakeVariableFinal", (Object[])new Object[]{String.valueOf(this.variableName)});
        }

        public ChangeInfo implement() throws IOException {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws IOException {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath tp = FixImpl.this.variable.resolve((CompilationInfo)wc);
                    if (tp == null) {
                        return;
                    }
                    VariableTree vt = (VariableTree)tp.getLeaf();
                    ModifiersTree mt = vt.getModifiers();
                    EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
                    modifiers.addAll(mt.getFlags());
                    modifiers.add(Modifier.FINAL);
                    ModifiersTree newMod = wc.getTreeMaker().Modifiers(modifiers, mt.getAnnotations());
                    wc.rewrite((Tree)mt, (Tree)newMod);
                }
            }).commit();
            return null;
        }

        public int hashCode() {
            return this.variable.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FixImpl)) {
                return false;
            }
            return this.variable.equals((Object)((FixImpl)obj).variable);
        }
    }
}

