/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.errors.ErrorFixesFakeHint;
import org.netbeans.modules.java.hints.errors.UncaughtException;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

final class MagicSurroundWithTryCatchFix
implements Fix {
    private JavaSource js;
    private List<TypeMirrorHandle> thandles;
    private int offset;
    private ElementHandle<ExecutableElement> method;
    List<String> fqns;
    private static final String[] STREAM_ALIKE_CLASSES = new String[]{"java.io.InputStream", "java.io.OutputStream", "java.io.Reader", "java.io.Writer"};

    public MagicSurroundWithTryCatchFix(JavaSource js, List<TypeMirrorHandle> thandles, int offset, ElementHandle<ExecutableElement> method, List<String> fqns) {
        this.js = js;
        this.thandles = thandles;
        this.offset = offset;
        this.method = method;
        this.fqns = fqns;
    }

    public String getText() {
        return NbBundle.getMessage(MagicSurroundWithTryCatchFix.class, (String)"LBL_SurroundBlockWithTryCatch");
    }

    private boolean isStreamAlike(CompilationInfo info, TypeMirror type) {
        for (String fqn : STREAM_ALIKE_CLASSES) {
            TypeElement inputStream = info.getElements().getTypeElement(fqn);
            if (!info.getTypes().isAssignable(type, inputStream.asType())) continue;
            return true;
        }
        return false;
    }

    public ChangeInfo implement() throws IOException {
        ModificationResult mr = this.js.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy wc) throws Exception {
                TreePath tryPath;
                TreePath currentPath;
                wc.toPhase(JavaSource.Phase.RESOLVED);
                for (currentPath = wc.getTreeUtilities().pathFor(MagicSurroundWithTryCatchFix.this.offset + 1); currentPath != null && !UncaughtException.STATEMENT_KINDS.contains((Object)currentPath.getLeaf().getKind()); currentPath = currentPath.getParentPath()) {
                }
                TreePath statement = currentPath;
                boolean streamAlike = false;
                if (statement.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                    Element curType = wc.getTrees().getElement(statement);
                    streamAlike = MagicSurroundWithTryCatchFix.this.isStreamAlike((CompilationInfo)wc, curType.asType());
                }
                if ((tryPath = MagicSurroundWithTryCatchFix.enclosingTry(currentPath)) != null) {
                    new TransformerImpl(wc, MagicSurroundWithTryCatchFix.this.thandles, streamAlike, statement).scan(tryPath, null);
                } else {
                    TreePath blockTree;
                    for (blockTree = currentPath; blockTree != null && blockTree.getLeaf().getKind() != Tree.Kind.BLOCK; blockTree = blockTree.getParentPath()) {
                    }
                    GeneratorUtilities.get((WorkingCopy)wc).importComments(blockTree.getLeaf(), blockTree.getCompilationUnit());
                    new TransformerImpl(wc, MagicSurroundWithTryCatchFix.this.thandles, streamAlike, statement).scan(blockTree, null);
                }
            }
        });
        return Utilities.commitAndComputeChangeInfo((FileObject)this.js.getFileObjects().iterator().next(), mr);
    }

    static TreePath enclosingTry(TreePath from) {
        TreePath tryPath;
        for (tryPath = from; tryPath != null && tryPath.getLeaf().getKind() != Tree.Kind.TRY && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tryPath.getLeaf().getKind()) && tryPath.getLeaf().getKind() != Tree.Kind.CATCH; tryPath = tryPath.getParentPath()) {
        }
        if (tryPath.getLeaf().getKind() == Tree.Kind.TRY) {
            TryTree tt = (TryTree)tryPath.getLeaf();
            for (Tree t : from) {
                if (tt.getFinallyBlock() != t) continue;
                return null;
            }
            return tryPath;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MagicSurroundWithTryCatchFix other = (MagicSurroundWithTryCatchFix)obj;
        if (!(this.js == other.js || this.js != null && this.js.equals(other.js))) {
            return false;
        }
        if (!((Object)this.fqns).equals(other.fqns)) {
            return false;
        }
        return this.method == other.method || this.method != null && this.method.equals(other.method);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.js != null ? this.js.hashCode() : 0);
        hash = 23 * hash + (this.method != null ? this.method.hashCode() : 0);
        return hash;
    }

    private static StatementTree createExceptionsStatement(CompilationInfo info, TreeMaker make, String name) {
        if (!ErrorFixesFakeHint.isUseExceptions()) {
            return null;
        }
        TypeElement exceptions = info.getElements().getTypeElement("org.openide.util.Exceptions");
        if (exceptions == null) {
            return null;
        }
        return make.ExpressionStatement((ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(make.QualIdent((Element)exceptions), (CharSequence)"printStackTrace"), Arrays.asList(make.Identifier((CharSequence)name))));
    }

    private static StatementTree createLogStatement(CompilationInfo info, TreeMaker make, TreePath statement, String name) {
        if (!ErrorFixesFakeHint.isUseLogger()) {
            return null;
        }
        if (!GeneratorUtils.supportsOverride((CompilationInfo)info)) {
            return null;
        }
        TypeElement logger = info.getElements().getTypeElement("java.util.logging.Logger");
        TypeElement level = info.getElements().getTypeElement("java.util.logging.Level");
        if (logger == null || level == null) {
            return null;
        }
        ClassTree containingTopLevel = null;
        for (Tree t : statement) {
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) continue;
            containingTopLevel = (ClassTree)t;
        }
        LiteralTree arg = containingTopLevel != null ? make.Identifier((CharSequence)(containingTopLevel.getSimpleName() + ".class.getName()")) : make.Literal((Object)"global");
        boolean useFQN = false;
        for (ImportTree importTree : info.getCompilationUnit().getImports()) {
            MemberSelectTree id = (MemberSelectTree)importTree.getQualifiedIdentifier();
            if (!"Logger".equals(id.getIdentifier()) || "java.util.logging.Logger".equals(id.toString())) continue;
            useFQN = true;
        }
        MethodInvocationTree etExpression = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(useFQN ? make.Identifier((CharSequence)logger.toString()) : make.QualIdent((Element)logger), (CharSequence)"getLogger"), Collections.singletonList(arg));
        MemberSelectTree memberSelectTree = make.MemberSelect(make.QualIdent((Element)level), (CharSequence)"SEVERE");
        return make.ExpressionStatement((ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)etExpression, (CharSequence)"log"), Arrays.asList(memberSelectTree, make.Literal(null), make.Identifier((CharSequence)name))));
    }

    private static StatementTree createRethrowAsRuntimeExceptionStatement(WorkingCopy info, TreeMaker make, String name) {
        if (!ErrorFixesFakeHint.isRethrowAsRuntimeException()) {
            return null;
        }
        TypeElement runtimeException = info.getElements().getTypeElement("java.lang.RuntimeException");
        if (runtimeException == null) {
            return null;
        }
        ExpressionTree exceptionName = make.QualIdent((Element)runtimeException);
        ThrowTree result = make.Throw((ExpressionTree)make.NewClass(null, Collections.emptyList(), exceptionName, Arrays.asList(make.Identifier((CharSequence)name)), null));
        info.tag((Tree)exceptionName, (Object)"select");
        return result;
    }

    private static StatementTree createRethrow(WorkingCopy info, TreeMaker make, String name) {
        if (!ErrorFixesFakeHint.isRethrow()) {
            return null;
        }
        ThrowTree result = make.Throw((ExpressionTree)make.Identifier((CharSequence)name));
        info.tag((Tree)result.getExpression(), (Object)"select");
        return result;
    }

    private static StatementTree createPrintStackTraceStatement(CompilationInfo info, TreeMaker make, String name) {
        return make.ExpressionStatement((ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)name), (CharSequence)"printStackTrace"), Collections.emptyList()));
    }

    private static CatchTree createCatch(WorkingCopy info, TreeMaker make, TreePath statement, String name, TypeMirror type) {
        StatementTree logStatement = MagicSurroundWithTryCatchFix.createExceptionsStatement((CompilationInfo)info, make, name);
        if (logStatement == null) {
            logStatement = MagicSurroundWithTryCatchFix.createLogStatement((CompilationInfo)info, make, statement, name);
        }
        if (logStatement == null) {
            logStatement = MagicSurroundWithTryCatchFix.createRethrowAsRuntimeExceptionStatement(info, make, name);
        }
        if (logStatement == null) {
            logStatement = MagicSurroundWithTryCatchFix.createRethrow(info, make, name);
        }
        if (logStatement == null) {
            logStatement = MagicSurroundWithTryCatchFix.createPrintStackTraceStatement((CompilationInfo)info, make, name);
        }
        return make.Catch(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name, make.Type(type), null), make.Block(Collections.singletonList(logStatement), false));
    }

    static List<CatchTree> createCatches(WorkingCopy info, TreeMaker make, List<TypeMirrorHandle> thandles, TreePath currentPath) {
        String name = MagicSurroundWithTryCatchFix.inferName((CompilationInfo)info, currentPath);
        ArrayList<CatchTree> catches = new ArrayList<CatchTree>();
        for (TypeMirrorHandle th : thandles) {
            TypeMirror tm = th.resolve((CompilationInfo)info);
            if (tm == null) continue;
            catches.add(MagicSurroundWithTryCatchFix.createCatch(info, make, currentPath, name, tm));
        }
        return catches;
    }

    private static String inferName(CompilationInfo info, TreePath currentPath) {
        Scope s = info.getTrees().getScope(currentPath);
        HashSet<String> existingVariables = new HashSet<String>();
        for (Element e : info.getElementUtilities().getLocalVars(s, new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element e, TypeMirror type) {
                return e != null && (e.getKind() == ElementKind.PARAMETER || e.getKind() == ElementKind.LOCAL_VARIABLE || e.getKind() == ElementKind.EXCEPTION_PARAMETER);
            }
        })) {
            existingVariables.add(e.getSimpleName().toString());
        }
        int index = 0;
        String proposal;
        while (existingVariables.contains(proposal = "ex" + (index == 0 ? "" : "" + index))) {
            ++index;
        }
        return proposal;
    }

    private final class TransformerImpl
    extends TreePathScanner<Void, Void> {
        private WorkingCopy info;
        private List<TypeMirrorHandle> thandles;
        private boolean streamAlike;
        private TreePath statement;
        private TreeMaker make;

        public TransformerImpl(WorkingCopy info, List<TypeMirrorHandle> thandles, boolean streamAlike, TreePath statement) {
            this.info = info;
            this.thandles = thandles;
            this.streamAlike = streamAlike;
            this.statement = statement;
            this.make = info.getTreeMaker();
        }

        @Override
        public Void visitTry(TryTree tt, Void p) {
            ArrayList<? extends CatchTree> catches = new ArrayList<CatchTree>();
            catches.addAll(tt.getCatches());
            catches.addAll(MagicSurroundWithTryCatchFix.createCatches(this.info, this.make, this.thandles, this.statement));
            if (!this.streamAlike) {
                this.info.rewrite((Tree)tt, (Tree)this.make.Try(tt.getResources(), tt.getBlock(), catches, tt.getFinallyBlock()));
            } else {
                VariableTree originalDeclaration = (VariableTree)this.statement.getLeaf();
                VariableTree declaration = this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)originalDeclaration.getName(), originalDeclaration.getType(), (ExpressionTree)this.make.Literal(null));
                ExpressionStatementTree assignment = this.make.ExpressionStatement((ExpressionTree)this.make.Assignment((ExpressionTree)this.make.Identifier((CharSequence)originalDeclaration.getName()), originalDeclaration.getInitializer()));
                ArrayList finallyStatements = new ArrayList(tt.getFinallyBlock() != null ? tt.getFinallyBlock().getStatements() : Collections.emptyList());
                finallyStatements.add(this.createFinallyCloseBlockStatement(originalDeclaration));
                BlockTree finallyTree = this.make.Block(finallyStatements, false);
                this.info.rewrite((Tree)originalDeclaration, (Tree)assignment);
                TryTree nueTry = this.make.Try(tt.getResources(), tt.getBlock(), catches, finallyTree);
                TreePath currentBlockCandidate = this.statement;
                while (currentBlockCandidate.getLeaf() != tt) {
                    currentBlockCandidate = currentBlockCandidate.getParentPath();
                }
                if ((currentBlockCandidate = currentBlockCandidate.getParentPath()).getLeaf().getKind() == Tree.Kind.BLOCK) {
                    BlockTree originalTree = (BlockTree)currentBlockCandidate.getLeaf();
                    ArrayList<? extends StatementTree> statements = new ArrayList<StatementTree>(originalTree.getStatements());
                    int index = statements.indexOf(tt);
                    statements.remove(index);
                    statements.add(index, nueTry);
                    statements.add(index, declaration);
                    this.info.rewrite((Tree)originalTree, (Tree)this.make.Block(statements, originalTree.isStatic()));
                } else {
                    BlockTree nueBlock = this.make.Block(Arrays.asList(declaration, nueTry), false);
                    this.info.rewrite((Tree)tt, (Tree)nueBlock);
                }
            }
            return null;
        }

        private StatementTree createFinallyCloseBlockStatement(VariableTree origDeclaration) {
            ExpressionStatementTree close;
            Trees trees = this.info.getTrees();
            TypeMirror tm = trees.getTypeMirror(this.statement);
            ElementUtilities elUtils = this.info.getElementUtilities();
            Iterable iterable = elUtils.getMembers(tm, new ElementUtilities.ElementAcceptor(){

                public boolean accept(Element e, TypeMirror type) {
                    return e.getKind() == ElementKind.METHOD && "close".equals(e.getSimpleName().toString());
                }
            });
            boolean throwsIO = false;
            block0: for (ExecutableElement elem : iterable) {
                if (!elem.getParameters().isEmpty()) continue;
                for (TypeMirror typeMirror : elem.getThrownTypes()) {
                    if (!"java.io.IOException".equals(((Object)typeMirror).toString())) continue;
                    throwsIO = true;
                    continue block0;
                }
            }
            Name name = origDeclaration.getName();
            StatementTree result = close = this.make.ExpressionStatement((ExpressionTree)this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)name), (CharSequence)"close"), Collections.emptyList()));
            if (throwsIO) {
                result = this.make.Try(this.make.Block(Collections.singletonList(close), false), Collections.singletonList(MagicSurroundWithTryCatchFix.createCatch(this.info, this.make, this.statement, MagicSurroundWithTryCatchFix.inferName((CompilationInfo)this.info, this.statement), this.info.getElements().getTypeElement("java.io.IOException").asType())), null);
            }
            return result;
        }

        private BlockTree createBlock(boolean statik, StatementTree ... trees) {
            LinkedList<StatementTree> statements = new LinkedList<StatementTree>();
            for (StatementTree t : trees) {
                if (t == null) continue;
                statements.add(t);
            }
            return this.make.Block(statements, statik);
        }

        @Override
        public Void visitBlock(BlockTree bt, Void p) {
            MethodTree mt;
            List<CatchTree> catches = MagicSurroundWithTryCatchFix.createCatches(this.info, this.make, this.thandles, this.statement);
            BlockTree toUse = bt;
            StatementTree toKeep = null;
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            if (parent.getKind() == Tree.Kind.METHOD && bt.getStatements().size() > 0 && (mt = (MethodTree)parent).getReturnType() == null) {
                toKeep = bt.getStatements().get(0);
                toUse = this.make.Block(bt.getStatements().subList(1, bt.getStatements().size()), false);
            }
            if (!this.streamAlike) {
                this.info.rewrite((Tree)bt, (Tree)this.createBlock(bt.isStatic(), toKeep, this.make.Try(toUse, catches, null)));
            } else {
                VariableTree originalDeclaration = (VariableTree)this.statement.getLeaf();
                VariableTree declaration = this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)originalDeclaration.getName(), originalDeclaration.getType(), (ExpressionTree)this.make.Identifier((CharSequence)"null"));
                ExpressionStatementTree assignment = this.make.ExpressionStatement((ExpressionTree)this.make.Assignment((ExpressionTree)this.make.Identifier((CharSequence)originalDeclaration.getName()), originalDeclaration.getInitializer()));
                BlockTree finallyTree = this.make.Block(Collections.singletonList(this.createFinallyCloseBlockStatement(originalDeclaration)), false);
                this.info.rewrite((Tree)originalDeclaration, (Tree)assignment);
                this.info.rewrite((Tree)bt, (Tree)this.createBlock(bt.isStatic(), toKeep, declaration, this.make.Try(toUse, catches, finallyTree)));
            }
            return null;
        }
    }
}

