/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class CreateMethodFix
implements Fix {
    private FileObject targetFile;
    private ElementHandle<TypeElement> target;
    private TypeMirrorHandle returnType;
    private List<TypeMirrorHandle> argumentTypes;
    private List<String> argumentNames;
    private final List<TypeMirrorHandle> typeParameterTypes;
    private final List<String> typeParameterNames;
    private ClasspathInfo cpInfo;
    private Set<Modifier> modifiers;
    private String name;
    private String inFQN;
    private String methodDisplayName;

    public CreateMethodFix(CompilationInfo info, String name, Set<Modifier> modifiers, TypeElement target, TypeMirror returnType, List<? extends TypeMirror> argumentTypes, List<String> argumentNames, List<? extends TypeMirror> typeParameterTypes, List<String> typeParameterNames, FileObject targetFile) {
        this.name = name;
        this.inFQN = Utilities.target2String(target);
        this.cpInfo = info.getClasspathInfo();
        this.modifiers = modifiers;
        this.targetFile = targetFile;
        this.target = ElementHandle.create((Element)target);
        if (returnType != null && returnType.getKind() == TypeKind.NULL) {
            returnType = info.getElements().getTypeElement("java.lang.Object").asType();
        }
        this.returnType = returnType != null ? TypeMirrorHandle.create((TypeMirror)returnType) : null;
        this.argumentTypes = new ArrayList<TypeMirrorHandle>();
        for (TypeMirror typeMirror : argumentTypes) {
            this.argumentTypes.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
        }
        this.argumentNames = argumentNames;
        this.typeParameterTypes = new ArrayList<TypeMirrorHandle>();
        for (TypeMirror typeMirror : typeParameterTypes) {
            this.typeParameterTypes.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
        }
        this.typeParameterNames = typeParameterNames;
        StringBuilder methodDisplayName = new StringBuilder();
        if (returnType != null) {
            methodDisplayName.append(name);
        } else {
            methodDisplayName.append(target.getSimpleName().toString());
        }
        methodDisplayName.append('(');
        boolean bl = true;
        for (TypeMirror typeMirror : argumentTypes) {
            boolean bl2;
            if (!bl2) {
                methodDisplayName.append(',');
            }
            bl2 = false;
            methodDisplayName.append(org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)typeMirror, (boolean)true));
        }
        methodDisplayName.append(')');
        this.methodDisplayName = methodDisplayName.toString();
    }

    public String getText() {
        if (this.target.getKind() == ElementKind.ANNOTATION_TYPE) {
            return NbBundle.getMessage(CreateMethodFix.class, (String)"LBL_FIX_Create_Annotation_Element", (Object)this.methodDisplayName, (Object)this.inFQN);
        }
        if (this.returnType != null) {
            return NbBundle.getMessage(CreateMethodFix.class, (String)"LBL_FIX_Create_Method", (Object)this.methodDisplayName, (Object)this.inFQN);
        }
        return NbBundle.getMessage(CreateMethodFix.class, (String)"LBL_FIX_Create_Constructor", (Object)this.methodDisplayName, (Object)this.inFQN);
    }

    public ChangeInfo implement() throws IOException {
        JavaSource js = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{this.targetFile});
        String methodBodyTag = "mbody";
        ModificationResult diff = js.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy working) throws IOException {
                BlockTree body;
                TypeMirror returnType;
                working.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement targetType = (TypeElement)CreateMethodFix.this.target.resolve((CompilationInfo)working);
                if (targetType == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target.");
                    return;
                }
                TreePath targetTree = working.getTrees().getPath(targetType);
                if (targetTree == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target tree: " + targetType.getQualifiedName() + ".");
                    return;
                }
                TypeMirrorHandle returnTypeHandle = CreateMethodFix.this.returnType;
                TypeMirror typeMirror = returnType = returnTypeHandle != null ? returnTypeHandle.resolve((CompilationInfo)working) : null;
                if (returnTypeHandle != null && returnType == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
                    return;
                }
                TreeMaker make = working.getTreeMaker();
                ArrayList<VariableTree> argTypes = new ArrayList<VariableTree>();
                Iterator typeIt = CreateMethodFix.this.argumentTypes.iterator();
                Iterator nameIt = CreateMethodFix.this.argumentNames.iterator();
                while (typeIt.hasNext() && nameIt.hasNext()) {
                    TypeMirrorHandle tmh = (TypeMirrorHandle)typeIt.next();
                    TypeMirror tm = tmh.resolve((CompilationInfo)working);
                    if (tm == null) {
                        ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve argument type.");
                        return;
                    }
                    argTypes.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)nameIt.next(), make.Type(tm), null));
                }
                ArrayList<TypeParameterTree> typeParameters = new ArrayList<TypeParameterTree>();
                Iterator tpTypeIt = CreateMethodFix.this.typeParameterTypes.iterator();
                Iterator tpNameIt = CreateMethodFix.this.typeParameterNames.iterator();
                while (tpTypeIt.hasNext() && tpNameIt.hasNext()) {
                    TypeMirrorHandle tmh = (TypeMirrorHandle)tpTypeIt.next();
                    TypeMirror tm = tmh.resolve((CompilationInfo)working);
                    if (tm == null) {
                        ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve type argument type.");
                        return;
                    }
                    ArrayList<ExpressionTree> bounds = new ArrayList<ExpressionTree>();
                    ArrayList<? extends TypeMirror> boundTypes = new ArrayList<TypeMirror>(working.getTypes().directSupertypes(tm));
                    TypeElement jlObject = working.getElements().getTypeElement("java.lang.Object");
                    if (boundTypes.size() == 1 && jlObject != null && ((Object)((TypeMirror)boundTypes.get(0))).equals(jlObject.asType())) {
                        boundTypes.remove(0);
                    }
                    for (TypeMirror typeMirror2 : boundTypes) {
                        bounds.add((ExpressionTree)make.Type(typeMirror2));
                    }
                    typeParameters.add(make.TypeParameter((CharSequence)((TypeVariable)tm).asElement().getSimpleName(), bounds));
                }
                BlockTree blockTree = body = targetType.getKind().isClass() ? CreateMethodFix.createDefaultMethodBody(working, targetTree, returnType, CreateMethodFix.this.name) : null;
                if (body != null && !body.getStatements().isEmpty()) {
                    working.tag((Tree)body.getStatements().get(0), (Object)"mbody");
                }
                MethodTree mt = make.Method(make.Modifiers(CreateMethodFix.this.modifiers), (CharSequence)CreateMethodFix.this.name, returnType != null ? make.Type(returnType) : null, typeParameters, argTypes, Collections.emptyList(), body, null);
                ClassTree decl = GeneratorUtilities.get((WorkingCopy)working).insertClassMember((ClassTree)targetTree.getLeaf(), (Tree)mt);
                working.rewrite(targetTree.getLeaf(), (Tree)decl);
            }
        });
        return Utilities.commitAndComputeChangeInfo(this.targetFile, diff, "mbody");
    }

    private void addArguments(CompilationInfo info, StringBuilder value) {
        value.append("(");
        Iterator<TypeMirrorHandle> typeIt = this.argumentTypes.iterator();
        Iterator<String> nameIt = this.argumentNames.iterator();
        boolean first = true;
        while (typeIt.hasNext() && nameIt.hasNext()) {
            if (!first) {
                value.append(",");
            }
            first = false;
            TypeMirrorHandle tmh = typeIt.next();
            String argName = nameIt.next();
            value.append(org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)tmh.resolve(info), (boolean)true));
            value.append(' ');
            value.append(argName);
        }
        value.append(")");
    }

    public String toDebugString(CompilationInfo info) {
        StringBuilder value = new StringBuilder();
        if (this.returnType != null) {
            value.append("CreateMethodFix:");
            value.append(this.name);
            this.addArguments(info, value);
            value.append(org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)this.returnType.resolve(info), (boolean)true));
        } else {
            value.append("CreateConstructorFix:");
            this.addArguments(info, value);
        }
        value.append(':');
        value.append(this.inFQN);
        return value.toString();
    }

    private static BlockTree createDefaultMethodBody(WorkingCopy wc, TreePath targetTree, TypeMirror returnType, String name) {
        TreeUtilities tu = wc.getTreeUtilities();
        TypeElement targetClazz = (TypeElement)wc.getTrees().getElement(targetTree);
        StatementTree st = tu.parseStatement("{class ${abstract " + (returnType != null ? ((Object)returnType).toString() : "void") + " " + ("<init>".equals(name) ? targetClazz.getSimpleName() : name) + "();}}", new SourcePositions[1]);
        Trees trees = wc.getTrees();
        List<? extends Tree> members = ((ClassTree)targetTree.getLeaf()).getMembers();
        Scope scope = members.isEmpty() ? trees.getScope(targetTree) : trees.getScope(new TreePath(targetTree, members.get(0)));
        tu.attributeTree((Tree)st, scope);
        Tree first = null;
        for (Tree tree : ((ClassTree)((BlockTree)st).getStatements().get(0)).getMembers()) {
            if (tree.getKind() != Tree.Kind.METHOD || "<init>".contentEquals(((MethodTree)tree).getName())) continue;
            first = tree;
            break;
        }
        ExecutableElement ee = (ExecutableElement)wc.getTrees().getElement(new TreePath(targetTree, first));
        return GeneratorUtilities.get((WorkingCopy)wc).createAbstractMethodImplementation(targetClazz, ee).getBody();
    }
}

