/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.ChangeTypeFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class ChangeMethodReturnType
implements ErrorRule<Void> {
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.err.cant.ret.val.from.meth.decl.void", "compiler.err.prob.found.req"));

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        TreePath tp;
        TreePath parentPath = treePath.getParentPath();
        if (parentPath == null || parentPath.getLeaf().getKind() != Tree.Kind.RETURN) {
            return null;
        }
        TreePath method = null;
        for (tp = treePath; tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()); tp = tp.getParentPath()) {
            if (tp.getLeaf().getKind() != Tree.Kind.METHOD) continue;
            method = tp;
            break;
        }
        if (method == null) {
            return null;
        }
        MethodTree mt = (MethodTree)tp.getLeaf();
        if (mt.getReturnType() == null) {
            return null;
        }
        TypeMirror targetType = this.purify(info, info.getTrees().getTypeMirror(treePath));
        if (targetType == null) {
            return null;
        }
        if (targetType.getKind() == TypeKind.EXECUTABLE) {
            String expression = info.getText().substring((int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), treePath.getLeaf()), (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), treePath.getLeaf()));
            Scope s = info.getTrees().getScope(treePath);
            ExpressionTree expr = info.getTreeUtilities().parseExpression(expression, new SourcePositions[1]);
            targetType = this.purify(info, info.getTreeUtilities().attributeTree((Tree)expr, s));
        }
        if (targetType == null) {
            return null;
        }
        return Collections.singletonList(new FixImpl(info, method, TypeMirrorHandle.create((TypeMirror)targetType), ((Object)info.getTypeUtilities().getTypeName(targetType, new TypeUtilities.TypeNameOptions[0])).toString()).toEditorFix());
    }

    private TypeMirror purify(CompilationInfo info, TypeMirror targetType) {
        if (targetType != null && targetType.getKind() == TypeKind.ERROR) {
            targetType = info.getTrees().getOriginalType((ErrorType)targetType);
        }
        if (targetType == null || targetType.getKind() == TypeKind.ERROR) {
            return null;
        }
        return Utilities.resolveCapturedType(info, targetType);
    }

    public String getId() {
        return ChangeMethodReturnType.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ChangeMethodReturnType.class, (String)"DN_ChangeMethodReturnType");
    }

    public void cancel() {
    }

    static final class FixImpl
    extends JavaFix {
        private final TypeMirrorHandle targetTypeHandle;
        private final String targetTypeDN;

        public FixImpl(CompilationInfo info, TreePath tp, TypeMirrorHandle targetTypeHandle, String targetTypeDN) {
            super(info, tp);
            this.targetTypeHandle = targetTypeHandle;
            this.targetTypeDN = targetTypeDN;
        }

        protected String getText() {
            return NbBundle.getMessage(ChangeMethodReturnType.class, (String)"FIX_ChangeMethodReturnType", (Object)ChangeTypeFix.escape(this.targetTypeDN));
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            TypeMirror targetType = this.targetTypeHandle.resolve((CompilationInfo)wc);
            if (targetType == null) {
                return;
            }
            MethodTree mt = (MethodTree)tp.getLeaf();
            TreeMaker make = wc.getTreeMaker();
            wc.rewrite(mt.getReturnType(), make.Type(targetType));
        }
    }
}

