/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.errors.ChangeParametersFix;
import org.netbeans.modules.java.hints.errors.CreateElement;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ChangeMethodParameters
implements ErrorRule<Void> {
    private String DEFAULT_NAME = "par";
    private boolean cancel = false;

    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.apply.symbol.1", "compiler.err.cant.apply.symbols"));
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        try {
            this.cancel = false;
            return this.analyze(info, offset);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public String getId() {
        return ChangeMethodParameters.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CreateElement.class, (String)"LBL_ChangeMethodParameters");
    }

    public String getDescription() {
        return NbBundle.getMessage(CreateElement.class, (String)"DSC_ChangeMethodParameters");
    }

    public void cancel() {
        this.cancel = true;
    }

    private List<Fix> analyze(CompilationInfo info, int offset) throws IOException {
        MethodInvocationTree invocation;
        TreePath errorPath = ErrorHintsProvider.findUnresolvedElement(info, offset);
        if (errorPath == null) {
            return Collections.emptyList();
        }
        Tree error = errorPath.getParentPath().getLeaf();
        if (error == null) {
            return Collections.emptyList();
        }
        if (info.getElements().getTypeElement("java.lang.Object") == null) {
            return Collections.emptyList();
        }
        if (error.getKind() == Tree.Kind.METHOD_INVOCATION && (invocation = (MethodInvocationTree)error).getMethodSelect().getKind().equals((Object)Tree.Kind.IDENTIFIER)) {
            TreePath enclosingTypePath = this.findEnclosingType(errorPath.getParentPath());
            List<? extends ExpressionTree> arguments = invocation.getArguments();
            Pair<List<? extends TypeMirror>, List<String>> formalArguments = Utilities.resolveArguments(info, errorPath.getParentPath(), arguments, info.getTrees().getElement(enclosingTypePath));
            if (formalArguments == null) {
                return Collections.emptyList();
            }
            IdentifierTree methodSelect = (IdentifierTree)invocation.getMethodSelect();
            LinkedList<TreePath> methods = new LinkedList<TreePath>();
            for (Tree tree : ((ClassTree)enclosingTypePath.getLeaf()).getMembers()) {
                MethodTree method;
                if (this.cancel) {
                    return Collections.emptyList();
                }
                if (!tree.getKind().equals((Object)Tree.Kind.METHOD) || !(method = (MethodTree)tree).getName().contentEquals(methodSelect.getName())) continue;
                methods.add(new TreePath(enclosingTypePath, method));
            }
            LinkedList<Fix> fixes = new LinkedList<Fix>();
            for (TreePath path : methods) {
                if (this.cancel) {
                    return Collections.emptyList();
                }
                ExecutableElement method = (ExecutableElement)info.getTrees().getElement(path);
                List<? extends VariableElement> parameters = method.getParameters();
                ChangeParametersRefactoring.ParameterInfo[] parameterInfo = new ChangeParametersRefactoring.ParameterInfo[parameters.size()];
                for (int i = 0; i < parameters.size(); ++i) {
                    VariableElement param2 = parameters.get(i);
                    VariableTree parTree = (VariableTree)info.getTrees().getTree(param2);
                    parameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(i, param2.toString(), parTree.getType().toString(), null);
                }
                ChangeParametersRefactoring.ParameterInfo[] newParameterInfo = new ChangeParametersRefactoring.ParameterInfo[arguments.size()];
                MethodTree methodTree = (MethodTree)path.getLeaf();
                BlockTree methodBody = methodTree.getBody();
                Scope scope = null;
                if (methodBody != null) {
                    TreePath bodyPath = new TreePath(path, methodBody);
                    scope = info.getTrees().getScope(bodyPath);
                }
                int i = 0;
                for (ExpressionTree expressionTree : arguments) {
                    if (this.cancel) {
                        return Collections.emptyList();
                    }
                    TreePath argumentPath = new TreePath(path, expressionTree);
                    TypeMirror argumentType = info.getTrees().getTypeMirror(argumentPath);
                    String type = ((Object)argumentType).toString();
                    String name = Utilities.getName(argumentPath.getLeaf());
                    if (name == null) {
                        name = this.DEFAULT_NAME;
                    }
                    name = ChangeMethodParameters.makeNameUnique(info, scope, name, newParameterInfo, i);
                    newParameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(-1, name, type, expressionTree.toString());
                    ++i;
                }
                TypeElement typeElement = (TypeElement)info.getTrees().getElement(enclosingTypePath);
                for (i = 0; i < newParameterInfo.length; ++i) {
                    if (this.cancel) {
                        return Collections.emptyList();
                    }
                    ChangeParametersRefactoring.ParameterInfo parameterInfo2 = newParameterInfo[i];
                    ChangeParametersRefactoring.ParameterInfo next = this.findNextByType(info, parameterInfo, parameterInfo2.getType(), typeElement);
                    if (next == null) continue;
                    newParameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(next.getOriginalIndex(), next.getName(), next.getType(), parameterInfo2.getDefaultValue());
                }
                for (i = 0; i < newParameterInfo.length; ++i) {
                    if (this.cancel) {
                        return Collections.emptyList();
                    }
                    ChangeParametersRefactoring.ParameterInfo parameterInfo3 = newParameterInfo[i];
                    TypeMirror type = info.getTreeUtilities().parseType(parameterInfo3.getType(), typeElement);
                    String typeString = ((Object)org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)type, (boolean)false)).toString();
                    newParameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(parameterInfo3.getOriginalIndex(), parameterInfo3.getName(), typeString, parameterInfo3.getDefaultValue());
                }
                for (i = 0; i < newParameterInfo.length; ++i) {
                    if (this.cancel) {
                        return Collections.emptyList();
                    }
                    ChangeParametersRefactoring.ParameterInfo parameterInfo4 = newParameterInfo[i];
                    if (parameterInfo4.getOriginalIndex() != -1 || parameterInfo.length <= i || parameterInfo[i].getOriginalIndex() == -1) continue;
                    newParameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(parameterInfo[i].getOriginalIndex(), parameterInfo[i].getName(), parameterInfo4.getType(), parameterInfo4.getDefaultValue());
                }
                TreePathHandle treePathHandle = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
                boolean doFullRefactoring = true;
                if (methodTree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
                    doFullRefactoring = false;
                }
                Set<Modifier> modifiers = method.getModifiers();
                fixes.add(new ChangeParametersFix(doFullRefactoring, treePathHandle, modifiers, this.genDeclarationString(methodTree, parameterInfo), this.genDeclarationString(methodTree, newParameterInfo), newParameterInfo));
            }
            return fixes;
        }
        return Collections.emptyList();
    }

    private static String makeNameUnique(CompilationInfo info, Scope s, String name, ChangeParametersRefactoring.ParameterInfo[] parameters, int current) {
        int counter = 0;
        boolean cont = true;
        String proposedName = name;
        block0: while (cont) {
            proposedName = name + (counter != 0 ? String.valueOf(counter) : "");
            cont = false;
            if (s != null) {
                for (Element e : info.getElementUtilities().getLocalMembersAndVars(s, (ElementUtilities.ElementAcceptor)new Utilities.VariablesFilter())) {
                    if (!proposedName.equals(e.getSimpleName().toString())) continue;
                    ++counter;
                    cont = true;
                    break;
                }
            }
            for (int i = 0; i < parameters.length; ++i) {
                ChangeParametersRefactoring.ParameterInfo parameterInfo = parameters[i];
                if (current == i || parameterInfo == null || !proposedName.equals(parameterInfo.getName())) continue;
                ++counter;
                cont = true;
                continue block0;
            }
        }
        return proposedName;
    }

    public String genDeclarationString(MethodTree methodTree, ChangeParametersRefactoring.ParameterInfo[] parameters) {
        StringBuilder buf = new StringBuilder();
        buf.append(methodTree.getName());
        buf.append('(');
        if (parameters.length > 0) {
            int i;
            for (i = 0; i < parameters.length - 1; ++i) {
                buf.append(parameters[i].getType());
                buf.append(' ');
                buf.append(parameters[i].getName());
                buf.append(',').append(' ');
            }
            buf.append(parameters[i].getType());
            buf.append(' ');
            buf.append(parameters[i].getName());
        }
        buf.append(')');
        return buf.toString();
    }

    private TreePath findEnclosingType(TreePath parentPath) {
        for (TreePath klazz = parentPath; klazz != null; klazz = klazz.getParentPath()) {
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)klazz.getLeaf().getKind())) continue;
            return klazz;
        }
        return null;
    }

    private ChangeParametersRefactoring.ParameterInfo findNextByType(CompilationInfo info, ChangeParametersRefactoring.ParameterInfo[] parameterInfo, String type, TypeElement scopeType) {
        for (int i = 0; i < parameterInfo.length; ++i) {
            ChangeParametersRefactoring.ParameterInfo param = parameterInfo[i];
            if (param.getOriginalIndex() <= -1 || !this.isSameType(info, type, param.getType(), scopeType)) continue;
            parameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(-1, param.getName(), param.getType(), null);
            return param;
        }
        return null;
    }

    private boolean isSameType(CompilationInfo info, String from, String to, TypeElement scopeType) {
        if (from.equals(to)) {
            return true;
        }
        Element fromElement = info.getTypes().asElement(info.getTreeUtilities().parseType(from, scopeType));
        Element toElement = info.getTypes().asElement(info.getTreeUtilities().parseType(to, scopeType));
        if (fromElement != null && toElement != null) {
            if (!(fromElement.getKind().isClass() || fromElement.getKind().isInterface() || fromElement.getKind().isField())) {
                return false;
            }
            if (!(toElement.getKind().isClass() || toElement.getKind().isInterface() || toElement.getKind().isField())) {
                return false;
            }
            TypeElement fromType = (TypeElement)fromElement;
            TypeElement toType = (TypeElement)toElement;
            return info.getTypes().isSubtype(fromType.asType(), toType.asType());
        }
        return false;
    }
}

