/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.introduce.Flow;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class UnusedAssignmentOrBranch {
    private static final String UNUSED_ASSIGNMENT_ID = "org.netbeans.modules.java.hints.bugs.UnusedAssignmentOrBranch.unusedAssignment";
    private static final String DEAD_BRANCH_ID = "org.netbeans.modules.java.hints.bugs.UnusedAssignmentOrBranch.deadBranch";
    private static final Object KEY_FLOW = new Object();
    private static final Object KEY_COMPUTED_ASSIGNMENTS = new Object();
    private static final Set<ElementKind> LOCAL_VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

    private static Flow.FlowResult runFlow(final HintContext ctx) {
        Object cachedFlow = ctx.getInfo().getCachedValue(KEY_FLOW);
        if (cachedFlow instanceof Flow.FlowResult) {
            return (Flow.FlowResult)cachedFlow;
        }
        Flow.FlowResult flow = Flow.assignmentsForUse(ctx.getInfo(), new TreePath(ctx.getInfo().getCompilationUnit()), new Flow.Cancel(){

            @Override
            public boolean isCanceled() {
                return ctx.isCanceled();
            }
        });
        if (flow == null || ctx.isCanceled()) {
            return null;
        }
        ctx.getInfo().putCachedValue(KEY_FLOW, (Object)flow, CompilationInfo.CacheClearPolicy.ON_TASK_END);
        return flow;
    }

    private static Pair<Set<Tree>, Set<Element>> computeUsedAssignments(final HintContext ctx) {
        final CompilationInfo info = ctx.getInfo();
        Pair<Set<Tree>, Set<Element>> result = (Pair<Set<Tree>, Set<Element>>)info.getCachedValue(KEY_COMPUTED_ASSIGNMENTS);
        if (result != null) {
            return result;
        }
        Flow.FlowResult flow = UnusedAssignmentOrBranch.runFlow(ctx);
        if (flow == null) {
            return null;
        }
        final HashSet<Tree> usedAssignments = new HashSet<Tree>();
        for (Iterable<? extends TreePath> i : flow.getAssignmentsForUse().values()) {
            for (TreePath treePath : i) {
                if (treePath == null) continue;
                usedAssignments.add(treePath.getLeaf());
            }
        }
        final HashSet usedVariables = new HashSet();
        new CancellableTreePathScanner<Void, Void>(){

            public Void visitAssignment(AssignmentTree node, Void p) {
                Element var = info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(node.getExpression())) {
                    this.scan(node.getExpression(), null);
                    return null;
                }
                return (Void)super.visitAssignment(node, (Object)p);
            }

            public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
                Element var = info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
                if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(node.getExpression())) {
                    this.scan(node.getExpression(), null);
                    return null;
                }
                return (Void)super.visitCompoundAssignment(node, (Object)p);
            }

            public Void visitIdentifier(IdentifierTree node, Void p) {
                Element var = info.getTrees().getElement(this.getCurrentPath());
                if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind())) {
                    usedVariables.add(var);
                }
                return (Void)super.visitIdentifier(node, (Object)p);
            }

            protected boolean isCanceled() {
                return ctx.isCanceled();
            }
        }.scan((Tree)info.getCompilationUnit(), null);
        result = new Pair<Set<Tree>, Set<Element>>(usedAssignments, usedVariables);
        info.putCachedValue(KEY_COMPUTED_ASSIGNMENTS, result, CompilationInfo.CacheClearPolicy.ON_TASK_END);
        return result;
    }

    public static ErrorDescription unusedAssignment(HintContext ctx) {
        String unusedAssignmentLabel = NbBundle.getMessage(UnusedAssignmentOrBranch.class, (String)"LBL_UNUSED_ASSIGNMENT_LABEL");
        Pair<Set<Tree>, Set<Element>> computedAssignments = UnusedAssignmentOrBranch.computeUsedAssignments(ctx);
        if (ctx.isCanceled() || computedAssignments == null) {
            return null;
        }
        CompilationInfo info = ctx.getInfo();
        Set<Tree> usedAssignments = computedAssignments.getA();
        Set<Element> usedVariables = computedAssignments.getB();
        Element var = info.getTrees().getElement((TreePath)ctx.getVariables().get("$var"));
        Tree value = ((TreePath)ctx.getVariables().get("$value")).getLeaf();
        if (var != null && LOCAL_VARIABLES.contains((Object)var.getKind()) && !usedAssignments.contains(value) && usedVariables.contains(var)) {
            return ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)value, (String)unusedAssignmentLabel, (Fix[])new Fix[0]);
        }
        return null;
    }

    public static List<ErrorDescription> deadBranch(HintContext ctx) {
        String deadBranchLabel = NbBundle.getMessage(UnusedAssignmentOrBranch.class, (String)"LBL_DEAD_BRANCH");
        Flow.FlowResult flow = UnusedAssignmentOrBranch.runFlow(ctx);
        if (flow == null) {
            return null;
        }
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        Set<? extends Tree> flowResult = flow.getDeadBranches();
        IfTree it = (IfTree)ctx.getPath().getLeaf();
        for (Tree t : new Tree[]{it.getThenStatement(), it.getElseStatement()}) {
            if (!flowResult.contains(t)) continue;
            result.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)t, (String)deadBranchLabel, (Fix[])new Fix[0]));
        }
        return result;
    }
}

