/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.UnionType;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class NPECheck {
    static final boolean DEF_ENABLE_FOR_FIELDS = false;
    static final String KEY_ENABLE_FOR_FIELDS = "enable-for-fields";
    private static final Object KEY_EXPRESSION_STATE = new Object();
    private static final Set<ElementKind> VARIABLE_ELEMENT_NO_FIELDS = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);
    private static final Set<ElementKind> VARIABLE_ELEMENT_FIELDS = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

    public static ErrorDescription assignment(HintContext ctx) {
        Element e = ctx.getInfo().getTrees().getElement((TreePath)ctx.getVariables().get("$var"));
        if (!NPECheck.isVariableElement(ctx, e)) {
            return null;
        }
        TreePath expr = (TreePath)ctx.getVariables().get("$expr");
        State r = NPECheck.computeExpressionsState(ctx).get(expr.getLeaf());
        State elementState = NPECheck.getStateFromAnnotations(e);
        if (elementState != null && elementState.isNotNull()) {
            String key = null;
            if (r == State.NULL || r == State.NULL_HYPOTHETICAL) {
                key = "ERR_AssigningNullToNotNull";
            }
            if (r == State.POSSIBLE_NULL_REPORT) {
                key = "ERR_PossibleAssigingNullToNotNull";
            }
            if (key != null) {
                return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)NbBundle.getMessage(NPECheck.class, (String)key), (Fix[])new Fix[0]);
            }
        }
        return null;
    }

    public static ErrorDescription memberSelect(HintContext ctx) {
        TreePath select = (TreePath)ctx.getVariables().get("$select");
        State r = NPECheck.computeExpressionsState(ctx).get(select.getLeaf());
        if (r == State.NULL || r == State.NULL_HYPOTHETICAL) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)"ERR_DereferencingNull");
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
        }
        if (r == State.POSSIBLE_NULL_REPORT) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)"ERR_PossiblyDereferencingNull");
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
        }
        return null;
    }

    public static List<ErrorDescription> methodInvocation(HintContext ctx) {
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        ArrayList<State> paramStates = new ArrayList<State>(mit.getArguments().size());
        Map<Tree, State> expressionsState = NPECheck.computeExpressionsState(ctx);
        for (ExpressionTree expressionTree : mit.getArguments()) {
            State r = expressionsState.get(expressionTree);
            paramStates.add(r != null ? r : State.POSSIBLE_NULL);
        }
        Element e = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (e == null || e.getKind() != ElementKind.METHOD) {
            return null;
        }
        ExecutableElement executableElement = (ExecutableElement)e;
        int index = 0;
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        List<? extends VariableElement> params = executableElement.getParameters();
        for (VariableElement variableElement : params) {
            if (!(NPECheck.getStateFromAnnotations(variableElement) != State.NOT_NULL || executableElement.isVarArgs() && variableElement == params.get(params.size() - 1))) {
                switch ((State)((Object)paramStates.get(index))) {
                    case NULL: 
                    case NULL_HYPOTHETICAL: {
                        result.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)mit.getArguments().get(index), (String)NbBundle.getMessage(NPECheck.class, (String)"ERR_NULL_TO_NON_NULL_ARG"), (Fix[])new Fix[0]));
                        break;
                    }
                    case POSSIBLE_NULL_REPORT: {
                        result.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)mit.getArguments().get(index), (String)NbBundle.getMessage(NPECheck.class, (String)"ERR_POSSIBLENULL_TO_NON_NULL_ARG"), (Fix[])new Fix[0]));
                    }
                }
            }
            ++index;
        }
        return result;
    }

    public static ErrorDescription notNullWouldBeNPE(HintContext ctx) {
        TreePath variable = (TreePath)ctx.getVariables().get("$variable");
        State r = NPECheck.computeExpressionsState(ctx).get(variable.getLeaf());
        if (r != null && r.isNotNull()) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)(r == State.NOT_NULL_BE_NPE ? "ERR_NotNullWouldBeNPE" : "ERR_NotNull"));
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription returnNull(HintContext ctx) {
        TreePath method;
        TreePath expression = (TreePath)ctx.getVariables().get("$expression");
        State returnState = NPECheck.computeExpressionsState(ctx).get(expression.getLeaf());
        if (returnState == null) {
            return null;
        }
        for (method = ctx.getPath(); method != null && method.getLeaf().getKind() != Tree.Kind.METHOD && method.getLeaf().getKind() != Tree.Kind.CLASS; method = method.getParentPath()) {
        }
        if (method == null || method.getLeaf().getKind() != Tree.Kind.METHOD) {
            return null;
        }
        Element el = ctx.getInfo().getTrees().getElement(method);
        if (el == null || el.getKind() != ElementKind.METHOD) {
            return null;
        }
        State expected = NPECheck.getStateFromAnnotations(el);
        String key = null;
        switch (returnState) {
            case NULL: 
            case NOT_NULL_HYPOTHETICAL: {
                if (!expected.isNotNull()) break;
                key = "ERR_ReturningNullFromNonNull";
                break;
            }
            case POSSIBLE_NULL_REPORT: {
                if (!expected.isNotNull()) break;
                key = "ERR_ReturningPossibleNullFromNonNull";
            }
        }
        if (key != null) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)key);
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)expression, (String)displayName, (Fix[])new Fix[0]);
        }
        return null;
    }

    private static Map<Tree, State> computeExpressionsState(HintContext ctx) {
        Map result = (Map)ctx.getInfo().getCachedValue(KEY_EXPRESSION_STATE);
        if (result != null) {
            return result;
        }
        VisitorImpl v = new VisitorImpl(ctx);
        v.scan((Tree)ctx.getInfo().getCompilationUnit(), null);
        result = v.expressionState;
        ctx.getInfo().putCachedValue(KEY_EXPRESSION_STATE, (Object)result, CompilationInfo.CacheClearPolicy.ON_TASK_END);
        return result;
    }

    private static State getStateFromAnnotations(Element e) {
        return NPECheck.getStateFromAnnotations(e, State.POSSIBLE_NULL);
    }

    private static State getStateFromAnnotations(Element e, State def) {
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            String simpleName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getSimpleName().toString();
            if ("Nullable".equals(simpleName) || "NullAllowed".equals(simpleName)) {
                return State.POSSIBLE_NULL_REPORT;
            }
            if ("CheckForNull".equals(simpleName)) {
                return State.POSSIBLE_NULL_REPORT;
            }
            if (!"NotNull".equals(simpleName) && !"NonNull".equals(simpleName) && !"Nonnull".equals(simpleName)) continue;
            return State.NOT_NULL;
        }
        return def;
    }

    private static boolean isVariableElement(HintContext ctx, Element ve) {
        return ve != null && (ctx.getPreferences().getBoolean(KEY_ENABLE_FOR_FIELDS, false) ? VARIABLE_ELEMENT_FIELDS : VARIABLE_ELEMENT_NO_FIELDS).contains((Object)ve.getKind());
    }

    private static final class ExitsFromAllBranches
    extends TreePathScanner<Boolean, Void> {
        private CompilationInfo info;
        private Set<Tree> seenTrees = new HashSet<Tree>();

        public ExitsFromAllBranches(CompilationInfo info) {
            this.info = info;
        }

        @Override
        public Boolean scan(Tree tree, Void p) {
            this.seenTrees.add(tree);
            return (Boolean)super.scan(tree, p);
        }

        @Override
        public Boolean visitIf(IfTree node, Void p) {
            return this.scan((Tree)node.getThenStatement(), null) == Boolean.TRUE && this.scan((Tree)node.getElseStatement(), null) == Boolean.TRUE;
        }

        @Override
        public Boolean visitReturn(ReturnTree node, Void p) {
            return true;
        }

        @Override
        public Boolean visitBreak(BreakTree node, Void p) {
            return !this.seenTrees.contains(this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()));
        }

        @Override
        public Boolean visitContinue(ContinueTree node, Void p) {
            return !this.seenTrees.contains(this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath()));
        }

        @Override
        public Boolean visitClass(ClassTree node, Void p) {
            return false;
        }

        @Override
        public Boolean visitThrow(ThrowTree node, Void p) {
            return true;
        }
    }

    static enum State {
        NULL,
        NULL_HYPOTHETICAL,
        POSSIBLE_NULL,
        POSSIBLE_NULL_REPORT,
        NOT_NULL,
        NOT_NULL_HYPOTHETICAL,
        NOT_NULL_BE_NPE;


        @CheckForNull
        public State reverse() {
            switch (this) {
                case NULL: {
                    return NOT_NULL;
                }
                case NULL_HYPOTHETICAL: {
                    return NOT_NULL_HYPOTHETICAL;
                }
                case POSSIBLE_NULL_REPORT: 
                case POSSIBLE_NULL: {
                    return this;
                }
                case NOT_NULL: 
                case NOT_NULL_BE_NPE: {
                    return NULL;
                }
                case NOT_NULL_HYPOTHETICAL: {
                    return NULL_HYPOTHETICAL;
                }
            }
            throw new IllegalStateException();
        }

        public boolean isNotNull() {
            return this == NOT_NULL || this == NOT_NULL_BE_NPE || this == NOT_NULL_HYPOTHETICAL;
        }

        public static State collect(State s1, State s2) {
            if (s1 == s2) {
                return s1;
            }
            if (s1 == NULL || s2 == NULL || s1 == NULL_HYPOTHETICAL || s2 == NULL_HYPOTHETICAL) {
                return POSSIBLE_NULL_REPORT;
            }
            if (s1 == POSSIBLE_NULL_REPORT || s2 == POSSIBLE_NULL_REPORT) {
                return POSSIBLE_NULL_REPORT;
            }
            if (s1 != null && s2 != null && s1.isNotNull() && s2.isNotNull()) {
                return NOT_NULL;
            }
            return POSSIBLE_NULL;
        }
    }

    private static final class VisitorImpl
    extends CancellableTreePathScanner<State, Void> {
        private final HintContext ctx;
        private final CompilationInfo info;
        private Map<VariableElement, State> variable2State = new HashMap<VariableElement, State>();
        private final Map<Tree, Collection<Map<VariableElement, State>>> resumeBefore = new IdentityHashMap<Tree, Collection<Map<VariableElement, State>>>();
        private final Map<Tree, Collection<Map<VariableElement, State>>> resumeAfter = new IdentityHashMap<Tree, Collection<Map<VariableElement, State>>>();
        private Map<TypeMirror, Collection<Map<VariableElement, State>>> resumeOnExceptionHandler = new IdentityHashMap<TypeMirror, Collection<Map<VariableElement, State>>>();
        private final Map<Tree, State> expressionState = new IdentityHashMap<Tree, State>();
        private final List<TreePath> pendingFinally = new LinkedList<TreePath>();
        private boolean not;
        private boolean doNotRecord;

        public VisitorImpl(HintContext ctx) {
            this.ctx = ctx;
            this.info = ctx.getInfo();
        }

        protected boolean isCanceled() {
            return this.ctx.isCanceled();
        }

        public State scan(Tree tree, Void p) {
            TypeMirror currentType;
            this.resume(tree, this.resumeBefore);
            State r = (State)((Object)super.scan(tree, (Object)p));
            TypeMirror typeMirror = currentType = tree != null ? this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), tree)) : null;
            if (currentType != null && currentType.getKind().isPrimitive()) {
                r = State.NOT_NULL;
            }
            if (r != null && !this.doNotRecord) {
                this.expressionState.put(tree, r);
            }
            this.resume(tree, this.resumeAfter);
            return r;
        }

        private void resume(Tree tree, Map<Tree, Collection<Map<VariableElement, State>>> resume) {
            Collection<Map<VariableElement, State>> toResume = resume.remove(tree);
            if (toResume != null) {
                for (Map<VariableElement, State> s : toResume) {
                    this.mergeIntoVariable2State(s);
                }
            }
        }

        public State visitAssignment(AssignmentTree node, Void p) {
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
            HashMap<VariableElement, State> orig = new HashMap<VariableElement, State>(this.variable2State);
            State r = this.scan((Tree)node.getExpression(), p);
            this.scan((Tree)node.getVariable(), p);
            this.mergeHypotheticalVariable2State(orig);
            if (this.isVariableElement(e)) {
                this.variable2State.put((VariableElement)e, r);
            }
            return r;
        }

        public State visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
            HashMap<VariableElement, State> orig = new HashMap<VariableElement, State>(this.variable2State);
            this.scan((Tree)node.getExpression(), p);
            this.scan((Tree)node.getVariable(), p);
            this.mergeHypotheticalVariable2State(orig);
            return null;
        }

        public State visitVariable(VariableTree node, Void p) {
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            HashMap<VariableElement, State> orig = new HashMap<VariableElement, State>(this.variable2State);
            State r = this.scan((Tree)node.getInitializer(), p);
            this.mergeHypotheticalVariable2State(orig);
            if (e != null) {
                this.variable2State.put((VariableElement)e, r);
            }
            return r;
        }

        public State visitMemberSelect(MemberSelectTree node, Void p) {
            Element e;
            State expr = this.scan((Tree)node.getExpression(), p);
            boolean wasNPE = false;
            if (expr == State.NULL || expr == State.NULL_HYPOTHETICAL || expr == State.POSSIBLE_NULL || expr == State.POSSIBLE_NULL_REPORT) {
                wasNPE = true;
            }
            if (this.isVariableElement(e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression())))) {
                State r = NPECheck.getStateFromAnnotations(e);
                if (wasNPE) {
                    this.variable2State.put((VariableElement)e, State.NOT_NULL_BE_NPE);
                }
                return r;
            }
            return State.POSSIBLE_NULL;
        }

        public State visitLiteral(LiteralTree node, Void p) {
            if (node.getValue() == null) {
                return State.NULL;
            }
            return State.NOT_NULL;
        }

        public State visitIf(IfTree node, Void p) {
            boolean elseExitsFromAllBranches;
            HashMap<VariableElement, State> oldVariable2StateBeforeCondition = new HashMap<VariableElement, State>(this.variable2State);
            State condition = this.scan((Tree)node.getCondition(), p);
            this.scan((Tree)node.getThenStatement(), null);
            HashMap<VariableElement, State> variableStatesAfterThen = new HashMap<VariableElement, State>(this.variable2State);
            this.variable2State = new HashMap<VariableElement, State>(oldVariable2StateBeforeCondition);
            this.not = true;
            this.doNotRecord = true;
            this.scan((Tree)node.getCondition(), p);
            this.not = false;
            this.doNotRecord = false;
            this.scan((Tree)node.getElseStatement(), null);
            boolean thenExitsFromAllBranches = new ExitsFromAllBranches(this.info).scan(new TreePath(this.getCurrentPath(), node.getThenStatement()), null) == Boolean.TRUE;
            boolean bl = elseExitsFromAllBranches = node.getElseStatement() != null && new ExitsFromAllBranches(this.info).scan(new TreePath(this.getCurrentPath(), node.getElseStatement()), null) == Boolean.TRUE;
            if (!thenExitsFromAllBranches || elseExitsFromAllBranches) {
                if (!thenExitsFromAllBranches && elseExitsFromAllBranches) {
                    this.variable2State = variableStatesAfterThen;
                } else {
                    this.mergeIntoVariable2State(variableStatesAfterThen);
                }
            }
            return null;
        }

        public State visitBinary(BinaryTree node, Void p) {
            boolean oldNot;
            boolean subnodesAlreadyProcessed = false;
            Tree.Kind kind = node.getKind();
            if (this.not) {
                switch (kind) {
                    case CONDITIONAL_AND: {
                        kind = Tree.Kind.CONDITIONAL_OR;
                        break;
                    }
                    case CONDITIONAL_OR: {
                        kind = Tree.Kind.CONDITIONAL_AND;
                        break;
                    }
                    case EQUAL_TO: {
                        kind = Tree.Kind.NOT_EQUAL_TO;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        kind = Tree.Kind.EQUAL_TO;
                    }
                }
            }
            if (kind == Tree.Kind.CONDITIONAL_AND) {
                this.scan((Tree)node.getLeftOperand(), p);
                this.scan((Tree)node.getRightOperand(), p);
                subnodesAlreadyProcessed = true;
            }
            if (kind == Tree.Kind.CONDITIONAL_OR) {
                HashMap<VariableElement, State> orig = new HashMap<VariableElement, State>(this.variable2State);
                this.scan((Tree)node.getLeftOperand(), p);
                Map<VariableElement, State> afterLeft = this.variable2State;
                this.variable2State = orig;
                oldNot = this.not;
                boolean oldDoNotRecord = this.doNotRecord;
                this.not ^= true;
                this.doNotRecord = true;
                this.scan((Tree)node.getLeftOperand(), p);
                this.not = oldNot;
                this.doNotRecord = oldDoNotRecord;
                this.scan((Tree)node.getRightOperand(), p);
                this.mergeIntoVariable2State(afterLeft);
                subnodesAlreadyProcessed = true;
            }
            State left = null;
            State right = null;
            if (!subnodesAlreadyProcessed) {
                oldNot = this.not;
                this.not = false;
                left = this.scan((Tree)node.getLeftOperand(), p);
                right = this.scan((Tree)node.getRightOperand(), p);
                this.not = oldNot;
            }
            if (kind == Tree.Kind.EQUAL_TO) {
                Element e;
                if (right == State.NULL && this.isVariableElement(e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getLeftOperand()))) && !this.hasDefiniteValue(e)) {
                    this.variable2State.put((VariableElement)e, State.NULL_HYPOTHETICAL);
                    return null;
                }
                if (left == State.NULL && this.isVariableElement(e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getRightOperand()))) && !this.hasDefiniteValue(e)) {
                    this.variable2State.put((VariableElement)e, State.NULL_HYPOTHETICAL);
                    return null;
                }
            }
            if (kind == Tree.Kind.NOT_EQUAL_TO) {
                Element e;
                if (right == State.NULL && this.isVariableElement(e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getLeftOperand()))) && !this.hasDefiniteValue(e)) {
                    this.variable2State.put((VariableElement)e, State.NOT_NULL_HYPOTHETICAL);
                    return null;
                }
                if (left == State.NULL && this.isVariableElement(e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getRightOperand()))) && !this.hasDefiniteValue(e)) {
                    this.variable2State.put((VariableElement)e, State.NOT_NULL_HYPOTHETICAL);
                    return null;
                }
            }
            return null;
        }

        public State visitInstanceOf(InstanceOfTree node, Void p) {
            super.visitInstanceOf(node, (Object)p);
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression()));
            if (!(!this.isVariableElement(e) || this.variable2State.get(e) != null && this.variable2State.get(e).isNotNull() || this.not)) {
                this.variable2State.put((VariableElement)e, State.NOT_NULL);
            }
            return null;
        }

        public State visitConditionalExpression(ConditionalExpressionTree node, Void p) {
            HashMap<VariableElement, State> oldVariable2State = new HashMap<VariableElement, State>(this.variable2State);
            this.scan((Tree)node.getCondition(), p);
            State thenSection = this.scan((Tree)node.getTrueExpression(), p);
            Map<VariableElement, State> variableStatesAfterThen = this.variable2State;
            this.variable2State = oldVariable2State;
            this.not = true;
            this.doNotRecord = true;
            this.scan((Tree)node.getCondition(), p);
            this.not = false;
            this.doNotRecord = false;
            State elseSection = this.scan((Tree)node.getFalseExpression(), p);
            State result = State.collect(thenSection, elseSection);
            this.mergeIntoVariable2State(variableStatesAfterThen);
            return result;
        }

        public State visitNewClass(NewClassTree node, Void p) {
            super.visitNewClass(node, (Object)p);
            Element invoked = this.info.getTrees().getElement(this.getCurrentPath());
            if (invoked != null && invoked.getKind() == ElementKind.CONSTRUCTOR) {
                this.recordResumeOnExceptionHandler((ExecutableElement)invoked);
            }
            return State.NOT_NULL;
        }

        public State visitMethodInvocation(MethodInvocationTree node, Void p) {
            this.scan(node.getTypeArguments(), p);
            this.scan((Tree)node.getMethodSelect(), p);
            for (ExpressionTree expressionTree : node.getArguments()) {
                this.scan((Tree)expressionTree, p);
            }
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e == null || e.getKind() != ElementKind.METHOD) {
                return State.POSSIBLE_NULL;
            }
            this.recordResumeOnExceptionHandler((ExecutableElement)e);
            return NPECheck.getStateFromAnnotations(e);
        }

        public State visitIdentifier(IdentifierTree node, Void p) {
            State s;
            super.visitIdentifier(node, (Object)p);
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e == null || !this.isVariableElement(e)) {
                return State.POSSIBLE_NULL;
            }
            if (e != null && (s = this.variable2State.get(e)) != null) {
                return s;
            }
            return NPECheck.getStateFromAnnotations(e);
        }

        public State visitWhileLoop(WhileLoopTree node, Void p) {
            return this.handleGeneralizedFor(null, node.getCondition(), null, node.getStatement(), p);
        }

        public State visitUnary(UnaryTree node, Void p) {
            boolean oldNot = this.not;
            this.not ^= node.getKind() == Tree.Kind.LOGICAL_COMPLEMENT;
            State res = this.scan((Tree)node.getExpression(), p);
            this.not = oldNot;
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public State visitMethod(MethodTree node, Void p) {
            Map<TypeMirror, Collection<Map<VariableElement, State>>> oldResumeOnExceptionHandler = this.resumeOnExceptionHandler;
            this.resumeOnExceptionHandler = new IdentityHashMap<TypeMirror, Collection<Map<VariableElement, State>>>();
            try {
                this.variable2State = new HashMap<VariableElement, State>();
                this.not = false;
                Element current = this.info.getTrees().getElement(this.getCurrentPath());
                if (current != null && (current.getKind() == ElementKind.METHOD || current.getKind() == ElementKind.CONSTRUCTOR)) {
                    for (VariableElement variableElement : ((ExecutableElement)current).getParameters()) {
                        this.variable2State.put(variableElement, NPECheck.getStateFromAnnotations(variableElement));
                    }
                }
                while (current != null) {
                    for (VariableElement variableElement : ElementFilter.fieldsIn(current.getEnclosedElements())) {
                        this.variable2State.put(variableElement, NPECheck.getStateFromAnnotations(variableElement));
                    }
                    current = current.getEnclosingElement();
                }
                State state = (State)((Object)super.visitMethod(node, (Object)p));
                return state;
            }
            finally {
                this.resumeOnExceptionHandler = oldResumeOnExceptionHandler;
            }
        }

        public State visitForLoop(ForLoopTree node, Void p) {
            return this.handleGeneralizedFor(node.getInitializer(), node.getCondition(), node.getUpdate(), node.getStatement(), p);
        }

        private State handleGeneralizedFor(Iterable<? extends Tree> initializer, Tree condition, Iterable<? extends Tree> update, Tree statement, Void p) {
            this.scan(initializer, p);
            HashMap<VariableElement, State> oldVariable2State = new HashMap<VariableElement, State>(this.variable2State);
            boolean oldNot = this.not;
            boolean oldDoNotRecord = this.doNotRecord;
            this.not = true;
            this.doNotRecord = true;
            this.scan(condition, p);
            this.not = oldNot;
            HashMap<VariableElement, State> negConditionVariable2State = new HashMap<VariableElement, State>(this.variable2State);
            if (!oldDoNotRecord) {
                this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
                this.scan(condition, p);
                this.scan(statement, p);
                this.scan(update, p);
                this.mergeIntoVariable2State(oldVariable2State);
            } else {
                this.variable2State = oldVariable2State;
            }
            this.doNotRecord = oldDoNotRecord;
            this.scan(condition, p);
            this.scan(statement, p);
            this.scan(update, p);
            this.mergeIntoVariable2State(negConditionVariable2State);
            return null;
        }

        public State visitAssert(AssertTree node, Void p) {
            this.scan((Tree)node.getCondition(), p);
            this.scan((Tree)node.getDetail(), p);
            return null;
        }

        public State visitArrayAccess(ArrayAccessTree node, Void p) {
            super.visitArrayAccess(node, (Object)p);
            return State.POSSIBLE_NULL;
        }

        public State visitSwitch(SwitchTree node, Void p) {
            this.scan((Tree)node.getExpression(), null);
            HashMap<VariableElement, State> origVariable2State = new HashMap<VariableElement, State>(this.variable2State);
            boolean exhaustive = false;
            for (CaseTree caseTree : node.getCases()) {
                this.mergeIntoVariable2State(origVariable2State);
                if (caseTree.getExpression() == null) {
                    exhaustive = true;
                }
                this.scan((Tree)caseTree, null);
            }
            if (!exhaustive) {
                this.mergeIntoVariable2State(origVariable2State);
            }
            return null;
        }

        public State visitBreak(BreakTree node, Void p) {
            super.visitBreak(node, (Object)p);
            StatementTree target = this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath());
            this.resumeAfter(target, this.variable2State);
            this.variable2State = new HashMap<VariableElement, State>();
            return null;
        }

        public State visitTry(TryTree node, Void p) {
            if (node.getFinallyBlock() != null) {
                this.pendingFinally.add(0, new TreePath(this.getCurrentPath(), node.getFinallyBlock()));
            }
            this.scan(node.getResources(), null);
            Map<VariableElement, State> oldVariable2State = this.variable2State;
            this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
            this.scan((Tree)node.getBlock(), null);
            HashMap<VariableElement, State> afterBlockVariable2State = new HashMap<VariableElement, State>(this.variable2State);
            for (CatchTree catchTree : node.getCatches()) {
                Map<VariableElement, State> variable2StateBeforeCatch = this.variable2State;
                this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
                if (catchTree.getParameter() != null) {
                    TypeMirror caught = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), catchTree.getParameter()));
                    ArrayList<? extends TypeMirror> caughtExceptions = new ArrayList<TypeMirror>();
                    if (caught != null && caught.getKind() != TypeKind.ERROR) {
                        if (caught.getKind() == TypeKind.UNION) {
                            caughtExceptions.addAll(((UnionType)caught).getAlternatives());
                        } else {
                            caughtExceptions.add(caught);
                        }
                    }
                    for (TypeMirror typeMirror : caughtExceptions) {
                        Iterator<Map.Entry<TypeMirror, Collection<Map<VariableElement, State>>>> it = this.resumeOnExceptionHandler.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry<TypeMirror, Collection<Map<VariableElement, State>>> e = it.next();
                            if (!this.info.getTypes().isSubtype(e.getKey(), typeMirror)) continue;
                            for (Map<VariableElement, State> s : e.getValue()) {
                                this.mergeIntoVariable2State(s);
                            }
                            it.remove();
                        }
                    }
                }
                this.scan((Tree)catchTree, null);
                this.mergeIntoVariable2State(variable2StateBeforeCatch);
            }
            if (node.getFinallyBlock() != null) {
                this.pendingFinally.remove(0);
                this.mergeIntoVariable2State(oldVariable2State);
                this.mergeIntoVariable2State(afterBlockVariable2State);
                this.scan((Tree)node.getFinallyBlock(), null);
            }
            return null;
        }

        private void recordResumeOnExceptionHandler(ExecutableElement invoked) {
            for (TypeMirror typeMirror : invoked.getThrownTypes()) {
                this.recordResumeOnExceptionHandler(typeMirror);
            }
            this.recordResumeOnExceptionHandler("java.lang.RuntimeException");
            this.recordResumeOnExceptionHandler("java.lang.Error");
        }

        private void recordResumeOnExceptionHandler(String exceptionTypeFQN) {
            TypeElement exc = this.info.getElements().getTypeElement(exceptionTypeFQN);
            if (exc == null) {
                return;
            }
            this.recordResumeOnExceptionHandler(exc.asType());
        }

        private void recordResumeOnExceptionHandler(TypeMirror thrown) {
            if (thrown == null || thrown.getKind() == TypeKind.ERROR) {
                return;
            }
            Collection<Map<VariableElement, State>> r = this.resumeOnExceptionHandler.get(thrown);
            if (r == null) {
                r = new ArrayList<Map<VariableElement, State>>();
                this.resumeOnExceptionHandler.put(thrown, r);
            }
            r.add(new HashMap<VariableElement, State>(this.variable2State));
        }

        private void resumeAfter(Tree target, Map<VariableElement, State> state) {
            for (TreePath tp : this.pendingFinally) {
                boolean shouldBeRun = false;
                for (Tree t : tp) {
                    if (t != target) continue;
                    shouldBeRun = true;
                    break;
                }
                if (!shouldBeRun) break;
                VisitorImpl.recordResume(this.resumeBefore, tp.getLeaf(), state);
            }
            VisitorImpl.recordResume(this.resumeAfter, target, state);
        }

        private static void recordResume(Map<Tree, Collection<Map<VariableElement, State>>> resume, Tree target, Map<VariableElement, State> state) {
            Collection<Map<VariableElement, State>> r = resume.get(target);
            if (r == null) {
                r = new ArrayList<Map<VariableElement, State>>();
                resume.put(target, r);
            }
            r.add(new HashMap<VariableElement, State>(state));
        }

        private void mergeIntoVariable2State(Map<VariableElement, State> other) {
            for (Map.Entry<VariableElement, State> e : other.entrySet()) {
                State t = e.getValue();
                if (this.variable2State.containsKey(e.getKey())) {
                    State el = this.variable2State.get(e.getKey());
                    this.variable2State.put(e.getKey(), State.collect(t, el));
                    continue;
                }
                this.variable2State.put(e.getKey(), t);
            }
        }

        private void mergeHypotheticalVariable2State(Map<VariableElement, State> original) {
            for (Map.Entry<VariableElement, State> e : this.variable2State.entrySet()) {
                State t = e.getValue();
                if (t != State.NULL_HYPOTHETICAL && t != State.NOT_NULL_HYPOTHETICAL) continue;
                State originalValue = original.get(e.getKey());
                e.setValue(originalValue == State.POSSIBLE_NULL || originalValue == null ? State.POSSIBLE_NULL_REPORT : originalValue);
            }
        }

        private boolean hasDefiniteValue(Element el) {
            State s = this.variable2State.get(el);
            return s != null && s.isNotNull();
        }

        private boolean isVariableElement(Element ve) {
            return NPECheck.isVariableElement(this.ctx, ve);
        }
    }
}

