/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class ThisInAnonymous {
    private static final String THIS_KEYWORD = "this";
    private static final Set<ElementKind> LOCAL_CLASS_CONTAINERS = EnumSet.of(ElementKind.METHOD, ElementKind.CONSTRUCTOR);

    public static ErrorDescription hint(HintContext ctx) {
        TreePath thisVariable = (TreePath)ctx.getVariables().get("$this");
        if (thisVariable.getLeaf().getKind() != Tree.Kind.IDENTIFIER || !((IdentifierTree)thisVariable.getLeaf()).getName().contentEquals(THIS_KEYWORD)) {
            return null;
        }
        TreePath anonClassTP = ThisInAnonymous.getParentClass(ctx.getPath());
        Element annonClass = ctx.getInfo().getTrees().getElement(anonClassTP);
        String key = ThisInAnonymous.getKey(annonClass);
        if (key != null) {
            Element parent = ctx.getInfo().getTrees().getElement(ThisInAnonymous.getParentClass(anonClassTP.getParentPath()));
            if (parent == null || !parent.getKind().isClass() && !parent.getKind().isInterface()) {
                return null;
            }
            Fix fix = new FixImpl(TreePathHandle.create((TreePath)thisVariable, (CompilationInfo)ctx.getInfo()), (ElementHandle<TypeElement>)ElementHandle.create((Element)((TypeElement)parent))).toEditorFix();
            String displayName = NbBundle.getMessage(ThisInAnonymous.class, (String)key);
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)thisVariable, (String)displayName, (Fix[])new Fix[]{fix});
        }
        return null;
    }

    private static TreePath getParentClass(TreePath tp) {
        while (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
            tp = tp.getParentPath();
        }
        return tp;
    }

    private static String getKey(Element e) {
        ElementKind enclosingKind = e.getKind();
        if (enclosingKind == ElementKind.CLASS) {
            if (e.getSimpleName().length() == 0) {
                return "ERR_ThisInAnonymous";
            }
            if (LOCAL_CLASS_CONTAINERS.contains((Object)e.getEnclosingElement().getKind())) {
                return "ERR_ThisInAnonymousLocal";
            }
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        private final ElementHandle<TypeElement> parentClassElementHandle;

        public FixImpl(TreePathHandle thisHandle, ElementHandle<TypeElement> parentClassElementHandle) {
            super(thisHandle);
            this.parentClassElementHandle = parentClassElementHandle;
        }

        public String getText() {
            return NbBundle.getMessage(ThisInAnonymous.class, (String)"FIX_ThisInAnonymous");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            TypeElement parentClass = (TypeElement)this.parentClassElementHandle.resolve((CompilationInfo)wc);
            assert (tp != null);
            assert (parentClass != null);
            TreeMaker make = wc.getTreeMaker();
            wc.rewrite(tp.getLeaf(), (Tree)make.MemberSelect(make.QualIdent((Element)parentClass), (CharSequence)ThisInAnonymous.THIS_KEYWORD));
        }
    }
}

