/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class DeclarationForInstanceOf
implements TreeRule {
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.INSTANCE_OF);
    }

    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        return this.run(compilationInfo, treePath, CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)compilationInfo.getFileObject()));
    }

    List<ErrorDescription> run(CompilationInfo info, TreePath treePath, int offset) {
        Tree.Kind lk;
        TreePath ifPath;
        for (ifPath = treePath; ifPath != null && (lk = ifPath.getLeaf().getKind()) != Tree.Kind.IF; ifPath = ifPath.getParentPath()) {
            if (lk != Tree.Kind.METHOD && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)lk)) continue;
            return null;
        }
        if (ifPath == null) {
            return null;
        }
        InstanceOfTree leaf = (InstanceOfTree)treePath.getLeaf();
        if (leaf.getType() == null || leaf.getType().getKind() == Tree.Kind.ERRONEOUS) {
            return null;
        }
        TypeMirror castTo = info.getTrees().getTypeMirror(new TreePath(treePath, leaf.getType()));
        TreePath expression = new TreePath(treePath, leaf.getExpression());
        TypeMirror expressionType = info.getTrees().getTypeMirror(expression);
        if (expressionType == null || !info.getTypeUtilities().isCastable(expressionType, castTo)) {
            return null;
        }
        List<FixImpl> fix = Collections.singletonList(new FixImpl(info.getJavaSource(), TreePathHandle.create((TreePath)ifPath, (CompilationInfo)info), TreePathHandle.create((TreePath)expression, (CompilationInfo)info), TypeMirrorHandle.create((TypeMirror)castTo), Utilities.getName(castTo)));
        String displayName = NbBundle.getMessage(DeclarationForInstanceOf.class, (String)"ERR_DeclarationForInstanceof");
        ErrorDescription err = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)displayName, fix, (FileObject)info.getFileObject(), (int)offset, (int)offset);
        return Collections.singletonList(err);
    }

    public String getId() {
        return DeclarationForInstanceOf.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(DeclarationForInstanceOf.class, (String)"DN_DeclarationForInstanceof");
    }

    public void cancel() {
    }

    static final class FixImpl
    implements Fix {
        private JavaSource js;
        private TreePathHandle ifHandle;
        private TreePathHandle expression;
        private TypeMirrorHandle type;
        private String name;

        public FixImpl(JavaSource js, TreePathHandle ifHandle, TreePathHandle expression, TypeMirrorHandle type, String name) {
            this.js = js;
            this.ifHandle = ifHandle;
            this.expression = expression;
            this.type = type;
            this.name = name;
        }

        public String getText() {
            return NbBundle.getMessage(DeclarationForInstanceOf.class, (String)"FIX_CreateDeclaration");
        }

        public ChangeInfo implement() throws Exception {
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath ifTP = FixImpl.this.ifHandle.resolve((CompilationInfo)wc);
                    TreePath resolvedExpression = FixImpl.this.expression.resolve((CompilationInfo)wc);
                    TypeMirror resolvedType = FixImpl.this.type.resolve((CompilationInfo)wc);
                    if (ifTP == null || resolvedType == null || resolvedExpression == null) {
                        return;
                    }
                    IfTree ift = (IfTree)ifTP.getLeaf();
                    StatementTree then = ift.getThenStatement();
                    if (then.getKind() == Tree.Kind.ERRONEOUS) {
                        return;
                    }
                    LinkedList<? extends StatementTree> statements = new LinkedList<StatementTree>();
                    if (then.getKind() == Tree.Kind.BLOCK) {
                        statements.addAll(((BlockTree)then).getStatements());
                    } else {
                        statements.add(then);
                    }
                    TreeMaker make = wc.getTreeMaker();
                    VariableTree decl = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)FixImpl.this.name, make.Type(resolvedType), (ExpressionTree)make.TypeCast(make.Type(resolvedType), (ExpressionTree)resolvedExpression.getLeaf()));
                    statements.add(0, decl);
                    BlockTree nue = make.Block(statements, false);
                    wc.rewrite((Tree)then, (Tree)nue);
                }
            }).commit();
            return null;
        }
    }
}

