/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class Braces {
    static final EnumSet<JavaTokenId> nonRelevant = EnumSet.of(JavaTokenId.LINE_COMMENT, JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.WHITESPACE);
    private static final String BRACES_ID = "Braces_";

    public static ErrorDescription checkFor(HintContext ctx) {
        StatementTree st;
        switch (ctx.getPath().getLeaf().getKind()) {
            case FOR_LOOP: {
                st = ((ForLoopTree)ctx.getPath().getLeaf()).getStatement();
                break;
            }
            case ENHANCED_FOR_LOOP: {
                st = ((EnhancedForLoopTree)ctx.getPath().getLeaf()).getStatement();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Braces.checkStatement(ctx, "LBL_Braces_For", st, ctx.getPath());
    }

    public static ErrorDescription checkWhile(HintContext ctx) {
        WhileLoopTree wlt = (WhileLoopTree)ctx.getPath().getLeaf();
        return Braces.checkStatement(ctx, "LBL_Braces_While", wlt.getStatement(), ctx.getPath());
    }

    public static ErrorDescription checkDoWhile(HintContext ctx) {
        DoWhileLoopTree dwlt = (DoWhileLoopTree)ctx.getPath().getLeaf();
        return Braces.checkStatement(ctx, "LBL_Braces_DoWhile", dwlt.getStatement(), ctx.getPath());
    }

    public static List<ErrorDescription> checkIf(HintContext ctx) {
        IfTree it = (IfTree)ctx.getPath().getLeaf();
        return Braces.checkifStatements(ctx, "LBL_Braces_If", it.getThenStatement(), it.getElseStatement(), ctx.getPath());
    }

    private static ErrorDescription checkStatement(HintContext ctx, String dnKey, StatementTree statement, TreePath tp) {
        if (statement != null && statement.getKind() != Tree.Kind.EMPTY_STATEMENT && statement.getKind() != Tree.Kind.BLOCK && statement.getKind() != Tree.Kind.ERRONEOUS && !Braces.isErroneousExpression(statement)) {
            return ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)statement, (String)NbBundle.getMessage(Braces.class, (String)dnKey), (Fix[])new Fix[]{new BracesFix(ctx.getInfo().getFileObject(), TreePathHandle.create((TreePath)tp, (CompilationInfo)ctx.getInfo())).toEditorFix()});
        }
        return null;
    }

    private static List<ErrorDescription> checkifStatements(HintContext ctx, String dnKey, StatementTree thenSt, StatementTree elseSt, TreePath tp) {
        BracesFix bf;
        boolean fixThen = false;
        boolean fixElse = false;
        if (thenSt != null && thenSt.getKind() != Tree.Kind.EMPTY_STATEMENT && thenSt.getKind() != Tree.Kind.BLOCK && thenSt.getKind() != Tree.Kind.ERRONEOUS && !Braces.isErroneousExpression(thenSt)) {
            fixThen = true;
        }
        if (elseSt != null && elseSt.getKind() != Tree.Kind.EMPTY_STATEMENT && elseSt.getKind() != Tree.Kind.BLOCK && elseSt.getKind() != Tree.Kind.ERRONEOUS && elseSt.getKind() != Tree.Kind.IF && !Braces.isErroneousExpression(elseSt)) {
            fixElse = true;
        }
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        if (fixThen) {
            bf = new BracesFix(ctx.getInfo().getFileObject(), TreePathHandle.create((TreePath)tp, (CompilationInfo)ctx.getInfo()));
            bf.fixThen = fixThen;
            bf.fixElse = fixElse;
            result.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)thenSt, (String)NbBundle.getMessage(Braces.class, (String)dnKey), (Fix[])new Fix[]{bf.toEditorFix()}));
        }
        if (fixElse) {
            bf = new BracesFix(ctx.getInfo().getFileObject(), TreePathHandle.create((TreePath)tp, (CompilationInfo)ctx.getInfo()));
            bf.fixThen = fixThen;
            bf.fixElse = fixElse;
            result.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)elseSt, (String)NbBundle.getMessage(Braces.class, (String)dnKey), (Fix[])new Fix[]{bf.toEditorFix()}));
        }
        return result;
    }

    private static boolean isErroneousExpression(StatementTree statement) {
        return statement instanceof ExpressionStatementTree && ((ExpressionStatementTree)statement).getExpression().getKind() == Tree.Kind.ERRONEOUS;
    }

    private static class BracesFix
    extends JavaFix {
        boolean fixThen;
        boolean fixElse;

        public BracesFix(FileObject file, TreePathHandle tph) {
            super(tph);
        }

        public String getText() {
            return NbBundle.getMessage(Braces.class, (String)"LBL_Braces_Fix");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath path = ctx.getPath();
            if (path != null) {
                TreeMaker make = copy.getTreeMaker();
                Tree oldTree = path.getLeaf();
                switch (oldTree.getKind()) {
                    case FOR_LOOP: {
                        ForLoopTree oldFor = (ForLoopTree)oldTree;
                        StatementTree oldBlock = oldFor.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                        break;
                    }
                    case ENHANCED_FOR_LOOP: {
                        EnhancedForLoopTree oldEnhancedFor = (EnhancedForLoopTree)oldTree;
                        StatementTree oldBlock = oldEnhancedFor.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                        break;
                    }
                    case WHILE_LOOP: {
                        WhileLoopTree oldWhile = (WhileLoopTree)oldTree;
                        StatementTree oldBlock = oldWhile.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                        break;
                    }
                    case DO_WHILE_LOOP: {
                        DoWhileLoopTree oldDoWhile = (DoWhileLoopTree)oldTree;
                        StatementTree oldBlock = oldDoWhile.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                        break;
                    }
                    case IF: {
                        BlockTree newBlock;
                        StatementTree oldBlock;
                        IfTree oldIf = (IfTree)oldTree;
                        if (this.fixThen) {
                            oldBlock = oldIf.getThenStatement();
                            newBlock = make.Block(Collections.singletonList(oldBlock), false);
                            copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                        }
                        if (!this.fixElse) break;
                        oldBlock = oldIf.getElseStatement();
                        newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite((Tree)oldBlock, (Tree)newBlock);
                    }
                }
            }
        }
    }
}

