/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.CustomizerAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.DebugAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.ProfileAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RefreshAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RemoveInstanceAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RestartAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.StartAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.StopAction;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.actions.SystemAction;

public class InstanceNodeDecorator
extends FilterNode
implements ServerInstance.StateListener {
    private static final String WAITING_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/waiting.png";
    private static final String RUNNING_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/running.png";
    private static final String DEBUGGING_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/debugging.png";
    private static final String SUSPENDED_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/suspended.png";
    private static final String PROFILING_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/profiling.png";
    private static final String PROFILER_BLOCKING_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/profilerblocking.png";
    private ServerInstance si;

    public InstanceNodeDecorator(Node original, ServerInstance si) {
        super(original);
        this.si = si;
        si.addStateListener(this);
    }

    public String getDisplayName() {
        return this.si.getDisplayName();
    }

    public String getName() {
        return this.si.getUrl();
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Arrays.asList(SystemAction.get(StartAction.class), SystemAction.get(DebugAction.class)));
        if (this.si.isProfileSupported()) {
            actions.add((Action)SystemAction.get(ProfileAction.class));
        }
        actions.addAll(Arrays.asList(SystemAction.get(RestartAction.class), SystemAction.get(StopAction.class), SystemAction.get(RefreshAction.class), null, SystemAction.get(RemoveInstanceAction.class)));
        actions.addAll(Arrays.asList(this.getOriginal().getActions(context)));
        actions.add(null);
        actions.add((Action)SystemAction.get(CustomizerAction.class));
        return actions.toArray(new Action[actions.size()]);
    }

    public Image getIcon(int type) {
        return this.badgeIcon(this.getOriginal().getIcon(type));
    }

    public Image getOpenedIcon(int type) {
        return this.badgeIcon(this.getOriginal().getOpenedIcon(type));
    }

    private Image badgeIcon(Image origImg) {
        Image badge = null;
        switch (this.si.getServerState()) {
            case 1: {
                badge = ImageUtilities.loadImage((String)WAITING_ICON);
                break;
            }
            case 3: {
                badge = ImageUtilities.loadImage((String)RUNNING_ICON);
                break;
            }
            case 4: {
                badge = ImageUtilities.loadImage((String)DEBUGGING_ICON);
                break;
            }
            case 5: {
                badge = ImageUtilities.loadImage((String)SUSPENDED_ICON);
                break;
            }
            case 6: {
                badge = ImageUtilities.loadImage((String)PROFILING_ICON);
                break;
            }
            case 7: {
                badge = ImageUtilities.loadImage((String)PROFILER_BLOCKING_ICON);
                break;
            }
            case 8: {
                badge = ImageUtilities.loadImage((String)WAITING_ICON);
                break;
            }
        }
        return badge != null ? ImageUtilities.mergeImages((Image)origImg, (Image)badge, (int)15, (int)8) : origImg;
    }

    @Override
    public void stateChanged(int oldState, int newState) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                InstanceNodeDecorator.this.fireIconChange();
            }
        });
    }
}

