/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.sharability;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

@SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"})
public class SourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation2 {
    private static final String[] CLASSPATH_VOLUMES = new String[]{"classpath", "wscompile"};
    private final Map<URL, SourceForBinaryQueryImplementation2.Result> cache = new ConcurrentHashMap<URL, SourceForBinaryQueryImplementation2.Result>();
    private final Map<URL, URL> normalizedURLCache = new ConcurrentHashMap<URL, URL>();

    @SuppressWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"})
    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        SourceForBinaryQueryImplementation2.Result res = this.cache.get(binaryRoot);
        if (res != null) {
            return res;
        }
        boolean isNormalizedURL = SourceForBinaryQueryImpl.isNormalizedURL(binaryRoot);
        for (LibraryManager mgr : LibraryManager.getOpenManagers()) {
            for (Library lib : mgr.getLibraries()) {
                if (!lib.getType().equals("serverlibrary")) continue;
                for (String type : CLASSPATH_VOLUMES) {
                    Iterator i$ = lib.getContent(type).iterator();
                    while (i$.hasNext()) {
                        URL entry;
                        URL normalizedEntry = entry = (URL)i$.next();
                        if (isNormalizedURL) {
                            normalizedEntry = this.getNormalizedURL(normalizedEntry);
                        }
                        if (!binaryRoot.equals(normalizedEntry)) continue;
                        res = new Result(entry, lib);
                        this.cache.put(binaryRoot, res);
                        return res;
                    }
                }
            }
        }
        return null;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    private URL getNormalizedURL(URL url) {
        FileObject fo;
        if (SourceForBinaryQueryImpl.isNormalizedURL(url)) {
            return url;
        }
        URL normalizedURL = this.normalizedURLCache.get(url);
        if (normalizedURL == null && (fo = URLMapper.findFileObject((URL)url)) != null) {
            try {
                normalizedURL = fo.getURL();
                this.normalizedURLCache.put(url, normalizedURL);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return normalizedURL;
    }

    private static boolean isNormalizedURL(URL url) {
        if ("jar".equals(url.getProtocol())) {
            url = FileUtil.getArchiveFile((URL)url);
        }
        return "file".equals(url.getProtocol());
    }

    private static class Result
    implements SourceForBinaryQueryImplementation2.Result,
    PropertyChangeListener {
        private Library lib;
        private URL entry;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private FileObject[] cache;

        public Result(URL queryFor, Library lib) {
            this.entry = queryFor;
            this.lib = lib;
            this.lib.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.lib));
        }

        public synchronized FileObject[] getRoots() {
            if (this.cache == null) {
                boolean contains = false;
                for (String type : CLASSPATH_VOLUMES) {
                    if (!this.lib.getContent(type).contains(this.entry)) continue;
                    contains = true;
                    break;
                }
                if (contains) {
                    ArrayList<FileObject> result = new ArrayList<FileObject>();
                    for (URL u : this.lib.getContent("src")) {
                        FileObject sourceRootURL = URLMapper.findFileObject((URL)u);
                        if (sourceRootURL == null) continue;
                        result.add(sourceRootURL);
                    }
                    this.cache = result.toArray(new FileObject[result.size()]);
                } else {
                    this.cache = new FileObject[0];
                }
            }
            return this.cache;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            assert (l != null) : "Listener cannot be null";
            this.cs.addChangeListener(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            assert (l != null) : "Listener cannot be null";
            this.cs.removeChangeListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("content".equals(event.getPropertyName())) {
                Result result = this;
                synchronized (result) {
                    this.cache = null;
                }
                this.cs.fireChange();
            }
        }

        public boolean preferSources() {
            return false;
        }
    }
}

