/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ResourceChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.execution.ModuleConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.impl.ChangeDescriptorAccessor;
import org.netbeans.modules.j2ee.deployment.impl.DeployOnSaveManager;
import org.netbeans.modules.j2ee.deployment.impl.DeploymentHelper;
import org.netbeans.modules.j2ee.deployment.impl.InitialServerFileDistributor;
import org.netbeans.modules.j2ee.deployment.impl.ProgressObjectUtil;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerFileDistributor;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.projects.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.DeploymentChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentContext;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentManager2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.TargetModuleIDResolver;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfigurationFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class TargetServer {
    private static final Logger LOGGER = Logger.getLogger(TargetServer.class.getName());
    private Target[] targets;
    private final ServerInstance instance;
    private final DeploymentTarget dtarget;
    private IncrementalDeployment incremental;
    private Map availablesMap = null;
    private Set deployedRootTMIDs = new HashSet();
    private Set undeployTMIDs = new HashSet();
    private Set distributeTargets = new HashSet();
    private TargetModule[] redeployTargetModules = null;
    private File application = null;
    private File currentContentDir = null;
    private String contextRoot = null;

    public TargetServer(DeploymentTarget target) {
        this.dtarget = target;
        this.instance = this.dtarget.getServer().getServerInstance();
    }

    private void init(ProgressUI ui, boolean start, boolean processLast) throws ServerException {
        if (this.targets == null) {
            if (start) {
                this.instance.start(ui);
                this.targets = this.dtarget.getServer().toTargets();
            } else {
                HashSet<Target> tempTargets = new HashSet<Target>(Arrays.asList(this.dtarget.getServer().toTargets()));
                Iterator it = tempTargets.iterator();
                while (it.hasNext()) {
                    Target target = (Target)it.next();
                    if (this.instance.getStartServer().isRunning(target)) continue;
                    it.remove();
                }
                this.targets = tempTargets.toArray(new Target[tempTargets.size()]);
            }
        }
        this.incremental = this.instance.getIncrementalDeployment();
        if (this.incremental != null && !this.checkServiceImplementations()) {
            this.incremental = null;
        }
        try {
            FileObject contentFO = this.dtarget.getModule().getContentDirectory();
            if (contentFO != null) {
                this.currentContentDir = FileUtil.toFile((FileObject)contentFO);
            }
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.INFO, null, ioe);
        }
        J2eeModuleProvider.ConfigSupport configSupport = this.dtarget.getConfigSupport();
        if (J2eeModule.Type.WAR.equals(this.dtarget.getModule().getType())) {
            try {
                this.contextRoot = configSupport.getWebContextRoot();
            }
            catch (ConfigurationException e) {
                this.contextRoot = null;
            }
        }
        if (processLast) {
            this.processLastTargetModules();
        }
    }

    private boolean canFileDeploy(Target[] targetz, J2eeModule deployable) throws IOException {
        if (targetz == null || targetz.length != 1) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(TargetServer.class, (String)"MSG_MoreThanOneIncrementalTargets"));
            if (targetz != null && LOGGER.isLoggable(Level.FINE)) {
                StringBuilder builder = new StringBuilder("[");
                for (int i = 0; i < targetz.length; ++i) {
                    if (i > 0) {
                        builder.append(",");
                    }
                    builder.append("[").append(targetz[i].getName()).append(",").append(targetz[i].getDescription()).append("]");
                }
                builder.append("]");
                LOGGER.log(Level.FINE, builder.toString());
            }
            return false;
        }
        return deployable != null && null != deployable.getContentDirectory() && this.instance.getIncrementalDeployment().canFileDeploy(targetz[0], deployable);
    }

    private boolean canFileDeploy(TargetModule[] targetModules, J2eeModule deployable) throws IOException {
        if (targetModules == null || targetModules.length != 1) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(TargetServer.class, (String)"MSG_MoreThanOneIncrementalTargets"));
            if (targetModules != null && LOGGER.isLoggable(Level.FINE)) {
                StringBuilder builder = new StringBuilder("[");
                for (int i = 0; i < targetModules.length; ++i) {
                    if (i > 0) {
                        builder.append(",");
                    }
                    builder.append("[").append(targetModules[i].getId()).append(",").append(targetModules[i].getTargetName()).append("]");
                }
                builder.append("]");
                LOGGER.log(Level.FINE, builder.toString());
            }
            return false;
        }
        return deployable != null && null != deployable.getContentDirectory() && this.instance.getIncrementalDeployment().canFileDeploy(targetModules[0].getTarget(), deployable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentChangeDescriptor distributeChanges(TargetModule targetModule, ProgressUI ui) throws IOException {
        ServerFileDistributor sfd = new ServerFileDistributor(this.instance, this.dtarget);
        try {
            ui.setProgressObject(sfd);
            ModuleChangeReporter mcr = this.dtarget.getModuleChangeReporter();
            ResourceChangeReporter rcr = this.dtarget.getResourceChangeReporter();
            DeploymentChangeDescriptor acd = sfd.distribute(targetModule, mcr, rcr);
            LOGGER.log(Level.FINE, "Change descriptor is {0}", acd);
            DeploymentChangeDescriptor deploymentChangeDescriptor = acd;
            return deploymentChangeDescriptor;
        }
        finally {
            ui.setProgressObject(null);
        }
    }

    private DeploymentChangeDescriptor distributeChangesOnSave(TargetModule targetModule, Iterable<ArtifactListener.Artifact> artifacts) throws IOException {
        ServerFileDistributor sfd = new ServerFileDistributor(this.instance, this.dtarget);
        ModuleChangeReporter mcr = this.dtarget.getModuleChangeReporter();
        ResourceChangeReporter rcr = this.dtarget.getResourceChangeReporter();
        DeploymentChangeDescriptor acd = sfd.distributeOnSave(targetModule, mcr, rcr, artifacts);
        LOGGER.log(Level.FINE, "Change descriptor is {0}", acd);
        return acd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File initialDistribute(Target target, ProgressUI ui) throws ServerException {
        InitialServerFileDistributor sfd = new InitialServerFileDistributor(this.dtarget, target);
        try {
            ui.setProgressObject(sfd);
            File ret = sfd.distribute();
            if (sfd.getDeploymentStatus().isFailed()) {
                String statusMessage = sfd.getDeploymentStatus().getMessage();
                String msg = null;
                msg = statusMessage != null ? NbBundle.getMessage(TargetServer.class, (String)"MSG_DeployFailed", (Object)statusMessage) : NbBundle.getMessage(TargetServer.class, (String)"MSG_DeployFailedNoMessage");
                throw new ServerException(msg);
            }
            File file = ret;
            return file;
        }
        finally {
            ui.setProgressObject(null);
        }
    }

    private boolean checkServiceImplementations() {
        String missing = null;
        if (this.instance.getServer().getModuleConfigurationFactory() == null) {
            missing = ModuleConfigurationFactory.class.getName();
        }
        if (missing != null) {
            String msg = NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_MissingServiceImplementations", (Object)missing);
            Logger.getLogger("global").log(Level.INFO, msg);
            return false;
        }
        return true;
    }

    private TargetModule[] checkUndeployForChangedReferences(Set toRedeploy) {
        if (J2eeModule.Type.WAR.equals(this.dtarget.getModule().getType())) {
            Iterator j = toRedeploy.iterator();
            while (j.hasNext()) {
                File lastContentDir;
                TargetModule deployed = (TargetModule)j.next();
                File file = lastContentDir = deployed.getContentDirectory() == null ? null : new File(deployed.getContentDirectory());
                if ((this.currentContentDir == null || this.currentContentDir.equals(lastContentDir)) && (this.contextRoot == null || this.contextRoot.equals(deployed.getContextRoot()))) continue;
                this.distributeTargets.add(deployed.findTarget());
                this.undeployTMIDs.add(deployed.delegate());
                deployed.remove();
                j.remove();
            }
        }
        return toRedeploy.toArray(new TargetModule[toRedeploy.size()]);
    }

    private TargetModule[] checkUndeployForSharedReferences(Target[] toDistribute) {
        HashSet<Target> distSet = new HashSet<Target>(Arrays.asList(toDistribute));
        return this.checkUndeployForSharedReferences(Collections.EMPTY_SET, distSet);
    }

    private TargetModule[] checkUndeployForSharedReferences(Set toRedeploy, Set toDistribute) {
        return this.checkUndeployForSharedReferences(toRedeploy, toDistribute, null);
    }

    /*
     * WARNING - void declaration
     */
    private TargetModule[] checkUndeployForSharedReferences(Set toRedeploy, Set toDistribute, Map queryInfo) {
        List<TargetModuleID> sharerTMIDs;
        if (this.contextRoot == null || toRedeploy.isEmpty() && toDistribute.isEmpty()) {
            return toRedeploy.toArray(new TargetModule[toRedeploy.size()]);
        }
        HashSet<Target> allTargets = new HashSet<Target>(Arrays.asList(TargetModule.toTarget(toRedeploy.toArray(new TargetModule[toRedeploy.size()]))));
        allTargets.addAll(toDistribute);
        Target[] targs = allTargets.toArray(new Target[allTargets.size()]);
        boolean shared = false;
        ArrayList<Target> addToDistributeWhenSharedDetected = new ArrayList<Target>();
        ArrayList<TargetModule> removeFromRedeployWhenSharedDetected = new ArrayList<TargetModule>();
        ArrayList<TargetModuleID> addToUndeployWhenSharedDetected = new ArrayList<TargetModuleID>();
        TargetModuleIDResolver tmidResolver = this.instance.getTargetModuleIDResolver();
        if (tmidResolver != null) {
            void var13_13;
            if (queryInfo == null) {
                queryInfo = new HashMap();
                queryInfo.put("contextRoot", this.contextRoot);
            }
            TargetModuleID[] haveSameReferences = TargetModule.EMPTY_TMID_ARRAY;
            if (targs.length > 0) {
                haveSameReferences = tmidResolver.lookupTargetModuleID(queryInfo, targs);
            }
            boolean bl = false;
            while (var13_13 < haveSameReferences.length) {
                haveSameReferences[var13_13] = new TargetModule(TargetServer.keyOf(haveSameReferences[var13_13]), haveSameReferences[var13_13]);
                ++var13_13;
            }
            sharerTMIDs = Arrays.asList(haveSameReferences);
            for (TargetModule targetModule : sharerTMIDs) {
                if (toRedeploy.size() > 0 && !toRedeploy.contains(targetModule) || toDistribute.contains(targetModule.getTarget())) {
                    shared = true;
                    addToUndeployWhenSharedDetected.add(targetModule.delegate());
                    continue;
                }
                removeFromRedeployWhenSharedDetected.add(targetModule);
                addToDistributeWhenSharedDetected.add(targetModule.getTarget());
            }
        }
        if (!shared) {
            sharerTMIDs = TargetModule.findByContextRoot(this.dtarget.getServer(), this.contextRoot);
            sharerTMIDs = TargetModule.initDelegate(sharerTMIDs, this.getAvailableTMIDsMap());
            for (TargetModule targetModule : sharerTMIDs) {
                boolean bl = false;
                for (TargetModule redeploying : toRedeploy) {
                    if (!redeploying.equals(targetModule) || !redeploying.getContentDirectory().equals(targetModule.getContentDirectory())) continue;
                    bl = true;
                    break;
                }
                if (!bl || toDistribute.contains(targetModule.getTarget())) {
                    shared = true;
                    addToUndeployWhenSharedDetected.add(targetModule.delegate());
                    continue;
                }
                removeFromRedeployWhenSharedDetected.add(targetModule);
                addToDistributeWhenSharedDetected.add(targetModule.getTarget());
            }
        }
        if (shared) {
            this.undeployTMIDs.addAll(addToUndeployWhenSharedDetected);
            TargetModule.removeByContextRoot(this.dtarget.getServer(), this.contextRoot);
            toRedeploy.removeAll(removeFromRedeployWhenSharedDetected);
            this.distributeTargets.addAll(addToDistributeWhenSharedDetected);
        }
        return toRedeploy.toArray(new TargetModule[toRedeploy.size()]);
    }

    private Map<String, TargetModuleID> getAvailableTMIDsMap() {
        if (this.availablesMap != null) {
            return this.availablesMap;
        }
        DeploymentManager dm = this.instance.getDeploymentManager();
        this.availablesMap = new HashMap();
        try {
            ModuleType type = J2eeModuleAccessor.getDefault().getJsrModuleType(this.dtarget.getModule().getType());
            TargetModuleID[] ids = dm.getAvailableModules(type, this.targets);
            if (ids == null) {
                return this.availablesMap;
            }
            for (int i = 0; i < ids.length; ++i) {
                this.availablesMap.put(TargetServer.keyOf(ids[i]), ids[i]);
            }
        }
        catch (TargetException te) {
            throw new IllegalArgumentException(te);
        }
        return this.availablesMap;
    }

    private void processLastTargetModules() {
        TargetModule[] targetModules = this.dtarget.getTargetModules();
        if (targetModules == null || targetModules.length == 0) {
            this.distributeTargets.addAll(Arrays.asList(this.targets));
            this.checkUndeployForSharedReferences(this.targets);
            return;
        }
        HashSet<String> targetNames = new HashSet<String>();
        for (int i = 0; i < this.targets.length; ++i) {
            targetNames.add(this.targets[i].getName());
        }
        Set<TargetModule> toRedeploy = new HashSet();
        for (int i = 0; i < targetModules.length; ++i) {
            if (!targetModules[i].getInstanceUrl().equals(this.instance.getUrl()) || !targetNames.contains(targetModules[i].getTargetName())) continue;
            TargetModuleID tmID = this.getAvailableTMIDsMap().get(targetModules[i].getId());
            if (tmID == null) {
                Target target = targetModules[i].findTarget();
                if (target == null) continue;
                this.distributeTargets.add(target);
                continue;
            }
            targetModules[i].initDelegate(tmID);
            toRedeploy.add(targetModules[i]);
        }
        DeploymentManager dm = this.instance.getDeploymentManager();
        if (this.incremental == null && this.getApplication() == null) {
            toRedeploy = Collections.EMPTY_SET;
        } else if (this.incremental == null) {
            long lastModified = this.getApplication().lastModified();
            Iterator j = toRedeploy.iterator();
            while (j.hasNext()) {
                TargetModule deployed = (TargetModule)j.next();
                if (lastModified >= deployed.getTimestamp()) {
                    if (dm.isRedeploySupported()) continue;
                    this.distributeTargets.add(deployed.findTarget());
                    this.undeployTMIDs.add(deployed.delegate());
                    j.remove();
                    continue;
                }
                j.remove();
            }
        }
        this.redeployTargetModules = this.checkUndeployForChangedReferences(toRedeploy);
        HashSet targetSet = new HashSet(this.distributeTargets);
        this.redeployTargetModules = this.checkUndeployForSharedReferences(toRedeploy, targetSet);
    }

    private File getApplication() {
        if (this.application != null) {
            return this.application;
        }
        try {
            FileObject archiveFO = this.dtarget.getModule().getArchive();
            if (archiveFO == null) {
                return null;
            }
            this.application = FileUtil.toFile((FileObject)archiveFO);
            return this.application;
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.SEVERE, ioe.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTargets(Deployment.Mode mode, ProgressUI ui) throws ServerException {
        if (this.instance.getStartServer().isAlsoTargetServer(null)) {
            switch (mode) {
                case DEBUG: {
                    this.instance.startDebug(ui);
                    break;
                }
                case PROFILE: {
                    final CountDownLatch latch = new CountDownLatch(1);
                    ServerInstance.StateListener sl = new ServerInstance.StateListener(){

                        @Override
                        public void stateChanged(int oldState, int newState) {
                            if (newState == 2 || newState == 6) {
                                latch.countDown();
                            }
                        }
                    };
                    this.instance.addStateListener(sl);
                    try {
                        this.instance.startProfile(false, ui);
                        try {
                            latch.await(60L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                        break;
                    }
                    finally {
                        this.instance.removeStateListener(sl);
                    }
                }
                case RUN: {
                    this.instance.start(ui);
                }
            }
            this.targets = this.dtarget.getServer().toTargets();
            return;
        }
        this.instance.start(ui);
        this.targets = this.dtarget.getServer().toTargets();
        switch (mode) {
            case DEBUG: {
                for (int i = 0; i < this.targets.length; ++i) {
                    this.instance.startDebugTarget(this.targets[i], ui);
                }
                break;
            }
            case RUN: {
                for (int i = 0; i < this.targets.length; ++i) {
                    this.instance.startTarget(this.targets[i], ui);
                }
                break;
            }
        }
    }

    private static String keyOf(TargetModuleID tmid) {
        return tmid.toString();
    }

    private TargetModuleID[] saveRootTargetModules(TargetModuleID[] modules) {
        long timestamp = System.currentTimeMillis();
        HashSet<TargetModuleID> originals = new HashSet<TargetModuleID>();
        for (int i = 0; i < modules.length; ++i) {
            if (modules[i].getParentTargetModuleID() != null) continue;
            String id = TargetServer.keyOf(modules[i]);
            String targetName = modules[i].getTarget().getName();
            String fromDir = "";
            if (null != this.currentContentDir) {
                fromDir = this.currentContentDir.getAbsolutePath();
            }
            TargetModule tm = new TargetModule(id, this.instance.getUrl(), timestamp, fromDir, this.contextRoot, modules[i]);
            this.deployedRootTMIDs.add(tm);
            originals.add(modules[i]);
        }
        return originals.toArray(new TargetModuleID[originals.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TargetModule[] deploy(ProgressUI ui, boolean forceRedeploy) throws IOException, ServerException {
        DeploymentContext deployment;
        DeploymentManager dm;
        boolean hasDirectory;
        ProgressObject po = null;
        boolean hasActivities = false;
        this.init(ui, true, true);
        boolean missingModule = false;
        if (J2eeModule.Type.EAR.equals(this.dtarget.getModule().getType()) && this.dtarget.getModule() instanceof J2eeApplication && this.redeployTargetModules != null && this.redeployTargetModules.length == 1) {
            int redeployChildrenCount = this.redeployTargetModules[0].getChildTargetModuleID() != null ? this.redeployTargetModules[0].getChildTargetModuleID().length : 0;
            boolean bl = missingModule = redeployChildrenCount < ((J2eeApplication)this.dtarget.getModule()).getModules().length;
            if (missingModule) {
                LOGGER.log(Level.INFO, "Enterprise application needs to be redeployed due to missing module");
            }
        }
        if ((forceRedeploy || missingModule) && this.redeployTargetModules != null) {
            for (int i = 0; i < this.redeployTargetModules.length; ++i) {
                this.distributeTargets.add(this.redeployTargetModules[i].findTarget());
                this.undeployTMIDs.add(this.redeployTargetModules[i].delegate());
                this.redeployTargetModules[i].remove();
            }
            this.redeployTargetModules = null;
        }
        File plan = null;
        J2eeModule deployable = null;
        ModuleConfigurationProvider mcp = this.dtarget.getModuleConfigurationProvider();
        if (mcp != null) {
            deployable = mcp.getJ2eeModule(null);
        }
        boolean bl = hasDirectory = this.dtarget.getModule().getContentDirectory() != null;
        if (this.undeployTMIDs.size() > 0) {
            TargetModuleID[] tmIDs = this.undeployTMIDs.toArray(new TargetModuleID[this.undeployTMIDs.size()]);
            ui.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_Undeploying"));
            ProgressObject undeployPO = this.instance.getDeploymentManager().undeploy(tmIDs);
            try {
                ProgressObjectUtil.trackProgressObject(ui, undeployPO, this.instance.getDeploymentTimeout());
            }
            catch (TimeoutException e) {
                // empty catch block
            }
        }
        if (this.distributeTargets.size() > 0) {
            hasActivities = true;
            Target[] targetz = this.distributeTargets.toArray(new Target[this.distributeTargets.size()]);
            IncrementalDeployment lincremental = IncrementalDeployment.getIncrementalDeploymentForModule(this.incremental, deployable);
            if (lincremental != null && hasDirectory && this.canFileDeploy(targetz, deployable)) {
                ModuleConfiguration cfg = this.dtarget.getModuleConfigurationProvider().getModuleConfiguration();
                File dir = this.initialDistribute(targetz[0], ui);
                if (lincremental instanceof IncrementalDeployment2) {
                    DeploymentContext deployment2 = DeploymentContextAccessor.getDefault().createDeploymentContext(deployable, dir, null, this.dtarget.getModuleProvider().getRequiredLibraries(), null);
                    po = ((IncrementalDeployment2)((Object)lincremental)).initialDeploy(targetz[0], deployment2);
                } else {
                    po = lincremental.initialDeploy(targetz[0], deployable, cfg, dir);
                }
                this.trackDeployProgressObject(ui, po, false);
            } else {
                if (this.getApplication() == null) {
                    throw new NoArchiveException(NbBundle.getMessage(TargetServer.class, (String)"MSG_NoArchive"));
                }
                ui.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_Distributing", (Object)this.application, Arrays.asList(targetz)));
                plan = this.dtarget.getConfigurationFile();
                dm = this.instance.getDeploymentManager();
                if (dm instanceof DeploymentManager2) {
                    deployment = DeploymentContextAccessor.getDefault().createDeploymentContext(this.dtarget.getModule(), this.getApplication(), plan, this.dtarget.getModuleProvider().getRequiredLibraries(), null);
                    po = ((DeploymentManager2)dm).distribute(targetz, deployment);
                } else {
                    po = dm.distribute(targetz, this.getApplication(), plan);
                }
                this.trackDeployProgressObject(ui, po, false);
            }
        }
        if (this.redeployTargetModules != null && this.redeployTargetModules.length > 0) {
            hasActivities = true;
            IncrementalDeployment lincremental = IncrementalDeployment.getIncrementalDeploymentForModule(this.incremental, deployable);
            if (lincremental != null && hasDirectory && this.canFileDeploy(this.redeployTargetModules, deployable)) {
                DeploymentChangeDescriptor acd = this.distributeChanges(this.redeployTargetModules[0], ui);
                if (!TargetServer.anyChanged(acd)) return this.dtarget.getTargetModules();
                ui.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_IncrementalDeploying", (Object)this.redeployTargetModules[0]));
                if (lincremental instanceof IncrementalDeployment2) {
                    DeploymentContext deployment3 = DeploymentContextAccessor.getDefault().createDeploymentContext(deployable, null, null, this.dtarget.getModuleProvider().getRequiredLibraries(), acd);
                    po = ((IncrementalDeployment2)((Object)lincremental)).incrementalDeploy(this.redeployTargetModules[0].delegate(), deployment3);
                } else {
                    po = lincremental.incrementalDeploy(this.redeployTargetModules[0].delegate(), acd);
                }
                this.trackDeployProgressObject(ui, po, true);
            } else {
                if (this.getApplication() == null) {
                    throw new IllegalArgumentException(NbBundle.getMessage(TargetServer.class, (String)"MSG_NoArchive"));
                }
                ui.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_Redeploying", (Object)this.application));
                TargetModuleID[] tmids = TargetModule.toTargetModuleID(this.redeployTargetModules);
                if (plan == null) {
                    plan = this.dtarget.getConfigurationFile();
                }
                if ((dm = this.instance.getDeploymentManager()) instanceof DeploymentManager2) {
                    deployment = DeploymentContextAccessor.getDefault().createDeploymentContext(this.dtarget.getModule(), this.getApplication(), plan, this.dtarget.getModuleProvider().getRequiredLibraries(), null);
                    po = ((DeploymentManager2)dm).redeploy(tmids, deployment);
                } else {
                    po = dm.redeploy(tmids, this.getApplication(), plan);
                }
                this.trackDeployProgressObject(ui, po, false);
            }
        }
        if (!hasActivities) return this.dtarget.getTargetModules();
        return this.deployedRootTMIDs.toArray(new TargetModule[this.deployedRootTMIDs.size()]);
    }

    public void undeploy(ProgressUI ui, boolean startServer) throws IOException, ServerException {
        if (!this.instance.isRunning() && !startServer) {
            return;
        }
        this.init(ui, startServer, false);
        TargetModule[] modules = this.getDeploymentDirectoryModules();
        if (modules.length <= 0) {
            return;
        }
        ArrayList<TargetModuleID> toUndeploy = new ArrayList<TargetModuleID>();
        for (TargetModule module : modules) {
            toUndeploy.add(module.delegate());
            module.remove();
        }
        TargetModuleID[] tmIDs = toUndeploy.toArray(new TargetModuleID[toUndeploy.size()]);
        ui.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_Undeploying"));
        ProgressObject undeployPO = this.instance.getDeploymentManager().undeploy(tmIDs);
        try {
            ProgressObjectUtil.trackProgressObject(ui, undeployPO, this.instance.getDeploymentTimeout());
        }
        catch (TimeoutException e) {
            LOGGER.log(Level.INFO, "Undeploy timeouted");
        }
    }

    public void notifyIncrementalDeployment(TargetModuleID[] modules) {
        if (modules != null && this.incremental != null) {
            for (int i = 0; i < modules.length; ++i) {
                this.incremental.notifyDeployment(modules[i]);
            }
        }
    }

    public static boolean anyChanged(DeploymentChangeDescriptor acd) {
        return acd.manifestChanged() || acd.descriptorChanged() || acd.classesChanged() || acd.ejbsChanged() || acd.serverDescriptorChanged() || acd.serverResourcesChanged();
    }

    public boolean supportsDeployOnSave(TargetModule[] modules) throws IOException {
        J2eeModule deployable = null;
        ModuleConfigurationProvider deployment = this.dtarget.getModuleConfigurationProvider();
        if (deployment != null) {
            deployable = deployment.getJ2eeModule(null);
        }
        boolean hasDirectory = this.dtarget.getModule().getContentDirectory() != null;
        IncrementalDeployment lincremental = IncrementalDeployment.getIncrementalDeploymentForModule(this.incremental, deployable);
        return lincremental != null && hasDirectory && this.canFileDeploy(modules, deployable) && lincremental.isDeployOnSaveSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public DeployOnSaveManager.DeploymentState notifyArtifactsUpdated(J2eeModuleProvider provider, Iterable<ArtifactListener.Artifact> artifacts) {
        TargetModule[] modules;
        if (!this.instance.isRunning()) {
            return DeployOnSaveManager.DeploymentState.MODULE_NOT_DEPLOYED;
        }
        if (!DeployOnSaveManager.isServerStateSupported(this.instance)) {
            return DeployOnSaveManager.DeploymentState.SERVER_STATE_UNSUPPORTED;
        }
        try {
            this.init(null, false, false);
        }
        catch (ServerException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.dtarget.getTargetModules() == null) {
            return DeployOnSaveManager.DeploymentState.MODULE_NOT_DEPLOYED;
        }
        try {
            modules = this.getDeploymentDirectoryModules();
        }
        catch (IllegalStateException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return DeployOnSaveManager.DeploymentState.SERVER_STATE_UNSUPPORTED;
        }
        try {
            if (!this.supportsDeployOnSave(modules)) {
                return DeployOnSaveManager.DeploymentState.MODULE_NOT_DEPLOYED;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        TargetModule targetModule = this.dtarget.getTargetModules()[0];
        if (!targetModule.hasDelegate()) {
            return DeployOnSaveManager.DeploymentState.MODULE_NOT_DEPLOYED;
        }
        ProgressUI ui = new ProgressUI(NbBundle.getMessage(TargetServer.class, (String)(provider.isOnlyCompileOnSaveEnabled() ? "MSG_CompileOnSave" : "MSG_DeployOnSave"), (Object)provider.getDeploymentName()), false);
        ui.start(0);
        try {
            Object artifact2222;
            boolean serverResources = false;
            for (Object artifact2222 : artifacts) {
                if (!artifact2222.isServerResource()) continue;
                serverResources = true;
                break;
            }
            try {
                if (serverResources && !provider.isOnlyCompileOnSaveEnabled()) {
                    DeploymentHelper.deployServerLibraries(provider);
                    DeploymentHelper.deployDatasources(provider);
                    DeploymentHelper.deployMessageDestinations(provider);
                }
            }
            catch (DatasourceAlreadyExistsException ex) {
                LOGGER.log(Level.INFO, null, ex);
                artifact2222 = DeployOnSaveManager.DeploymentState.DEPLOYMENT_FAILED;
                ui.finish();
                return artifact2222;
            }
            catch (ConfigurationException ex) {
                LOGGER.log(Level.INFO, null, ex);
                artifact2222 = DeployOnSaveManager.DeploymentState.DEPLOYMENT_FAILED;
                ui.finish();
                return artifact2222;
            }
            DeploymentChangeDescriptor changes = this.distributeChangesOnSave(targetModule, artifacts);
            if (serverResources) {
                ChangeDescriptorAccessor.getDefault().withChangedServerResources(changes);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, changes.toString());
            }
            if (provider.isOnlyCompileOnSaveEnabled()) {
                artifact2222 = DeployOnSaveManager.DeploymentState.MODULE_NOT_DEPLOYED;
                return artifact2222;
            }
            boolean completed = this.reloadArtifacts(ui, modules, changes);
            if (!completed) {
                LOGGER.log(Level.INFO, "On save deployment failed");
                DeployOnSaveManager.DeploymentState deploymentState = DeployOnSaveManager.DeploymentState.DEPLOYMENT_FAILED;
                return deploymentState;
            }
            DeployOnSaveManager.DeploymentState deploymentState = DeployOnSaveManager.DeploymentState.MODULE_UPDATED;
            return deploymentState;
            {
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                    DeployOnSaveManager.DeploymentState deploymentState2 = DeployOnSaveManager.DeploymentState.DEPLOYMENT_FAILED;
                    return deploymentState2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ui.finish();
        }
    }

    private boolean reloadArtifacts(ProgressUI ui, TargetModule[] modules, DeploymentChangeDescriptor desc) {
        boolean completed = true;
        for (TargetModule module : modules) {
            ProgressObject obj = this.incremental.deployOnSave(module.delegate(), desc);
            try {
                completed = completed && this.trackDeployProgressObject(ui, obj, true);
            }
            catch (ServerException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                completed = false;
            }
        }
        this.notifyIncrementalDeployment(modules);
        return completed;
    }

    private TargetModule[] getDeploymentDirectoryModules() {
        TargetModule[] modules = this.dtarget.getTargetModules();
        if (modules == null) {
            return new TargetModule[0];
        }
        ServerInstance serverInstance = this.dtarget.getServer().getServerInstance();
        HashSet<String> targetNames = new HashSet<String>();
        for (int i = 0; i < this.targets.length; ++i) {
            targetNames.add(this.targets[i].getName());
        }
        HashSet<TargetModule> ret = new HashSet<TargetModule>();
        for (TargetModule module : modules) {
            TargetModuleID tmID;
            if (!module.getInstanceUrl().equals(serverInstance.getUrl()) || !targetNames.contains(module.getTargetName()) || (tmID = this.getAvailableTMIDsMap().get(module.getId())) == null) continue;
            module.initDelegate(tmID);
            ret.add(module);
        }
        return ret.toArray(new TargetModule[ret.size()]);
    }

    private boolean trackDeployProgressObject(ProgressUI ui, ProgressObject po, boolean incremental) throws ServerException {
        long deploymentTimeout = this.instance.getDeploymentTimeout();
        long startTime = System.currentTimeMillis();
        try {
            boolean completed = ProgressObjectUtil.trackProgressObject(ui, po, deploymentTimeout);
            if (completed) {
                TargetModuleID[] modules = po.getResultTargetModuleIDs();
                modules = this.saveRootTargetModules(modules);
                if (!incremental) {
                    ProgressObject startPO = this.instance.getDeploymentManager().start(modules);
                    long deployTime = System.currentTimeMillis() - startTime;
                    return ProgressObjectUtil.trackProgressObject(ui, startPO, deploymentTimeout - deployTime);
                }
            }
            return completed;
        }
        catch (TimeoutException e) {
            throw new ServerException(NbBundle.getMessage(TargetServer.class, (String)"MSG_DeploymentTimeoutExceeded"));
        }
    }

    public static class NoArchiveException
    extends IllegalArgumentException {
        public NoArchiveException(String s) {
            super(s);
        }
    }

    public static abstract class DeploymentContextAccessor {
        private static volatile DeploymentContextAccessor accessor;

        public static void setDefault(DeploymentContextAccessor accessor) {
            if (DeploymentContextAccessor.accessor != null) {
                throw new IllegalStateException("Already initialized accessor");
            }
            DeploymentContextAccessor.accessor = accessor;
        }

        public static DeploymentContextAccessor getDefault() {
            if (accessor != null) {
                return accessor;
            }
            Class<DeploymentContext> c = DeploymentContext.class;
            try {
                Class.forName(c.getName(), true, DeploymentContextAccessor.class.getClassLoader());
            }
            catch (ClassNotFoundException cnf) {
                Exceptions.printStackTrace((Throwable)cnf);
            }
            return accessor;
        }

        public abstract DeploymentContext createDeploymentContext(J2eeModule var1, File var2, File var3, File[] var4, AppChangeDescriptor var5);
    }
}

