/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TargetModuleConverter
extends DOMConvertor {
    private static final String PUBLIC_ID = "-//org_netbeans_modules_j2ee//DTD TargetModule 1.0//EN";
    private static final String SYSTEM_ID = "nbres:/org/netbeans/modules/j2ee/deployment/impl/target-module.dtd";
    private static final String E_TARGET_MODULE_LIST = "target-module-list";
    private static final String E_TARGET_MODULE = "target-module";
    private static final String A_ID = "id";
    private static final String A_INSTANCE_URL = "instance-url";
    private static final String A_TARGET_NAME = "target-name";
    private static final String A_TIMESTAMP = "timestamp";
    private static final String A_CONTENT_DIR = "content-dir";
    private static final String A_CONTEXT_ROOT = "context-root";
    private static final String CHARSET = "UTF-8";
    private static final Logger LOGGER = Logger.getLogger(TargetModuleConverter.class.getName());
    private static final Set<FileObject> FILE_OBJECTS_IN_USE = new HashSet<FileObject>();
    private static final String DIR_TARGETMODULES = "TargetModules";
    private static FileObject targetModulesDir = null;

    public static DOMConvertor create() {
        return new TargetModuleConverter();
    }

    protected TargetModuleConverter() {
        super(PUBLIC_ID, SYSTEM_ID, E_TARGET_MODULE_LIST);
    }

    protected Object readElement(Element element) throws IOException, ClassNotFoundException {
        NodeList targetModuleElements = element.getElementsByTagName(E_TARGET_MODULE);
        TargetModule[] targetModules = new TargetModule[targetModuleElements.getLength()];
        for (int i = 0; i < targetModules.length; ++i) {
            Element te = (Element)targetModuleElements.item(i);
            String id = te.getAttribute(A_ID);
            String url = te.getAttribute(A_INSTANCE_URL);
            String targetName = te.getAttribute(A_TARGET_NAME);
            String timestamp = te.getAttribute(A_TIMESTAMP);
            String contentDir = te.getAttribute(A_CONTENT_DIR);
            String contextRoot = te.getAttribute(A_CONTEXT_ROOT);
            if (id == null || url == null || targetName == null) {
                throw new IOException(NbBundle.getMessage(TargetModuleConverter.class, (String)"MSG_TargetModuleParseError"));
            }
            try {
                targetModules[i] = new TargetModule(id, url, targetName, Long.parseLong(timestamp), contentDir, contextRoot);
                continue;
            }
            catch (NumberFormatException nfe) {
                IOException exc = new IOException();
                exc.initCause(nfe);
                throw exc;
            }
        }
        return new TargetModule.List(targetModules);
    }

    protected void writeElement(Document doc, Element element, Object obj) throws IOException, DOMException {
        if (obj == null) {
            return;
        }
        if (!(obj instanceof TargetModule.List)) {
            throw new DOMException(9, NbBundle.getMessage(TargetModuleConverter.class, (String)"MSG_NotSupportedObject", obj.getClass()));
        }
        TargetModule.List tmList = (TargetModule.List)obj;
        TargetModule[] targetModules = tmList.getTargetModules();
        for (int i = 0; i < targetModules.length; ++i) {
            Element tmElement = doc.createElement(E_TARGET_MODULE);
            tmElement.setAttribute(A_ID, targetModules[i].getId());
            tmElement.setAttribute(A_INSTANCE_URL, targetModules[i].getInstanceUrl());
            tmElement.setAttribute(A_TARGET_NAME, targetModules[i].getTargetName());
            tmElement.setAttribute(A_TIMESTAMP, String.valueOf(targetModules[i].getTimestamp()));
            tmElement.setAttribute(A_CONTENT_DIR, targetModules[i].getContentDirectory());
            tmElement.setAttribute(A_CONTEXT_ROOT, targetModules[i].getContextRoot());
            element.appendChild(tmElement);
        }
    }

    public void registerSaver(Object inst, Saver s) {
    }

    public void unregisterSaver(Object inst, Saver s) {
    }

    private static FileObject getTargetModulesDir() throws IOException {
        FileObject j2eeDir;
        if (targetModulesDir == null && (targetModulesDir = (j2eeDir = FileUtil.getConfigFile((String)"J2EE")).getFileObject(DIR_TARGETMODULES)) == null) {
            targetModulesDir = j2eeDir.createFolder(DIR_TARGETMODULES);
        }
        return targetModulesDir;
    }

    public static boolean writeTargetModule(final TargetModule instance, String managerDir, String targetDir, String tmFileName) {
        try {
            FileObject targetDirFO;
            FileObject managerDirFO = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
            if (managerDirFO == null) {
                managerDirFO = TargetModuleConverter.getTargetModulesDir().createFolder(managerDir);
            }
            if ((targetDirFO = managerDirFO.getFileObject(targetDir)) == null) {
                targetDirFO = managerDirFO.createFolder(targetDir);
            }
            final FileObject fo = FileUtil.createData((FileObject)targetDirFO, (String)tmFileName);
            TargetModuleConverter.executeExclusively(fo, new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    FileLock lock = fo.lock();
                    try {
                        Void void_;
                        block8: {
                            OutputStreamWriter writer = new OutputStreamWriter(fo.getOutputStream(lock), TargetModuleConverter.CHARSET);
                            try {
                                TargetModuleConverter.create().write((Writer)writer, (Object)new TargetModule.List(instance));
                                void_ = null;
                                if (writer == null) break block8;
                            }
                            catch (Throwable throwable) {
                                if (writer != null) {
                                    ((Writer)writer).close();
                                }
                                throw throwable;
                            }
                            ((Writer)writer).close();
                        }
                        return void_;
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
            return true;
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, null, ex);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (Exception ioe) {
            LOGGER.log(Level.WARNING, null, ioe);
            return false;
        }
    }

    public static TargetModule readTargetModule(String managerDir, String targetDir, String tmFileName) {
        try {
            FileObject fo;
            FileObject dir = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
            if (dir != null && (dir = dir.getFileObject(targetDir)) != null && (fo = dir.getFileObject(tmFileName)) != null) {
                return TargetModuleConverter.executeExclusively(fo, new Callable<TargetModule>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public TargetModule call() throws Exception {
                        InputStreamReader reader = new InputStreamReader(fo.getInputStream(), TargetModuleConverter.CHARSET);
                        try {
                            TargetModule.List tml = (TargetModule.List)TargetModuleConverter.create().read((Reader)reader);
                            if (tml == null || tml.getTargetModules().length < 1) {
                                TargetModule targetModule = null;
                                return targetModule;
                            }
                            TargetModule targetModule = tml.getTargetModules()[0];
                            return targetModule;
                        }
                        finally {
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                        }
                    }
                });
            }
            return null;
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, null, ex);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Could not read {0}", tmFileName);
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
        catch (Exception ioe) {
            LOGGER.log(Level.WARNING, null, ioe);
            return null;
        }
    }

    public static List<TargetModule> getTargetModulesByContextRoot(String managerDir, String targetDir, final String contextRoot) {
        try {
            FileObject dir = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
            if (dir != null && (dir = dir.getFileObject(targetDir)) != null) {
                Enumeration fos = dir.getChildren(false);
                final ArrayList<TargetModule> result = new ArrayList<TargetModule>();
                while (fos.hasMoreElements()) {
                    final FileObject fo = (FileObject)fos.nextElement();
                    final AtomicInteger exceptions = new AtomicInteger();
                    TargetModuleConverter.executeExclusively(fo, new Callable<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void call() throws Exception {
                            try {
                                InputStreamReader reader = new InputStreamReader(fo.getInputStream(), TargetModuleConverter.CHARSET);
                                try {
                                    TargetModule tm;
                                    TargetModule.List tml = (TargetModule.List)TargetModuleConverter.create().read((Reader)reader);
                                    if (tml != null && tml.getTargetModules().length > 0 && contextRoot.equals((tm = tml.getTargetModules()[0]).getContextRoot())) {
                                        result.add(tm);
                                    }
                                }
                                finally {
                                    if (reader != null) {
                                        ((Reader)reader).close();
                                    }
                                }
                            }
                            catch (IOException ioe) {
                                if (exceptions.getAndIncrement() < 1) {
                                    LOGGER.log(Level.WARNING, fo.getName(), ioe);
                                }
                                LOGGER.log(Level.INFO, fo.getName(), ioe);
                            }
                            return null;
                        }
                    });
                }
                return result;
            }
            return Collections.emptyList();
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, null, ex);
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
        catch (Exception ioe) {
            LOGGER.log(Level.WARNING, null, ioe);
            return Collections.emptyList();
        }
    }

    public static TargetModule remove(String managerDir, String targetDir, String tmFileName) {
        try {
            FileObject fo;
            FileObject dir = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
            if (dir != null && (dir = dir.getFileObject(targetDir)) != null && (fo = dir.getFileObject(tmFileName)) != null) {
                TargetModuleConverter.executeExclusively(fo, new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        FileLock lock = fo.lock();
                        try {
                            fo.delete(lock);
                            Void void_ = null;
                            return void_;
                        }
                        finally {
                            if (lock != null) {
                                lock.releaseLock();
                            }
                        }
                    }
                });
            }
            return null;
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, null, ex);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception ioe) {
            LOGGER.log(Level.WARNING, null, ioe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T executeExclusively(FileObject fo, Callable<T> action) throws InterruptedException, Exception {
        Set<Object> set = FILE_OBJECTS_IN_USE;
        synchronized (set) {
            while (FILE_OBJECTS_IN_USE.contains(fo)) {
                FILE_OBJECTS_IN_USE.wait();
            }
            FILE_OBJECTS_IN_USE.add(fo);
        }
        try {
            set = action.call();
            return (T)set;
        }
        finally {
            Set<FileObject> set2 = FILE_OBJECTS_IN_USE;
            synchronized (set2) {
                FILE_OBJECTS_IN_USE.remove(fo);
                FILE_OBJECTS_IN_USE.notifyAll();
            }
        }
    }
}

