/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;

public class ProgressObjectUtil {
    private static final Logger LOGGER = Logger.getLogger(ProgressObjectUtil.class.getName());

    private ProgressObjectUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean trackProgressObject(ProgressUI ui, ProgressObject po, long timeout) throws TimeoutException {
        AtomicBoolean completed;
        block15: {
            assert (po != null);
            assert (ui != null);
            completed = new AtomicBoolean();
            ui.setProgressObject(po);
            try {
                final CountDownLatch progressFinished = new CountDownLatch(1);
                ProgressListener listener = new ProgressListener(){

                    public void handleProgressEvent(ProgressEvent progressEvent) {
                        DeploymentStatus status = progressEvent.getDeploymentStatus();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Received progress state {0} from {1}", new Object[]{status.getState(), progressEvent});
                        }
                        if (status.isCompleted()) {
                            completed.set(true);
                        }
                        if (status.isCompleted() || status.isFailed()) {
                            progressFinished.countDown();
                        }
                    }
                };
                LOGGER.log(Level.FINEST, "Adding progress listener {0}", listener);
                po.addProgressListener(listener);
                try {
                    DeploymentStatus status = po.getDeploymentStatus();
                    if (!status.isCompleted() && !status.isFailed()) {
                        try {
                            if (timeout == 0L) {
                                progressFinished.await();
                            } else {
                                boolean passed = progressFinished.await(timeout, TimeUnit.MILLISECONDS);
                                if (!passed) {
                                    throw new TimeoutException();
                                }
                            }
                            break block15;
                        }
                        catch (InterruptedException e) {
                            LOGGER.log(Level.INFO, null, e);
                        }
                        break block15;
                    }
                    if (status.isCompleted()) {
                        completed.set(true);
                    }
                }
                finally {
                    po.removeProgressListener(listener);
                }
            }
            finally {
                ui.setProgressObject(null);
            }
        }
        return completed.get();
    }
}

