/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.common.api.OriginalCMPMapping;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.execution.ModuleConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.impl.DeployOnSaveManager;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentDescriptorConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.EjbResourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.MappingConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.MessageDestinationConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfigurationFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfigurationFactory2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ServerLibraryConfiguration;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class ConfigSupportImpl
implements J2eeModuleProvider.ConfigSupport,
ModuleConfigurationProvider {
    private static final Logger LOGGER = Logger.getLogger(ConfigSupportImpl.class.getName());
    private static final File[] EMPTY_FILE_LIST = new File[0];
    private static final String GENERIC_NAME = "netbeans";
    private static final String GENERIC_EXTENSION = ".dpf";
    private String configurationPrimaryFileName = null;
    private Map relativePaths = null;
    private Map allRelativePaths = null;
    private final J2eeModuleProvider provider;
    private final J2eeModule j2eeModule;
    private Server server;
    private ServerInstance instance;
    private ModuleConfiguration moduleConfiguration;

    public ConfigSupportImpl(J2eeModuleProvider provider) {
        String serverID;
        this.provider = provider;
        this.j2eeModule = provider.getJ2eeModule();
        J2eeModuleAccessor.getDefault().setJ2eeModuleProvider(this.j2eeModule, provider);
        String serverInstanceId = provider.getServerInstanceID();
        if (serverInstanceId != null) {
            this.instance = ServerRegistry.getInstance().getServerInstance(serverInstanceId);
            if (this.instance != null) {
                this.server = this.instance.getServer();
            }
        }
        if (this.server == null && (serverID = provider.getServerID()) != null) {
            this.server = ServerRegistry.getInstance().getServer(serverID);
        }
    }

    public File getConfigurationFile() {
        try {
            return this.getDeploymentPlanFileForDistribution();
        }
        catch (Exception ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
            return null;
        }
    }

    public static File[] getDeploymentConfigurationFiles(J2eeModuleProvider provider, Server server) {
        return ConfigSupportImpl.getDeploymentConfigurationFiles(provider, server, false);
    }

    public static FileObject[] getConfigurationFiles(J2eeModuleProvider jmp) {
        Collection<Server> servers = ServerRegistry.getInstance().getServers();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (Server s : servers) {
            File[] configs = ConfigSupportImpl.getDeploymentConfigurationFiles(jmp, s, true);
            for (int j = 0; j < configs.length; ++j) {
                files.add(FileUtil.toFileObject((File)configs[j]));
            }
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public String getDeploymentName() {
        FileObject dir = this.getProjectDirectory();
        if (dir != null) {
            return dir.getNameExt();
        }
        return null;
    }

    public final FileObject getProjectDirectory() {
        try {
            String configFileName;
            File file;
            FileObject fo = this.getProvider().getJ2eeModule().getContentDirectory();
            if (fo == null && (file = this.j2eeModule.getDeploymentConfigurationFile(configFileName = this.getPrimaryConfigurationFileName())) != null) {
                fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            }
            if (fo == null) {
                return null;
            }
            Project owner = FileOwnerQuery.getOwner((FileObject)fo);
            if (owner != null) {
                return owner.getProjectDirectory();
            }
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.INFO, null, ioe);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.server != null) {
            ModuleConfiguration moduleConfig = null;
            ConfigSupportImpl configSupportImpl = this;
            synchronized (configSupportImpl) {
                moduleConfig = this.moduleConfiguration;
            }
            if (moduleConfig != null) {
                moduleConfig.dispose();
            }
        }
    }

    @Override
    public boolean createInitialConfiguration() {
        return this.getModuleConfiguration() != null;
    }

    @Override
    public boolean ensureConfigurationReady() {
        return this.getModuleConfiguration() != null;
    }

    @Override
    public String getWebContextRoot() {
        if (!this.getProvider().getJ2eeModule().getType().equals(J2eeModule.Type.WAR)) {
            Logger.getLogger("global").log(Level.INFO, "getWebContextRoot called on other module type then WAR");
            return null;
        }
        if (this.server == null) {
            return null;
        }
        ModuleConfiguration config = this.getModuleConfiguration();
        if (config == null) {
            return null;
        }
        try {
            ContextRootConfiguration contextRootConfiguration = (ContextRootConfiguration)config.getLookup().lookup(ContextRootConfiguration.class);
            if (contextRootConfiguration != null) {
                return contextRootConfiguration.getContextRoot();
            }
        }
        catch (ConfigurationException ce) {
            Logger.getLogger("global").log(Level.INFO, null, ce);
        }
        return null;
    }

    @Override
    public void setWebContextRoot(String contextRoot) {
        if (!this.getProvider().getJ2eeModule().getType().equals(J2eeModule.Type.WAR)) {
            Logger.getLogger("global").log(Level.INFO, "setWebContextRoot called on other module type then WAR");
            return;
        }
        if (this.server == null) {
            return;
        }
        ModuleConfiguration config = this.getModuleConfiguration();
        if (config == null) {
            return;
        }
        try {
            ContextRootConfiguration contextRootConfiguration = (ContextRootConfiguration)config.getLookup().lookup(ContextRootConfiguration.class);
            if (contextRootConfiguration != null) {
                contextRootConfiguration.setContextRoot(contextRoot);
            }
        }
        catch (ConfigurationException ce) {
            Logger.getLogger("global").log(Level.INFO, null, ce);
        }
    }

    @Override
    public String[] getDeploymentConfigurationFileNames() {
        if (this.server == null) {
            return new String[0];
        }
        if (this.hasCustomSupport()) {
            return this.getRelativePaths().keySet().toArray(new String[this.relativePaths.size()]);
        }
        return new String[]{this.getStandardDeploymentPlanName()};
    }

    @Override
    public String getContentRelativePath(String configName) {
        if (!this.hasCustomSupport()) {
            return configName;
        }
        return (String)this.getAllRelativePaths().get(configName);
    }

    @Override
    public void setCMPMappingInfo(OriginalCMPMapping[] mappings) throws ConfigurationException {
        if (this.server == null) {
            return;
        }
        ModuleConfiguration config = this.getModuleConfiguration();
        if (config == null) {
            return;
        }
        MappingConfiguration mappingConfiguration = (MappingConfiguration)config.getLookup().lookup(MappingConfiguration.class);
        if (mappingConfiguration != null) {
            mappingConfiguration.setMappingInfo(mappings);
        }
    }

    @Override
    public void setCMPResource(String ejbName, String jndiName) throws ConfigurationException {
        Parameters.notNull((CharSequence)"ejbName", (Object)ejbName);
        Parameters.notNull((CharSequence)"jndiName", (Object)jndiName);
        if (this.server == null) {
            return;
        }
        ModuleConfiguration config = this.getModuleConfiguration();
        if (config == null) {
            return;
        }
        MappingConfiguration mappingConfiguration = (MappingConfiguration)config.getLookup().lookup(MappingConfiguration.class);
        if (mappingConfiguration != null) {
            mappingConfiguration.setCMPResource(ejbName, jndiName);
        }
    }

    @Override
    public void configureLibrary(@NonNull ServerLibraryDependency library) throws ConfigurationException {
        ServerLibraryConfiguration libraryConfiguration = this.getServerLibraryConfiguration();
        if (libraryConfiguration != null) {
            libraryConfiguration.configureLibrary(library);
        }
    }

    @Override
    public Set<ServerLibraryDependency> getLibraries() throws ConfigurationException {
        Set<ServerLibraryDependency> libs = Collections.emptySet();
        ServerLibraryConfiguration libraryConfiguration = this.getServerLibraryConfiguration();
        if (libraryConfiguration != null) {
            libs = libraryConfiguration.getLibraries();
        }
        return libs;
    }

    @Override
    public void addLibraryChangeListener(ChangeListener listener) {
        ServerLibraryConfiguration libraryConfiguration = this.getServerLibraryConfiguration();
        if (libraryConfiguration != null) {
            libraryConfiguration.addLibraryChangeListener(listener);
        }
    }

    @Override
    public void removeLibraryChangeListener(ChangeListener listener) {
        ServerLibraryConfiguration libraryConfiguration = this.getServerLibraryConfiguration();
        if (libraryConfiguration != null) {
            libraryConfiguration.removeLibraryChangeListener(listener);
        }
    }

    public void addDeployOnSaveListener(DeployOnSaveListener listener) {
        DeployOnSaveManager.getDefault().addDeployOnSaveListener(this.provider, listener);
    }

    public void removeDeployOnSaveListener(DeployOnSaveListener listener) {
        DeployOnSaveManager.getDefault().removeDeployOnSaveListener(this.provider, listener);
    }

    @Override
    public boolean isDescriptorRequired() {
        DeploymentDescriptorConfiguration descriptorConfiguration = this.getDeploymentDescriptorConfiguration();
        if (descriptorConfiguration != null) {
            return descriptorConfiguration.isDescriptorRequired();
        }
        return false;
    }

    @Override
    public Set<Datasource> getDatasources() throws ConfigurationException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration config;
        Set<Datasource> projectDS = Collections.emptySet();
        if (this.server != null && (config = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)config.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            projectDS = datasourceConfiguration.getDatasources();
        }
        return projectDS;
    }

    @Override
    public boolean isDatasourceCreationSupported() {
        DatasourceConfiguration datasourceConfiguration;
        if (this.server == null) {
            return false;
        }
        ModuleConfiguration config = this.getModuleConfiguration();
        if (config != null && (datasourceConfiguration = (DatasourceConfiguration)config.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            return datasourceConfiguration.supportsCreateDatasource();
        }
        return false;
    }

    @Override
    public Datasource createDatasource(String jndiName, String url, String username, String password, String driver) throws UnsupportedOperationException, DatasourceAlreadyExistsException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration config;
        Datasource ds = null;
        if (this.server != null && (config = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)config.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            try {
                ds = datasourceConfiguration.createDatasource(jndiName, url, username, password, driver);
            }
            catch (ConfigurationException ce) {
                Logger.getLogger("global").log(Level.INFO, null, ce);
            }
        }
        return ds;
    }

    @Override
    public void bindDatasourceReference(String referenceName, String jndiName) throws ConfigurationException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration config;
        Parameters.notNull((CharSequence)"referenceName", (Object)referenceName);
        Parameters.notNull((CharSequence)"jndiName", (Object)jndiName);
        if (this.server != null && (config = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)config.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            datasourceConfiguration.bindDatasourceReference(referenceName, jndiName);
        }
    }

    @Override
    public void bindDatasourceReferenceForEjb(String ejbName, String ejbType, String referenceName, String jndiName) throws ConfigurationException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration config;
        Parameters.notNull((CharSequence)"ejbName", (Object)ejbName);
        Parameters.notNull((CharSequence)"ejbType", (Object)ejbType);
        Parameters.notNull((CharSequence)"referenceName", (Object)referenceName);
        Parameters.notNull((CharSequence)"jndiName", (Object)jndiName);
        if (!("Session".equals(ejbType) || "Entity".equals(ejbType) || "MessageDriven".equals(ejbType))) {
            throw new IllegalArgumentException("ejbType parameter doesn't have an allowed value.");
        }
        if (this.server != null && (config = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)config.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            datasourceConfiguration.bindDatasourceReferenceForEjb(ejbName, ejbType, referenceName, jndiName);
        }
    }

    @Override
    public String findDatasourceJndiName(String referenceName) throws ConfigurationException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration config;
        Parameters.notNull((CharSequence)"referenceName", (Object)referenceName);
        String jndiName = null;
        if (this.server != null && (config = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)config.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            jndiName = datasourceConfiguration.findDatasourceJndiName(referenceName);
        }
        return jndiName;
    }

    @Override
    public String findDatasourceJndiNameForEjb(String ejbName, String referenceName) throws ConfigurationException {
        DatasourceConfiguration datasourceConfiguration;
        ModuleConfiguration config;
        Parameters.notNull((CharSequence)"ejbName", (Object)ejbName);
        Parameters.notNull((CharSequence)"referenceName", (Object)referenceName);
        String jndiName = null;
        if (this.server != null && (config = this.getModuleConfiguration()) != null && (datasourceConfiguration = (DatasourceConfiguration)config.getLookup().lookup(DatasourceConfiguration.class)) != null) {
            jndiName = datasourceConfiguration.findDatasourceJndiNameForEjb(ejbName, referenceName);
        }
        return jndiName;
    }

    @Override
    public Datasource findDatasource(String jndiName) throws ConfigurationException {
        Parameters.notNull((CharSequence)"jndiName", (Object)jndiName);
        Set<Datasource> datasources = this.getDatasources();
        for (Datasource ds : datasources) {
            if (!jndiName.equals(ds.getJndiName())) continue;
            return ds;
        }
        datasources = this.provider.getServerDatasources();
        for (Datasource ds : datasources) {
            if (!jndiName.equals(ds.getJndiName())) continue;
            return ds;
        }
        return null;
    }

    @Override
    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        MessageDestinationConfiguration msgConfig;
        ModuleConfiguration config;
        Set<MessageDestination> destinations = Collections.emptySet();
        if (this.server != null && (config = this.getModuleConfiguration()) != null && (msgConfig = (MessageDestinationConfiguration)config.getLookup().lookup(MessageDestinationConfiguration.class)) != null) {
            destinations = msgConfig.getMessageDestinations();
        }
        return destinations;
    }

    @Override
    public Set<MessageDestination> getServerMessageDestinations() throws ConfigurationException {
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(this.provider.getServerInstanceID());
        if (si == null) {
            Logger.getLogger("global").log(Level.WARNING, "The server data sources cannot be retrieved because the server instance cannot be found.");
            return Collections.emptySet();
        }
        return si.getMessageDestinations();
    }

    @Override
    public boolean supportsCreateMessageDestination() {
        MessageDestinationConfiguration msgConfig;
        if (this.server == null) {
            return false;
        }
        ModuleConfiguration config = this.getModuleConfiguration();
        if (config != null && (msgConfig = (MessageDestinationConfiguration)config.getLookup().lookup(MessageDestinationConfiguration.class)) != null) {
            return msgConfig.supportsCreateMessageDestination();
        }
        return false;
    }

    @Override
    public MessageDestination createMessageDestination(String name, MessageDestination.Type type) throws UnsupportedOperationException, ConfigurationException {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        if (this.server == null) {
            return null;
        }
        ModuleConfiguration config = this.getModuleConfiguration();
        if (config == null) {
            return null;
        }
        MessageDestinationConfiguration msgConfig = (MessageDestinationConfiguration)config.getLookup().lookup(MessageDestinationConfiguration.class);
        if (msgConfig != null) {
            return msgConfig.createMessageDestination(name, type);
        }
        return null;
    }

    @Override
    public void bindMdbToMessageDestination(String mdbName, String name, MessageDestination.Type type) throws ConfigurationException {
        Parameters.notNull((CharSequence)"mdbName", (Object)mdbName);
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        ModuleConfiguration config = this.getModuleConfiguration();
        if (this.server == null || config == null) {
            return;
        }
        MessageDestinationConfiguration msgConfig = (MessageDestinationConfiguration)config.getLookup().lookup(MessageDestinationConfiguration.class);
        if (msgConfig != null) {
            msgConfig.bindMdbToMessageDestination(mdbName, name, type);
        }
    }

    @Override
    public String findMessageDestinationName(String mdbName) throws ConfigurationException {
        Parameters.notNull((CharSequence)"mdbName", (Object)mdbName);
        ModuleConfiguration config = this.getModuleConfiguration();
        if (this.server == null || config == null) {
            return null;
        }
        MessageDestinationConfiguration msgConfig = (MessageDestinationConfiguration)config.getLookup().lookup(MessageDestinationConfiguration.class);
        if (msgConfig != null) {
            return msgConfig.findMessageDestinationName(mdbName);
        }
        return null;
    }

    @Override
    public MessageDestination findMessageDestination(String name) throws ConfigurationException {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Set<MessageDestination> destinations = this.getMessageDestinations();
        for (MessageDestination dest : destinations) {
            if (!name.equals(dest.getName())) continue;
            return dest;
        }
        destinations = this.provider.getConfigSupport().getServerMessageDestinations();
        for (MessageDestination dest : destinations) {
            if (!name.equals(dest.getName())) continue;
            return dest;
        }
        return null;
    }

    @Override
    public void bindMessageDestinationReference(String referenceName, String connectionFactoryName, String destName, MessageDestination.Type type) throws ConfigurationException {
        Parameters.notNull((CharSequence)"referenceName", (Object)referenceName);
        Parameters.notNull((CharSequence)"connectionFactoryName", (Object)connectionFactoryName);
        Parameters.notNull((CharSequence)"destName", (Object)destName);
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        ModuleConfiguration config = this.getModuleConfiguration();
        if (this.server == null || config == null) {
            return;
        }
        MessageDestinationConfiguration msgConfig = (MessageDestinationConfiguration)config.getLookup().lookup(MessageDestinationConfiguration.class);
        if (msgConfig != null) {
            msgConfig.bindMessageDestinationReference(referenceName, connectionFactoryName, destName, type);
        }
    }

    @Override
    public void bindMessageDestinationReferenceForEjb(String ejbName, String ejbType, String referenceName, String connectionFactoryName, String destName, MessageDestination.Type type) throws ConfigurationException {
        Parameters.notNull((CharSequence)"ejbName", (Object)ejbName);
        Parameters.notNull((CharSequence)"ejbType", (Object)ejbType);
        Parameters.notNull((CharSequence)"referenceName", (Object)referenceName);
        Parameters.notNull((CharSequence)"connectionFactoryName", (Object)connectionFactoryName);
        Parameters.notNull((CharSequence)"destName", (Object)destName);
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        if (!("Session".equals(ejbType) || "Entity".equals(ejbType) || "MessageDriven".equals(ejbType))) {
            throw new IllegalArgumentException("ejbType parameter doesn't have an allowed value.");
        }
        ModuleConfiguration config = this.getModuleConfiguration();
        if (this.server == null || config == null) {
            return;
        }
        MessageDestinationConfiguration msgConfig = (MessageDestinationConfiguration)config.getLookup().lookup(MessageDestinationConfiguration.class);
        if (msgConfig != null) {
            msgConfig.bindMessageDestinationReferenceForEjb(ejbName, ejbType, referenceName, connectionFactoryName, destName, type);
        }
    }

    @Override
    public String findJndiNameForEjb(String ejbName) throws ConfigurationException {
        Parameters.notNull((CharSequence)"ejbName", (Object)ejbName);
        ModuleConfiguration config = this.getModuleConfiguration();
        if (this.server == null || config == null) {
            return null;
        }
        EjbResourceConfiguration ejbConfig = (EjbResourceConfiguration)config.getLookup().lookup(EjbResourceConfiguration.class);
        if (ejbConfig != null) {
            return ejbConfig.findJndiNameForEjb(ejbName);
        }
        return null;
    }

    @Override
    public void bindEjbReference(String referenceName, String jndiName) throws ConfigurationException {
        Parameters.notNull((CharSequence)"referenceName", (Object)referenceName);
        Parameters.notNull((CharSequence)"referencedEjbName", (Object)jndiName);
        ModuleConfiguration config = this.getModuleConfiguration();
        if (this.server == null || config == null) {
            return;
        }
        EjbResourceConfiguration ejbConfig = (EjbResourceConfiguration)config.getLookup().lookup(EjbResourceConfiguration.class);
        if (ejbConfig != null) {
            ejbConfig.bindEjbReference(referenceName, jndiName);
        }
    }

    @Override
    public void bindEjbReferenceForEjb(String ejbName, String ejbType, String referenceName, String jndiName) throws ConfigurationException {
        Parameters.notNull((CharSequence)"ejbName", (Object)ejbName);
        Parameters.notNull((CharSequence)"ejbType", (Object)ejbType);
        Parameters.notNull((CharSequence)"referenceName", (Object)referenceName);
        Parameters.notNull((CharSequence)"referencedEjbName", (Object)jndiName);
        if (!("Session".equals(ejbType) || "Entity".equals(ejbType) || "MessageDriven".equals(ejbType))) {
            throw new IllegalArgumentException("ejbType parameter doesn't have an allowed value.");
        }
        ModuleConfiguration config = this.getModuleConfiguration();
        if (this.server == null || config == null) {
            return;
        }
        EjbResourceConfiguration ejbConfig = (EjbResourceConfiguration)config.getLookup().lookup(EjbResourceConfiguration.class);
        if (ejbConfig != null) {
            ejbConfig.bindEjbReferenceForEjb(ejbName, ejbType, referenceName, jndiName);
        }
    }

    @Override
    public ModuleConfiguration getModuleConfiguration() {
        return (ModuleConfiguration)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ModuleConfiguration>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ModuleConfiguration run() {
                ConfigSupportImpl configSupportImpl = ConfigSupportImpl.this;
                synchronized (configSupportImpl) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Thread {0} acquired lock on object {1}", new Object[]{Thread.currentThread().getName(), ConfigSupportImpl.this});
                        LOGGER.log(Level.FINE, "Stacktrace", new Exception());
                    }
                    if (ConfigSupportImpl.this.moduleConfiguration == null) {
                        try {
                            if (ConfigSupportImpl.this.server == null) {
                                return null;
                            }
                            ModuleConfigurationFactory moduleConfigurationFactory = ConfigSupportImpl.this.server.getModuleConfigurationFactory();
                            if (moduleConfigurationFactory instanceof ModuleConfigurationFactory2 && ConfigSupportImpl.this.instance != null) {
                                ConfigSupportImpl.this.moduleConfiguration = ((ModuleConfigurationFactory2)moduleConfigurationFactory).create(ConfigSupportImpl.this.j2eeModule, ConfigSupportImpl.this.instance.getUrl());
                            } else {
                                ConfigSupportImpl.this.moduleConfiguration = moduleConfigurationFactory.create(ConfigSupportImpl.this.j2eeModule);
                            }
                        }
                        catch (ConfigurationException ce) {
                            LOGGER.log(Level.INFO, null, ce);
                            return null;
                        }
                    }
                    return ConfigSupportImpl.this.moduleConfiguration;
                }
            }
        });
    }

    @Override
    public J2eeModule getJ2eeModule(String moduleUri) {
        if (this.j2eeModule instanceof J2eeApplication) {
            if (moduleUri == null) {
                return this.j2eeModule;
            }
            for (J2eeModule childModule : ((J2eeApplication)this.j2eeModule).getModules()) {
                if (!moduleUri.equals(childModule.getUrl())) continue;
                return childModule;
            }
        }
        return this.j2eeModule;
    }

    @CheckForNull
    private ServerLibraryConfiguration getServerLibraryConfiguration() {
        ModuleConfiguration config;
        if (this.server != null && (config = this.getModuleConfiguration()) != null) {
            return (ServerLibraryConfiguration)config.getLookup().lookup(ServerLibraryConfiguration.class);
        }
        return null;
    }

    @CheckForNull
    private DeploymentDescriptorConfiguration getDeploymentDescriptorConfiguration() {
        ModuleConfiguration config;
        if (this.server != null && (config = this.getModuleConfiguration()) != null) {
            return (DeploymentDescriptorConfiguration)config.getLookup().lookup(DeploymentDescriptorConfiguration.class);
        }
        return null;
    }

    private static File[] getDeploymentConfigurationFiles(J2eeModuleProvider provider, Server server, boolean existingOnly) {
        String[] fnames;
        if (provider == null || server == null) {
            return new File[0];
        }
        J2eeModule.Type type = provider.getJ2eeModule().getType();
        if (ConfigSupportImpl.hasCustomSupport(server, type)) {
            fnames = server.getDeploymentPlanFiles(type);
        } else if (server.supportsModuleType(type)) {
            fnames = new String[]{ConfigSupportImpl.getStandardDeploymentPlanName(server)};
        } else {
            return EMPTY_FILE_LIST;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < fnames.length; ++i) {
            File path = new File(fnames[i]);
            String fname = path.getName();
            File file = provider.getJ2eeModule().getDeploymentConfigurationFile(fname);
            if (file == null || existingOnly && !file.exists()) continue;
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getDeploymentPlanFileForDistribution() throws IOException, ConfigurationException {
        if (this.server == null) {
            String msg = NbBundle.getMessage(ConfigSupportImpl.class, (String)"MSG_NoTargetSelected");
            throw new ConfigurationException(msg);
        }
        ModuleConfiguration conf = this.getModuleConfiguration();
        if (conf == null) {
            return null;
        }
        DeploymentPlanConfiguration deploymentPlanConfiguration = (DeploymentPlanConfiguration)conf.getLookup().lookup(DeploymentPlanConfiguration.class);
        if (deploymentPlanConfiguration == null) {
            return null;
        }
        FileLock lock = null;
        OutputStream out = null;
        try {
            FileObject dist = this.getProvider().getJ2eeModule().getContentDirectory();
            String planName = this.getStandardDeploymentPlanName();
            FileObject plan = null;
            if (dist != null) {
                plan = dist.getFileObject(planName);
                if (plan == null) {
                    plan = dist.createData(planName);
                }
            } else {
                File file = null;
                return file;
            }
            lock = plan.lock();
            out = plan.getOutputStream(lock);
            deploymentPlanConfiguration.save(out);
            File file = FileUtil.toFile((FileObject)plan);
            return file;
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                Logger.getLogger("global").log(Level.INFO, ioe.toString());
            }
        }
    }

    private String getPrimaryConfigurationFileName() {
        this.getRelativePaths();
        if (this.configurationPrimaryFileName == null) {
            return this.getStandardDeploymentPlanName();
        }
        return this.configurationPrimaryFileName;
    }

    private String getStandardDeploymentPlanName() {
        return ConfigSupportImpl.getStandardDeploymentPlanName(this.server);
    }

    private static String getStandardDeploymentPlanName(Server server) {
        return (server != null ? server.getShortName() : GENERIC_NAME) + GENERIC_EXTENSION;
    }

    private J2eeModule.Type getModuleType() {
        return this.getProvider().getJ2eeModule().getType();
    }

    private boolean hasCustomSupport() {
        return ConfigSupportImpl.hasCustomSupport(this.server, this.getModuleType());
    }

    private static boolean hasCustomSupport(Server server, J2eeModule.Type type) {
        if (server == null || server.getModuleConfigurationFactory() == null) {
            return false;
        }
        return server.getDeploymentPlanFiles(type) != null;
    }

    private J2eeModuleProvider getProvider() {
        return this.provider;
    }

    private Map getRelativePaths() {
        if (this.relativePaths != null) {
            return this.relativePaths;
        }
        this.relativePaths = new HashMap();
        if (this.hasCustomSupport()) {
            String[] paths = this.server.getDeploymentPlanFiles(this.getModuleType());
            this.configurationPrimaryFileName = paths[0].substring(paths[0].lastIndexOf("/") + 1);
            this.collectData(this.server, this.relativePaths);
        }
        return this.relativePaths;
    }

    private void collectData(Server server, Map map) {
        if (!ConfigSupportImpl.hasCustomSupport(server, this.getModuleType())) {
            return;
        }
        String[] paths = server.getDeploymentPlanFiles(this.getModuleType());
        paths = paths == null ? new String[]{} : paths;
        for (int i = 0; i < paths.length; ++i) {
            String name = paths[i].substring(paths[i].lastIndexOf("/") + 1);
            map.put(name, paths[i]);
        }
    }

    private Map getAllRelativePaths() {
        if (this.allRelativePaths != null) {
            return this.allRelativePaths;
        }
        this.allRelativePaths = new HashMap();
        Collection<Server> servers = ServerRegistry.getInstance().getServers();
        for (Server server : servers) {
            this.collectData(server, this.allRelativePaths);
        }
        return this.allRelativePaths;
    }

    public static interface DeployOnSaveListener {
        public void deployed(Iterable<ArtifactListener.Artifact> var1);
    }
}

