/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.mobility.antext.preprocessor.PPToken;
import org.netbeans.mobility.antext.preprocessor.PreprocessorException;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.mobility.editor.ConfigurationHighlightsLayerFactory;
import org.netbeans.modules.mobility.editor.hints.DisableHint;
import org.netbeans.modules.mobility.editor.hints.InlineIncludeHint;
import org.netbeans.modules.mobility.editor.hints.ReplaceOldSyntaxHint;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.bridge.J2MEProjectUtilitiesProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DocumentPreprocessor
implements PropertyChangeListener {
    public static final String PREPROCESSOR_LINE_LIST = "preprocessor.line.list";
    public static final String PREPROCESSOR_BLOCK_LIST = "preprocessor.block.list";
    static final long serialVersionUID = 4863325941230276217L;
    static final Pattern BLOCK_HEADER_PATTERN = Pattern.compile("^\\s*/((/#)|(\\*[\\$#]))\\S");
    DocumentListener dl;
    private static final RequestProcessor RP = new RequestProcessor(DocumentPreprocessor.class);
    final RequestProcessor.Task timerTask = RP.create(new Runnable(){

        @Override
        public void run() {
            JTextComponent component = EditorRegistry.focusedComponent();
            if (component != null) {
                DocumentPreprocessor.updateBlockChain((NbEditorDocument)component.getDocument());
            }
        }
    });

    public DocumentPreprocessor() {
        this.dl = new DL();
        JTextComponent component = EditorRegistry.focusedComponent();
        if (component != null) {
            DocumentPreprocessor.updateBlockChain((NbEditorDocument)component.getDocument());
            final NbEditorDocument doc = (NbEditorDocument)component.getDocument();
            doc.addDocumentListener(this.dl);
            doc.getDocumentProperties().put("TEXT_SWITCH_SUPPORT", new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DocumentPreprocessor.updateBlockChain(doc);
                }
            });
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JTextComponent current;
        JTextComponent last = EditorRegistry.lastFocusedComponent();
        if (last != null) {
            NbEditorDocument doc = (NbEditorDocument)last.getDocument();
            doc.getDocumentProperties().remove("TEXT_SWITCH_SUPPORT");
            doc.removeDocumentListener(this.dl);
        }
        if ((current = EditorRegistry.focusedComponent()) != null) {
            NbEditorDocument doc = (NbEditorDocument)current.getDocument();
            doc.addDocumentListener(this.dl);
            doc.getDocumentProperties().put("TEXT_SWITCH_SUPPORT", new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DocumentPreprocessor.this.restartTimer();
                }
            });
            this.restartTimer();
        }
    }

    static final void setLineInfo(NbEditorDocument doc, List<PPLine> lineList, List<PPBlockInfo> blockList) {
        ConfigurationHighlightsLayerFactory.Highlighting blockLayer;
        doc.putProperty((Object)PREPROCESSOR_LINE_LIST, lineList);
        doc.putProperty((Object)PREPROCESSOR_BLOCK_LIST, blockList);
        ConfigurationHighlightsLayerFactory.Highlighting headerLayer = (ConfigurationHighlightsLayerFactory.Highlighting)doc.getProperty((Object)ConfigurationHighlightsLayerFactory.PROP_HIGLIGHT_HEADER_LAYER);
        if (headerLayer != null) {
            headerLayer.updateBags();
        }
        if ((blockLayer = (ConfigurationHighlightsLayerFactory.Highlighting)doc.getProperty((Object)ConfigurationHighlightsLayerFactory.PROP_HIGLIGHT_BLOCKS_LAYER)) != null) {
            blockLayer.updateBags();
        }
        DocumentPreprocessor.processAnnotations(doc, lineList);
    }

    void restartTimer() {
        this.timerTask.schedule(200);
    }

    public static final void updateBlockChain(NbEditorDocument doc) {
        if (doc == null) {
            return;
        }
        Project p = J2MEProjectUtils.getProjectForDocument((Document)doc);
        if (p != null && p instanceof J2MEProject) {
            ProjectConfigurationsHelper configHelper = (ProjectConfigurationsHelper)p.getLookup().lookup(ProjectConfigurationsHelper.class);
            if (configHelper == null || !configHelper.isPreprocessorOn()) {
                return;
            }
            HashMap<String, Object> activeIdentifiers = new HashMap<String, Object>(configHelper.getActiveAbilities());
            activeIdentifiers.put(configHelper.getActiveConfiguration().getDisplayName(), null);
            try {
                J2MEProjectUtilitiesProvider utilProvider = (J2MEProjectUtilitiesProvider)Lookup.getDefault().lookup(J2MEProjectUtilitiesProvider.class);
                if (utilProvider == null) {
                    return;
                }
                CommentingPreProcessor cpp = new CommentingPreProcessor(utilProvider.createPPDocumentSource((StyledDocument)doc), null, activeIdentifiers);
                cpp.run();
                DocumentPreprocessor.setLineInfo(doc, cpp.getLines(), cpp.getBlockList());
            }
            catch (PreprocessorException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    static String prefixPropertyName(String configuration, String propertyName) {
        return "configs." + configuration + '.' + propertyName;
    }

    static void processAnnotations(NbEditorDocument doc, List<PPLine> lineList) {
        ArrayList<ErrorDescription> errs = new ArrayList<ErrorDescription>();
        DataObject dob = NbEditorUtilities.getDataObject((Document)doc);
        FileObject fo = dob == null ? null : dob.getPrimaryFile();
        for (PPLine line : lineList) {
            for (PPLine.Error err : line.getErrors()) {
                PPToken tok = err.token;
                int shift = tok.getType() == 257 || tok.getType() == 258 || tok.getType() == 300 ? Math.max(1, tok.getPadding().length()) : 0;
                int loff = NbDocument.findLineOffset((StyledDocument)doc, (int)(line.getLineNumber() - 1));
                errs.add(ErrorDescriptionFactory.createErrorDescription((Severity)(err.warning ? Severity.WARNING : Severity.ERROR), (String)err.message, (FileObject)fo, (int)(loff + tok.getColumn() - shift), (int)(loff + tok.getColumn() + tok.getText().length())));
            }
            ArrayList<Object> fixes = new ArrayList<Object>();
            int start = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(line.getLineNumber() - 1));
            if (line.getTokens().size() > 1 && "//#include".equals(((PPToken)line.getTokens().get(0)).getText())) {
                fixes.add(new InlineIncludeHint((BaseDocument)doc, start, ((PPToken)line.getTokens().get(1)).getText()));
            } else if (line.getType() == 13 || line.getType() == 14) {
                PPBlockInfo b;
                for (b = line.getBlock(); b != null && b.getType() != 13; b = b.getParent()) {
                }
                if (b != null) {
                    fixes.add(new ReplaceOldSyntaxHint((Document)doc, lineList, b));
                }
            }
            if (line.getType() == -1) {
                fixes.add(new DisableHint((BaseDocument)doc, start));
            }
            if (fixes.size() <= 0) continue;
            errs.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)NbBundle.getMessage(DocumentPreprocessor.class, (String)"LBL_PreprocessorHint"), fixes, (Document)doc, (int)line.getLineNumber()));
        }
        HintsController.setErrors((Document)doc, (String)"preprocessor-errors", errs);
    }

    class DL
    implements DocumentListener {
        DL() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            DocumentPreprocessor.this.restartTimer();
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            DocumentPreprocessor.this.restartTimer();
        }
    }
}

