/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.versioning.util.VerticallyNonResizingPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HgQueueHookPanel
extends VerticallyNonResizingPanel
implements ItemListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.vcshooks.HookPanel");
    private QuickSearchComboBar qs;
    private boolean blockEvents;
    private Issue preselectedIssue;
    private FieldValues fieldValues = null;
    private ButtonGroup buttonGroup1;
    final LinkButton changeFormatButton = new LinkButton();
    final JRadioButton commitRadioButton = new JRadioButton();
    private JLabel issueLabel;
    private JPanel issuePanel;
    private JButton jButton2;
    private JLabel jLabel2;
    final JCheckBox linkCheckBox = new JCheckBox();
    final JRadioButton pushRadioButton = new JRadioButton();
    final JComboBox repositoryComboBox = new JComboBox();
    private JLabel repositoryLabel;
    final JCheckBox resolveCheckBox = new JCheckBox();

    public HgQueueHookPanel(boolean link, boolean resolve, boolean commit) {
        this.initComponents();
        this.fieldValues = new FieldValues();
        this.qs = new QuickSearchComboBar((JPanel)((Object)this));
        this.issuePanel.add((Component)this.qs, "North");
        this.issueLabel.setLabelFor(this.qs.getIssueComponent());
        this.linkCheckBox.setSelected(link);
        this.resolveCheckBox.setSelected(resolve);
        this.commitRadioButton.setSelected(commit);
        this.pushRadioButton.setSelected(!commit);
        this.enableFields();
        this.repositoryComboBox.addItemListener(this);
    }

    Issue getIssue() {
        return this.qs.getIssue();
    }

    void enableFields() {
        boolean enableFields;
        boolean repoSelected = !this.blockEvents && this.repositoryComboBox.getSelectedItem() instanceof Repository;
        boolean bl = enableFields = repoSelected && this.getIssue() != null;
        if (!enableFields && !this.fieldValues.stored) {
            this.fieldValues.store();
        } else if (enableFields && this.fieldValues.stored) {
            this.fieldValues.restore();
        }
        this.linkCheckBox.setEnabled(enableFields);
        this.resolveCheckBox.setEnabled(enableFields);
        this.pushRadioButton.setEnabled(enableFields);
        this.commitRadioButton.setEnabled(enableFields);
        this.changeFormatButton.setEnabled(enableFields);
        this.issueLabel.setEnabled(repoSelected);
        this.qs.enableFields(repoSelected);
    }

    void enableIssueField(boolean enabled) {
        this.blockEvents = !enabled;
        this.jButton2.setEnabled(enabled);
        this.repositoryComboBox.setEnabled(enabled);
        if (enabled) {
            this.enableFields();
        }
    }

    void setIssue(Issue issue) {
        this.preselectedIssue = issue;
        this.qs.setRepository(issue.getRepository());
        this.preselectIssue();
    }

    private void preselectIssue() {
        if (this.qs.getIssueComponent() instanceof JComboBox) {
            ((JComboBox)this.qs.getIssueComponent()).getEditor().setItem(this.preselectedIssue);
        }
        this.enableFields();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.issuePanel = new JPanel();
        this.repositoryLabel = new JLabel();
        this.jButton2 = this.createDoubleWidthButton();
        this.issueLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.setFocusable(false);
        this.issuePanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.resolveCheckBox, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.resolveCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.linkCheckBox, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.linkCheckBox.text"));
        this.repositoryLabel.setLabelFor(this.repositoryComboBox);
        Mnemonics.setLocalizedText((JLabel)this.repositoryLabel, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.repositoryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HgQueueHookPanel.this.jButton2ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.issueLabel, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.issueLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.changeFormatButton, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.changeFormatButton.text"));
        this.buttonGroup1.add(this.commitRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.commitRadioButton, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.commitRadioButton.text"));
        this.buttonGroup1.add(this.pushRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.pushRadioButton, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.pushRadioButton.text"));
        this.jLabel2.setForeground(UIManager.getDefaults().getColor("Button.disabledText"));
        this.jLabel2.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.jLabel2.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repositoryLabel).addComponent(this.issueLabel)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resolveCheckBox).addComponent(this.linkCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.changeFormatButton, -2, -1, -2).addGap(65, 65, 65).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commitRadioButton).addComponent(this.pushRadioButton))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, 502, Short.MAX_VALUE).addComponent(this.issuePanel, -1, 502, Short.MAX_VALUE).addComponent(this.repositoryComboBox, GroupLayout.Alignment.LEADING, 0, 502, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repositoryLabel).addComponent(this.jButton2).addComponent(this.repositoryComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.issuePanel, -1, 16, Short.MAX_VALUE).addComponent(this.issueLabel, -1, 16, Short.MAX_VALUE)).addGap(9, 9, 9).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.resolveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.linkCheckBox).addComponent((Component)this.changeFormatButton, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.commitRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pushRadioButton))).addContainerGap()));
        this.resolveCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.resolveCheckBox.AccessibleContext.accessibleDescription"));
        this.linkCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.addRevisionCheckBox.AccessibleContext.accessibleDescription"));
        this.repositoryComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.repositoryComboBox.AccessibleContext.accessibleDescription"));
        this.jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.jButton2.AccessibleContext.accessibleDescription"));
        this.changeFormatButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.changeRevisionFormatButton.AccessibleContext.accessibleDescription"));
        this.commitRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.commitRadioButton.AccessibleContext.accessibleDescription"));
        this.pushRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.pushRadioButton.AccessibleContext.accessibleDescription"));
    }

    private JButton createDoubleWidthButton() {
        class DoubleWidthButton
        extends JButton {
            DoubleWidthButton() {
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension defPrefSize = super.getPreferredSize();
                return new Dimension((int)(1.8f * (float)defPrefSize.width), defPrefSize.height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        }
        return new DoubleWidthButton();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        Repository repo = RepositoryManager.getInstance().createRepository();
        if (repo == null) {
            return;
        }
        this.repositoryComboBox.addItem(repo);
        this.repositoryComboBox.setSelectedItem(repo);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "itemStateChanged() - selected item: {0}", e.getItem());
        }
        this.enableFields();
        if (e.getStateChange() == 1) {
            Repository repo;
            Object item = e.getItem();
            Repository repository = repo = item instanceof Repository ? (Repository)item : null;
            if (!this.blockEvents && repo != null) {
                this.qs.setRepository(repo);
                if (this.preselectedIssue != null && repo.equals(this.preselectedIssue.getRepository())) {
                    this.preselectIssue();
                }
            }
        }
    }

    public void addNotify() {
        this.qs.addPropertyChangeListener((PropertyChangeListener)this);
        super.addNotify();
    }

    public void removeNotify() {
        this.qs.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("QuickSearchComboBar.issue.changed")) {
            this.enableFields();
        }
    }

    private class FieldValues {
        private boolean addLinkInfo = false;
        private boolean resolve = false;
        private boolean commit = false;
        private boolean stored = false;

        private FieldValues() {
        }

        void store() {
            this.addLinkInfo = HgQueueHookPanel.this.linkCheckBox.isSelected();
            this.resolve = HgQueueHookPanel.this.resolveCheckBox.isSelected();
            this.commit = HgQueueHookPanel.this.commitRadioButton.isSelected();
            HgQueueHookPanel.this.linkCheckBox.setSelected(false);
            HgQueueHookPanel.this.resolveCheckBox.setSelected(false);
            HgQueueHookPanel.this.commitRadioButton.setSelected(false);
            this.stored = true;
        }

        void restore() {
            HgQueueHookPanel.this.linkCheckBox.setSelected(this.addLinkInfo);
            HgQueueHookPanel.this.resolveCheckBox.setSelected(this.resolve);
            HgQueueHookPanel.this.commitRadioButton.setSelected(this.commit);
            this.stored = false;
        }
    }
}

