/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.richfaces;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.web.jsf.richfaces.Bundle;
import org.netbeans.modules.web.jsf.richfaces.Richfaces4Implementation;
import org.netbeans.modules.web.jsf.richfaces.ui.Richfaces4CustomizerPanelVisual;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public class Richfaces4Customizer
implements JsfComponentCustomizer {
    private static final RequestProcessor RP = new RequestProcessor(Richfaces4Customizer.class);
    private Richfaces4CustomizerPanelVisual panel;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Future<Boolean> result = null;
    private boolean fixedLibrary = false;
    public static final Logger LOGGER = Logger.getLogger(Richfaces4Customizer.class.getName());

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new Richfaces4CustomizerPanelVisual(this);
            this.panel.initLibraries(true);
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Preferences preferences = Richfaces4Implementation.getRichfacesPreferences();
        String richfacesLibrary = preferences.get("base-library", "");
        if (LibraryManager.getDefault().getLibrary(richfacesLibrary) != null) {
            return true;
        }
        Richfaces4Customizer richfaces4Customizer = this;
        synchronized (richfaces4Customizer) {
            if (this.result == null) {
                this.result = RP.submit((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (Library library : LibraryManager.getDefault().getLibraries()) {
                            List content;
                            if (!"j2se".equals(library.getType()) || !Richfaces4Customizer.isValidRichfacesLibrary(content = library.getContent("classpath"))) continue;
                            this.refreshParentValidation();
                            return true;
                        }
                        this.refreshParentValidation();
                        return false;
                    }

                    private void refreshParentValidation() {
                        Mutex.EVENT.readAccess(new Runnable(){

                            @Override
                            public void run() {
                                Richfaces4Customizer.this.fireChange();
                            }
                        });
                    }
                });
            } else {
                if (!this.result.isDone()) {
                    return false;
                }
                try {
                    return this.result.get() != false || this.fixedLibrary;
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return false;
    }

    public String getWarningMessage() {
        return this.panel.getWarningMessage();
    }

    public String getErrorMessage() {
        if (this.result == null && !this.isValid() || this.result != null && !this.result.isDone()) {
            return Bundle.Richfaces4Customizer_err_searching_richfaces_library();
        }
        return this.panel.getErrorMessage();
    }

    public void saveConfiguration() {
        Preferences preferences = Richfaces4Implementation.getRichfacesPreferences();
        preferences.put("base-library", this.panel.getRichFacesLibrary());
    }

    public void setFixedLibrary(boolean fixed) {
        this.fixedLibrary = fixed;
    }

    public void fireChange() {
        this.changeSupport.fireChange();
    }

    public static List<Library> getRichfacesLibraries() {
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List content;
            if (!"j2se".equals(library.getType()) || !Richfaces4Customizer.isValidRichfacesLibrary(content = library.getContent("classpath"))) continue;
            libraries.add(library);
        }
        return libraries;
    }

    public static boolean isValidRichfacesLibrary(List<URL> libraryContent) {
        for (String libraryName : Richfaces4Implementation.RF_LIBRARIES) {
            try {
                if (Util.containsClass(libraryContent, (String)libraryName)) continue;
                return false;
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return false;
            }
        }
        return true;
    }

    public HelpCtx getHelpCtx() {
        return this.panel.getHelpCtx();
    }
}

