/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.antproject.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class AbstractGroovyActionProvider
implements ActionProvider {
    public static final String BUILD_SCRIPT = "buildfile";
    public static final String PROP_CONFIG = "config";
    private final Map<String, String> supportedActions;
    private final Project project;

    public AbstractGroovyActionProvider(Project project) {
        this.project = project;
        this.supportedActions = new HashMap<String, String>();
        this.supportedActions.put("compile.single", "compile-single");
        this.supportedActions.put("test.single", "test-single");
        this.supportedActions.put("debug.test.single", "debug-test");
        this.supportedActions.put("test", "test");
        this.addProjectSpecificActions(this.supportedActions);
    }

    protected abstract void addProjectSpecificActions(Map<String, String> var1);

    public String[] getSupportedActions() {
        FileObject destDirFO = this.project.getProjectDirectory().getFileObject("nbproject");
        if (destDirFO != null) {
            FileObject groovyBuild = destDirFO.getFileObject("groovy-build.xml");
            if (groovyBuild == null) {
                this.supportedActions.remove("test");
            } else if (!this.supportedActions.containsKey("test")) {
                this.supportedActions.put("test", "test");
            }
        } else {
            this.supportedActions.remove("test");
        }
        return this.supportedActions.keySet().toArray(new String[0]);
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if (this.supportedActions.keySet().contains(command)) {
            if ("test".equals(command)) {
                return true;
            }
            FileObject[] testSources = this.findTestSources(context);
            FileObject[] sources = this.findSources(context);
            if (testSources != null) {
                return true;
            }
            if (sources != null && sources.length == 1) {
                return !"test.single".equals(command) && !"debug.test.single".equals(command);
            }
        }
        return false;
    }

    public void invokeAction(final String command, final Lookup context) {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                Properties p = new Properties();
                String[] targetNames = AbstractGroovyActionProvider.this.getTargetNames(command, context, p);
                if (targetNames.length == 0) {
                    targetNames = null;
                }
                if (p.keySet().isEmpty()) {
                    p = null;
                }
                try {
                    FileObject buildFo = AbstractGroovyActionProvider.this.findBuildXml();
                    if (buildFo == null || !buildFo.isValid()) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AbstractGroovyActionProvider.class, (String)"LBL_No_Build_XML_Found"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    } else {
                        ActionUtils.runTarget((FileObject)buildFo, (String[])targetNames, (Properties)p);
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        };
        if (this.supportedActions.containsKey(command)) {
            ScanDialog.runWhenScanFinished((Runnable)action, (String)NbBundle.getMessage(AbstractGroovyActionProvider.class, (String)("ACTION_" + command)));
        } else {
            action.run();
        }
    }

    private String[] getTargetNames(String command, Lookup context, Properties p) {
        if (this.supportedActions.keySet().contains(command)) {
            if (command.equals("test")) {
                return this.setupTestAll(p);
            }
            FileObject[] testSources = this.findTestSources(context);
            if (testSources != null) {
                if (command.equals("run.single") || command.equals("test.single")) {
                    return this.setupTestSingle(p, testSources);
                }
                if (command.equals("debug.single") || command.equals("debug.test.single")) {
                    return this.setupDebugTestSingle(p, testSources);
                }
                if (command.equals("compile.single")) {
                    return this.setupCompileSingle(p, testSources);
                }
            } else {
                FileObject file = this.findSources(context)[0];
                Sources sources = ProjectUtils.getSources((Project)this.project);
                SourceGroup[] sourceGroups = sources.getSourceGroups("java");
                String clazz = FileUtil.getRelativePath((FileObject)this.getRoot(sourceGroups, file), (FileObject)file);
                p.setProperty("javac.includes", clazz);
                if (clazz.endsWith(".groovy")) {
                    clazz = clazz.substring(0, clazz.length() - 7);
                }
                clazz = clazz.replace('/', '.');
                String[] targets = this.loadTargetsFromConfig().get(command);
                if (command.equals("run.single")) {
                    p.setProperty("run.class", clazz);
                } else if (command.equals("debug.single")) {
                    p.setProperty("debug.class", clazz);
                } else if (command.equals("compile.single")) {
                    p.setProperty("compile.class", clazz);
                }
                return this.getTargetNamesForCommand(targets, command);
            }
        }
        return new String[0];
    }

    private String[] getTargetNamesForCommand(String[] targetsFromConfig, String commandName) {
        if (targetsFromConfig != null) {
            return targetsFromConfig;
        }
        return new String[]{this.supportedActions.get(commandName)};
    }

    private FileObject getRoot(SourceGroup[] groups, FileObject file) {
        assert (file != null) : "File can't be null";
        FileObject srcDir = null;
        for (SourceGroup sourceGroup : groups) {
            FileObject root = sourceGroup.getRootFolder();
            assert (root != null) : "Source Path Root can't be null";
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)file) && !root.equals(file)) continue;
            srcDir = root;
            break;
        }
        return srcDir;
    }

    private FileObject getRoot(FileObject[] groups, FileObject file) {
        assert (file != null) : "File can't be null";
        FileObject srcDir = null;
        for (FileObject root : groups) {
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)file) && !root.equals(file)) continue;
            srcDir = root;
            break;
        }
        return srcDir;
    }

    private FileObject[] findSources(Lookup context) {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        for (SourceGroup sourceGroup : sources.getSourceGroups("java")) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)sourceGroup.getRootFolder(), (String)".groovy", (boolean)true);
            if (files == null) continue;
            return files;
        }
        return null;
    }

    private FileObject[] findTestSources(Lookup context) {
        for (FileObject testSourceRoot : AbstractGroovyActionProvider.getTestSourceRoots(this.project)) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)testSourceRoot, (String)".groovy", (boolean)true);
            if (files == null) continue;
            return files;
        }
        return null;
    }

    private FileObject findBuildXml() {
        return AbstractGroovyActionProvider.getBuildXml(this.project);
    }

    public static String getBuildXmlName(Project project) {
        assert (project != null);
        String buildScriptPath = AbstractGroovyActionProvider.evaluateProperty(project, BUILD_SCRIPT);
        if (buildScriptPath == null) {
            buildScriptPath = "build.xml";
        }
        return buildScriptPath;
    }

    public static FileObject getBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject(AbstractGroovyActionProvider.getBuildXmlName(project));
    }

    private static FileObject[] getTestSourceRoots(Project project) {
        List<String> names = AbstractGroovyActionProvider.getTestRootsNames(project);
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (String name : names) {
            FileObject root = project.getProjectDirectory().getFileObject(name);
            if (root == null) continue;
            result.add(root);
        }
        return result.toArray(new FileObject[result.size()]);
    }

    private static List<String> getTestRootsNames(Project project) {
        File propFile = FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.properties"));
        Map map = PropertyUtils.propertiesFilePropertyProvider((File)propFile).getProperties();
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("test.") || !((String)entry.getKey()).endsWith(".dir")) continue;
            result.add((String)entry.getValue());
        }
        return result;
    }

    private static String evaluateProperty(Project project, String key) {
        File propFile = FileUtil.toFile((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.properties"));
        Map map = PropertyUtils.propertiesFilePropertyProvider((File)propFile).getProperties();
        return (String)map.get(key);
    }

    private String[] setupTestAll(Properties p) {
        p.setProperty("test.binarytestincludes", "**/*Test.class");
        p.setProperty("test.binaryexcludes", "**/*$*");
        p.setProperty("test.binaryincludes", "");
        return new String[]{"test-with-groovy"};
    }

    private String[] setupTestSingle(Properties p, FileObject[] files) {
        FileObject[] testSrcPath = AbstractGroovyActionProvider.getTestSourceRoots(this.project);
        FileObject root = this.getRoot(testSrcPath, files[0]);
        String path = FileUtil.getRelativePath((FileObject)root, (FileObject)files[0]);
        p.setProperty("test.binarytestincludes", path.substring(0, path.length() - 7) + ".class");
        p.setProperty("test.binaryexcludes", "**/*$*");
        p.setProperty("test.binaryincludes", "");
        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        return new String[]{"test-single-groovy"};
    }

    private String[] setupDebugTestSingle(Properties p, FileObject[] files) {
        FileObject[] testSrcPath = AbstractGroovyActionProvider.getTestSourceRoots(this.project);
        FileObject root = this.getRoot(testSrcPath, files[0]);
        String path = FileUtil.getRelativePath((FileObject)root, (FileObject)files[0]);
        p.setProperty("test.binarytestincludes", path.substring(0, path.length() - 7) + ".class");
        p.setProperty("test.binaryexcludes", "**/*$*");
        p.setProperty("test.binaryincludes", "");
        p.setProperty("test.class", path.substring(0, path.length() - 7).replace('/', '.'));
        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        return new String[]{"debug-test"};
    }

    private String[] setupCompileSingle(Properties p, FileObject[] files) {
        FileObject[] testSrcPath = AbstractGroovyActionProvider.getTestSourceRoots(this.project);
        FileObject root = this.getRoot(testSrcPath, files[0]);
        String path = FileUtil.getRelativePath((FileObject)root, (FileObject)files[0]);
        p.setProperty("compile.class", path.substring(0, path.length() - 7).replace('/', '.'));
        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root));
        return new String[]{"compile-single"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String[]> loadTargetsFromConfig() {
        HashMap<String, String[]> targets = new HashMap<String, String[]>(6);
        String config = AbstractGroovyActionProvider.evaluateProperty(this.project, PROP_CONFIG);
        FileObject propFO = this.project.getProjectDirectory().getFileObject("nbproject/configs/" + config + ".properties");
        if (propFO == null) {
            return targets;
        }
        Properties props = new Properties();
        try {
            InputStream is = propFO.getInputStream();
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return targets;
        }
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String tNameVal;
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith("$target.") || (tNameVal = props.getProperty(propName)) == null || tNameVal.equals("")) continue;
            String cmdNameKey = propName.substring("$target.".length());
            StringTokenizer stok = new StringTokenizer(tNameVal.trim(), " ");
            ArrayList<String> targetNames = new ArrayList<String>(3);
            while (stok.hasMoreTokens()) {
                targetNames.add(stok.nextToken());
            }
            targets.put(cmdNameKey, targetNames.toArray(new String[targetNames.size()]));
        }
        return targets;
    }
}

