/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.editor.embedding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public class GroovyEmbeddingProvider
extends EmbeddingProvider {
    private static final Logger LOG = Logger.getLogger(GroovyEmbeddingProvider.class.getName());

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        if ("text/x-gsp".equals(snapshot.getMimeType())) {
            List<Embedding> embeddings = this.translate(snapshot);
            if (embeddings.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Embedding.create(embeddings));
        }
        LOG.warning("Unexpected snapshot type: '" + snapshot.getMimeType() + "'; expecting '" + "text/x-gsp" + "'");
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void cancel() {
    }

    private static TokenSequence<? extends TokenId> getTokenSequence(Snapshot snapshot) {
        Language l = Language.find((String)snapshot.getMimeType());
        if (l != null) {
            return TokenHierarchy.create((CharSequence)snapshot.getText(), (Language)l).tokenSequence();
        }
        return null;
    }

    private List<Embedding> translate(Snapshot snapshot) {
        TokenSequence<? extends TokenId> tokenSequence = GroovyEmbeddingProvider.getTokenSequence(snapshot);
        if (tokenSequence == null) {
            return Collections.emptyList();
        }
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        TokenSequence<? extends TokenId> gspTokenSequence = tokenSequence;
        this.translate(snapshot, gspTokenSequence, embeddings);
        return embeddings;
    }

    private void translate(Snapshot snapshot, TokenSequence<? extends GspTokenId> tokenSequence, List<Embedding> embeddings) {
        embeddings.add(snapshot.create((CharSequence)"def _buf ='';", "text/x-groovy"));
        boolean skipNewline = false;
        while (tokenSequence.moveNext()) {
            int sourceStart;
            Token token = tokenSequence.token();
            if (token.id() == GspTokenId.HTML) {
                int i;
                sourceStart = tokenSequence.offset();
                int sourceEnd = sourceStart + token.length();
                CharSequence charSequence = token.text();
                String text = charSequence == null ? "" : ((Object)charSequence).toString();
                boolean found = false;
                for (i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (c == '\n') {
                        ++i;
                        found = true;
                        break;
                    }
                    if (!Character.isWhitespace(c)) break;
                }
                if (found) {
                    embeddings.add(snapshot.create(sourceStart, i, "text/x-groovy"));
                    text = text.substring(i);
                }
                embeddings.add(snapshot.create((CharSequence)"_buf += \"\"\"", "text/x-groovy"));
                if (skipNewline && text.startsWith("\n")) {
                    text = text.substring(1);
                    --sourceEnd;
                }
                embeddings.add(snapshot.create((CharSequence)text.replace("\"", "\\\""), "text/x-groovy"));
                embeddings.add(snapshot.create((CharSequence)"\"\"\";", "text/x-groovy"));
                skipNewline = false;
                continue;
            }
            if (token.id() == GspTokenId.GROOVY) {
                sourceStart = tokenSequence.offset();
                String text = ((Object)token.text()).toString();
                String trimmedText = text.trim();
                if (trimmedText.startsWith("--") && trimmedText.endsWith("--")) {
                    int last;
                    int first = text.indexOf("--");
                    if (first != (last = text.lastIndexOf("--")) && last - 2 > 0) {
                        embeddings.add(snapshot.create((CharSequence)"/*", "text/x-groovy"));
                        embeddings.add(snapshot.create(sourceStart + first + 2, last - 2, "text/x-groovy"));
                        embeddings.add(snapshot.create((CharSequence)"*/", "text/x-groovy"));
                    }
                } else {
                    embeddings.add(snapshot.create(sourceStart, text.length(), "text/x-groovy"));
                    embeddings.add(snapshot.create((CharSequence)";", "text/x-groovy"));
                }
                skipNewline = false;
                continue;
            }
            if (token.id() != GspTokenId.GROOVY_EXPR) continue;
            embeddings.add(snapshot.create((CharSequence)"_buf += (", "text/x-groovy"));
            sourceStart = tokenSequence.offset();
            String text = ((Object)token.text()).toString();
            skipNewline = false;
            embeddings.add(snapshot.create(sourceStart, text.length(), "text/x-groovy"));
            embeddings.add(snapshot.create((CharSequence)";)", "text/x-groovy"));
        }
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            if (!"text/x-gsp".equals(snapshot.getMimeType())) {
                return Collections.emptyList();
            }
            return Collections.singleton(new GroovyEmbeddingProvider());
        }
    }
}

