/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.dtd;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.netbeans.modules.html.editor.lib.api.dtd.ReaderProvider;
import org.netbeans.modules.html.editor.lib.dtd.DTD;

class DTDParser {
    private ReaderProvider provider = null;
    private WeakHashSet stringCache = new WeakHashSet(131, 0.75f);
    private WeakHashSet attributes = new WeakHashSet(23, 0.75f);
    private WeakHashSet models = new WeakHashSet(131, 0.75f);
    private WeakHashSet contents = new WeakHashSet(131, 0.75f);
    Set leafs = new HashSet(131, 0.75f);
    private SortedMap charRefs = new TreeMap();
    private SortedMap elementMap = new TreeMap();
    private Map entityMap = new HashMap();
    public boolean xmlDTD;
    private static final int DTD_INIT = 0;
    private static final int DTD_LT = 1;
    private static final int DTD_EXC = 2;
    private static final int DTD_MINUS = 3;
    private static final int DTD_ACOMMENT = 4;
    private static final int PED_INIT = 0;
    private static final int PED_PERCENT = 1;
    private static final int PED_CHAR = 2;
    private static final int PED_NAME = 3;
    private static final int PED_ANAME = 4;
    private static final int PED_VAL = 5;
    private static final int PED_TYPE = 6;
    private static final int PED_AVAL = 7;
    private static final int PED_AVAL_M = 8;
    private static final int PED_ATYPE = 9;
    private static final int PED_ID = 10;
    private static final int PED_AID = 11;
    private static final int PED_FILE = 12;
    private static final int PED_AFILE = 13;
    private static final int PED_AFILE_M = 14;
    private static final int PED_ACHAR = 15;
    private static final int PED_CH_TYPE = 16;
    private static final int PED_CH_ATYPE = 17;
    private static final int PED_CH_QUOT = 18;
    private static final int GR_INIT = 0;
    private static final int GR_NAME = 1;
    private static final int GR_ANAME = 2;
    private static final int EL_INIT = 0;
    private static final int EL_NAME = 1;
    private static final int EL_ANAME = 2;
    private static final int EL_ASTART = 3;
    private static final int EL_ACONTENT = 4;
    private static final int EL_PLUS = 5;
    private static final int EL_MINUS = 6;
    private static final int EL_ANAME_XML = 7;
    private static final int CO_INIT = 0;
    private static final int CO_NAME = 1;
    private static final int CO_AMODEL = 2;
    private static final int CO_AND = 3;
    private static final int CO_OR = 4;
    private static final int CO_SEQ = 5;
    private static final int CO_AGROUP = 6;
    private static final int ATT_INIT = 0;
    private static final int ATT_NAME = 1;
    private static final int ATT_ANAME = 2;
    private static final int ATT_ANAME_M = 3;
    private static final int ATT_VAR = 4;
    private static final int ATT_AVAR = 5;
    private static final int ATT_TYPE = 6;
    private static final int ATT_ATYPE = 7;
    private static final int ATT_MODE = 8;
    private static final int ATT_FIXED_VALUE = 9;
    private static final int ATT_FIXED_VALUE_SQ = 10;
    private static final int ATT_FIXED_VALUE_DQ = 11;
    private static final int OPT_INIT = 0;
    private static final int OPT_PROCESS = 1;
    private static final int OPT_APROCESS = 2;
    private static final int OPT_CONTENT = 3;
    private static final int OPT_BRAC1 = 4;
    private static final int OPT_BRAC2 = 5;
    private static final int COMM_TEXT = 0;
    private static final int COMM_DASH = 1;

    DTDParser() {
    }

    private Reader getReader(String identifier, String fileName) {
        if (this.provider == null) {
            return null;
        }
        return this.provider.getReaderForIdentifier(identifier, fileName);
    }

    public DTD createDTD(ReaderProvider provider, String identifier, String fileName) throws WrongDTDException {
        this.provider = provider;
        this.xmlDTD = provider.isXMLContent(identifier);
        Reader reader = this.getReader(identifier, fileName);
        if (reader == null) {
            throw new WrongDTDException("Can't open Reader for public identifier " + identifier);
        }
        try {
            this.parseDTD(new PushbackReader(reader, 131072));
        }
        catch (IOException e) {
            throw new WrongDTDException("IOException during parsing: " + e.getMessage());
        }
        for (DTD.Element elem : this.elementMap.values()) {
            ContentModelImpl cm = (ContentModelImpl)elem.getContentModel();
            HashSet newIncs = new HashSet();
            for (Object oldElem : cm.included) {
                Object subElem = oldElem;
                if (subElem instanceof String) {
                    String key = (String)subElem;
                    subElem = this.elementMap.get(this.xmlDTD ? key : key.toUpperCase(Locale.ENGLISH));
                }
                if (subElem == null) {
                    throw new WrongDTDException("'" + oldElem + "' element referenced from " + elem.getName() + " not found throughout the DTD.");
                }
                newIncs.add(subElem);
            }
            cm.included = newIncs;
            HashSet newExcs = new HashSet();
            for (Object oldElem : cm.excluded) {
                Object subElem = oldElem;
                if (subElem instanceof String) {
                    String key = (String)subElem;
                    subElem = this.elementMap.get(this.xmlDTD ? key : key.toUpperCase(Locale.ENGLISH));
                }
                if (subElem == null) {
                    throw new WrongDTDException("'" + oldElem + "' element referenced from " + elem.getName() + " not found throughout the DTD.");
                }
                newExcs.add(subElem);
            }
            cm.excluded = newExcs;
            cm.hashcode = cm.content.hashCode() + 2 * ((Object)cm.included).hashCode() + 3 * ((Object)cm.excluded).hashCode();
        }
        for (ContentLeafImpl leaf : this.leafs) {
            leaf.elem = (DTD.Element)this.elementMap.get(leaf.elemName);
        }
        return new DTDImpl(identifier, this.elementMap, this.charRefs, this.xmlDTD);
    }

    void addEntity(String name, String content) {
        if (this.entityMap.get(name) == null) {
            this.entityMap.put(name, content);
        }
    }

    void addPublicEntity(String name, String identifier, String file) throws WrongDTDException {
        if (this.entityMap.get(name) == null) {
            StringBuffer sb = new StringBuffer();
            char[] buffer = new char[16384];
            Reader r = this.getReader(identifier, file);
            try {
                int len;
                while ((len = r.read(buffer)) >= 0) {
                    sb.append(buffer, 0, len);
                }
            }
            catch (IOException e) {
                throw new WrongDTDException("Error reading included public entity " + name + " - " + e.getMessage());
            }
            this.entityMap.put(name, sb.toString());
        }
    }

    DTD.Value createValue(String name) {
        return new ValueImpl((String)this.stringCache.put(name));
    }

    DTD.ContentModel createContentModel(DTD.Content content, Set included, Set excluded) {
        ContentModelImpl cm = new ContentModelImpl(content, included, excluded);
        return (DTD.ContentModel)this.models.put(cm);
    }

    DTD.Content createContentLeaf(String name) {
        DTD.Content c = new ContentLeafImpl(name);
        c = (DTD.Content)this.contents.put(c);
        this.leafs.add(c);
        return c;
    }

    DTD.Content createContentNode(char type, DTD.Content subContent) {
        return (DTD.Content)this.contents.put(new UnaryContentNodeImpl(type, subContent));
    }

    DTD.Content createContentNode(char type, DTD.Content[] subContent) {
        return (DTD.Content)this.contents.put(new MultiContentNodeImpl(type, subContent));
    }

    DTD.Element createElement(String name, DTD.ContentModel cm, boolean optStart, boolean optEnd, boolean xmlDTD) {
        ElementImpl retVal = new ElementImpl(name, cm, optStart, optEnd, new TreeMap(), xmlDTD);
        return retVal;
    }

    DTD.Attribute createAttribute(String name, int type, String baseType, String typeHelper, String defaultMode, SortedMap values, boolean xmlDTD) {
        AttributeImpl attr = new AttributeImpl(name, type, (String)this.stringCache.put(baseType), (String)this.stringCache.put(typeHelper), (String)this.stringCache.put(defaultMode), values, xmlDTD);
        return (DTD.Attribute)this.attributes.put(attr);
    }

    void addAttrToElement(String elemName, DTD.Attribute attr) throws WrongDTDException {
        String key = this.xmlDTD ? elemName : elemName.toUpperCase(Locale.ENGLISH);
        ElementImpl elem = (ElementImpl)this.elementMap.get(key);
        if (elem == null) {
            throw new WrongDTDException("Attribute definition for unknown Element \"" + elemName + "\".");
        }
        elem.addAttribute(attr);
    }

    void createAddCharRef(String name, char value) {
        CharRefImpl ref = new CharRefImpl(name, value);
        this.charRefs.put(name, ref);
    }

    private boolean isNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.' || c == ':';
    }

    private void parseDTD(PushbackReader in) throws IOException, WrongDTDException {
        int i;
        int state = 0;
        while ((i = in.read()) != -1) {
            block0 : switch (state) {
                case 0: {
                    switch (i) {
                        case 60: {
                            state = 1;
                            break block0;
                        }
                        case 37: {
                            this.parseEntityReference(in);
                        }
                    }
                    break;
                }
                case 1: {
                    if (i != 33) {
                        throw new WrongDTDException("Unexpected char '" + (char)i + "' after '<'");
                    }
                    state = 2;
                    break;
                }
                case 2: {
                    switch (i) {
                        case 45: {
                            state = 3;
                            break block0;
                        }
                        case 91: {
                            this.parseOptional(in);
                            state = 0;
                            break block0;
                        }
                    }
                    in.unread(i);
                    this.parseMarkup(in);
                    state = 0;
                    break;
                }
                case 3: {
                    if (i != 45) {
                        throw new WrongDTDException("Unexpected char '" + (char)i + "' after \"<!-\"");
                    }
                    this.parseComment(in);
                    state = 4;
                    break;
                }
                case 4: {
                    if (i != 62) {
                        throw new WrongDTDException("Unexpected char '" + (char)i + "' after comment");
                    }
                    state = 0;
                }
            }
        }
        if (state != 0) {
            throw new WrongDTDException("Premature end of DTD");
        }
    }

    private void parseMarkup(PushbackReader in) throws IOException, WrongDTDException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int i;
            if ((i = in.read()) == -1) {
                throw new WrongDTDException("Premature end of DTD");
            }
            if (i == 32) break;
            sb.append((char)i);
        }
        String markup = sb.toString();
        if ("ENTITY".equals(markup)) {
            this.parseEntityDefinition(in);
        } else if ("ELEMENT".equals(markup)) {
            this.parseElement(in);
        } else if ("ATTLIST".equals(markup)) {
            this.parseAttlist(in);
        } else {
            throw new WrongDTDException("Wrong DTD markup <!" + markup);
        }
    }

    private void parseEntityDefinition(PushbackReader in) throws IOException, WrongDTDException {
        int state = 0;
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        StringBuffer type = new StringBuffer();
        StringBuffer identifier = new StringBuffer();
        block21: while (true) {
            int i;
            if ((i = in.read()) == -1) {
                throw new WrongDTDException("Premature end of DTD");
            }
            switch (state) {
                case 0: {
                    if (Character.isWhitespace((char)i)) continue block21;
                    if (i == 37) {
                        state = 1;
                        break;
                    }
                    name.append((char)i);
                    state = 2;
                    break;
                }
                case 1: {
                    if (Character.isWhitespace((char)i)) continue block21;
                    name.append((char)i);
                    state = 3;
                    break;
                }
                case 3: {
                    if (Character.isWhitespace((char)i)) {
                        state = 4;
                        break;
                    }
                    name.append((char)i);
                    break;
                }
                case 4: {
                    if (Character.isWhitespace((char)i)) continue block21;
                    if (i == 34) {
                        state = 5;
                        break;
                    }
                    in.unread(i);
                    state = 6;
                    break;
                }
                case 5: {
                    if (i == 34) {
                        this.addEntity(name.toString(), value.toString());
                        state = 7;
                        break;
                    }
                    value.append((char)i);
                    break;
                }
                case 7: {
                    if (i == 62) {
                        return;
                    }
                    if (i != 45) break;
                    state = 8;
                    break;
                }
                case 8: {
                    if (i == 45) {
                        this.parseComment(in);
                    }
                    state = 7;
                    break;
                }
                case 6: {
                    if (Character.isWhitespace((char)i)) {
                        if (type.toString().equals("PUBLIC")) {
                            state = 9;
                            break;
                        }
                        throw new WrongDTDException("Unexpected entity type \"" + type + "\".");
                    }
                    type.append((char)i);
                    break;
                }
                case 9: {
                    if (Character.isWhitespace((char)i)) continue block21;
                    if (i == 34) {
                        state = 10;
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in PUBLIC entity.");
                }
                case 10: {
                    if (i == 34) {
                        state = 11;
                        break;
                    }
                    identifier.append((char)i);
                    break;
                }
                case 11: {
                    if (Character.isWhitespace((char)i)) continue block21;
                    if (i == 34) {
                        state = 12;
                        break;
                    }
                    if (i == 62) {
                        this.addPublicEntity(name.toString(), identifier.toString(), null);
                        return;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in PUBLIC entity.");
                }
                case 12: {
                    if (i == 34) {
                        state = 13;
                        break;
                    }
                    value.append((char)i);
                    break;
                }
                case 13: {
                    if (Character.isWhitespace((char)i)) continue block21;
                    if (i == 45) {
                        state = 14;
                        break;
                    }
                    if (i == 62) {
                        this.addPublicEntity(name.toString(), identifier.toString(), value.toString());
                        return;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in PUBLIC entity.");
                }
                case 14: {
                    if (i == 45) {
                        this.parseComment(in);
                        state = 12;
                        break;
                    }
                    throw new WrongDTDException("Unexpected sequence \"-" + (char)i + "\" in in PUBLIC entity.");
                }
                case 2: {
                    if (Character.isWhitespace((char)i)) {
                        state = 15;
                        break;
                    }
                    name.append((char)i);
                    break;
                }
                case 15: {
                    if (Character.isWhitespace((char)i)) continue block21;
                    if (this.xmlDTD) {
                        in.unread(i);
                        type.append("CDATA");
                        state = 17;
                        break;
                    }
                    type.append((char)i);
                    state = 16;
                    break;
                }
                case 16: {
                    if (Character.isWhitespace((char)i)) {
                        if (type.toString().equals("CDATA")) {
                            state = 17;
                            break;
                        }
                        throw new WrongDTDException("Unexpected entity type \"" + type + "\".");
                    }
                    type.append((char)i);
                    break;
                }
                case 17: {
                    if (Character.isWhitespace((char)i)) continue block21;
                    if (i == 34) {
                        state = 18;
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in entity.");
                }
                case 18: {
                    if (i == 34) {
                        if (this.xmlDTD) {
                            String replaced = value.toString().replace("&#38;", "&");
                            value.replace(0, value.length(), replaced);
                        }
                        value.delete(0, 2);
                        value.deleteCharAt(value.length() - 1);
                        int code = Integer.parseInt(value.toString());
                        this.createAddCharRef(name.toString(), (char)code);
                        state = 7;
                        break;
                    }
                    value.append((char)i);
                }
            }
        }
    }

    private List parseGroup(PushbackReader in) throws IOException, WrongDTDException {
        int state = 0;
        StringBuffer name = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        block13: while (true) {
            int i;
            if ((i = in.read()) == -1) {
                throw new WrongDTDException("Premature end of DTD");
            }
            block0 : switch (state) {
                case 0: {
                    if (Character.isWhitespace((char)i)) continue block13;
                    if (i == 37) {
                        this.parseEntityReference(in);
                        break;
                    }
                    name.append((char)i);
                    state = 1;
                    break;
                }
                case 1: {
                    if (this.isNameChar((char)i)) {
                        name.append((char)i);
                        break;
                    }
                    switch (i) {
                        case 41: {
                            list.add(name.toString());
                            return list;
                        }
                        case 124: {
                            list.add(name.toString());
                            name.setLength(0);
                            state = 0;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace((char)i)) {
                        list.add(name.toString());
                        name.setLength(0);
                        state = 2;
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in group definition.");
                }
                case 2: {
                    if (Character.isWhitespace((char)i)) continue block13;
                    switch (i) {
                        case 41: {
                            return list;
                        }
                        case 124: {
                            state = 0;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in group definition.");
                }
            }
        }
    }

    private void parseElement(PushbackReader in) throws IOException, WrongDTDException {
        int i;
        int state = 0;
        StringBuffer name = new StringBuffer();
        ArrayList<String> list = null;
        boolean optStart = false;
        boolean optEnd = false;
        DTD.Content content = null;
        HashSet inSet = new HashSet();
        HashSet exSet = new HashSet();
        while ((i = in.read()) != -1) {
            block0 : switch (state) {
                case 0: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 40: {
                            list = this.parseGroup(in);
                            state = 2;
                            break block0;
                        }
                        case 37: {
                            this.parseEntityReference(in);
                            break block0;
                        }
                    }
                    name.append((char)i);
                    state = 1;
                    break;
                }
                case 1: {
                    if (Character.isWhitespace((char)i)) {
                        state = this.xmlDTD ? 7 : 2;
                        list = new ArrayList<String>();
                        list.add(name.toString());
                        break;
                    }
                    name.append((char)i);
                    break;
                }
                case 7: {
                    if (Character.isWhitespace((char)i)) break;
                    in.unread(i);
                    content = this.parseContent(in);
                    state = 4;
                    break;
                }
                case 2: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 79: {
                            optStart = true;
                        }
                        case 45: {
                            state = 3;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in ELEMENT optStart definition.");
                }
                case 3: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 79: {
                            optEnd = true;
                        }
                        case 45: {
                            content = this.parseContent(in);
                            state = 4;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in ELEMENT optEnd definition.");
                }
                case 4: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 43: {
                            state = 5;
                            break block0;
                        }
                        case 45: {
                            state = 6;
                            break block0;
                        }
                        case 62: {
                            DTD.ContentModel cm = this.createContentModel(content, inSet, exSet);
                            for (String key : list) {
                                key = this.xmlDTD ? key : key.toUpperCase(Locale.ENGLISH);
                                this.elementMap.put(key, this.createElement(key, cm, optStart, optEnd, this.xmlDTD));
                            }
                            return;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in ELEMENT definition.");
                }
                case 5: {
                    if (i == 40) {
                        state = 4;
                        inSet.addAll(this.parseGroup(in));
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in ELEMENT definition.");
                }
                case 6: {
                    switch (i) {
                        case 40: {
                            state = 4;
                            List l = this.parseGroup(in);
                            exSet.addAll(l);
                            break block0;
                        }
                        case 45: {
                            state = 4;
                            this.parseComment(in);
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in ELEMENT definition.");
                }
            }
        }
    }

    private DTD.Content parseContent(PushbackReader in) throws IOException, WrongDTDException {
        int i;
        int state = 0;
        StringBuffer name = new StringBuffer();
        ArrayList<DTD.Content> list = null;
        DTD.Content content = null;
        while ((i = in.read()) != -1) {
            block0 : switch (state) {
                case 0: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 37: {
                            this.parseEntityReference(in);
                            break block0;
                        }
                        case 40: {
                            content = this.parseContent(in);
                            state = 2;
                            break block0;
                        }
                    }
                    name.append((char)i);
                    state = 1;
                    break;
                }
                case 1: {
                    if (this.isNameChar((char)i)) {
                        name.append((char)i);
                        break;
                    }
                    switch (i) {
                        case 42: 
                        case 43: 
                        case 63: {
                            DTD.Content leaf = this.createContentLeaf(name.toString());
                            return this.createContentNode((char)i, leaf);
                        }
                    }
                    in.unread(i);
                    return this.createContentLeaf(name.toString());
                }
                case 2: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 38: {
                            list = new ArrayList<DTD.Content>();
                            list.add(content);
                            list.add(this.parseContent(in));
                            state = 3;
                            break block0;
                        }
                        case 124: {
                            list = new ArrayList();
                            list.add(content);
                            list.add(this.parseContent(in));
                            state = 4;
                            break block0;
                        }
                        case 44: {
                            list = new ArrayList();
                            list.add(content);
                            list.add(this.parseContent(in));
                            state = 5;
                            break block0;
                        }
                        case 41: {
                            state = 6;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in ELEMENT optEnd definition.");
                }
                case 3: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 38: {
                            list.add(this.parseContent(in));
                            break block0;
                        }
                        case 41: {
                            content = this.createContentNode('&', list.toArray(new DTD.Content[0]));
                            state = 6;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in ContentModel definition.");
                }
                case 4: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 124: {
                            list.add(this.parseContent(in));
                            break block0;
                        }
                        case 41: {
                            content = this.createContentNode('|', list.toArray(new DTD.Content[0]));
                            state = 6;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in ContentModel definition.");
                }
                case 5: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 44: {
                            list.add(this.parseContent(in));
                            break block0;
                        }
                        case 41: {
                            content = this.createContentNode(',', list.toArray(new DTD.Content[0]));
                            state = 6;
                            break block0;
                        }
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in ContentModel definition.");
                }
                case 6: {
                    if (Character.isWhitespace((char)i)) {
                        return content;
                    }
                    switch (i) {
                        case 42: 
                        case 43: 
                        case 63: {
                            return this.createContentNode((char)i, content);
                        }
                    }
                    in.unread(i);
                    return content;
                }
            }
        }
        throw new WrongDTDException("Premature end of DTD");
    }

    private void parseAttlist(PushbackReader in) throws IOException, WrongDTDException {
        int i;
        int state = 0;
        StringBuffer name = new StringBuffer();
        List list = null;
        StringBuffer attr = new StringBuffer();
        List values = null;
        StringBuffer type = new StringBuffer();
        String typeHelper = null;
        StringBuffer mode = new StringBuffer();
        while ((i = in.read()) != -1) {
            block0 : switch (state) {
                case 0: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 37: {
                            this.parseEntityReference(in);
                            break block0;
                        }
                        case 40: {
                            list = this.parseGroup(in);
                            state = 2;
                            break block0;
                        }
                    }
                    name.append((char)i);
                    state = 1;
                    break;
                }
                case 1: {
                    if (Character.isWhitespace((char)i)) {
                        list = new ArrayList<String>();
                        list.add(name.toString());
                        state = 2;
                        break;
                    }
                    name.append((char)i);
                    break;
                }
                case 2: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 37: {
                            this.parseEntityReference(in);
                            break block0;
                        }
                        case 45: {
                            state = 3;
                            break block0;
                        }
                        case 62: {
                            return;
                        }
                    }
                    attr.append((char)i);
                    state = 4;
                    break;
                }
                case 3: {
                    if (i == 45) {
                        this.parseComment(in);
                        state = 2;
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in ATTLIST definition.");
                }
                case 4: {
                    if (Character.isWhitespace((char)i)) {
                        state = 5;
                        break;
                    }
                    attr.append((char)i);
                    break;
                }
                case 5: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 37: {
                            typeHelper = this.parseEntityReference(in);
                            break block0;
                        }
                        case 40: {
                            values = this.parseGroup(in);
                            state = 7;
                            break block0;
                        }
                    }
                    type.append((char)i);
                    state = 6;
                    break;
                }
                case 6: {
                    if (Character.isWhitespace((char)i)) {
                        state = 7;
                        break;
                    }
                    type.append((char)i);
                    break;
                }
                case 7: {
                    if (Character.isWhitespace((char)i)) break;
                    switch (i) {
                        case 37: {
                            this.parseEntityReference(in);
                            break block0;
                        }
                    }
                    mode.append((char)i);
                    state = 8;
                    break;
                }
                case 8: {
                    if (Character.isWhitespace((char)i) || i == 62) {
                        DTD.Attribute a = null;
                        if (values == null) {
                            a = this.createAttribute(attr.toString(), 2, type.toString(), typeHelper, mode.toString(), null, this.xmlDTD);
                        } else if (values.size() == 1) {
                            a = this.createAttribute(attr.toString(), 0, null, typeHelper, mode.toString(), null, this.xmlDTD);
                        } else {
                            TreeMap<String, DTD.Value> vals = new TreeMap<String, DTD.Value>();
                            for (String key : values) {
                                String valName = this.xmlDTD ? key : key.toLowerCase(Locale.ENGLISH);
                                vals.put(valName, this.createValue(valName));
                            }
                            a = this.createAttribute(attr.toString(), 1, null, typeHelper, mode.toString(), vals, this.xmlDTD);
                        }
                        Iterator iter = list.iterator();
                        while (iter.hasNext()) {
                            this.addAttrToElement((String)iter.next(), a);
                        }
                        typeHelper = null;
                        attr.setLength(0);
                        type.setLength(0);
                        mode.setLength(0);
                        values = null;
                        state = this.xmlDTD && a.getDefaultMode().equals("#FIXED") ? 9 : 2;
                        if (i != 62) break;
                        return;
                    }
                    mode.append((char)i);
                    break;
                }
                case 9: {
                    if (Character.isWhitespace((char)i)) break;
                    if (i == 39) {
                        state = 10;
                        break;
                    }
                    if (i != 34) break;
                    state = 11;
                    break;
                }
                case 10: {
                    if (i != 39) break;
                    state = 2;
                    break;
                }
                case 11: {
                    if (i != 34) break;
                    state = 2;
                }
            }
        }
    }

    private void parseOptional(PushbackReader in) throws IOException, WrongDTDException {
        int i;
        int state = 0;
        StringBuffer process = new StringBuffer();
        StringBuffer content = new StringBuffer();
        boolean ignore = false;
        while ((i = in.read()) != -1) {
            switch (state) {
                case 0: {
                    if (Character.isWhitespace((char)i)) break;
                    if (i == 37) {
                        this.parseEntityReference(in);
                        break;
                    }
                    process.append((char)i);
                    state = 1;
                    break;
                }
                case 1: {
                    if (Character.isWhitespace((char)i)) {
                        String s = process.toString();
                        if ("IGNORE".equals(s)) {
                            ignore = true;
                        } else if (!"INCLUDE".equals(s)) {
                            throw new WrongDTDException("Unexpected processing instruction " + s);
                        }
                        state = 2;
                        break;
                    }
                    process.append((char)i);
                    break;
                }
                case 2: {
                    if (Character.isWhitespace((char)i)) break;
                    if (i == 91) {
                        state = 3;
                        break;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in processing instruction.");
                }
                case 3: {
                    if (i == 93) {
                        state = 4;
                        break;
                    }
                    content.append((char)i);
                    break;
                }
                case 4: {
                    if (i == 93) {
                        state = 5;
                        break;
                    }
                    content.append(']').append((char)i);
                    state = 3;
                    break;
                }
                case 5: {
                    if (Character.isWhitespace((char)i)) break;
                    if (i == 62) {
                        if (!ignore) {
                            in.unread(content.toString().toCharArray());
                        }
                        return;
                    }
                    throw new WrongDTDException("Unexpected char '" + (char)i + "' in processing instruction.");
                }
            }
        }
    }

    private void parseComment(PushbackReader in) throws IOException, WrongDTDException {
        int i;
        int state = 0;
        while ((i = in.read()) != -1) {
            switch (state) {
                case 0: {
                    if (i != 45) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (i == 45) {
                        return;
                    }
                    state = 0;
                }
            }
        }
        throw new WrongDTDException("Premature end of DTD");
    }

    private String parseEntityReference(PushbackReader in) throws IOException, WrongDTDException {
        int i;
        StringBuffer sb = new StringBuffer();
        while ((i = in.read()) != -1) {
            if (this.isNameChar((char)i)) {
                sb.append((char)i);
                continue;
            }
            String entValue = (String)this.entityMap.get(sb.toString());
            if (entValue == null) {
                throw new WrongDTDException("No such entity: \"" + sb + "\"");
            }
            if (i != 59) {
                in.unread(i);
            }
            in.unread(entValue.toCharArray());
            return sb.toString();
        }
        throw new WrongDTDException("Premature end of DTD");
    }

    public static class WeakHashSet {
        Entry[] data;
        int count = 0;
        int treshold;
        float loadFactor;

        public WeakHashSet(int capacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.treshold = (int)((float)capacity * loadFactor);
            this.data = new Entry[capacity];
        }

        public Object get(Object obj) {
            if (obj == null) {
                return null;
            }
            Entry[] tab = this.data;
            Entry prev = null;
            int hash = obj.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash) {
                    Object value = e.value.get();
                    if (value == null) {
                        --this.count;
                        if (prev == null) {
                            tab[index] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                    } else if (value.equals(obj)) {
                        return value;
                    }
                }
                prev = e;
                e = e.next;
            }
            return null;
        }

        public Object put(Object obj) {
            if (obj == null) {
                return null;
            }
            Entry[] tab = this.data;
            Entry prev = null;
            int hash = obj.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash) {
                    Object value = e.value.get();
                    if (value == null) {
                        --this.count;
                        if (prev == null) {
                            tab[index] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                    } else if (value.equals(obj)) {
                        return value;
                    }
                }
                prev = e;
                e = e.next;
            }
            if (this.count >= this.treshold) {
                this.rehash();
                tab = this.data;
                index = (hash & Integer.MAX_VALUE) % tab.length;
            }
            tab[index] = e = new Entry(hash, obj, tab[index]);
            ++this.count;
            return obj;
        }

        private void rehash() {
            int oldCapacity = this.data.length;
            Entry[] oldMap = this.data;
            int newCapacity = oldCapacity * 2 + 1;
            Entry[] newMap = new Entry[newCapacity];
            this.treshold = (int)((float)newCapacity * this.loadFactor);
            this.data = newMap;
            int i = oldCapacity;
            while (i-- > 0) {
                Entry old = oldMap[i];
                while (old != null) {
                    Entry e = old;
                    old = old.next;
                    int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                    e.next = newMap[index];
                    newMap[index] = e;
                }
            }
        }

        private static class Entry {
            int hash;
            WeakReference value;
            Entry next;

            Entry(int hash, Object value, Entry next) {
                this.hash = hash;
                this.value = new WeakReference<Object>(value);
                this.next = next;
            }
        }
    }

    private static class MultiContentNodeImpl
    implements DTD.ContentNode {
        int hashcode;
        char type;
        DTD.Content[] content;

        public MultiContentNodeImpl(char type, DTD.Content[] content) {
            if (type != '|' && type != '&' && type != ',') {
                throw new IllegalArgumentException("Unknown n-ary content type '" + type + "'");
            }
            this.type = type;
            this.content = content;
            this.hashcode = type;
            for (int i = 0; i < content.length; ++i) {
                this.hashcode += content[i].hashCode();
            }
        }

        public boolean isLeaf() {
            return false;
        }

        @Override
        public char getType() {
            return this.type;
        }

        public DTD.Content[] getContent() {
            return this.content;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MultiContentNodeImpl)) {
                return false;
            }
            return this.type == ((MultiContentNodeImpl)obj).type && Arrays.equals(this.content, ((MultiContentNodeImpl)obj).content);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("(");
            for (int i = 0; i < this.content.length; ++i) {
                sb.append(this.content[i].toString());
                if (i + 1 >= this.content.length) continue;
                sb.append(this.type);
            }
            sb.append(')');
            return sb.toString();
        }

        public int hashCode() {
            return this.hashcode;
        }

        @Override
        public boolean isDiscardable() {
            if (this.type == '&' || this.type == ',') {
                for (int i = 0; i < this.content.length; ++i) {
                    if (this.content[i].isDiscardable()) continue;
                    return false;
                }
                return true;
            }
            for (int i = 0; i < this.content.length; ++i) {
                if (!this.content[i].isDiscardable()) continue;
                return true;
            }
            return false;
        }

        @Override
        public DTD.Content reduce(String elementName) {
            if (this.type == '|') {
                for (int index = 0; index < this.content.length; ++index) {
                    DTD.Content sub = this.content[index].reduce(elementName);
                    if (sub == null) continue;
                    return sub;
                }
                return null;
            }
            if (this.type == ',') {
                for (int index = 0; index < this.content.length; ++index) {
                    DTD.Content sub = this.content[index].reduce(elementName);
                    if (sub == null && !this.content[index].isDiscardable()) {
                        return null;
                    }
                    if (sub == EMPTY_CONTENT) {
                        int newLen = this.content.length - index - 1;
                        if (newLen > 1) {
                            DTD.Content[] newSub = new DTD.Content[newLen];
                            System.arraycopy(this.content, index + 1, newSub, 0, newLen);
                            return new MultiContentNodeImpl(',', newSub);
                        }
                        return this.content[index + 1];
                    }
                    if (sub == null) continue;
                    int newLen = this.content.length - index;
                    if (newLen > 1) {
                        DTD.Content[] newSub = new DTD.Content[newLen];
                        System.arraycopy(this.content, index + 1, newSub, 1, newLen - 1);
                        newSub[0] = sub;
                        return new MultiContentNodeImpl(',', newSub);
                    }
                    return sub;
                }
                return null;
            }
            if (this.type == '&') {
                for (int index = 0; index < this.content.length; ++index) {
                    DTD.Content sub = this.content[index].reduce(elementName);
                    if (sub == EMPTY_CONTENT) {
                        int newLen = this.content.length - 1;
                        if (newLen == 0) {
                            return EMPTY_CONTENT;
                        }
                        DTD.Content[] newSub = new DTD.Content[newLen];
                        System.arraycopy(this.content, 0, newSub, 0, index);
                        if (index < newSub.length) {
                            System.arraycopy(this.content, index + 1, newSub, index, newLen - index);
                        }
                        return new MultiContentNodeImpl('&', newSub);
                    }
                    if (sub == null) continue;
                    int newLen = this.content.length - 1;
                    if (newLen == 0) {
                        return sub;
                    }
                    DTD.Content[] newSub = new DTD.Content[newLen];
                    System.arraycopy(this.content, 0, newSub, 0, index);
                    if (index < newSub.length) {
                        System.arraycopy(this.content, index + 1, newSub, index, newLen - index);
                    }
                    MultiContentNodeImpl right = new MultiContentNodeImpl('&', newSub);
                    return new MultiContentNodeImpl('&', new DTD.Content[]{sub, right});
                }
                return null;
            }
            assert (false) : "Unknown operator '" + this.type + "' found in the DTD file when trying to reduce " + elementName;
            return null;
        }

        @Override
        public Set getPossibleElements() {
            HashSet retVal = new HashSet(11);
            if (this.type == '|' || this.type == '&') {
                for (int index = 0; index < this.content.length; ++index) {
                    retVal.addAll(this.content[index].getPossibleElements());
                }
            } else {
                for (int index = 0; index < this.content.length; ++index) {
                    retVal.addAll(this.content[index].getPossibleElements());
                    if (this.content[index].isDiscardable()) {
                        continue;
                    }
                    break;
                }
            }
            return retVal;
        }
    }

    private static class UnaryContentNodeImpl
    implements DTD.ContentNode {
        int hashcode;
        char type;
        DTD.Content content;

        public UnaryContentNodeImpl(char type, DTD.Content content) {
            if (type != '*' && type != '?' && type != '+') {
                throw new IllegalArgumentException("Unknown unary content type '" + type + "'");
            }
            this.type = type;
            this.content = content;
            this.hashcode = type + content.hashCode();
        }

        public boolean isLeaf() {
            return false;
        }

        @Override
        public char getType() {
            return this.type;
        }

        public DTD.Content[] getContent() {
            return new DTD.Content[]{this.content};
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UnaryContentNodeImpl)) {
                return false;
            }
            return this.type == ((UnaryContentNodeImpl)obj).type && this.content.equals(((UnaryContentNodeImpl)obj).content);
        }

        public int hashCode() {
            return this.hashcode;
        }

        public String toString() {
            return this.content.toString() + this.type;
        }

        @Override
        public boolean isDiscardable() {
            if (this.type == '*' || this.type == '?') {
                return true;
            }
            return this.content.isDiscardable();
        }

        @Override
        public DTD.Content reduce(String elementName) {
            DTD.Content sub = this.content.reduce(elementName);
            if (sub == null) {
                return null;
            }
            if (sub == EMPTY_CONTENT) {
                if (this.type == '?') {
                    return EMPTY_CONTENT;
                }
                if (this.type == '*') {
                    return this;
                }
                return new UnaryContentNodeImpl('*', this.content);
            }
            if (this.type == '?') {
                return sub;
            }
            UnaryContentNodeImpl second = this.type == '*' ? this : new UnaryContentNodeImpl('*', this.content);
            return new MultiContentNodeImpl(',', new DTD.Content[]{sub, second});
        }

        @Override
        public Set getPossibleElements() {
            return this.content.getPossibleElements();
        }
    }

    static class ContentLeafImpl
    implements DTD.ContentLeaf {
        String elemName;
        DTD.Element elem;

        public ContentLeafImpl(String name) {
            this.elemName = name;
        }

        @Override
        public String getElementName() {
            return this.elemName;
        }

        @Override
        public DTD.Element getElement() {
            return this.elem;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ContentLeafImpl)) {
                return false;
            }
            return this.elemName.equals(((ContentLeafImpl)obj).elemName);
        }

        public int hashCode() {
            return this.elemName.hashCode();
        }

        public String toString() {
            return this.elemName;
        }

        @Override
        public boolean isDiscardable() {
            return this.getElementName().equals("#PCDATA");
        }

        @Override
        public DTD.Content reduce(String elementName) {
            if (this.elemName.equals(elementName)) {
                return EMPTY_CONTENT;
            }
            return null;
        }

        @Override
        public Set getPossibleElements() {
            HashSet<DTD.Element> s = new HashSet<DTD.Element>();
            if (this.elem != null) {
                s.add(this.elem);
            }
            return s;
        }
    }

    private static class ContentModelImpl
    implements DTD.ContentModel {
        int hashcode;
        DTD.Content content;
        Set included;
        Set excluded;

        public ContentModelImpl(DTD.Content content, Set included, Set excluded) {
            this.content = content;
            this.included = included;
            this.excluded = excluded;
            this.hashcode = content.hashCode() + 2 * ((Object)included).hashCode() + 3 * ((Object)excluded).hashCode();
        }

        @Override
        public DTD.Content getContent() {
            return this.content;
        }

        @Override
        public Set getIncludes() {
            return this.included;
        }

        @Override
        public Set getExcludes() {
            return this.excluded;
        }

        public String toString() {
            Iterator i;
            StringBuffer sb = new StringBuffer(this.content.toString());
            if (!this.included.isEmpty()) {
                sb.append(" +(");
                i = this.included.iterator();
                while (true) {
                    sb.append(((DTD.Element)i.next()).getName());
                    if (!i.hasNext()) break;
                    sb.append("|");
                }
                sb.append(")");
            }
            if (!this.excluded.isEmpty()) {
                sb.append(" -(");
                i = this.excluded.iterator();
                while (true) {
                    sb.append(((DTD.Element)i.next()).getName());
                    if (!i.hasNext()) break;
                    sb.append("|");
                }
                sb.append(")");
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ContentModelImpl)) {
                return false;
            }
            ContentModelImpl cmi = (ContentModelImpl)obj;
            return this.content.equals(cmi.content) && ((Object)this.included).equals(cmi.included) && ((Object)this.excluded).equals(cmi.excluded);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    private static class CharRefImpl
    implements DTD.CharRef {
        private String name;
        private char value;

        CharRefImpl(String name, char value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public char getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "->'" + this.value + "'(&#" + this.value + ";)";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CharRefImpl)) {
                return false;
            }
            return this.name.equals(((CharRefImpl)obj).name) && this.value == ((CharRefImpl)obj).value;
        }

        public int hashCode() {
            return this.name.hashCode() * this.value;
        }
    }

    private static class ValueImpl
    implements DTD.Value {
        String name;

        ValueImpl(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ValueImpl)) {
                return false;
            }
            return this.name.equals(((ValueImpl)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class AttributeImpl
    implements DTD.Attribute {
        private String name;
        private int type;
        private String baseType;
        private String typeHelper;
        private String defaultMode;
        private SortedMap values;
        private int hashcode;
        private boolean xmlDTD;

        public AttributeImpl(String name, int type, String baseType, String typeHelper, String defaultMode, SortedMap values, boolean xmlDTD) {
            this.name = name;
            this.type = type;
            this.baseType = baseType;
            this.typeHelper = typeHelper;
            this.defaultMode = defaultMode;
            this.values = values;
            this.hashcode = name.hashCode() * (type + 1) * (baseType == null ? 1 : baseType.hashCode()) + (typeHelper == null ? 1 : typeHelper.hashCode()) + defaultMode.hashCode() + (values == null ? 1 : values.hashCode());
            this.xmlDTD = xmlDTD;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getBaseType() {
            return this.baseType;
        }

        @Override
        public String getTypeHelper() {
            return this.typeHelper;
        }

        @Override
        public String getDefaultMode() {
            return this.defaultMode;
        }

        @Override
        public boolean isRequired() {
            return this.defaultMode.equals("#REQUIRED");
        }

        @Override
        public List getValueList(String prefix) {
            if (this.type != 1) {
                return null;
            }
            prefix = prefix == null ? "" : (this.xmlDTD ? prefix : prefix.toLowerCase(Locale.ENGLISH));
            ArrayList retVal = new ArrayList();
            for (Map.Entry entry : this.values.tailMap(prefix).entrySet()) {
                if (!entry.getKey().startsWith(prefix)) break;
                retVal.add(entry.getValue());
            }
            return retVal;
        }

        @Override
        public DTD.Value getValue(String name) {
            return (DTD.Value)this.values.get(name);
        }

        public String toString() {
            if (this.type == 1) {
                return this.name + " " + this.values + "[" + this.typeHelper + "] " + this.defaultMode;
            }
            if (this.type == 0) {
                return this.name + " (" + this.name + ")[" + this.typeHelper + "] " + this.defaultMode;
            }
            return this.name + " " + this.baseType + "[" + this.typeHelper + "] " + this.defaultMode;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AttributeImpl)) {
                return false;
            }
            AttributeImpl a = (AttributeImpl)obj;
            return this.hashcode == a.hashcode && this.name.equals(a.name) && this.type == a.type && (this.baseType == a.baseType || this.baseType != null && this.baseType.equals(a.baseType)) && (this.typeHelper == a.typeHelper || this.typeHelper != null && this.typeHelper.equals(a.typeHelper)) && this.defaultMode.equals(a.defaultMode) && (this.values == a.values || this.values != null && this.values.equals(a.values));
        }
    }

    private static class ElementImpl
    implements DTD.Element {
        private String name;
        private DTD.ContentModel model;
        private boolean optStart;
        private boolean optEnd;
        private SortedMap attributes;
        private boolean xmlDTD;

        ElementImpl(String name, DTD.ContentModel model, boolean optStart, boolean optEnd, SortedMap attributes, boolean xmlDTD) {
            this.name = name;
            this.model = model;
            this.optStart = optStart;
            this.optEnd = optEnd;
            this.attributes = attributes;
            this.xmlDTD = xmlDTD;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isEmpty() {
            return this.optEnd && this.model.getContent() instanceof DTD.ContentLeaf && ((DTD.ContentLeaf)this.model.getContent()).getElementName().equals("EMPTY");
        }

        @Override
        public boolean hasOptionalStart() {
            return this.optStart;
        }

        @Override
        public boolean hasOptionalEnd() {
            return this.optEnd;
        }

        @Override
        public List getAttributeList(String prefix) {
            TreeSet set = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (this.isRequired(o1) && !this.isRequired(o2)) {
                        return -1;
                    }
                    if (!this.isRequired(o1) && this.isRequired(o2)) {
                        return 1;
                    }
                    return ((DTD.Attribute)o1).getName().compareTo(((DTD.Attribute)o2).getName());
                }

                private final boolean isRequired(Object o) {
                    return ((DTD.Attribute)o).getDefaultMode().equals("#REQUIRED");
                }
            });
            if (prefix == null) {
                prefix = "";
            }
            prefix = this.xmlDTD ? prefix : prefix.toLowerCase(Locale.ENGLISH);
            for (Map.Entry entry : this.attributes.tailMap(prefix).entrySet()) {
                if (!entry.getKey().startsWith(prefix)) break;
                set.add(entry.getValue());
            }
            return new ArrayList(set);
        }

        @Override
        public DTD.Attribute getAttribute(String name) {
            return (DTD.Attribute)this.attributes.get(name);
        }

        void addAttribute(DTD.Attribute attr) {
            this.attributes.put(attr.getName(), attr);
        }

        @Override
        public DTD.ContentModel getContentModel() {
            return this.model;
        }

        public String toString() {
            return super.toString() + "[" + this.name + (this.optStart ? " O" : " -") + (this.optEnd ? " O " : " - ") + this.model + " attribs=" + this.attributes + "]";
        }
    }

    private static class DTDImpl
    implements DTD {
        private String id;
        private SortedMap elements;
        private SortedMap charRefs;
        private boolean xmlDTD;

        DTDImpl(String identifier, SortedMap elements, SortedMap charRefs, boolean xmlDTD) {
            this.id = identifier;
            this.elements = elements;
            this.charRefs = charRefs;
            this.xmlDTD = xmlDTD;
        }

        @Override
        public String getIdentifier() {
            return this.id;
        }

        @Override
        public List getElementList(String prefix) {
            ArrayList l = new ArrayList();
            prefix = prefix == null ? "" : (this.xmlDTD ? prefix : prefix.toUpperCase(Locale.ENGLISH));
            for (Map.Entry entry : this.elements.tailMap(prefix).entrySet()) {
                if (!entry.getKey().startsWith(prefix)) break;
                l.add(entry.getValue());
            }
            return l;
        }

        @Override
        public DTD.Element getElement(String name) {
            return (DTD.Element)this.elements.get(this.xmlDTD ? name : name.toUpperCase(Locale.ENGLISH));
        }

        @Override
        public List getCharRefList(String prefix) {
            ArrayList l = new ArrayList();
            for (Map.Entry entry : this.charRefs.tailMap(prefix).entrySet()) {
                if (!entry.getKey().startsWith(prefix)) break;
                l.add(entry.getValue());
            }
            return l;
        }

        @Override
        public DTD.CharRef getCharRef(String name) {
            return (DTD.CharRef)this.charRefs.get(name);
        }

        public String toString() {
            return super.toString() + "[id=" + this.id + ", elements=" + this.elements + ",charRefs=" + this.charRefs + "]";
        }
    }

    public static class WrongDTDException
    extends Exception {
        public WrongDTDException(String reason) {
            super(reason);
        }
    }
}

