/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.api.elements;

import java.util.Iterator;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.lib.ElementsParser;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.parsing.api.Snapshot;

public class ElementsIterator
implements Iterator<Element> {
    private Iterator<Element> wrapped;

    public ElementsIterator(Snapshot snapshot) {
        if (!"text/html".equals(snapshot.getMimeType())) {
            throw new IllegalStateException();
        }
        CharSequence source = snapshot.getText();
        TokenSequence tokenSequence = snapshot.getTokenHierarchy().tokenSequence(HTMLTokenId.language());
        this.wrapped = new ElementsParser(source, (TokenSequence<HTMLTokenId>)tokenSequence, 0);
    }

    public ElementsIterator(HtmlSource source) {
        CharSequence sourceCode = source.getSourceCode();
        Snapshot snapshot = source.getSnapshot();
        TokenHierarchy hi = snapshot != null ? snapshot.getTokenHierarchy() : TokenHierarchy.create((CharSequence)sourceCode, (Language)HTMLTokenId.language());
        TokenSequence tokenSequence = hi.tokenSequence(HTMLTokenId.language());
        this.wrapped = new ElementsParser(sourceCode, (TokenSequence<HTMLTokenId>)tokenSequence, 0);
    }

    @Override
    public boolean hasNext() {
        return this.wrapped.hasNext();
    }

    @Override
    public Element next() {
        return this.wrapped.next();
    }

    @Override
    public void remove() {
        this.wrapped.remove();
    }
}

