/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.netbeans.modules.html.editor.lib.ElementsIteratorHandle;
import org.netbeans.modules.html.editor.lib.XmlSTElements;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class XmlSyntaxTreeBuilder {
    private static boolean ADD_TEXT_NODES;
    private static boolean FOLLOW_HTML_MODEL;
    private static HtmlModel MODEL;

    public static Node makeUncheckedTree(HtmlSource source, String namespace, Lookup lookup) {
        Iterator<Element> elements;
        Parameters.notNull((CharSequence)"source", (Object)source);
        Parameters.notNull((CharSequence)"lookup", (Object)lookup);
        ElementsIteratorHandle handle = (ElementsIteratorHandle)lookup.lookup(ElementsIteratorHandle.class);
        Iterator<Element> iterator = elements = handle != null ? handle.getIterator() : null;
        assert (elements != null);
        Properties props = (Properties)lookup.lookup(Properties.class);
        if (props != null) {
            ADD_TEXT_NODES = Boolean.parseBoolean(props.getProperty("add_text_nodes"));
            FOLLOW_HTML_MODEL = Boolean.parseBoolean(props.getProperty("follow_html_model"));
        }
        if (FOLLOW_HTML_MODEL) {
            MODEL = (HtmlModel)lookup.lookup(HtmlModel.class);
            assert (MODEL != null) : "add HtmlModel instance to the lookup!";
        }
        CharSequence code = source.getSourceCode();
        XmlSTElements.Root rootNode = new XmlSTElements.Root(namespace, code);
        LinkedList<XmlSTElements.OT> stack = new LinkedList<XmlSTElements.OT>();
        stack.add(rootNode);
        while (elements.hasNext()) {
            Element element = elements.next();
            if (element.type() == ElementType.OPEN_TAG) {
                HtmlTag htmlTag;
                OpenTag plainOpenTag = (OpenTag)element;
                XmlSTElements.EmptyOT openTagNode = plainOpenTag.isEmpty() ? new XmlSTElements.EmptyOT(plainOpenTag.attributes(), plainOpenTag.name(), code, plainOpenTag.from(), plainOpenTag.to()) : new XmlSTElements.OT(plainOpenTag.attributes(), plainOpenTag.name(), code, plainOpenTag.from(), plainOpenTag.to());
                XmlSTElements.OT peek = (XmlSTElements.OT)stack.getLast();
                peek.addChild(openTagNode);
                if (MODEL != null && (htmlTag = MODEL.getTag(((Object)plainOpenTag.name()).toString())) != null && htmlTag.isEmpty() || plainOpenTag.isEmpty()) continue;
                stack.addLast((XmlSTElements.OT)openTagNode);
                continue;
            }
            if (element.type() == ElementType.CLOSE_TAG) {
                CloseTag plainElement = (CloseTag)element;
                CharSequence tagName = plainElement.name();
                XmlSTElements.ET endTagNode = new XmlSTElements.ET(plainElement.name(), code, plainElement.from(), plainElement.to());
                int matched_index = -1;
                for (int i = stack.size() - 1; i >= 0; --i) {
                    OpenTag node = (OpenTag)stack.get(i);
                    if (!LexerUtils.equals((CharSequence)tagName, (CharSequence)node.name(), (boolean)false, (boolean)false)) continue;
                    matched_index = i;
                    break;
                }
                assert (matched_index != 0);
                if (matched_index > 0) {
                    XmlSTElements.OT match = (XmlSTElements.OT)stack.get(matched_index);
                    for (int i = stack.size() - 1; i > matched_index; --i) {
                        XmlSTElements.OT node = (XmlSTElements.OT)stack.get(i);
                        node.setLogicalEndOffset(endTagNode.from());
                        stack.remove(i);
                    }
                    XmlSTElements.OT match_parent = (XmlSTElements.OT)stack.get(matched_index - 1);
                    match_parent.addChild(endTagNode);
                    match.setMatchingEndTag(endTagNode);
                    match.setLogicalEndOffset(endTagNode.to());
                    endTagNode.setMatchingOpenTag(match);
                    stack.removeLast();
                    continue;
                }
                ((XmlSTElements.OT)stack.getLast()).addChild(endTagNode);
                continue;
            }
            if (element.type() != ElementType.TEXT || !ADD_TEXT_NODES) continue;
            XmlSTElements.OT parent = (XmlSTElements.OT)stack.getLast();
            XmlSTElements.Text text = new XmlSTElements.Text(code, element.from(), element.to());
            parent.addChild(text);
        }
        for (int i = stack.size() - 1; i > 0; --i) {
            XmlSTElements.OT node = (XmlSTElements.OT)stack.get(i);
            node.setLogicalEndOffset(code.length());
        }
        return rootNode;
    }
}

