/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.lib.ElementsParser;
import org.netbeans.modules.html.editor.lib.api.elements.Element;

public class ElementsParserCache {
    static int CACHE_BLOCK_SIZE = 1000;
    List<CacheBlock> cacheBlocks = new ArrayList<CacheBlock>();
    private final CharSequence sourceCode;
    private final TokenSequence<HTMLTokenId> tokenSequence;

    public ElementsParserCache(CharSequence sourceCode, TokenSequence<HTMLTokenId> tokenSequence) {
        this.sourceCode = sourceCode;
        this.tokenSequence = tokenSequence;
    }

    public Iterator<Element> createElementsIterator() {
        return new Iterator<Element>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.getCacheBlock().getEndIndex() > this.index;
            }

            @Override
            public Element next() {
                return this.getCacheBlock().getElementAtIndex(this.index++);
            }

            private CacheBlock getCacheBlock() {
                CacheBlock item;
                int blockIndex = this.index / CACHE_BLOCK_SIZE;
                CacheBlock cacheBlock = item = ElementsParserCache.this.cacheBlocks.size() > blockIndex ? ElementsParserCache.this.cacheBlocks.get(blockIndex) : null;
                if (item == null) {
                    int offset = blockIndex == 0 ? 0 : ElementsParserCache.this.cacheBlocks.get(blockIndex - 1).getEndOffset();
                    item = new CacheBlock(ElementsParserCache.this.sourceCode, ElementsParserCache.this.tokenSequence, this.index, offset);
                    assert (blockIndex == ElementsParserCache.this.cacheBlocks.size());
                    ElementsParserCache.this.cacheBlocks.add(blockIndex, item);
                }
                return item;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static class CacheBlockContent {
        private List<Element> elements;

        private CacheBlockContent(CharSequence code, TokenSequence<HTMLTokenId> tokenSequence, int startOffset) {
            ElementsParser parser = new ElementsParser(code, tokenSequence, startOffset);
            this.elements = new ArrayList<Element>(CACHE_BLOCK_SIZE);
            int limit = CACHE_BLOCK_SIZE;
            while (parser.hasNext() && limit-- > 0) {
                this.elements.add(parser.next());
            }
        }

        List<Element> getElements() {
            return this.elements;
        }

        Element getLastElement() {
            return this.elements.get(this.elements.size() - 1);
        }
    }

    static class CacheBlock {
        int blockReads = 0;
        Reference<CacheBlockContent> blockReference;
        private final int startIndex;
        private int endIndex;
        private int startOffset;
        private int endOffset;
        private CharSequence code;
        private TokenSequence<HTMLTokenId> tokenSequence;

        private CacheBlock(CharSequence code, TokenSequence<HTMLTokenId> tokenSequence, int startIndex, int startOffset) {
            this.code = code;
            this.tokenSequence = tokenSequence;
            this.startIndex = startIndex;
            this.startOffset = startOffset;
            CacheBlockContent block = new CacheBlockContent(code, tokenSequence, startOffset);
            int blockSize = block.getElements().size();
            this.endIndex = startIndex + blockSize;
            this.endOffset = blockSize == 0 ? startOffset : block.getLastElement().to();
            ++this.blockReads;
            this.blockReference = new SoftReference<CacheBlockContent>(block);
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public Element getElementAtIndex(int index) {
            return this.getElements().get(index - this.getStartIndex());
        }

        public List<Element> getElements() {
            CacheBlockContent block = this.blockReference.get();
            if (block == null) {
                block = new CacheBlockContent(this.code, this.tokenSequence, this.startOffset);
                ++this.blockReads;
                this.blockReference = new SoftReference<CacheBlockContent>(block);
            }
            return block.getElements();
        }

        public String toString() {
            return "CacheBlock(hash=" + this.hashCode() + ",items=" + this.getElements().size();
        }
    }
}

