/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private static final Logger LOGGER = Logger.getLogger(XmlUtils.class.getName());

    private XmlUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(File xmlFile) throws IOException, SAXException {
        FileInputStream fileInputStream = new FileInputStream(xmlFile);
        try {
            Document document;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                InputSource inputSource = new InputSource(bufferedInputStream);
                document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, (EntityResolver)new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        return new InputSource(new ByteArrayInputStream(new byte[0]));
                    }
                });
            }
            catch (Throwable throwable) {
                bufferedInputStream.close();
                throw throwable;
            }
            bufferedInputStream.close();
            return document;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Document document, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            try {
                XMLUtil.write((Document)document, (OutputStream)bufferedOutputStream, (String)document.getXmlEncoding());
            }
            finally {
                bufferedOutputStream.close();
            }
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static Node query(Document document, String xpathExpression) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPathExpression xPathExpression = xPath.compile(xpathExpression);
            Object result = xPathExpression.evaluate(document, XPathConstants.NODE);
            if (result == null) {
                return null;
            }
            if (!(result instanceof Node)) {
                LOGGER.log(Level.FINE, "Node expected for XPath '{0}' but '{1}' returned", new Object[]{xpathExpression, result.getClass().getName()});
                return null;
            }
            return (Node)result;
        }
        catch (XPathExpressionException ex) {
            LOGGER.log(Level.INFO, "XPath error for: " + xpathExpression, ex);
            return null;
        }
    }

    public static void commentNode(Document document, Node node) {
        Node parentNode = node.getParentNode();
        parentNode.replaceChild(document.createComment(XmlUtils.asString(node, false)), node);
    }

    public static String getNodeValue(Document document, Node node) {
        return node.getFirstChild().getNodeValue();
    }

    public static void setNodeValue(Document document, Node node, String newValue) {
        node.getFirstChild().setNodeValue(newValue);
    }

    public static String asString(Node node, boolean formatted) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (formatted) {
                transformer.setOutputProperty("indent", "yes");
            }
            if (!(node instanceof Document)) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (TransformerException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }
}

