/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.hudson.php.commands.PpwScript;
import org.netbeans.modules.hudson.php.options.HudsonOptions;
import org.netbeans.modules.hudson.php.ui.options.Bundle;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HudsonOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -464132465732132L;
    private static final String PPW_LAST_FOLDER_SUFFIX = ".ppw";
    private static final String JOB_CONFIG_LAST_FOLDER_SUFFIX = ".jobConfig";
    private static final String DEFAULT_JOB_CONFIG = HudsonOptions.getInstance().getDefaultJobConfig();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel errorLabel;
    private JButton jobConfigBrowseButton;
    private JButton jobConfigDefaultButton;
    private JLabel jobConfigDownloadLabel;
    private JLabel jobConfigHintLabel;
    private JLabel jobConfigInstallationInfoLabel;
    private JLabel jobConfigLabel;
    private JLabel jobConfigLearnMoreLabel;
    private JLabel jobConfigNoteLabel;
    private JTextField jobConfigTextField;
    private JLabel note1Label;
    private JLabel note2Label;
    private JButton ppwBrowseButton;
    private JLabel ppwHintLabel;
    private JLabel ppwInstallationInfoLabel;
    private JLabel ppwLabel;
    private JLabel ppwLearnMoreLabel;
    private JLabel ppwNoteLabel;
    private JButton ppwSearchButton;
    private JTextField ppwTextField;

    public HudsonOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.ppwHintLabel.setText(Bundle.LBL_PpwHint("ppw", PpwScript.SCRIPT_NAME_LONG));
        this.ppwNoteLabel.setText(Bundle.TXT_PpwNote());
        this.jobConfigHintLabel.setText(Bundle.LBL_JobConfigHint(File.separator));
        this.jobConfigNoteLabel.setText(Bundle.TXT_JobConfigNote());
        this.errorLabel.setText(" ");
        this.checkDefaultButtonState();
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.ppwTextField.getDocument().addDocumentListener(documentListener);
        this.jobConfigTextField.getDocument().addDocumentListener(documentListener);
        this.jobConfigTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HudsonOptionsPanel.this.checkDefaultButtonState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HudsonOptionsPanel.this.checkDefaultButtonState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HudsonOptionsPanel.this.checkDefaultButtonState();
            }
        });
    }

    public String getPpw() {
        return this.ppwTextField.getText();
    }

    public void setPpw(String ppw) {
        this.ppwTextField.setText(ppw);
    }

    public String getJobConfig() {
        return this.jobConfigTextField.getText();
    }

    public void setJobConfig(String jobConfig) {
        this.jobConfigTextField.setText(jobConfig);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    void checkDefaultButtonState() {
        this.jobConfigDefaultButton.setEnabled(!DEFAULT_JOB_CONFIG.equals(this.getJobConfig()));
    }

    private void initComponents() {
        this.ppwLabel = new JLabel();
        this.ppwTextField = new JTextField();
        this.ppwBrowseButton = new JButton();
        this.ppwSearchButton = new JButton();
        this.ppwHintLabel = new JLabel();
        this.note1Label = new JLabel();
        this.ppwNoteLabel = new JLabel();
        this.ppwInstallationInfoLabel = new JLabel();
        this.ppwLearnMoreLabel = new JLabel();
        this.jobConfigLabel = new JLabel();
        this.jobConfigTextField = new JTextField();
        this.jobConfigBrowseButton = new JButton();
        this.jobConfigDefaultButton = new JButton();
        this.jobConfigHintLabel = new JLabel();
        this.note2Label = new JLabel();
        this.jobConfigNoteLabel = new JLabel();
        this.jobConfigInstallationInfoLabel = new JLabel();
        this.jobConfigLearnMoreLabel = new JLabel();
        this.jobConfigDownloadLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.ppwLabel.setLabelFor(this.ppwTextField);
        Mnemonics.setLocalizedText((JLabel)this.ppwLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.ppwLabel.text"));
        this.ppwLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                HudsonOptionsPanel.this.ppwLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                HudsonOptionsPanel.this.ppwLearnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.ppwBrowseButton, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.ppwBrowseButton.text"));
        this.ppwBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HudsonOptionsPanel.this.ppwBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.ppwSearchButton, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.ppwSearchButton.text"));
        this.ppwSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HudsonOptionsPanel.this.ppwSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.ppwHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.note1Label, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.note1Label.text"));
        Mnemonics.setLocalizedText((JLabel)this.ppwNoteLabel, (String)"PPW NOTE");
        Mnemonics.setLocalizedText((JLabel)this.ppwInstallationInfoLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.ppwInstallationInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.ppwLearnMoreLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.ppwLearnMoreLabel.text"));
        this.ppwLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                HudsonOptionsPanel.this.ppwLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                HudsonOptionsPanel.this.ppwLearnMoreLabelMousePressed(evt);
            }
        });
        this.jobConfigLabel.setLabelFor(this.jobConfigTextField);
        Mnemonics.setLocalizedText((JLabel)this.jobConfigLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.jobConfigLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jobConfigBrowseButton, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.jobConfigBrowseButton.text"));
        this.jobConfigBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HudsonOptionsPanel.this.jobConfigBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jobConfigDefaultButton, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.jobConfigDefaultButton.text"));
        this.jobConfigDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HudsonOptionsPanel.this.jobConfigDefaultButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jobConfigHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.note2Label, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.note2Label.text"));
        Mnemonics.setLocalizedText((JLabel)this.jobConfigNoteLabel, (String)"CONFIG NOTE");
        Mnemonics.setLocalizedText((JLabel)this.jobConfigInstallationInfoLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.jobConfigInstallationInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jobConfigLearnMoreLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.jobConfigLearnMoreLabel.text"));
        this.jobConfigLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                HudsonOptionsPanel.this.jobConfigLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                HudsonOptionsPanel.this.jobConfigLearnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jobConfigDownloadLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.jobConfigDownloadLabel.text"));
        this.jobConfigDownloadLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                HudsonOptionsPanel.this.jobConfigDownloadLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                HudsonOptionsPanel.this.jobConfigDownloadLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.ppwLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.ppwHintLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.ppwTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppwBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppwSearchButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addComponent(this.note1Label, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jobConfigLabel).addComponent(this.note2Label, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jobConfigHintLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jobConfigTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jobConfigBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jobConfigDefaultButton)))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ppwInstallationInfoLabel).addComponent(this.ppwLearnMoreLabel, -2, -1, -2).addComponent(this.ppwNoteLabel).addComponent(this.jobConfigNoteLabel).addComponent(this.jobConfigInstallationInfoLabel).addComponent(this.jobConfigLearnMoreLabel, -2, -1, -2).addComponent(this.jobConfigDownloadLabel, -2, -1, -2)).addContainerGap()));
        layout.linkSize(0, this.jobConfigBrowseButton, this.jobConfigDefaultButton, this.ppwBrowseButton, this.ppwSearchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ppwTextField, -2, -1, -2).addComponent(this.ppwLabel).addComponent(this.ppwBrowseButton).addComponent(this.ppwSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppwHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.note1Label, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppwNoteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppwInstallationInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppwLearnMoreLabel, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jobConfigTextField, -2, -1, -2).addComponent(this.jobConfigLabel).addComponent(this.jobConfigBrowseButton).addComponent(this.jobConfigDefaultButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jobConfigHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.note2Label, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jobConfigNoteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jobConfigInstallationInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jobConfigLearnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jobConfigDownloadLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void ppwLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void ppwLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("https://github.com/sebastianbergmann/php-project-wizard"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void ppwBrowseButtonActionPerformed(ActionEvent evt) {
        File ppwScript = new FileChooserBuilder(HudsonOptionsPanel.class.getName() + PPW_LAST_FOLDER_SUFFIX).setTitle(Bundle.LBL_SelectPpw()).setFilesOnly(true).showOpenDialog();
        if (ppwScript != null) {
            ppwScript = FileUtil.normalizeFile((File)ppwScript);
            this.ppwTextField.setText(ppwScript.getAbsolutePath());
        }
    }

    private void ppwSearchButtonActionPerformed(ActionEvent evt) {
        String ppwScript = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])new String[]{"ppw", PpwScript.SCRIPT_NAME_LONG});
            }

            public String getWindowTitle() {
                return Bundle.LBL_PpwScriptsTitle();
            }

            public String getListTitle() {
                return Bundle.LBL_PpwScripts();
            }

            public String getPleaseWaitPart() {
                return Bundle.LBL_PpwScriptsPleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.LBL_NoPpwScriptsFound();
            }
        });
        if (ppwScript != null) {
            this.ppwTextField.setText(ppwScript);
        }
    }

    private void jobConfigLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jobConfigLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://jenkins-php.org/"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void jobConfigDownloadLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jobConfigDownloadLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("https://github.com/sebastianbergmann/php-jenkins-template/blob/master/config.xml"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void jobConfigBrowseButtonActionPerformed(ActionEvent evt) {
        File jobConfig = new FileChooserBuilder(HudsonOptionsPanel.class.getName() + JOB_CONFIG_LAST_FOLDER_SUFFIX).setTitle(Bundle.LBL_SelectJobConfig()).setFilesOnly(true).setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return "config.xml".equals(f.getName());
            }

            @Override
            public String getDescription() {
                return Bundle.TXT_JobConfigDesciption();
            }
        }).showOpenDialog();
        if (jobConfig != null) {
            jobConfig = FileUtil.normalizeFile((File)jobConfig);
            this.jobConfigTextField.setText(jobConfig.getAbsolutePath());
        }
    }

    private void jobConfigDefaultButtonActionPerformed(ActionEvent evt) {
        this.jobConfigTextField.setText(DEFAULT_JOB_CONFIG);
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            HudsonOptionsPanel.this.fireChange();
        }
    }
}

