/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php.support;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.php.support.PhpcpdTarget;
import org.netbeans.modules.hudson.php.support.PhpcsTarget;
import org.netbeans.modules.hudson.php.support.PhpdocTarget;
import org.netbeans.modules.hudson.php.support.PhplocTarget;
import org.netbeans.modules.hudson.php.support.PhpmdTarget;
import org.netbeans.modules.hudson.php.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class Target {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private volatile boolean selected = true;
    private volatile String selectedOption = null;

    Target() {
    }

    public static List<Target> all() {
        return Arrays.asList(new PhpmdTarget(), new PhpcpdTarget(), new PhpcsTarget(), new PhpdocTarget(), new PhplocTarget());
    }

    public abstract String getName();

    public abstract String getTitleWithMnemonic();

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isEnabled() {
        return true;
    }

    public List<String> getOptions() {
        return null;
    }

    public String getSelectedOption() {
        return this.selectedOption;
    }

    public void setSelectedOption(String selectedOption) {
        this.selectedOption = selectedOption;
    }

    public void apply(Map<String, String> commandParams) {
    }

    public boolean apply(Document document) {
        if (this.isSelected()) {
            return true;
        }
        return this.commentNode(document, "//antcall[@target='" + this.getName() + "']");
    }

    protected boolean commentNode(Document document, String xpathExpression) {
        Node node = XmlUtils.query(document, xpathExpression);
        if (node == null) {
            this.logger.log(Level.WARNING, "Node not found for {0}", xpathExpression);
            return false;
        }
        XmlUtils.commentNode(document, node);
        return true;
    }
}

