/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php.options;

import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.hudson.php.commands.PpwScript;
import org.netbeans.modules.php.api.util.FileUtils;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public final class HudsonOptions {
    private static final Logger LOGGER = Logger.getLogger(HudsonOptions.class.getName());
    private static final String PREFERENCES_PATH = "hudson";
    private static final HudsonOptions INSTANCE = new HudsonOptions();
    private static final String PPW = "ppw.path";
    private static final String JOB_CONFIG = "job.config.path";
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile boolean ppwSearched = false;

    private HudsonOptions() {
        this.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                HudsonOptions.this.changeSupport.fireChange();
            }
        });
    }

    public static HudsonOptions getInstance() {
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getPpw() {
        String ppw = this.getPreferences().get(PPW, null);
        if (ppw == null && !this.ppwSearched) {
            this.ppwSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{"ppw", PpwScript.SCRIPT_NAME_LONG});
            if (!scripts.isEmpty()) {
                ppw = (String)scripts.get(0);
                this.setPpw(ppw);
            }
        }
        return ppw;
    }

    public void setPpw(String ppw) {
        this.getPreferences().put(PPW, ppw);
    }

    public String getJobConfig() {
        String config = this.getPreferences().get(JOB_CONFIG, null);
        if (config == null && (config = this.getDefaultJobConfig()) != null) {
            this.setJobConfig(config);
        }
        return config;
    }

    public void setJobConfig(String jobConfig) {
        this.getPreferences().put(JOB_CONFIG, jobConfig);
    }

    public String getDefaultJobConfig() {
        File configFile = InstalledFileLocator.getDefault().locate("hudson/config.xml", "org.netbeans.modules.hudson.php", false);
        if (configFile == null) {
            LOGGER.info("Hudson job config should be bundled with the IDE");
            return null;
        }
        return configFile.getAbsolutePath();
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(HudsonOptions.class).node(PREFERENCES_PATH);
    }
}

