/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php.commands;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.hudson.php.commands.Bundle;
import org.netbeans.modules.hudson.php.options.HudsonOptions;
import org.netbeans.modules.hudson.php.ui.options.HudsonOptionsPanelController;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class PpwScript {
    private static final Logger LOGGER = Logger.getLogger(PpwScript.class.getName());
    public static final String SCRIPT_NAME = "ppw";
    public static final String SCRIPT_NAME_LONG = "ppw" + FileUtils.getScriptExtension((boolean)true);
    public static final String BUILD_XML = "build.xml";
    public static final String PHPUNIT_XML = "phpunit.xml.dist";
    public static final String PHPCS_RULESET_PARAM = "--phpcs";
    public static final List<String> PHPCS_RULESET_OPTIONS = Arrays.asList("PEAR", "Zend", "PHPCS", "Squiz", "MySource");
    private final String ppwPath;

    private PpwScript(String ppwPath) {
        this.ppwPath = ppwPath;
    }

    public static PpwScript getDefault() throws InvalidPhpExecutableException {
        String ppw = HudsonOptions.getInstance().getPpw();
        String error = PpwScript.validate(ppw);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new PpwScript(ppw);
    }

    public static String validate(String command) {
        return PhpExecutableValidator.validateCommand((String)command, (String)Bundle.PpwScript_script_label());
    }

    public boolean createProjectFiles(PhpModule phpModule, Map<String, String> optionalParams) {
        assert (!EventQueue.isDispatchThread());
        String name = phpModule.getDisplayName();
        FileObject projectDirectory = phpModule.getProjectDirectory();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (optionalParams != null) {
            params.putAll(optionalParams);
        }
        params.put("--name", name);
        params.put("--source", this.relativizePath(projectDirectory, phpModule.getSourceDirectory()));
        params.put("--tests", this.relativizePath(projectDirectory, phpModule.getTestDirectory()));
        ArrayList<Object> allParams = new ArrayList<Object>();
        for (Map.Entry entry : params.entrySet()) {
            allParams.add(entry.getKey());
            allParams.add(entry.getValue());
        }
        allParams.add(FileUtil.toFile((FileObject)projectDirectory).getAbsolutePath());
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().optionsPath(HudsonOptionsPanelController.getOptionsPath());
        try {
            Integer status = new PhpExecutable(this.ppwPath).additionalParameters(allParams).runAndWait(executionDescriptor, "Creating project files");
            if (status != null) {
                projectDirectory.refresh();
                return status == 0;
            }
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return false;
    }

    private String relativizePath(FileObject parent, FileObject child) {
        if (parent.equals(child)) {
            return ".";
        }
        String relativePath = FileUtil.getRelativePath((FileObject)parent, (FileObject)child);
        if (relativePath != null) {
            return relativePath;
        }
        return FileUtil.toFile((FileObject)child).getAbsolutePath();
    }
}

