/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hudson.php.Bundle;
import org.netbeans.modules.hudson.php.commands.PpwScript;
import org.netbeans.modules.hudson.php.options.HudsonOptions;
import org.netbeans.modules.hudson.php.options.HudsonOptionsValidator;
import org.netbeans.modules.hudson.php.support.Target;
import org.netbeans.modules.hudson.php.xml.XmlUtils;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.UiUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class HudsonJobCreator
extends JPanel
implements ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator,
ChangeListener {
    private static final long serialVersionUID = -668435132135465L;
    private static final Logger LOGGER = Logger.getLogger(HudsonJobCreator.class.getName());
    final List<Target> targets;
    private final PhpModule phpModule;
    private final HudsonSCM.Configuration scm;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    private HudsonJobCreator(PhpModule phpModule) {
        this.phpModule = phpModule;
        this.scm = ProjectHudsonJobCreatorFactory.Helper.prepareSCM((File)FileUtil.toFile((FileObject)phpModule.getProjectDirectory()));
        this.targets = this.initComponents();
    }

    private static HudsonJobCreator forPhpModule(PhpModule phpModule) {
        HudsonJobCreator hudsonJobCreator = new HudsonJobCreator(phpModule);
        HudsonOptions options = HudsonOptions.getInstance();
        options.addChangeListener(WeakListeners.change((ChangeListener)hudsonJobCreator, (Object)options));
        return hudsonJobCreator;
    }

    public String jobName() {
        return this.phpModule.getDisplayName();
    }

    public JComponent customizer() {
        return this;
    }

    public ProjectHudsonJobCreatorFactory.ConfigurationStatus status() {
        if (this.phpModule.getTestDirectory() == null) {
            return ProjectHudsonJobCreatorFactory.ConfigurationStatus.withError((String)Bundle.HudsonJobCreator_error_noTests());
        }
        if (this.scm == null) {
            return ProjectHudsonJobCreatorFactory.Helper.noSCMError();
        }
        try {
            PpwScript.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            return ProjectHudsonJobCreatorFactory.ConfigurationStatus.withError((String)Bundle.HudsonJobCreator_error_invalidHudsonOptions()).withExtraButton(this.getOpenHudsonOptionsButton());
        }
        if (HudsonOptionsValidator.validateJobConfig(this.getJobConfig()) != null) {
            return ProjectHudsonJobCreatorFactory.ConfigurationStatus.withError((String)Bundle.HudsonJobCreator_error_invalidHudsonOptions()).withExtraButton(this.getOpenHudsonOptionsButton());
        }
        FileObject buildXml = this.phpModule.getProjectDirectory().getFileObject("build.xml");
        if (buildXml != null && buildXml.isData()) {
            return ProjectHudsonJobCreatorFactory.ConfigurationStatus.withError((String)Bundle.HudsonJobCreator_error_buildXmlExists());
        }
        FileObject phpUnitConfig = this.phpModule.getProjectDirectory().getFileObject("phpunit.xml.dist");
        if (phpUnitConfig != null && phpUnitConfig.isData()) {
            return ProjectHudsonJobCreatorFactory.ConfigurationStatus.withError((String)Bundle.HudsonJobCreator_error_phpUnitConfigExists());
        }
        ProjectHudsonJobCreatorFactory.ConfigurationStatus scmStatus = this.scm.problems();
        if (scmStatus != null) {
            return scmStatus;
        }
        return ProjectHudsonJobCreatorFactory.ConfigurationStatus.valid();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public Document configure() throws IOException {
        this.setupProject();
        return this.createJobXml();
    }

    private String getJobConfig() {
        return HudsonOptions.getInstance().getJobConfig();
    }

    private JButton getOpenHudsonOptionsButton() {
        JButton button = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)button, (String)Bundle.HudsonJobCreator_button_labelWithMnemonics());
        button.getAccessibleContext().setAccessibleDescription(Bundle.HudsonJobCreator_button_a11y());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UiUtils.showOptions((String)"Hudson");
            }
        });
        return button;
    }

    private void setupProject() throws IOException {
        try {
            LinkedHashMap<String, String> targetParams = new LinkedHashMap<String, String>();
            for (Target target : this.targets) {
                target.apply(targetParams);
            }
            if (PpwScript.getDefault().createProjectFiles(this.phpModule, targetParams)) {
                this.processBuildXml();
            } else {
                this.errorOccured(Bundle.HudsonJobCreator_error_ppw(), "The project files were not generated by PPW script", this.getOpenHudsonOptionsButton());
            }
        }
        catch (InvalidPhpExecutableException ex) {
            LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    private Document createJobXml() throws IOException {
        Document document;
        try {
            document = XmlUtils.parse(new File(this.getJobConfig()));
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
        this.removeNodes(document, "/project/scm", "/project/triggers", "/project/logRotator");
        this.scm.configure(document);
        ProjectHudsonJobCreatorFactory.Helper.addLogRotator((Document)document);
        Node disabled = XmlUtils.query(document, "/project/disabled");
        if (disabled != null) {
            XmlUtils.setNodeValue(document, disabled, "false");
        }
        return document;
    }

    private void removeNodes(Document document, String ... xpathExpressions) {
        for (String xpathExpression : xpathExpressions) {
            Node node = XmlUtils.query(document, xpathExpression);
            if (node == null) continue;
            node.getParentNode().removeChild(node);
        }
    }

    private void processBuildXml() throws IOException {
        boolean success = true;
        File buildXml = new File(FileUtil.toFile((FileObject)this.phpModule.getProjectDirectory()), "build.xml");
        try {
            Document document = XmlUtils.parse(buildXml);
            for (Target target : this.targets) {
                if (target.apply(document)) continue;
                success = false;
            }
            if (success) {
                XmlUtils.save(document, buildXml);
            }
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
        if (!success) {
            this.warningOccured(Bundle.HudsonJobCreator_error_config());
        }
    }

    private void warningOccured(String warning) {
        this.informUser(warning, false, null);
    }

    private void errorOccured(String error, String logMessage, JButton extraButton) throws IOException {
        this.informUser(error, true, extraButton);
        throw new ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator.SilentIOException(logMessage);
    }

    private void informUser(String message, boolean error, JButton extraButton) {
        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)message, error ? 0 : 2);
        if (extraButton != null) {
            descriptor.setAdditionalOptions(new Object[]{extraButton});
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
    }

    private List<Target> initComponents() {
        this.setLayout(new GridBagLayout());
        List<Target> allTargets = Target.all();
        int i = 0;
        for (Target target : allTargets) {
            this.initTargetComponent(i++, target);
        }
        this.finishLayout(i);
        return allTargets;
    }

    private void initTargetComponent(int row, final Target target) {
        JComboBox<String> combo;
        JCheckBox checkBox = new JCheckBox();
        checkBox.setSelected(target.isSelected());
        checkBox.setEnabled(target.isEnabled());
        Mnemonics.setLocalizedText((AbstractButton)checkBox, (String)target.getTitleWithMnemonic());
        checkBox.getAccessibleContext().setAccessibleDescription(Bundle.HudsonJobCreator_checkbox_a11y(target.getName()));
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                target.setSelected(e.getStateChange() == 1);
            }
        });
        List<String> options = target.getOptions();
        JComboBox<String> jComboBox = combo = options != null ? new JComboBox<String>() : null;
        if (combo != null) {
            combo.setModel(new DefaultComboBoxModel<String>(options.toArray(new String[options.size()])));
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    combo.setEnabled(e.getStateChange() == 1);
                }
            });
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    target.setSelectedOption((String)combo.getSelectedItem());
                }
            });
            combo.setSelectedIndex(0);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = row;
        gridBagConstraints.anchor = 21;
        if (combo != null) {
            gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        }
        this.add((Component)checkBox, gridBagConstraints);
        if (combo != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = row;
            gridBagConstraints.insets = new Insets(2, 2, 0, 5);
            this.add(combo, gridBagConstraints);
        }
    }

    private void finishLayout(int lastRow) {
        JLabel spaceHolder = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = lastRow + 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)spaceHolder, gridBagConstraints);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    public static class Factory
    implements ProjectHudsonJobCreatorFactory {
        public ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator forProject(Project project) {
            PhpModule phpModule = (PhpModule)project.getLookup().lookup(PhpModule.class);
            if (phpModule == null) {
                return null;
            }
            return HudsonJobCreator.forPhpModule(phpModule);
        }
    }
}

