/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.locals;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.netbeans.modules.web.javascript.debugger.ViewModelSupport;
import org.netbeans.modules.web.javascript.debugger.eval.EvaluatorService;
import org.netbeans.modules.web.javascript.debugger.locals.Bundle;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.PropertyDescriptor;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Scope;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

public class VariablesModel
extends ViewModelSupport
implements TreeModel,
ExtendedNodeModel,
TableModel,
Debugger.Listener,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(VariablesModel.class.getName());
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png";
    public static final String GLOBAL = "org/netbeans/modules/web/javascript/debugger/resources/global_variable_16.png";
    public static final String PROTO = "org/netbeans/modules/web/javascript/debugger/resources/proto_variable_16.png";
    protected final Debugger debugger;
    protected final EvaluatorService evaluator;
    private ScopedRemoteObject globalScopeVar;
    protected final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private AtomicReference<CallFrame> currentStack = new AtomicReference();
    private Map<RemoteObject, List<ScopedRemoteObject>> variablesCache = new HashMap<RemoteObject, List<ScopedRemoteObject>>();
    private RequestProcessor RP = new RequestProcessor(VariablesModel.class.getName());

    public VariablesModel(ContextProvider contextProvider) {
        this.debugger = (Debugger)contextProvider.lookupFirst(null, Debugger.class);
        this.evaluator = (EvaluatorService)contextProvider.lookupFirst(null, EvaluatorService.class);
        this.debugger.addListener((Debugger.Listener)this);
        this.debugger.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.debugger.isSuspended()) {
            this.currentStack.set(this.debugger.getCurrentCallFrame());
        } else {
            this.currentStack.set(null);
        }
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        CallFrame frame = this.currentStack.get();
        if (frame == null) {
            return new Object[0];
        }
        if (parent == "Root") {
            return this.getVariables(frame).subList(from, to).toArray();
        }
        if (parent instanceof ScopedRemoteObject) {
            return this.getProperties((ScopedRemoteObject)parent).toArray();
        }
        throw new UnknownTypeException(parent);
    }

    protected CallFrame getCurrentStack() {
        return this.currentStack.get();
    }

    private List<ScopedRemoteObject> getVariables(CallFrame frame) {
        ArrayList<ScopedRemoteObject> vars = new ArrayList<ScopedRemoteObject>();
        for (Scope scope : frame.getScopes()) {
            RemoteObject obj = scope.getScopeObject();
            if (scope.isLocalScope()) {
                vars.addAll(this.getProperties(obj, ViewScope.LOCAL));
                continue;
            }
            if (!scope.isGlobalScope()) continue;
            vars.add(this.getGlobalScopeVariable(obj, scope));
        }
        return this.sortVariables(vars);
    }

    private ScopedRemoteObject getGlobalScopeVariable(RemoteObject obj, Scope scope) {
        if (this.globalScopeVar == null) {
            this.globalScopeVar = new ScopedRemoteObject(obj, scope);
        }
        return this.globalScopeVar;
    }

    private List<ScopedRemoteObject> sortVariables(List<ScopedRemoteObject> vars) {
        Collections.sort(vars, new Comparator<ScopedRemoteObject>(){

            @Override
            public int compare(ScopedRemoteObject o1, ScopedRemoteObject o2) {
                int i = o1.getScope().compareTo(o2.getScope());
                if (i != 0) {
                    return i;
                }
                return o1.getObjectName().compareToIgnoreCase(o2.getObjectName());
            }
        });
        return vars;
    }

    private Collection<? extends ScopedRemoteObject> getProperties(ScopedRemoteObject var) {
        return this.getProperties(var.getRemoteObject(), ViewScope.DEFAULT);
    }

    private Collection<? extends ScopedRemoteObject> getProperties(RemoteObject prop, ViewScope scope) {
        List<ScopedRemoteObject> res = this.variablesCache.get(prop);
        if (res != null) {
            return res;
        }
        res = new ArrayList<ScopedRemoteObject>();
        this.variablesCache.put(prop, res);
        if (prop.getType() == RemoteObject.Type.OBJECT) {
            for (PropertyDescriptor desc : prop.getProperties()) {
                if (desc.getValue() == null || desc.getValue().getType() == RemoteObject.Type.FUNCTION) continue;
                res.add(new ScopedRemoteObject(desc.getValue(), desc.getName(), scope));
            }
        }
        return this.sortVariables(res);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof ScopedRemoteObject) {
            RemoteObject var = ((ScopedRemoteObject)node).getRemoteObject();
            if (var.getType() == RemoteObject.Type.OBJECT) {
                if (var.hasFetchedProperties()) {
                    return var.getProperties().isEmpty();
                }
                this.updateNodeOnBackground(node, var);
                return true;
            }
            return true;
        }
        throw new UnknownTypeException(node);
    }

    protected void updateNodeOnBackground(final Object node, final RemoteObject var) {
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                if (VariablesModel.this.getCurrentStack() == null) {
                    return;
                }
                var.getProperties();
                VariablesModel.this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, node, 16));
            }
        });
    }

    public int getChildrenCount(Object parent) throws UnknownTypeException {
        CallFrame frame = this.currentStack.get();
        if (frame == null) {
            return 0;
        }
        if (parent == "Root") {
            return this.getVariables(frame).size();
        }
        if (parent instanceof ScopedRemoteObject) {
            return this.getProperties((ScopedRemoteObject)parent).size();
        }
        throw new UnknownTypeException(parent);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Bundle.VariablesModel_Name();
        }
        if (node instanceof ScopedRemoteObject) {
            return ((ScopedRemoteObject)node).getObjectName();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException();
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        assert (node != "Root");
        if (node instanceof ScopedRemoteObject) {
            ScopedRemoteObject sv = (ScopedRemoteObject)node;
            switch (sv.getScope()) {
                case GLOBAL: {
                    return GLOBAL;
                }
                case PROTO: {
                    return PROTO;
                }
            }
            return LOCAL;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Bundle.VariablesModel_Desc();
        }
        if (node instanceof ScopedRemoteObject) {
            return ((ScopedRemoteObject)node).getObjectName();
        }
        throw new UnknownTypeException(node);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node == "Root") {
            return "";
        }
        if (node instanceof ScopedRemoteObject) {
            RemoteObject var = ((ScopedRemoteObject)node).getRemoteObject();
            if ("LocalsValue".equals(columnID)) {
                String value = var.getValueAsString();
                if (value.isEmpty() && var.getType() == RemoteObject.Type.OBJECT) {
                    value = var.getDescription();
                }
                return value;
            }
            if ("LocalsType".equals(columnID)) {
                if (var.getType() == RemoteObject.Type.OBJECT) {
                    String clazz = var.getClassName();
                    if (clazz == null) {
                        return var.getType().getName();
                    }
                    return clazz;
                }
                return var.getType().getName();
            }
            if ("LocalsToString".equals(columnID)) {
                return var.getValueAsString();
            }
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if ("LocalsValue".equals(columnID) && node instanceof ScopedRemoteObject || "WatchValue".equals(columnID) && node instanceof ScopedRemoteObject) {
            return true;
        }
        return true;
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        if ("LocalsValue".equals(columnID) && node instanceof ScopedRemoteObject) {
            ScopedRemoteObject sro = (ScopedRemoteObject)node;
            this.evaluator.evaluateExpression(this.getCurrentStack(), sro.getObjectName() + "=" + value + ";", false);
            this.refresh();
        }
        throw new UnknownTypeException(node);
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void paused(List<CallFrame> callStack, String reason) {
        this.currentStack.set(this.debugger.getCurrentCallFrame());
        this.refresh();
    }

    public void resumed() {
        this.currentStack.set(null);
        this.variablesCache = new HashMap<RemoteObject, List<ScopedRemoteObject>>();
        this.globalScopeVar = null;
        this.refresh();
    }

    public void reset() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("currentFrame".equals(propertyName)) {
            this.currentStack.set(this.debugger.getCurrentCallFrame());
            this.refresh();
        }
    }

    public static enum ViewScope {
        LOCAL,
        GLOBAL,
        DEFAULT,
        PROTO;

    }

    public static class ScopedRemoteObject {
        private RemoteObject var;
        private ViewScope scope;
        private String objectName;

        public ScopedRemoteObject(RemoteObject var, String name) {
            this(var, name, ViewScope.DEFAULT);
        }

        public ScopedRemoteObject(RemoteObject var, Scope sc) {
            this.var = var;
            if (sc.isLocalScope()) {
                this.scope = ViewScope.LOCAL;
                this.objectName = "Local";
            } else {
                this.scope = ViewScope.GLOBAL;
                this.objectName = "Global";
            }
        }

        public ScopedRemoteObject(RemoteObject var, String name, ViewScope scope) {
            this.var = var;
            this.scope = scope;
            this.objectName = name;
        }

        public ViewScope getScope() {
            if ("__proto__".equals(this.objectName)) {
                return ViewScope.PROTO;
            }
            return this.scope;
        }

        public RemoteObject getRemoteObject() {
            return this.var;
        }

        public String getObjectName() {
            return this.objectName;
        }
    }
}

