/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.eval.ui;

import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.web.javascript.debugger.eval.ui.CodeEvaluator;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.openide.util.NbPreferences;

public class EvaluatorLifecycle
extends DebuggerManagerAdapter {
    private static final String EVALUATOR_LIFECYCLE_PROPERTIES = "EvaluatorLifecycle";
    private static final String EVALUATOR_OPENED = "EvaluatorOpened";
    private Preferences preferences = NbPreferences.forModule(EvaluatorLifecycle.class).node("EvaluatorLifecycle");

    public void engineAdded(DebuggerEngine engine) {
        boolean opened;
        Debugger d = (Debugger)engine.lookupFirst("", Debugger.class);
        if (d != null && (opened = this.preferences.getBoolean(EVALUATOR_OPENED, false))) {
            this.openOrClose(true);
        }
    }

    public void engineRemoved(DebuggerEngine engine) {
        Debugger d = (Debugger)engine.lookupFirst("", Debugger.class);
        if (d != null) {
            this.openOrClose(false);
        }
    }

    private void openOrClose(final boolean open) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (open) {
                    CodeEvaluator.getInstance().open();
                } else {
                    boolean opened = CodeEvaluator.getInstance().isOpened();
                    EvaluatorLifecycle.this.preferences.putBoolean(EvaluatorLifecycle.EVALUATOR_OPENED, opened);
                    if (opened) {
                        CodeEvaluator.getInstance().close();
                    }
                }
            }
        });
    }
}

