/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.eval.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.modules.web.javascript.debugger.eval.ui.Bundle;
import org.netbeans.modules.web.javascript.debugger.locals.VariablesModel;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CodeEvaluator
extends TopComponent
implements HelpCtx.Provider,
DocumentListener,
KeyListener,
PropertyChangeListener,
Debugger.Listener {
    private static final String ID = "debuggerJSevaluator";
    private static final String PROP_RESULT_CHANGED = "resultChanged";
    private static final String PREFERENCES_NAME = "variables_view";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static WeakReference<CodeEvaluator> instanceRef;
    private JEditorPane codePane;
    private volatile String codeText = "";
    private History history;
    private Reference<Debugger> debuggerRef = new WeakReference<Object>(null);
    private DbgManagerListener dbgManagerListener;
    private TopComponent resultView;
    private Set<String> editItemsSet = new HashSet<String>();
    private ArrayList<String> editItemsList = new ArrayList();
    private JButton dropDownButton;
    private Preferences preferences = NbPreferences.forModule(ContextProvider.class).node("variables_view");
    private HistoryRecord lastEvaluationRecord = null;
    private VariablesModel.ScopedRemoteObject result;
    private static RequestProcessor rp;
    private RequestProcessor.Task evalTask = rp.create((Runnable)new EvaluateTask());
    private RequestProcessor.Task setupContextTask;
    private JScrollPane editorScrollPane;
    private JButton evaluateButton;
    private JPanel rightPanel;
    private JPanel separatorPanel;

    public CodeEvaluator() {
        this.initComponents();
        this.codePane = new JEditorPane();
        this.codePane.setMinimumSize(new Dimension(0, 0));
        this.history = new History();
        this.dropDownButton = this.createDropDownButton();
        GroupLayout rightPanelLayout = new GroupLayout(this.rightPanel);
        this.rightPanel.setLayout(rightPanelLayout);
        rightPanelLayout.setHorizontalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.dropDownButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2)).addGroup(rightPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2).addComponent(this.evaluateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2)));
        rightPanelLayout.setVerticalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPanelLayout.createSequentialGroup().addComponent(this.dropDownButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.evaluateButton)));
        this.editorScrollPane.setViewportView(this.codePane);
        this.codePane.addKeyListener(this);
        this.dbgManagerListener = new DbgManagerListener(this);
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", (DebuggerManagerListener)this.dbgManagerListener);
        this.checkDebuggerState();
    }

    public static RequestProcessor getRequestProcessor() {
        return rp;
    }

    public void pasteExpression(String expr) {
        this.codePane.setText(expr);
        this.codeText = expr;
        if (!this.isOpened()) {
            this.open();
        }
        this.requestActive();
    }

    private JButton createDropDownButton() {
        ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/javascript/debugger/resources/drop_down_arrow.png", (boolean)false);
        DropDownButton button = new DropDownButton();
        button.setIcon(icon);
        String tooltipText = Bundle.CTL_Expressions_Dropdown_tooltip();
        button.setToolTipText(tooltipText);
        button.setEnabled(false);
        Dimension size = new Dimension(icon.getIconWidth() + 3, icon.getIconHeight() + 2);
        button.setPreferredSize(size);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusable(false);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("pressed".equals(e.getActionCommand())) {
                    JComponent jc = (JComponent)e.getSource();
                    CodeEvaluator.this.createEditItemsPopup().show(jc, 0, jc.getHeight());
                    if (jc instanceof AbstractButton) {
                        AbstractButton jb = (AbstractButton)jc;
                        jb.getModel().setPressed(false);
                        jb.getModel().setRollover(false);
                        jb.getModel().setArmed(false);
                        jb.repaint();
                    }
                }
            }

            @Override
            public boolean isEnabled() {
                return !CodeEvaluator.this.editItemsList.isEmpty();
            }
        };
        action.putValue("SmallIcon", icon);
        action.putValue("ShortDescription", tooltipText);
        button.setAction(action);
        return button;
    }

    private void setupContext() {
        if (this.setupContextTask == null) {
            this.setupContextTask = rp.create(new Runnable(){

                @Override
                public void run() {
                    CodeEvaluator.this.setupContextLazily();
                }
            });
        }
        this.setupContextTask.schedule(500);
    }

    private void setupContextLazily() {
        final String text = this.codeText;
        final Document[] documentPtr = new Document[]{null};
        class ContextUpdated
        implements ActionListener,
        Runnable {
            ContextUpdated() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.run();
            }

            @Override
            public void run() {
                if (CodeEvaluator.this.codePane.getDocument() != documentPtr[0]) {
                    CodeEvaluator.this.codePane.getDocument().addDocumentListener(CodeEvaluator.this);
                    if (text != null) {
                        CodeEvaluator.this.codePane.setText(text);
                    }
                }
                documentPtr[0] = CodeEvaluator.this.codePane.getDocument();
            }
        }
        ContextUpdated contextUpdated = new ContextUpdated();
        MiscEditorUtil.setupContext(this.codePane, contextUpdated);
        SwingUtilities.invokeLater(contextUpdated);
    }

    private JPopupMenu createEditItemsPopup() {
        JPopupMenu popup = new JPopupMenu();
        ActionListener editItemAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem mi = (JMenuItem)e.getSource();
                String text = mi.getText();
                CodeEvaluator.this.codePane.setText(text);
                CodeEvaluator.this.codeText = text;
            }
        };
        for (String item : this.editItemsList) {
            JMenuItem editItem = new JMenuItem(item);
            editItem.addActionListener(editItemAction);
            popup.add(editItem);
        }
        return popup;
    }

    public void recomputeDropDownItems() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String str : CodeEvaluator.this.editItemsList) {
                    StringTokenizer tok = new StringTokenizer(str, "\n");
                    String dispName = "";
                    while (dispName.trim().length() == 0 && tok.hasMoreTokens()) {
                        dispName = tok.nextToken();
                    }
                }
                CodeEvaluator.this.dropDownButton.setEnabled(!CodeEvaluator.this.editItemsList.isEmpty());
            }
        });
    }

    public static synchronized CodeEvaluator getInstance() {
        CodeEvaluator instance = (CodeEvaluator)WindowManager.getDefault().findTopComponent(ID);
        if (instance == null) {
            instance = new CodeEvaluator();
        }
        return instance;
    }

    private static CodeEvaluator getDefaultInstance() {
        CodeEvaluator evaluator;
        CodeEvaluator codeEvaluator = evaluator = instanceRef != null ? (CodeEvaluator)instanceRef.get() : null;
        if (evaluator != null) {
            return evaluator;
        }
        final CodeEvaluator[] result = new CodeEvaluator[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = CodeEvaluator.getInstance();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = CodeEvaluator.getInstance();
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        instanceRef = new WeakReference<CodeEvaluator>(result[0]);
        return result[0];
    }

    public static ArrayList<History.Item> getHistory() {
        CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
        return defaultInstance != null ? defaultInstance.history.getItems() : new ArrayList<History.Item>();
    }

    public static VariablesModel.ScopedRemoteObject getResult() {
        CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
        return defaultInstance != null ? defaultInstance.result : null;
    }

    public static String getExpressionText() {
        CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
        HistoryRecord rec = defaultInstance != null ? defaultInstance.lastEvaluationRecord : null;
        return rec != null ? rec.expr : "";
    }

    public static void addResultListener(final PropertyChangeListener listener) {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
                if (defaultInstance != null) {
                    PropertyChangeSupport propertyChangeSupport = defaultInstance.pcs;
                    synchronized (propertyChangeSupport) {
                        defaultInstance.pcs.addPropertyChangeListener(listener);
                    }
                }
            }
        });
    }

    public static void removeResultListener(final PropertyChangeListener listener) {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
                if (defaultInstance != null) {
                    PropertyChangeSupport propertyChangeSupport = defaultInstance.pcs;
                    synchronized (propertyChangeSupport) {
                        defaultInstance.pcs.removePropertyChangeListener(listener);
                    }
                }
            }
        });
    }

    private static void fireResultChange() {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluator defaultInstance = CodeEvaluator.getDefaultInstance();
                if (defaultInstance != null) {
                    PropertyChangeSupport propertyChangeSupport = defaultInstance.pcs;
                    synchronized (propertyChangeSupport) {
                        defaultInstance.pcs.firePropertyChange(CodeEvaluator.PROP_RESULT_CHANGED, null, null);
                    }
                }
            }
        });
    }

    private synchronized void checkDebuggerState() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Debugger lastDebugger;
                DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
                Debugger debugger = null;
                if (de != null) {
                    debugger = (Debugger)de.lookupFirst(null, Debugger.class);
                }
                if (debugger != (lastDebugger = (Debugger)CodeEvaluator.this.debuggerRef.get())) {
                    CodeEvaluator.this.setupContext();
                }
                if (lastDebugger != null && debugger != lastDebugger) {
                    lastDebugger.removePropertyChangeListener((PropertyChangeListener)CodeEvaluator.this);
                    lastDebugger.removeListener((Debugger.Listener)CodeEvaluator.this);
                    CodeEvaluator.this.debuggerRef = new WeakReference<Object>(null);
                    CodeEvaluator.this.displayResult(null);
                }
                if (debugger != null) {
                    CodeEvaluator.this.debuggerRef = new WeakReference<Debugger>(debugger);
                    debugger.addListener((Debugger.Listener)CodeEvaluator.this);
                    debugger.addPropertyChangeListener((PropertyChangeListener)CodeEvaluator.this);
                } else {
                    CodeEvaluator.this.history.clear();
                }
                CodeEvaluator.this.computeEvaluationButtonState();
            }
        });
    }

    private void computeEvaluationButtonState() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodeEvaluator.this.computeEvaluationButtonState();
                }
            });
            return;
        }
        Debugger debugger = this.debuggerRef.get();
        boolean isEnabled = debugger != null && debugger.isEnabled() && debugger.isSuspended() && debugger.getCurrentCallFrame() != null && this.codePane.getDocument().getLength() > 0 && this.editorScrollPane.getViewport().getView() == this.codePane;
        this.evaluateButton.setEnabled(isEnabled);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this.dbgManagerListener);
    }

    private void initComponents() {
        this.evaluateButton = new JButton();
        this.editorScrollPane = new JScrollPane();
        this.separatorPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.evaluateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/web/javascript/debugger/resources/evaluate.png")));
        this.evaluateButton.setToolTipText(NbBundle.getMessage(CodeEvaluator.class, (String)"HINT_Evaluate_Button"));
        this.evaluateButton.setEnabled(false);
        this.evaluateButton.setPreferredSize(new Dimension(38, 22));
        this.evaluateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeEvaluator.this.evaluateButtonActionPerformed(evt);
            }
        });
        this.editorScrollPane.setBorder(null);
        this.separatorPanel.setBackground(UIManager.getDefaults().getColor("Separator.foreground"));
        this.separatorPanel.setMaximumSize(new Dimension(1, Short.MAX_VALUE));
        this.separatorPanel.setMinimumSize(new Dimension(1, 10));
        this.separatorPanel.setPreferredSize(new Dimension(1, 10));
        this.rightPanel.setMinimumSize(new Dimension(0, 0));
        this.rightPanel.setPreferredSize(new Dimension(48, 0));
        GroupLayout rightPanelLayout = new GroupLayout(this.rightPanel);
        this.rightPanel.setLayout(rightPanelLayout);
        rightPanelLayout.setHorizontalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 48, Short.MAX_VALUE));
        rightPanelLayout.setVerticalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 22, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.editorScrollPane, -1, 450, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.separatorPanel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.rightPanel, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editorScrollPane, -1, 22, Short.MAX_VALUE).addComponent(this.separatorPanel, -1, 22, Short.MAX_VALUE).addComponent(this.rightPanel, -1, 22, Short.MAX_VALUE));
    }

    private void evaluateButtonActionPerformed(ActionEvent evt) {
        this.evaluate();
    }

    public static void openEvaluator() {
        String selectedText = null;
        JEditorPane editor = EditorContextDispatcher.getDefault().getMostRecentEditor();
        if (editor != null) {
            selectedText = editor.getSelectedText();
        }
        CodeEvaluator evaluator = CodeEvaluator.getInstance();
        evaluator.open();
        if (selectedText != null) {
            evaluator.codePane.setText(selectedText);
            evaluator.codeText = selectedText;
        }
        evaluator.codePane.selectAll();
        evaluator.requestActive();
    }

    public boolean requestFocusInWindow() {
        this.codePane.requestFocusInWindow();
        return super.requestFocusInWindow();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return Bundle.CTL_Code_Evaluator_name();
    }

    public String getToolTipText() {
        return Bundle.CTL_Code_Evaluator_tooltip();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("EvaluateCode");
    }

    public String getExpression() {
        return this.codeText;
    }

    public void evaluate() {
        this.evalTask.schedule(10);
    }

    private void displayResult(VariablesModel.ScopedRemoteObject var) {
        this.result = var;
        if (var == null) {
            CodeEvaluator.fireResultChange();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CodeEvaluator.this.preferences.getBoolean("show_evaluator_result", true)) {
                    TopComponent view = WindowManager.getDefault().findTopComponent("localsView");
                    view.open();
                    view.requestActive();
                } else {
                    if (CodeEvaluator.this.resultView == null) {
                        CodeEvaluator.this.resultView = CodeEvaluator.this.getResultViewInstance();
                    }
                    if (CodeEvaluator.this.result != null) {
                        CodeEvaluator.this.resultView.open();
                        CodeEvaluator.this.resultView.requestActive();
                    }
                }
                CodeEvaluator.getInstance().requestActive();
                CodeEvaluator.fireResultChange();
            }
        });
    }

    private void addResultToHistory(final String expr, VariablesModel.ScopedRemoteObject result) {
        if (this.lastEvaluationRecord != null) {
            this.history.addItem(this.lastEvaluationRecord.expr, this.lastEvaluationRecord.type, this.lastEvaluationRecord.value, this.lastEvaluationRecord.toString);
        }
        if (result != null) {
            String type = result.getRemoteObject().getClassName();
            String value = result.getRemoteObject().getDescription();
            this.lastEvaluationRecord = new HistoryRecord(expr, type, value, value);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String expr2 = expr.trim();
                if (CodeEvaluator.this.editItemsSet.contains(expr2)) {
                    CodeEvaluator.this.editItemsList.remove(expr2);
                    CodeEvaluator.this.editItemsList.add(0, expr2);
                } else {
                    CodeEvaluator.this.editItemsList.add(0, expr2);
                    CodeEvaluator.this.editItemsSet.add(expr2);
                    if (CodeEvaluator.this.editItemsList.size() > 20) {
                        String removed = (String)CodeEvaluator.this.editItemsList.remove(CodeEvaluator.this.editItemsList.size() - 1);
                        CodeEvaluator.this.editItemsSet.remove(removed);
                    }
                }
                CodeEvaluator.this.recomputeDropDownItems();
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && e.isControlDown()) {
            e.consume();
            if (this.debuggerRef.get() != null) {
                this.evaluate();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    private void updateWatch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeEvaluator.this.computeEvaluationButtonState();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if ("currentFrame".equals(propertyName)) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CodeEvaluator codeEvaluator = CodeEvaluator.this;
                    synchronized (codeEvaluator) {
                        Debugger debugger = (Debugger)CodeEvaluator.this.debuggerRef.get();
                        if (debugger != null) {
                            CodeEvaluator.this.computeEvaluationButtonState();
                            CodeEvaluator.this.setupContext();
                        }
                    }
                }
            });
        }
    }

    public void paused(List<CallFrame> callStack, String reason) {
        this.setupContext();
        this.computeEvaluationButtonState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumed() {
        CodeEvaluator codeEvaluator = this;
        synchronized (codeEvaluator) {
            if (this.result != null) {
                this.history.addItem(this.lastEvaluationRecord.expr, this.lastEvaluationRecord.type, this.lastEvaluationRecord.value, this.lastEvaluationRecord.toString);
                this.lastEvaluationRecord = null;
                this.result = null;
                CodeEvaluator.fireResultChange();
            }
        }
        this.computeEvaluationButtonState();
    }

    public void reset() {
        this.resumed();
    }

    private synchronized TopComponent getResultViewInstance() {
        TopComponent instance = WindowManager.getDefault().findTopComponent("resultsView");
        return instance;
    }

    static {
        rp = new RequestProcessor("Debugger Evaluator", 1);
    }

    private static class HistoryRecord {
        String expr;
        String type;
        String value;
        String toString;

        HistoryRecord(String expr, String type, String value, String toString) {
            this.expr = expr;
            this.type = type;
            this.value = value;
            this.toString = toString;
        }
    }

    private static class DropDownButton
    extends JButton {
        private DropDownButton() {
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            if (this.isEnabled() && me.getID() == 501) {
                this.getAction().actionPerformed(new ActionEvent(this, 1001, "pressed"));
            }
        }

        protected String getTabActionCommand(ActionEvent e) {
            return null;
        }

        void performAction(ActionEvent e) {
        }
    }

    private static class DbgManagerListener
    extends DebuggerManagerAdapter {
        private Reference<CodeEvaluator> codeEvaluatorRef;

        public DbgManagerListener(CodeEvaluator evaluator) {
            this.codeEvaluatorRef = new WeakReference<CodeEvaluator>(evaluator);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            CodeEvaluator evaluator = this.codeEvaluatorRef.get();
            if (evaluator != null) {
                evaluator.checkDebuggerState();
            }
        }
    }

    private class EvaluateTask
    implements Runnable {
        private EvaluateTask() {
        }

        @Override
        public void run() {
            CallFrame frame;
            String exp = CodeEvaluator.this.getExpression();
            if (exp == null || "".equals(exp)) {
                return;
            }
            Debugger debugger = (Debugger)CodeEvaluator.this.debuggerRef.get();
            if (debugger != null && (frame = debugger.getCurrentCallFrame()) != null) {
                RemoteObject ro = frame.evaluate(exp);
                VariablesModel.ScopedRemoteObject var = ro != null ? new VariablesModel.ScopedRemoteObject(ro, exp, VariablesModel.ViewScope.LOCAL) : null;
                CodeEvaluator.this.addResultToHistory(exp, var);
                CodeEvaluator.this.displayResult(var);
            }
        }
    }

    public static class History {
        private static final int MAX_ITEMS = 100;
        private ArrayList<Item> historyItems = new ArrayList();

        private void addItem(String expr, String type, String value, String toString) {
            Item item = new Item(expr, type, value, toString);
            this.historyItems.add(0, item);
            if (this.historyItems.size() > 100) {
                this.historyItems.remove(100);
            }
        }

        public ArrayList<Item> getItems() {
            return this.historyItems;
        }

        public void clear() {
            this.historyItems.clear();
        }

        public class Item {
            public String expr;
            public String type;
            public String value;
            public String toString;
            public String tooltip;
            public String exprFormatted;

            Item(String expr, String type, String value, String toString) {
                this.expr = expr;
                this.type = type;
                this.value = value;
                this.toString = toString;
                StringBuilder buf = new StringBuilder();
                buf.append("<html>");
                String text = expr.replaceAll("&", "&amp;");
                text = text.replaceAll("<", "&lt;");
                text = text.replaceAll(">", "&gt;");
                text = text.replaceAll("\n", "<br/>");
                text = text.replaceAll("\r", "");
                buf.append(text);
                buf.append("</html>");
                this.tooltip = buf.toString();
            }

            public String toString() {
                return this.expr;
            }
        }
    }
}

