/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.console;

import java.awt.Color;
import java.awt.SystemColor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.javascript.debugger.console.Bundle;
import org.netbeans.modules.web.webkit.debugging.api.console.Console;
import org.netbeans.modules.web.webkit.debugging.api.console.ConsoleMessage;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class BrowserConsoleLogger
implements Console.Listener {
    private static final String LEVEL_ERROR = "error";
    private static final String LEVEL_DEBUG = "debug";
    private ProjectContext pc;
    private InputOutput io;
    private Color colorStdBrighter;
    private ConsoleMessage lastMessage;
    private final AtomicBoolean shownOnError = new AtomicBoolean(false);
    private static final SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
    private static final String LOG_IGNORED = "log";
    private static final String CONSOLE_API = "console-api";
    private static final String TIME_SEPARATOR = " | ";

    public BrowserConsoleLogger(ProjectContext pc) {
        this.pc = pc;
        this.initIO();
    }

    private void initIO() {
        this.io = IOProvider.getDefault().getIO(Bundle.BrowserConsoleLoggerTitle(), false);
        if (IOColors.isSupported((InputOutput)this.io) && IOColorPrint.isSupported((InputOutput)this.io)) {
            Color colorStd = IOColors.getColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.OUTPUT);
            Color background = UIManager.getDefaults().getColor("nb.output.background");
            if (background == null) {
                background = SystemColor.window;
            }
            this.colorStdBrighter = BrowserConsoleLogger.shiftTowards(colorStd, background);
        }
    }

    private static Color shiftTowards(Color c, Color b) {
        return new Color((c.getRed() + b.getRed()) / 2, (c.getGreen() + b.getGreen()) / 2, (c.getBlue() + b.getBlue()) / 2);
    }

    public void messageAdded(ConsoleMessage message) {
        try {
            this.lastMessage = message;
            this.logMessage(message);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void messagesCleared() {
        this.shownOnError.set(false);
    }

    public void messageRepeatCountUpdated(int count) {
        try {
            this.logMessage(this.lastMessage);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static String getCurrentTime() {
        return formatter.format(new Date(System.currentTimeMillis()));
    }

    private void logMessage(ConsoleMessage msg) throws IOException {
        String level = msg.getLevel();
        boolean isErr = LEVEL_ERROR.equals(level);
        String time = BrowserConsoleLogger.getCurrentTime();
        String logInfo = BrowserConsoleLogger.createLogInfo(time, level, msg.getSource(), msg.getType());
        OutputWriter ow = isErr ? this.io.getErr() : this.io.getOut();
        String[] lines = msg.getText().replace("\r", "").split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String singleMessageLine = lines[i];
            if (this.colorStdBrighter == null && i == lines.length - 1) {
                singleMessageLine = singleMessageLine + logInfo;
            }
            Object[] res = this.tryToConvertLineToHyperlink(singleMessageLine);
            MyListener l = null;
            String newMessage1 = null;
            String newMessage2 = null;
            if (res != null) {
                l = (MyListener)res[0];
                newMessage1 = (String)res[1];
                newMessage2 = (String)res[2];
            }
            if (l != null && l.isValidHyperlink()) {
                if (this.colorStdBrighter != null && i == lines.length - 1) {
                    newMessage2 = newMessage2 + logInfo;
                }
                ow.print(newMessage1);
                ow.println(newMessage2, (OutputListener)l);
                continue;
            }
            ow.print(singleMessageLine);
            if (this.colorStdBrighter != null && i == lines.length - 1) {
                IOColorPrint.print((InputOutput)this.io, (CharSequence)logInfo, (Color)this.colorStdBrighter);
                continue;
            }
            ow.println("");
        }
        boolean doPrintStackTrace = LEVEL_ERROR.equals(level) || LEVEL_DEBUG.equals(level);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (doPrintStackTrace && msg.getStackTrace() != null) {
            for (ConsoleMessage.StackFrame sf : msg.getStackTrace()) {
                String indent;
                if (first) {
                    indent = "    at ";
                    first = false;
                } else {
                    indent = "    at ";
                }
                ow.print(indent);
                ow.print(sf.getFunctionName());
                sb = new StringBuilder();
                String urlStr = sf.getURLString();
                urlStr = this.getProjectPath(urlStr);
                sb.append(" (" + urlStr + ":" + sf.getLine() + ":" + sf.getColumn() + ")");
                MyListener l = new MyListener(sf.getURLString(), sf.getLine(), sf.getColumn());
                if (l.isValidHyperlink()) {
                    ow.println(sb.toString(), (OutputListener)l);
                    continue;
                }
                ow.println(sb.toString());
            }
        }
        if (first && msg.getURLString() != null && msg.getURLString().length() > 0) {
            MyListener l;
            ow.print("  at ");
            String url = msg.getURLString();
            String file = this.getProjectPath(url);
            sb = new StringBuilder(file);
            int line = msg.getLine();
            if (line != -1 && line != 0) {
                sb.append(":");
                sb.append(line);
            }
            if ((l = new MyListener(url, line, -1)).isValidHyperlink()) {
                ow.println(sb.toString(), (OutputListener)l);
            } else {
                ow.println(sb.toString());
            }
        }
        if (this.io.isClosed() || isErr && !this.shownOnError.getAndSet(true)) {
            this.io.select();
        }
    }

    private Object[] tryToConvertLineToHyperlink(String line) {
        if (!line.endsWith(")")) {
            return this.tryToConvertLineURLToHyperlink(line);
        }
        int start = line.lastIndexOf(40);
        if (start == -1) {
            return null;
        }
        int lineNumberEnd = line.lastIndexOf(58);
        if (lineNumberEnd == -1) {
            return null;
        }
        int fileEnd = line.lastIndexOf(58, lineNumberEnd - 1);
        if (fileEnd == -1) {
            return null;
        }
        if (start >= fileEnd) {
            return null;
        }
        int lineNumber = -1;
        int columnNumber = -1;
        try {
            lineNumber = Integer.parseInt(line.substring(fileEnd + 1, lineNumberEnd));
            columnNumber = Integer.parseInt(line.substring(lineNumberEnd + 1, line.length() - 1));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (columnNumber != -1 && lineNumber == -1) {
            lineNumber = columnNumber;
        }
        if (lineNumber == -1) {
            return null;
        }
        String file = line.substring(start + 1, fileEnd);
        if (file.length() == 0) {
            return null;
        }
        String s1 = line.substring(0, start);
        String s2 = "(" + this.getProjectPath(file) + line.substring(fileEnd, line.length());
        MyListener l = new MyListener(file, lineNumber, columnNumber);
        return new Object[]{l, s1, s2};
    }

    private Object[] tryToConvertLineURLToHyperlink(String line) {
        int col2;
        int u1 = line.indexOf("http://");
        if (u1 < 0) {
            u1 = line.indexOf("https://");
        }
        if (u1 < 0) {
            return null;
        }
        int ue = line.indexOf(32, u1);
        if (ue < 0) {
            ue = line.length();
        }
        if ((col2 = line.lastIndexOf(58, ue)) < 0) {
            return null;
        }
        int col1 = line.lastIndexOf(58, col2 - 1);
        if (col1 < 0) {
            return null;
        }
        int lineNumber = -1;
        int columnNumber = -1;
        try {
            lineNumber = Integer.parseInt(line.substring(col1 + 1, col2));
            columnNumber = Integer.parseInt(line.substring(col2 + 1, ue));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (columnNumber != -1 && lineNumber == -1) {
            lineNumber = columnNumber;
        }
        if (lineNumber == -1) {
            return null;
        }
        String file = line.substring(u1, col1);
        if (file.length() == 0) {
            return null;
        }
        String s1 = line.substring(0, u1);
        String s2 = line.substring(u1, line.length());
        MyListener l = new MyListener(file, lineNumber, columnNumber);
        return new Object[]{l, s1, s2};
    }

    private static String createLogInfo(String time, String level, String source, String type) {
        StringBuilder logInfoBuilder = new StringBuilder(" (");
        logInfoBuilder.append(time);
        boolean separator = false;
        if (!LOG_IGNORED.equals(level)) {
            separator = true;
            logInfoBuilder.append(TIME_SEPARATOR);
            logInfoBuilder.append(level);
        }
        if (!CONSOLE_API.equals(source)) {
            if (separator) {
                logInfoBuilder.append(", ");
            } else {
                logInfoBuilder.append(TIME_SEPARATOR);
            }
            logInfoBuilder.append(source);
        }
        if (!LOG_IGNORED.equals(type)) {
            if (separator) {
                logInfoBuilder.append(", ");
            } else {
                logInfoBuilder.append(TIME_SEPARATOR);
            }
            logInfoBuilder.append(type);
        }
        logInfoBuilder.append(")\n");
        return logInfoBuilder.toString();
    }

    private String getProjectPath(String urlStr) {
        try {
            String relPath;
            FileObject fo;
            URL url = new URL(urlStr);
            Project project = this.pc.getProject();
            if (project != null && (fo = ServerURLMapping.fromServer((Project)project, (URL)url)) != null && (relPath = FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)fo)) != null) {
                urlStr = relPath;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return urlStr;
    }

    private class MyListener
    implements OutputListener {
        private String url;
        private int line;
        private int column;

        public MyListener(String url, int line, int column) {
            this.url = url;
            this.line = line;
            this.column = column;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            Line l = this.getLine();
            if (l != null) {
                l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, this.column != -1 ? this.column - 1 : -1);
            }
        }

        private Line getLine() {
            Project project = BrowserConsoleLogger.this.pc.getProject();
            return MiscEditorUtil.getLine(project, this.url, this.line - 1);
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public boolean isValidHyperlink() {
            return this.getLine() != null;
        }
    }
}

