/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.callstack;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JToolTip;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.javascript.debugger.ViewModelSupport;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.javascript.debugger.callstack.Bundle;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class CallStackModel
extends ViewModelSupport
implements TreeModel,
NodeModel,
TableModel,
Debugger.Listener,
PropertyChangeListener {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private Debugger debugger;
    private ProjectContext pc;
    private AtomicReference<List<? extends CallFrame>> stackTrace = new AtomicReference(new ArrayList());

    public CallStackModel(ContextProvider contextProvider) {
        this.debugger = (Debugger)contextProvider.lookupFirst(null, Debugger.class);
        this.pc = (ProjectContext)contextProvider.lookupFirst(null, ProjectContext.class);
        this.debugger.addListener((Debugger.Listener)this);
        this.debugger.addPropertyChangeListener((PropertyChangeListener)this);
        this.setStackTrace(this.debugger.isSuspended() ? this.debugger.getCurrentCallStack() : new ArrayList());
    }

    private void setStackTrace(List<? extends CallFrame> stackTrace) {
        ArrayList<CallFrame> l = new ArrayList<CallFrame>();
        this.stackTrace = new AtomicReference(l);
        for (CallFrame callFrame : stackTrace) {
            if (callFrame.getScript() == null) continue;
            l.add(callFrame);
        }
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            List<? extends CallFrame> list = this.stackTrace.get();
            if (list == null) {
                return new Object[0];
            }
            if (from >= list.size()) {
                return new Object[0];
            }
            int end = Math.min(list.size(), to);
            List<? extends CallFrame> stack = list.subList(from, end);
            return stack.toArray();
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof CallFrame) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            List<? extends CallFrame> list = this.stackTrace.get();
            if (list == null) {
                return 0;
            }
            return list.size();
        }
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Bundle.CTL_CallstackModel_Column_Name_Name();
        }
        if (node instanceof CallFrame) {
            CallFrame frame = (CallFrame)node;
            String frameName = frame.getFunctionName();
            if (frameName.isEmpty()) {
                frameName = Bundle.LBL_AnonymousFunction();
            }
            if (frame == this.debugger.getCurrentCallFrame()) {
                return CallStackModel.toHTML(frameName, true, false, null);
            }
            return frameName;
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            CallFrame curStack = this.debugger.getCurrentCallFrame();
            if (curStack == node) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        if (node == "Root") {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            CallFrame frame = (CallFrame)node;
            return frame.getScript().getURL() + ":" + (frame.getLineNumber() + 1);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        String file;
        CallFrame frame;
        if (!columnID.equals("CallStackFrameLocation")) throw new UnknownTypeException((Object)("Unknown columnID: " + columnID));
        if (node instanceof CallFrame) {
            frame = (CallFrame)node;
            file = frame.getScript().getURL();
            if (file.isEmpty()) return file + ":" + (frame.getLineNumber() + 1);
            FileObject fo = null;
            try {
                URL url = URI.create(file).toURL();
                Project project = this.pc.getProject();
                if (project != null) {
                    fo = ServerURLMapping.fromServer((Project)project, (URL)url);
                }
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (fo == null) return file + ":" + (frame.getLineNumber() + 1);
            file = fo.getNameExt();
            return file + ":" + (frame.getLineNumber() + 1);
        }
        if (!(node instanceof JToolTip)) throw new UnknownTypeException((Object)("Unknown Type Node: " + node));
        JToolTip tooltip = (JToolTip)node;
        if (!((node = tooltip.getClientProperty("getShortDescription")) instanceof CallFrame)) throw new UnknownTypeException((Object)("Unknown Type Node: " + node));
        frame = (CallFrame)node;
        file = frame.getScript().getURL();
        if (file.isEmpty()) return file + ":" + (frame.getLineNumber() + 1);
        try {
            FileObject fo;
            URL url = URI.create(file).toURL();
            Project project = this.pc.getProject();
            if (project == null || (fo = ServerURLMapping.fromServer((Project)project, (URL)url)) == null) return file + ":" + (frame.getLineNumber() + 1);
            file = FileUtil.getFileDisplayName((FileObject)fo);
            return file + ":" + (frame.getLineNumber() + 1);
        }
        catch (MalformedURLException ex) {}
        return file + ":" + (frame.getLineNumber() + 1);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof CallFrame && columnID.equals("CallStackFrameLocation")) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    public void paused(List<CallFrame> callStack, String reason) {
        this.setStackTrace(callStack);
        this.refresh();
    }

    public void resumed() {
        this.setStackTrace(new ArrayList());
        this.refresh();
    }

    public void reset() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("currentFrame".equals(propertyName)) {
            this.refresh();
        }
    }
}

