/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.callstack;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.modules.web.javascript.debugger.annotation.CallStackAnnotation;
import org.netbeans.modules.web.javascript.debugger.annotation.CurrentLineAnnotation;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Script;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

public class CallStackAnnotationListener
extends DebuggerManagerAdapter
implements Debugger.Listener,
PropertyChangeListener {
    private ProjectContext pc;
    private final List<Annotation> annotations = new ArrayList<Annotation>();

    public String[] getProperties() {
        return new String[]{"debuggerEngines", "currentEngine"};
    }

    public void engineAdded(DebuggerEngine engine) {
        Debugger d = (Debugger)engine.lookupFirst("", Debugger.class);
        if (d != null) {
            d.addListener((Debugger.Listener)this);
            d.addPropertyChangeListener((PropertyChangeListener)this);
            this.pc = (ProjectContext)engine.lookupFirst(null, ProjectContext.class);
            List stackTrace = d.isSuspended() ? d.getCurrentCallStack() : Collections.emptyList();
            this.updateAnnotations(stackTrace);
        }
    }

    public void engineRemoved(DebuggerEngine engine) {
        Debugger d = (Debugger)engine.lookupFirst("", Debugger.class);
        if (d != null) {
            d.removeListener((Debugger.Listener)this);
            d.removePropertyChangeListener((PropertyChangeListener)this);
            this.pc = null;
            this.updateAnnotations(Collections.EMPTY_LIST);
        }
    }

    public void paused(List<CallFrame> callStack, String reason) {
        this.updateAnnotations(callStack);
    }

    public void resumed() {
        this.updateAnnotations(Collections.EMPTY_LIST);
    }

    public void reset() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Debugger d;
        DebuggerEngine engine;
        Script script;
        CallFrame cf;
        String propertyName = evt.getPropertyName();
        if ("currentFrame".equals(propertyName) && (cf = (CallFrame)evt.getNewValue()) != null && (script = cf.getScript()) != null) {
            Project project = this.pc != null ? this.pc.getProject() : null;
            Line line = MiscEditorUtil.getLine(project, script, cf.getLineNumber());
            MiscEditorUtil.showLine(line, true);
        }
        if ("currentEngine".equals(propertyName) && (engine = (DebuggerEngine)evt.getNewValue()) != null && (d = (Debugger)engine.lookupFirst("", Debugger.class)) != null) {
            this.pc = (ProjectContext)engine.lookupFirst(null, ProjectContext.class);
            List stackTrace = d.isSuspended() ? d.getCurrentCallStack() : Collections.emptyList();
            this.updateAnnotations(stackTrace);
        }
    }

    private void updateAnnotations(List<CallFrame> stackTrace) {
        for (Annotation ann : this.annotations) {
            ann.detach();
        }
        this.annotations.clear();
        boolean first = true;
        for (CallFrame cf : stackTrace) {
            Annotation anno;
            Script script = cf.getScript();
            if (script == null) continue;
            Project project = this.pc != null ? this.pc.getProject() : null;
            Line line = MiscEditorUtil.getLine(project, script, cf.getLineNumber());
            if (line == null) {
                first = false;
                continue;
            }
            if (first) {
                anno = new CurrentLineAnnotation((Annotatable)line);
                MiscEditorUtil.showLine(line, true);
                first = false;
            } else {
                anno = new CallStackAnnotation((Annotatable)line);
            }
            this.annotations.add(anno);
        }
    }
}

