/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.callstack;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.modules.web.javascript.debugger.ViewModelSupport;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.javascript.debugger.callstack.Bundle;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class CallStackActionsModel
extends ViewModelSupport
implements NodeActionsProvider {
    private Debugger debugger;
    private ProjectContext pc;
    private Action GO_TO_SOURCE;
    private Action MAKE_CURRENT_ACTION = Models.createAction((String)Bundle.CTL_CallstackAction_MakeCurrent_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return node != CallStackActionsModel.this.debugger.getCurrentCallFrame();
        }

        public void perform(Object[] nodes) {
            CallStackActionsModel.this.debugger.setCurrentCallFrame((CallFrame)nodes[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private final Action COPY_TO_CLBD_ACTION = Models.createAction((String)Bundle.CTL_CallstackAction_Copy2CLBD_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return CallStackActionsModel.this.debugger.isSuspended();
        }

        public void perform(Object[] nodes) {
            CallStackActionsModel.this.stackToCLBD();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private RequestProcessor RP = new RequestProcessor(CallStackActionsModel.class.getName());

    public CallStackActionsModel(ContextProvider contextProvider) {
        this.debugger = (Debugger)contextProvider.lookupFirst(null, Debugger.class);
        this.pc = (ProjectContext)contextProvider.lookupFirst(null, ProjectContext.class);
        this.GO_TO_SOURCE = MiscEditorUtil.createDebuggerGoToAction(this.pc);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            CallFrame frame = (CallFrame)node;
            if (frame != this.debugger.getCurrentCallFrame()) {
                this.debugger.setCurrentCallFrame(frame);
            } else {
                Project project = this.pc.getProject();
                Line line = MiscEditorUtil.getLine(project, frame.getScript(), frame.getLineNumber());
                MiscEditorUtil.showLine(line, true);
            }
        }
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            return new Action[]{this.MAKE_CURRENT_ACTION, this.GO_TO_SOURCE, this.COPY_TO_CLBD_ACTION};
        }
        return new Action[]{this.COPY_TO_CLBD_ACTION};
    }

    private void stackToCLBD() {
        if (!this.debugger.isSuspended()) {
            return;
        }
        StringBuilder frameStr = new StringBuilder(50);
        List stack = this.debugger.getCurrentCallStack();
        if (stack != null) {
            for (CallFrame frame : stack) {
                String functionName = frame.getFunctionName();
                if (functionName.isEmpty()) {
                    functionName = "(anonymous function)";
                }
                frameStr.append(functionName);
                String sourceName = frame.getScript().getURL().toString();
                int sourceNameIndex = sourceName.lastIndexOf(47);
                if (sourceNameIndex > 0) {
                    sourceName = sourceName.substring(sourceNameIndex + 1);
                }
                frameStr.append(" (");
                frameStr.append(sourceName);
                int line = frame.getLineNumber();
                if (line > 0) {
                    frameStr.append(":");
                    frameStr.append(line + 1);
                }
                frameStr.append(")\n");
            }
        }
        Clipboard systemClipboard = CallStackActionsModel.getClipboard();
        StringSelection transferableText = new StringSelection(frameStr.toString());
        systemClipboard.setContents(transferableText, null);
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }
}

