/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints.ui;

import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.modules.web.javascript.debugger.breakpoints.BreakpointRuntimeSetter;
import org.netbeans.modules.web.javascript.debugger.breakpoints.LineBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.ui.ControllerProvider;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LineBreakpointCustomizer
extends JPanel
implements ControllerProvider,
HelpCtx.Provider {
    private final CustomizerController controller;
    private final LineBreakpoint lb;
    private boolean createBreakpoint;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel lineLabel;
    private JTextField lineTextField;

    private static LineBreakpoint createBreakpoint() {
        Line line = MiscEditorUtil.getCurrentLine();
        if (line == null) {
            return null;
        }
        return new LineBreakpoint(line);
    }

    public LineBreakpointCustomizer() {
        this(LineBreakpointCustomizer.createBreakpoint());
        this.createBreakpoint = true;
    }

    public LineBreakpointCustomizer(LineBreakpoint lb) {
        this.lb = lb;
        this.initComponents();
        this.controller = new CustomizerController();
        if (lb != null) {
            Line line = lb.getLine();
            FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
            if (fo != null) {
                File file = FileUtil.toFile((FileObject)fo);
                if (file != null) {
                    this.fileTextField.setText(file.getAbsolutePath());
                } else {
                    this.fileTextField.setText(fo.toURL().toExternalForm());
                }
            }
            this.lineTextField.setText(Integer.toString(line.getLineNumber() + 1));
        }
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.lineLabel = new JLabel();
        this.lineTextField = new JTextField();
        this.fileLabel.setText(NbBundle.getMessage(LineBreakpointCustomizer.class, (String)"LineBreakpointCustomizer.fileLabel.text"));
        this.fileTextField.setText(NbBundle.getMessage(LineBreakpointCustomizer.class, (String)"LineBreakpointCustomizer.fileTextField.text"));
        this.lineLabel.setText(NbBundle.getMessage(LineBreakpointCustomizer.class, (String)"LineBreakpointCustomizer.lineLabel.text"));
        this.lineTextField.setText(NbBundle.getMessage(LineBreakpointCustomizer.class, (String)"LineBreakpointCustomizer.lineTextField.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lineLabel).addComponent(this.fileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileTextField).addComponent(this.lineTextField, -1, 278, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lineLabel).addComponent(this.lineTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerLineBreakpointJavaScript");
    }

    private class CustomizerController
    implements Controller {
        private CustomizerController() {
        }

        public boolean ok() {
            int lineNumber;
            LineBreakpoint lb = LineBreakpointCustomizer.this.lb;
            String fileStr = LineBreakpointCustomizer.this.fileTextField.getText();
            try {
                lineNumber = Integer.parseInt(LineBreakpointCustomizer.this.lineTextField.getText());
            }
            catch (NumberFormatException nfex) {
                return false;
            }
            Line line = MiscEditorUtil.getLine(fileStr, --lineNumber);
            if (line == null) {
                return false;
            }
            if (lb != null) {
                this.updateBreakpoint(line);
            } else {
                lb = new LineBreakpoint(line);
            }
            if (LineBreakpointCustomizer.this.createBreakpoint) {
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)lb);
            }
            return true;
        }

        private void updateBreakpoint(final Line line) {
            BreakpointRuntimeSetter.RP.post(new Runnable(){

                @Override
                public void run() {
                    LineBreakpointCustomizer.this.lb.setLine(line);
                }
            });
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }
}

