/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.javascript.debugger.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.Bundle;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMNode;
import org.netbeans.modules.web.javascript.debugger.breakpoints.EventsBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.LineBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.XHRBreakpoint;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Breakpoint;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.RequestProcessor;

abstract class WebKitBreakpointManager
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(WebKitBreakpointManager.class.getName());
    protected final Debugger d;
    private final AbstractBreakpoint ab;
    private static final RequestProcessor rp = new RequestProcessor(WebKitBreakpointManager.class);

    protected WebKitBreakpointManager(Debugger d, AbstractBreakpoint ab) {
        this.d = d;
        this.ab = ab;
        ab.addPropertyChangeListener(this);
    }

    public static WebKitBreakpointManager create(Debugger d, ProjectContext pc, LineBreakpoint lb) {
        return new WebKitLineBreakpointManager(d, pc, lb);
    }

    public static WebKitBreakpointManager create(WebKitDebugging wd, ProjectContext pc, DOMBreakpoint db) {
        return new WebKitDOMBreakpointManager(wd, pc, db);
    }

    public static WebKitBreakpointManager create(Debugger d, EventsBreakpoint eb) {
        return new WebKitEventsBreakpointManager(d, eb);
    }

    public static WebKitBreakpointManager create(Debugger d, XHRBreakpoint xb) {
        return new WebKitXHRBreakpointManager(d, xb);
    }

    public boolean canAdd() {
        return this.ab.isEnabled();
    }

    public abstract void add();

    public abstract void remove();

    public void destroy() {
        this.remove();
        this.ab.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent event) {
        if (!"enabled".equals(event.getPropertyName())) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            rp.post(new Runnable(){

                @Override
                public void run() {
                    WebKitBreakpointManager.this.propertyChange(event);
                }
            });
            return;
        }
        org.netbeans.api.debugger.Breakpoint b = (org.netbeans.api.debugger.Breakpoint)event.getSource();
        if (b.isEnabled()) {
            this.add();
        } else {
            this.remove();
        }
    }

    private static final class WebKitXHRBreakpointManager
    extends WebKitBreakpointManager {
        private final XHRBreakpoint xb;
        private Breakpoint b;
        private String lastUrlSubstring;

        public WebKitXHRBreakpointManager(Debugger d, XHRBreakpoint xb) {
            super(d, xb);
            this.xb = xb;
        }

        @Override
        public void add() {
            if (this.b != null) {
                return;
            }
            String urlSubstring = this.xb.getUrlSubstring();
            this.b = this.d.addXHRBreakpoint(urlSubstring);
            this.lastUrlSubstring = urlSubstring;
        }

        @Override
        public void remove() {
            if (this.b == null) {
                return;
            }
            if (this.d.isEnabled()) {
                if (this.b.getBreakpointID() != null) {
                    this.d.removeLineBreakpoint(this.b);
                } else {
                    this.d.removeXHRBreakpoint(this.lastUrlSubstring);
                }
            }
            this.b = null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("urlSubstring".equals(event.getPropertyName())) {
                if (SwingUtilities.isEventDispatchThread()) {
                    rp.post(new Runnable(){

                        @Override
                        public void run() {
                            WebKitXHRBreakpointManager.this.remove();
                            WebKitXHRBreakpointManager.this.add();
                        }
                    });
                    return;
                }
                this.remove();
                this.add();
            } else {
                super.propertyChange(event);
            }
        }
    }

    private static final class WebKitEventsBreakpointManager
    extends WebKitBreakpointManager {
        private EventsBreakpoint eb;
        private Map<String, Breakpoint> bps;

        public WebKitEventsBreakpointManager(Debugger d, EventsBreakpoint eb) {
            super(d, eb);
            this.eb = eb;
        }

        @Override
        public void add() {
            Set<String> events = this.eb.getEvents();
            this.bps = new HashMap<String, Breakpoint>(events.size());
            for (String event : events) {
                Breakpoint b = this.d.addEventBreakpoint(event);
                if (b == null) continue;
                this.bps.put(event, b);
            }
        }

        @Override
        public void remove() {
            if (this.bps == null) {
                return;
            }
            if (this.d.isEnabled()) {
                boolean removed = true;
                for (Breakpoint b : this.bps.values()) {
                    if (b.getBreakpointID() != null) {
                        this.d.removeLineBreakpoint(b);
                        continue;
                    }
                    removed = false;
                }
                if (!removed) {
                    Set<String> events = this.eb.getEvents();
                    for (String event : events) {
                        this.d.removeEventBreakpoint(event);
                    }
                }
            }
            this.bps = null;
        }

        @Override
        public void propertyChange(final PropertyChangeEvent event) {
            if (!this.eb.isEnabled()) {
                super.propertyChange(event);
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        WebKitEventsBreakpointManager.this.propertyChange(event);
                    }
                });
                return;
            }
            String propertyName = event.getPropertyName();
            if ("events".equals(propertyName) && this.bps != null) {
                Object newValue = event.getNewValue();
                Object oldValue = event.getOldValue();
                if (newValue != null) {
                    String newEvent = (String)newValue;
                    Breakpoint b = this.d.addEventBreakpoint(newEvent);
                    if (b != null) {
                        this.bps.put(newEvent, b);
                    }
                } else if (oldValue != null) {
                    String oldEvent = (String)oldValue;
                    Breakpoint b = this.bps.remove(oldEvent);
                    if (b != null) {
                        this.d.removeEventBreakpoint(oldEvent);
                    }
                } else {
                    this.remove();
                    this.add();
                }
            } else {
                super.propertyChange(event);
            }
        }
    }

    private static final class WebKitDOMBreakpointManager
    extends WebKitBreakpointManager
    implements ChangeListener {
        private final WebKitDebugging wd;
        private final ProjectContext pc;
        private final DOMBreakpoint db;
        private Node node;
        private Map<Breakpoint, DOMBreakpoint.Type> bps;

        public WebKitDOMBreakpointManager(WebKitDebugging wd, ProjectContext pc, DOMBreakpoint db) {
            super(wd.getDebugger(), db);
            this.wd = wd;
            this.pc = pc;
            this.db = db;
            pc.addChangeSupport(this);
        }

        @Override
        public void add() {
            FileObject projectDirectory;
            URL urlBP;
            FileObject fo;
            if (this.bps != null) {
                return;
            }
            Project project = this.pc.getProject();
            if (project != null && (fo = URLMapper.findFileObject((URL)(urlBP = this.db.getURL()))) != null && !FileUtil.isParentOf((FileObject)(projectDirectory = project.getProjectDirectory()), (FileObject)fo)) {
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("WebKitDOMBreakpointManager.add(): breakpoint URL = '" + this.db.getURL() + "'");
            }
            DOMNode dn = this.db.getNode();
            dn.addPropertyChangeListener(this);
            try {
                dn.bindTo(this.wd.getDOM());
            }
            catch (DOMNode.PathNotFoundException pex) {
                this.db.setValidity(pex);
                return;
            }
            Node n = dn.getNode();
            if (n != null) {
                this.addTo(n);
            }
        }

        private void addTo(Node node) {
            this.node = node;
            Set<DOMBreakpoint.Type> types = this.db.getTypes();
            if (types.isEmpty()) {
                return;
            }
            this.bps = new HashMap<Breakpoint, DOMBreakpoint.Type>(types.size());
            for (DOMBreakpoint.Type type : types) {
                Breakpoint b = this.d.addDOMBreakpoint(node, type.getTypeString());
                if (b == null) continue;
                this.bps.put(b, type);
            }
        }

        @Override
        public void remove() {
            DOMNode dn = this.db.getNode();
            dn.unbind();
            dn.removePropertyChangeListener(this);
            this.removeBreakpoints();
        }

        private void removeBreakpoints() {
            Node theNode = this.node;
            this.node = null;
            if (theNode != null) {
                this.removeBreakpoints(theNode);
            }
        }

        private void removeBreakpoints(Node theNode) {
            if (this.bps == null) {
                return;
            }
            if (this.d.isEnabled()) {
                for (Breakpoint b : this.bps.keySet()) {
                    if (b.getBreakpointID() != null) {
                        this.d.removeLineBreakpoint(b);
                        continue;
                    }
                    this.d.removeDOMBreakpoint(theNode, this.bps.get(b).getTypeString());
                }
            }
            this.bps = null;
        }

        @Override
        public void propertyChange(final PropertyChangeEvent event) {
            if (SwingUtilities.isEventDispatchThread()) {
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        WebKitDOMBreakpointManager.this.propertyChange(event);
                    }
                });
                return;
            }
            String propertyName = event.getPropertyName();
            if ("nodeChanged".equals(propertyName)) {
                Node newNode;
                Node oldNode = (Node)event.getOldValue();
                if (oldNode != null) {
                    this.removeBreakpoints();
                }
                if ((newNode = (Node)event.getNewValue()) != null) {
                    this.addTo(newNode);
                }
            } else if ("nodePathRequestFailed".equals(propertyName)) {
                this.removeBreakpoints();
                this.db.setValidity((DOMNode.PathNotFoundException)event.getNewValue());
            } else if ("types".equals(propertyName)) {
                Node theNode = this.node;
                if (theNode != null) {
                    this.removeBreakpoints(theNode);
                    this.addTo(theNode);
                }
            } else if ("node".equals(propertyName)) {
                DOMNode oldNode = (DOMNode)event.getOldValue();
                oldNode.unbind();
                oldNode.removePropertyChangeListener(this);
                this.removeBreakpoints();
                this.add();
            } else {
                super.propertyChange(event);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.remove();
            this.add();
        }
    }

    private static final class WebKitLineBreakpointManager
    extends WebKitBreakpointManager
    implements Debugger.Listener,
    ChangeListener {
        private final LineBreakpoint lb;
        private volatile Breakpoint b;
        private final AtomicBoolean lineChanged = new AtomicBoolean(false);
        private final AtomicBoolean resubmitting = new AtomicBoolean(false);
        private final ThreadLocal<Boolean> ignoreLineUpdate = new ThreadLocal();
        private ProjectContext pc;

        public WebKitLineBreakpointManager(Debugger d, ProjectContext pc, LineBreakpoint lb) {
            super(d, lb);
            this.lb = lb;
            this.pc = pc;
            pc.addChangeSupport(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add() {
            if (this.b != null) {
                return;
            }
            URL curl = this.d.getConnectionURL();
            if (curl != null) {
                String url = this.lb.getURLString(this.pc.getProject(), curl);
                Breakpoint br = this.d.addLineBreakpoint(url = WebKitLineBreakpointManager.reformatFileURL(url), this.lb.getLine().getLineNumber(), 0);
                if (br != null) {
                    br.addPropertyChangeListener((PropertyChangeListener)this);
                    long brLine = br.getLineNumber();
                    if (brLine >= 0L) {
                        this.ignoreLineUpdate.set(Boolean.TRUE);
                        try {
                            this.lb.setLine((int)brLine);
                        }
                        finally {
                            this.ignoreLineUpdate.remove();
                        }
                        this.lb.setValid(Bundle.MSG_BRKP_Resolved());
                    } else {
                        this.lb.setInvalid(Bundle.MSG_BRKP_Unresolved());
                    }
                    this.b = br;
                    this.d.addListener((Debugger.Listener)this);
                }
            }
        }

        @Override
        public void remove() {
            if (this.b == null) {
                return;
            }
            this.b.removePropertyChangeListener((PropertyChangeListener)this);
            this.d.removeListener((Debugger.Listener)this);
            if (this.d.isEnabled()) {
                this.d.removeLineBreakpoint(this.b);
            }
            this.b = null;
            this.lb.resetValidity();
        }

        private void resubmit() {
            if (this.b != null) {
                this.d.removeLineBreakpoint(this.b);
                URL curl = this.d.getConnectionURL();
                if (curl != null) {
                    String url = this.lb.getURLString(this.pc.getProject(), curl);
                    url = WebKitLineBreakpointManager.reformatFileURL(url);
                    this.resubmitting.set(false);
                    this.b = this.d.addLineBreakpoint(url, this.lb.getLine().getLineNumber(), 0);
                }
            }
        }

        private static String reformatFileURL(String tabToDebug) {
            if (!tabToDebug.startsWith("file:")) {
                return tabToDebug;
            }
            tabToDebug = tabToDebug.substring(5);
            while (tabToDebug.length() > 0 && tabToDebug.startsWith("/")) {
                tabToDebug = tabToDebug.substring(1);
            }
            return "file:///" + tabToDebug;
        }

        public void paused(List<CallFrame> callStack, String reason) {
        }

        public void resumed() {
        }

        public void reset() {
            if (this.lineChanged.getAndSet(false)) {
                this.resubmitting.set(true);
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        WebKitLineBreakpointManager.this.resubmit();
                        WebKitLineBreakpointManager.this.resubmitting.set(false);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if ("line".equals(propertyName)) {
                Boolean ignore = this.ignoreLineUpdate.get();
                if (ignore != null && ignore.booleanValue()) {
                    return;
                }
                this.resubmit();
            } else if ("lineNumber".equals(propertyName)) {
                this.lineChanged.set(true);
            } else if ("location".equals(propertyName)) {
                if (this.resubmitting.get()) {
                    return;
                }
                int lineNumber = (int)this.b.getLineNumber();
                this.ignoreLineUpdate.set(Boolean.TRUE);
                try {
                    this.lb.setLine(lineNumber);
                }
                finally {
                    this.ignoreLineUpdate.remove();
                }
                if (lineNumber >= 0) {
                    this.lb.setValid(Bundle.MSG_BRKP_Resolved());
                } else {
                    this.lb.setInvalid(Bundle.MSG_BRKP_Unresolved());
                }
            } else {
                super.propertyChange(event);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.resubmit();
        }
    }
}

